
{
	Badwordfilter script Copyright (c) 2008 Joseph Robert Gillotti  ...aka "JRGP"
	Feel free to use this for anything, just give me credit in the source.
}


//config
const
  NumWarnings = 3;					//number of times a player can curse before getting kicked or banned
  FileName = 'BadWordsList.txt';	//file which holds the badwords, each seperated with a space
  Ban = false;						//When a player reaches the curse limit, ban the player? (true or false)
  KillOnOffense = true;				//With each offense, kill the player? (true or false)
  TextColor = $ffff00001;			//color of messages told to player
  BanLength = 15;					//minutes a player will be banned for, if the Ban = true;

//holders of information
var
	Warnings: array[1..32] of integer;	//holds the number of warnings for each player
	FileContents: string; //contents of badwords file
	BadWords: TStringArray;
	HaveBadWords: boolean;

//credits to DorkeyDear - http://www.soldatforums.com/index.php?topic=27844.0
function Explode(Source: string; const Delimiter: string): array of string;
var TempStr: string;
begin
	Source := Source + Delimiter;
	repeat
		TempStr := GetPiece(Source, Delimiter, 0);
		SetArrayLength(Result, GetArrayLength(Result) + 1);
		Result[GetArrayLength(Result) - 1] := TempStr;
		Delete(Source, 1, Length(TempStr) + Length(Delimiter));
	until Length(Source) = 0;
end;
	
//load badwords list
procedure ActivateServer();
begin
	if not FileExists(FileName) then
	begin
		WriteLn('Cannot find badwords file')	
		HaveBadWords := false;
		exit;
	end;
	FileContents := UpperCase(ReadFile(FileName));	//we're making the list of badword's case uppercase so they are case insensitive
	BadWords := Explode(FileContents, ' ');
	HaveBadWords := true;
end;

//whenever someone says something, check it.
procedure OnPlayerSpeak(PlayerID: Byte; Text: string);
var i: integer;
var Bad: boolean;
begin
	//do we any badwords to check?
	if not HaveBadWords then
		exit;
	//for now, make it false
	Bad := false;
	//check it!
	for i := 0 to GetArrayLength(BadWords) - 1 do
	begin
		//if it is a bad word, make it known that we cursed
		if ContainsString(UpperCase(Text), BadWords[i]) then	//we're making what they said upercase so the badwords are case insensitive
			Bad := true;
	end;
	//saying something naughty?
	if Bad then
	begin
		//increase number of warnings used
		inc(Warnings[PlayerID], 1);
		//reached limit
		if Warnings[PlayerID] = NumWarnings then
		begin
			//reset limit for this id
			Warnings[PlayerID] := 0;
			//Ban or kick?
			if Ban then
			begin
				BanPlayer(PlayerID, 15);
				exit;
			end;
				KickPlayer(PlayerID);
			exit;
		end;
		//under limit..
		if Warnings[PlayerID] < NumWarnings then
		begin
			//should we kill him / her?
			if KillOnOffense then
				DoDamage(PlayerID, 4000);
			//notify player of this
			WriteConsole(PlayerID, 'You have been warned for offensive language.', TextColor);
			WriteConsole(PlayerID, 'If you curse '+inttostr(NumWarnings - Warnings[PlayerID])+' more time(s), you will be '+iif(Ban,'banned','kicked')+'.', TextColor);
		end;
	end;
end;
