<?php
/*	
This file is part of JRG Stats.

JRG Stats is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3 of the License, or
(at your option) any later version.

JRG Stats is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

//antihack
defined('instats') or die;

//make sure signatures are enabled
if ($signature_images == false)
{
	mysql_close();
	die('Signature Images are disabled.');
}


//url to the template image (this is the image that php writes the text and favorite weapon image over)
$template = 'img/sigpic.png';

//make sure it exists
if (!is_file($template))
{
	mysql_close();
	die('Template image <code>'.$template.'</code> not found.');
}

//make sure player id supplied
if (trim($_GET['id']) == '')
{
	mysql_close();
	die('No player id supplied in url.');
}

//get db safe player id
$pid = db_prot($_GET['id']);

//info query for this player
$query = mysql_query("
select
	`name`,
	`kills`,
	`deaths`,
	`suicides`,
	(`kills` / `deaths`) as kd
from
	`{$db['prefix']}players`
where
	`id` = '$pid'
limit 1
");

//make sure player exists
if (mysql_num_rows($query) == 0)
{
	mysql_close();
	die('Invalid player id supplied in url.');
}

//info in array
$in = mysql_fetch_assoc($query);

//save ram
mysql_free_result($query);

//get favorite weapon

//query that gets the name of every weapon I used to kill
$wep_query = mysql_query("
select
	`{$db['prefix']}weapons`.`name`
from
	`{$db['prefix']}kills`,
	`{$db['prefix']}weapons`
where 
	`{$db['prefix']}kills`.`killer` = '$pid'
	AND `suicide` = 0
	AND `{$db['prefix']}weapons`.`id` = `{$db['prefix']}kills`.`weapon`");

//check if I have no kills
if (mysql_num_rows($wep_query) == 0)
{
	//save ram
	mysql_free_result($wep_query);
	//just set it to false
	$fav_wep_n = false;
}
//if I do have kills
else
{
	//temp array to hold info
	$fav_weps = array();
	
	//loop through query, working with the array above to store weapon stats
	while($f = mysql_fetch_row($wep_query))
	{
		//if weapon not already in array
		if (!isset($fav_weps[$f[0]]) || empty($fav_weps[$f[0]]))
			//start it's kill count off as one
			$fav_weps[$f[0]] = 1;
		else
			//otherwise, increase it by one
			$fav_weps[$f[0]]++;
	}
	
	//save ram
	mysql_free_result($wep_query);

	//sort array
	array_multisort($fav_weps,SORT_DESC);

	//name of favorite wep
	$fav_wep_n_a = array_values(array_flip($fav_weps));
	$fav_wep = $fav_wep_n_a[0];
	unset($fav_weps,$fav_wep_n_a); 
}

//get my last action

//query that gets the date of the latest kill / death / suicide
$last_act_query = mysql_query("select `date` from `{$db['prefix']}kills` where `killer` = '$pid' order by `date` desc limit 1");

//check if there are none
if (mysql_num_rows($last_act_query) == 0)
{
	//save ram
	mysql_free_result($last_act_query);
	//just mark it as na
	$last_act = 'N/A';
}
//if a date is found
else
{
	//array containing the date
	$last_act_a = mysql_fetch_row($last_act_query);
	//save ram
	mysql_free_result($last_act_query);
	//the actual date
	$last_act = date('m-d-Y g:i:s A',$last_act_a[0]);
	//save ram
	unset($last_act_a);
}

//we won't need mysql again
mysql_close();

//attempt creating new image resource
$img = @imagecreatefrompng($template)
	or die('Error loading image template <code>'.$template.'</code> for usage.');

//color for text (black)
$color = imagecolorallocate($img, 0, 0, 0);

//write players name to the image
imagestring($img, 5, 7, 5, stripslashes($in['name']), $color);

//write players kills to image
imagestring($img, 2, 7, 30, 'Kills: ' . number_format($in['kills']) , $color);

//write players deaths to image
imagestring($img, 2, 7, 45, 'Deaths: ' . number_format($in['deaths']) , $color);

//write players suicides to image
imagestring($img, 2, 7, 60, 'Suicides: ' . number_format($in['suicides']) , $color);

//write players KD Ratio to image
imagestring($img, 2, 7, 75, 'K:D Ratio: ' . round($in['kd'],2) , $color);

//write players last action to image
imagestring($img, 2, 7, 90, 'Last action: ' . $last_act , $color);

if ($fav_wep_n != false)
{
	//write players favorite weapon to image
	imagestring($img, 2, 7, 105, 'Favorite Weapon: ' , $color);
	//load image icon
	//path to weapon icon
	$fav_wep_p = 'img/' . str_replace(' ', '_', $fav_wep) . '.gif';
	//check if weapon icon exists
	if (is_file($fav_wep_p))
	{
		//image sizes
		$fav_wep_s = getimagesize($fav_wep_p);
		//load image into a new image resource
		$fav_wep_r = imagecreatefromgif($fav_wep_p) or die('error loading weapon icon');
		//merge image icon into main image
		imagecopymerge($img, $fav_wep_r, 110, 107, 0, 0, $fav_wep_s[0], $fav_wep_s[1],100);
		//delete image icon from ram
		imagedestroy($fav_wep_r);
		//delete image sizes
		unset($fav_wep_s);
	}
	else
		//if it doesn't, just give a textual representation of the weapon
		imagestring($img, 2, 7, 90, $fav_wep, $color);
	unset($fav_wep_p,$fav_wep);
}

//give the header content type as a gif image
header('Content-type: image/gif');

//echo image out as a gif
imagegif($img);

//kill image resource
imagedestroy($img);

//make sure it's sent
flush();

//stop
die;
?>
