<?php
/*	
This file is part of JRG Stats.

JRG Stats is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3 of the License, or
(at your option) any later version.

JRG Stats is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/


//anti hack
define('instats',true);


//keep going even if the user pushes escape / goes back / closes browser
@ignore_user_abort(true);

//give us unlimited time for running
@set_time_limit(0);

//check if include file exists
if (!is_file('inc.php'))
	die("The file inc.php cannot be found.\n");
	
//if it does, load it
require_once('inc.php');

//connect to mysql database
db_connect();

//send header as plain text
header('Content-type: text/plain');

//echo little jrgstats logoish thing
echo "------------------------------
|  JRG Stats - Stats Update  |
------------------------------\n\n";

//send it out immediately
flush();

//date of latest kill
list($latestdate) = mysql_fetch_row(mysql_query("select `date` from `{$db['prefix']}kills` order by `date` desc limit 1"));

//counters
$new = array('kills' => 0, 'suicides' => 0);


//do what is required based on log retrieval method

//if log method is set to get logs from a local kill folder
if ($log['get_method'] == 1)
{
	//check if directory exists
	if (!is_dir($log['local_log_path']))
	{
		echo "Local kills folder you specified is not a valid directory.\n";
		mysql_close();
		die;
	}
	
	//try switching to it
	if (!chdir($log['local_log_path']))
	{
		echo "Cannot change to the local kills folder you specified.\n";
		mysql_close();
		die;
	}
	
	//ok, it exists and we are inside of it.
	
	//get list of filenames
	$files = glob('*.txt');
	
	//make sure we have some files
	if (empty($files))
	{
		echo "There are no log files in the local kills folder you specified.\n";
		mysql_close();
		die;
	}
	
	//go through each one
	foreach($files as $file)
	{
		//make sure file can be read
		if (!is_readable($file))
		{
			echo "$file cannot be read.\n";
			flush();
			continue;
		}
				
		//the entire contents of the current logfile
		$contents = file_get_contents($file);
		
		//little bit of ram savage
		//unset($file);
		
		//make sure the file isn't empty
		if (empty($contents))
		{
			echo "$file is empty.\n";
			//echo out the above immediately
			flush();
			//skip what's below
			continue;
		}
		
		//Parse the log file. While parsing, add entries to database and work with it.
		parselogfile($contents, $new, $file);
	}
	
}


//for ftp logs
elseif ($log['get_method'] == 2)
{
	//attempt connecting to ftp server and assigning the connection resource to $fcon
	$fcon = @ftp_connect($log['ftp']['server'], $log['ftp']['port']) or die("Cannot connect to specified ftp server.\n");
	
	//attempt logging into the server, only if the server requires a username and password
	if (empty($log['ftp']['annon']))
		@ftp_login($fcon, $log['ftp']['user'], $log['ftp']['pass']) or die("Cannot login to FTP server with specified credentials.\n");
	
	//as of now, we are connected and logged in to ftp server

	//try changing to desired ftp directory
	if (!@ftp_chdir($fcon, $log['ftp']['path']))
	{
		//close connection to ftp server
		ftp_close($fcon);
		//close connection to mysql
		mysql_close();
		die("Can't change to specified FTP directory.");
	}
	
	//get list of remote filenames
	$files = ftp_nlist($fcon, '.');
		
	//check if we used any files at al
	if (empty($files))
	{
		//close connection to mysql database
		mysql_close();
		die("There are no log files in the folder you specifed.\n");
	}
	
	//counter for how many files are actually used
	$files_used = 0;
	
	//work with each file
	foreach($files as $f)
	{
		//if the file extension isn't txt, skip anything to do with it
		if (pathinfo($f, PATHINFO_EXTENSION) != 'txt')
			continue;
		//path of local temp file
		$t = './' . $log['ftp']['tmp'] . $f;
		//snag it
		if (!@ftp_get($fcon, $t, $f, FTP_BINARY))
		{
			echo "Error downloading $f to temp folder.\n";
			continue;
		}
		//snag it's contents into a var
		$contents = file_get_contents($t);
		//kill it
		unlink($t);
		//kill the memory of it
		unset($t);
		//make sure it contains stuff
		if (empty($contents))
			continue;
		//parse it
		parselogfile($contents, $new, $f);
		//increment the files used counter
		$files_used++;
	}
	
	//save some ram
	unset($files);
	
	//close connection to ftp server
	ftp_close($fcon);

	//save some ram
	unset($files_used);
}

//for http logs
elseif ($log['get_method'] == 3)
{

}


//we are done

//close connection to mysql
mysql_close();

//echo success message
echo "\n-----------------
|   Finished!   |
-----------------

".number_format($new['kills'])." new kills and ".number_format($new['suicides'])." new suicides.
This took ".round((microtime(true) - $start),4)." seconds.\n\n";


//these functions are used throughout this file


//this function inserts the logs into the database
function insertlogs($e)
{
	//get access to the database array
	global $db;
	
	//check if this entry is empty / there are no entries
	if (empty($e))
		return;

	//loop through each value in the array
	foreach($e as $k)
	{
		//query that gets the date of the latest kill recorded in the database
		//check if the killers name isn't in the players table yet, if it isn't, insert it
		if (mysql_num_rows(mysql_query("select null from `{$db['prefix']}players` where `name` = '{$k['k']}' limit 1")) == 0)
			@mysql_query("insert into `{$db['prefix']}players` (`name`) values ('{$k['k']}')") 
				or die('Error inserting killers name into database: '.mysql_error());

		//check if the victims name isn't in the players table yet, if it isn't insert it
		if ($k['s'] != 1) //skip this if the killer is the victim (suicide)
			if (mysql_num_rows(mysql_query("select null from `{$db['prefix']}players` where `name` = '{$k['v']}' limit 1")) == 0)
				@mysql_query("insert into `{$db['prefix']}players` (`name`) values ('{$k['v']}')") 
					or die('Error inserting victims name into database: '.mysql_error());

		//check if weapon is in weapons table, if it isn't, insert it
		if (mysql_num_rows(mysql_query("select null from `{$db['prefix']}weapons` where `name` = '{$k['w']}' limit 1")) == 0)
			@mysql_query("insert into `{$db['prefix']}weapons` (`name`) values ('{$k['w']}')") 
				or die('Error inserting weapon name into database: '.mysql_error());

		//get id's of killer, victim, and weapon used
		list($kid) = mysql_fetch_row(mysql_query("select `id` from `{$db['prefix']}players` where `name` = '{$k['k']}' limit 1"));
		list($vid) = mysql_fetch_row(mysql_query("select `id` from `{$db['prefix']}players` where `name` = '{$k['v']}' limit 1"));
		list($wid) = mysql_fetch_row(mysql_query("select `id` from `{$db['prefix']}weapons` where `name` = '{$k['w']}' limit 1"));

		//if a suicide
		if ($k['s'] == 1)
		{
			//insert kill info
			@mysql_query("insert into `{$db['prefix']}kills` (`killer`,`victim`,`weapon`,`suicide`,`date`) values ('$kid','$vid','$wid','1','{$k['d']}')")
				or die('Error inserting suicide kill info into database: '.mysql_error());
			//increment killers suicde and death count by one
			@mysql_query("update `{$db['prefix']}players` set `suicides` = `suicides` + 1, `deaths` = `deaths` + 1  where `id` = '$kid' limit 1")
				or die('Error increasing the players suicide and death count: '.mysql_error());
			//increment the weapon's suicides by one
			@mysql_query("update `{$db['prefix']}weapons` set `suicides` = `suicides` + 1 where `id` = '$wid' limit 1")
				or die('Error increasing the weapon\'s suicide count: '.mysql_error());
			//skip whats below
			continue;
		}

		//if a regular kill
		//insert kill info
		@mysql_query("insert into `{$db['prefix']}kills` set `killer` = '$kid', `victim` = '$vid', `weapon` = '$wid', `date` = '{$k['d']}'")
			or die('Error inserting regular kill info into database: '.mysql_error());

		//increment the killers kills by one
		@mysql_query("update `{$db['prefix']}players` set `kills` = `kills` + 1 where `id` = '$kid' limit 1")
			or die('Error increasing the killers kill count: '.mysql_error());

		//increment the victims deaths by one
		@mysql_query("update `{$db['prefix']}players` set `deaths` = `deaths` + 1 where `id` = '$vid' limit 1")
			or die('Error increasing the killers death count: '.mysql_error());

		//increment the weapon's kills by one
		@mysql_query("update `{$db['prefix']}weapons` set `kills` = `kills` + 1 where `id` = '$wid' limit 1")
			or die('Error increasing the weapon\'s kill count: '.mysql_error());

		//delete stuff we don't need anymore
		unset($kid,$vid,$wid,$k);
	}
	//save ram
	unset($e);
}

//this function reads a log file and every 200 kills, enters it into the database and starts over
function parselogfile(&$contents,&$new, $file)
{
	//get access to the date of the latest kill in the database
	global $latestdate;

	//get the two halves of the file (the first part and the last)
	$halves = explode("\n",$contents,2);
	
	//delete the entire file's contents from memory
	unset($contents);
	
	//make sure the second halve of the file contains kills
	if (empty($halves[1]))
	{
		echo "$file does not contain any entries.\n";
		flush();
		return;
	}
	
	//the second halve of the file as an array every four lines
	$kills = array_chunk(explode("\n",$halves[1]),4);

	//save ram by deleting the two halves of the file
	unset($halves);

	//this is where the entries for this log file will be stored
	$entries = array();

	//counter for entries of this single log file
	$this_entries = 0;

	foreach($kills as $k)
	{
		//automatically insert all entries every 200 entries
		if (count($entries) % 200 == 0 && $this_entries > 0)
		{
			//entry inserting function
			insertlogs($entries);
			//mega save ram
			//totally kill the gigantic entries array
			unset($entries);
			//start it off new and fresh
			$entries = array();
		}	

		//if array is empty, just skip this entry
		if (empty($k[0]))
			continue;

		//temporary array that holds info.		
		$t = array();

		//date of killing in unix timestamp
		$t['d'] = strtotime(str_replace('--- ','',$k[0]));

		//if kill older than latest on DB 
		if ($latestdate >= $t['d'])
		{
			//save ram
			unset($t,$k);
			//skip the rest
			continue;
		}
		
		//escaped name of killer
		$t['k'] = trim(db_prot($k[1]));

		//name of victim
		$t['v'] = trim(db_prot($k[2]));

		//weapon
		$t['w'] = trim(db_prot($k[3]));

		//determine if a bugged up logfile or not
		if ($t['k'] == '' || $t['v'] == '' || $t['w'] == '')
			continue;

		//determine if a suicide or not
		//if victim equals killer and weapon equals selfkill
		if ($t['k'] == $t['v'] && $t['w'] == 'Selfkill')
			$t['s'] = 1;
		//if victim equals killer and weapon doesn't equal selfkill
		elseif($t['k'] == $t['v'] && $t['w'] != 'Selfkill')
			$t['s'] = 1;
		//bug in 1.4 where USSOCOM kills are recorded as suicide. Should be a normal kill
		elseif($t['k'] != $t['v'] && $t['w'] == 'Selfkill')
		{
			$t['w'] = 'USSOCOM';
			$t['s'] = 0;
		}

		//normal kill
		elseif($t['k'] != $t['v'] && $t['w'] != 'Selfkill')
			$t['s'] = 0;

		//barret possible mispelling
		$t['w'] = str_replace('Barrett','Barret',$t['w']);
		
		//counters for statistics
		if (empty($t['s']))
			$new['kills']++;
		else
			$new['suicides']++;
		
		//insert this info into main kills array
		$entries[] = $t;

		//increment the number of entries contained in this log file
		$this_entries++;

		//kill temporary stuff we just used to save ram
		unset($k,$t);
	}
	
	//echo stat for this file
	echo "$file contains ".number_format($this_entries)." new entries.\n";
	flush();
	
	//save some ram
	unset($this_entries);
	
	//insert the entries into the database if there are more than 0 entries
	if (count($entries) > 0)
		insertlogs($entries);
		
	//mega save ram
	//totally kill the gigantic entries array
	unset($entries);
}



//end
die;
?>
