<?php
/*	
This file is part of JRG Stats.

JRG Stats is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3 of the License, or
(at your option) any later version.

JRG Stats is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
//page start in micro seconds
$start = microtime(true);

//antihack
defined('instats') or die;

//check if config file exists first
if (!is_file('config.php'))
	die('Configuration file <code>config.php</code> cannot be found.');

//load config file
require_once 'config.php';

//validate mysql config
foreach($db as $f => $i)
	if (trim($i) == '' && $f != 'prefix')
		die('MSQL section of Configuration file <code>config.php</code> not filled out completely.');

//validate logging methods
if ($log['get_method'] != 1 && $log['get_method'] != 2 && $log['get_method'] && $log['get_method'] != 3 || empty($log['get_method']) || !is_numeric($log['get_method']))
	die('Invalid log method specified in config file.');
//validate local logging methods
if ($log['get_method'] == 1 && empty($log['local_log_path']))
	die('No path to kills folder specified in config file.');
//validate ftp logging methods
if ($log['get_method'] == 2)
{
	//make sure server section is filled out
	if (empty($log['ftp']['server']))
		die('FTP Server not filled out.');
	//make sure ftp path is filled out
	if (empty($log['ftp']['path']))
		die('FTP Path not filled out.');
	//make sure user info is provided, if the server isn't anonomous
	//check for username
	if (empty($log['ftp']['annon']) && empty($log['ftp']['user']))
		die('FTP Username not filled out');
	//check for password
	if (empty($log['ftp']['annon']) && empty($log['ftp']['pass']))
		die('FTP Password not filled out');
	//validate port
	if (empty($log['ftp']['port']) || !is_numeric($log['ftp']['port']))
		$log['ftp']['port'] = 21;
	//specify temp folder (inclide trailing slash)
	$log['ftp']['tmp'] = 'ftp_tmp/';
	//make sure it exists
	if (!is_dir($log['ftp']['tmp']))
		die('FTP Temp Folder cannot be found');
	//make sure it is writeable
	if (!is_writable($log['ftp']['tmp']))
		die('Cannot write to FTP temp folder. You must change the permissions of the folder to enable it to be written to.');
}
//validate http logging methods
if ($log['get_method'] == 3)
{
	//make sure the http server is specified
	if (empty($log['http']['server']))
		die('HTTP Server not specified');
	//make sure the path on the server to the kills folder is specified
	if (empty($log['http']['path']))
		die('Path on http server to the kills folder not specified');
}

//validate minimum kills
if (empty($min_ranked_kills) || !is_numeric($min_ranked_kills))
	$min_ranked_kills = false;

//validate signature enablization
if (empty($signature_images) || !function_exists('gd_info') || !is_numeric($signature_images))
	$signature_images = false;
else
	$signature_images = true;
	
//version number
$version = '1.5';

//load layout file
require_once 'layout.php';

//useful functions
function db_connect()
{
	global $db;
	
	//make sure db config filled out all the way
			
	//connect
	if ($db['persist'] == 1)
		@mysql_pconnect($db['server'],$db['user'],$db['pass'])
			or die('Cannot persistantly connect to mysql database: ' . mysql_error());
	else
		@mysql_connect($db['server'],$db['user'],$db['pass'])
			or die('Cannot regularly connect to mysql database: ' . mysql_error());
	
	//if can't select database
	if (!mysql_select_db($db['db']))
	{
		//attempt creating database if it doesn't already exist
		@mysql_create_db($db['db'])
			or die('We cannot create your database for you. You must create it yourself or pick an existing one.');
		//then select it
		@mysql_select_db($db['db'])
			or die('Cannot select mysql database, even after trying to create it ourselves.');
	}

}
function db_prot($s)
{
	//check if string is just a number
	if (@is_numeric($s))
		return $s;
	
	//decide which function to use for escaping the string
	if (@function_exists('mysql_real_escape_string'))
		return mysql_real_escape_string($s);
	elseif(@function_exists('mysql_escape_string'))
		return mysql_escape_string($s);
	else
		return addslashes($s);
}
?>
