<?php
/*	
This file is part of JRG Stats.

JRG Stats is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3 of the License, or
(at your option) any later version.

JRG Stats is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

//antihack
defined('instats') or die;

//layout header
lt_head('Rankings');

##	suicides and kill stats	##
echo '
<h2>Stats</h2>
<ul>
	<li>Total kills: '.number_format($total_kills).'</li>
	<li>Total Suicides: '.number_format($total_suicides).'</li>
</ul>
';


##	top ten ranked players	##

if ($min_ranked_kills != false)
{
echo '
<a name="top10rankers"></a>
<h2>Top 10 Ranked Players</h2>
';

//query
$top10ranks = mysql_query("select `id`,`name`,`kills` from `{$db['prefix']}players` where `kills` >= $min_ranked_kills order by `kills` desc limit 10");

if (mysql_num_rows($top10ranks) > 0)
{

echo '
<table cellpadding="0" cellspacing="0">
<tr>
	<th class="rank_cell">#</th>
	<th>Name</th>
	<th>Kills</th>
</tr>
';
//loop through query
for ($i = 0, $r = 1; $p = mysql_fetch_assoc($top10ranks); $i++, $r++)
	echo '<tr',($i % 2) ? ' class="alt"' : '','>
	<td class="num">'.$r.'</td>
	<td><a href="'.$_SERVER['PHP_SELF'].'?sa=player&amp;id='.$p['id'].'">'.htmlentities(stripslashes($p['name'])).'</a></td>
	<td class="num">'.number_format($p['kills']).'</td>
</tr>
';

mysql_free_result($top10ranks);
echo '
</table>
<p><em>It takes atleast '.number_format($min_ranked_kills).' kills to be ranked</em></p>
';
}
else
echo '<p><em>No one is ranked yet. It takes '.$min_ranked_kills.' kills to be ranked.</em></p>';

}

##	top ten kills list	##
echo '
<a name="top10killers"></a>
<h2>Top 10 Killers</h2>
';

//query
$top10killers = mysql_query("select `id`,`name`,`kills` from `{$db['prefix']}players` order by `kills` desc limit 10");

echo '
<table cellpadding="0" cellspacing="0">
<tr>
	<th class="rank_cell">#</th>
	<th>Name</th>
	<th>Kills</th>
</tr>
';

//loop through query
for ($i = 0, $r = 1; $p = mysql_fetch_assoc($top10killers); $i++, $r++)
	echo '<tr',($i % 2) ? ' class="alt"' : '','>
	<td class="num">'.$r.'</td>
	<td><a href="'.$_SERVER['PHP_SELF'].'?sa=player&amp;id='.$p['id'].'">'.htmlentities(stripslashes($p['name'])).'</a></td>
	<td class="num">'.number_format($p['kills']).'</td>
</tr>
';

mysql_free_result($top10killers);
echo '</table>';

##	top ten K:D ratio list	##
echo '
<a name="top10kd"></a>
<h2>Top 10 K:D</h2>
';
$top10kd = mysql_query("select `id`,`name`, (`kills` / `deaths`) as `kd` from `{$db['prefix']}players` order by `kd` desc limit 10");
echo '
<table cellpadding="0" cellspacing="0">
<tr>
	<th class="rank_cell">#</th>
	<th>Name</th>
	<th>K:D</th>
</tr>
';

//loop through query
for ($i = 0, $r = 1; $p = mysql_fetch_assoc($top10kd); $i++, $r++)
echo '
<tr',($i % 2) ? ' class="alt"' : '','>
	<td class="num">'.$r.'</td>
	<td><a href="'.$_SERVER['PHP_SELF'].'?sa=player&amp;id='.$p['id'].'">'.htmlentities(stripslashes($p['name'])).'</a></td>
	<td class="num">'.round($p['kd'],2).'</td>
</tr>
';

mysql_free_result($top10kd);
echo '</table>';


##	top ten victims list	##
echo '
<a name="top10victims"></a>
<h2>Top 10 Victims</h2>
';
$top10victims = mysql_query("select `id`,`name`,`deaths` from `{$db['prefix']}players` order by `deaths` desc limit 10");
echo '
<table cellpadding="0" cellspacing="0">
<tr>
	<th class="rank_cell">#</th>
	<th>Name</th>
	<th>Deaths</th>
</tr>
';

//loop through query
for($i = 0, $r = 1; $p = mysql_fetch_assoc($top10victims); $i++, $r++)
echo '
<tr',($i % 2) ? ' class="alt"' : '','>
	<td class="num">'.$r.'</td>
	<td><a href="'.$_SERVER['PHP_SELF'].'?sa=player&amp;id='.$p['id'].'">'.htmlentities(stripslashes($p['name'])).'</a></td>
	<td class="num">'.number_format($p['deaths']).'</td>
</tr>
';

echo '</table>';

//clear ram used by query
mysql_free_result($top10victims);

##	top ten suiciders list	##
echo '
<a name="top10suiciders"></a>
<h2>Top 10 Kamikaze Players</h2>
';
$top10suicides = mysql_query("select `id`,`name`,`suicides` from `{$db['prefix']}players` order by `suicides` desc limit 10");
echo '
<table cellpadding="0" cellspacing="0">
<tr>
	<th class="rank_cell">#</th>
	<th>Name</th>
	<th>Suicides</th>
</tr>
';

//loop through query
for($i = 0, $r = 1; $p = mysql_fetch_assoc($top10suicides); $i++, $r++)
echo '
<tr',($i % 2) ? ' class="alt"' : '','>
	<td class="num">'.$r.'</td>
	<td><a href="'.$_SERVER['PHP_SELF'].'?sa=player&amp;id='.$p['id'].'">'.htmlentities(stripslashes($p['name'])).'</a></td>
	<td class="num">'.number_format($p['suicides']).'</td>
</tr>
';

echo '</table>';

//clear ram used by query
mysql_free_result($top10suicides);

##	Search Form	##
echo '
<h2>Search For Player</h2>
<form action="'.$_SERVER['PHP_SELF'].'" method="get">
	<input type="hidden" id="sa" name="sa" value="search" />
	<label for="name">Player Name: </label> <input type="text" id="name" name="name" /> <input type="submit" value="Search!" />
</form>';

##	More
echo '
<h2>More</h2>
<ul>
	<li><a href="'.$_SERVER['PHP_SELF'].'?sa=top_weapons">View the most popular weapons</a></li>
	<li><a href="'.$_SERVER['PHP_SELF'].'?sa=players_list">View full player list</a></li>
	<li><a href="'.$_SERVER['PHP_SELF'].'?sa=history">View kill history</a></li>
</ul>';

//layout footer
lt_foot();
?>
