<?php
/*	
This file is part of JRG Stats.

JRG Stats is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3 of the License, or
(at your option) any later version.

JRG Stats is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/


//anti hack
define('instats',true);

//keep going even if the user pushes escape / goes back / closes browser
@ignore_user_abort(true);

//give us unlimited time for running
@set_time_limit(0);


//load config file
require_once 'inc.php';

//connect to mysql database
db_connect();

//send header as plain text
header('Content-type: text/plain');

echo "------------------------------
|  JRG Stats - Stats Update  |
------------------------------\n\n";

flush();

//check if path given is a real directory
if (!is_dir($path))
{
	mysql_close();
	die("The path to the log folder you specified \"$path\" does not exist or is not a directory.\n");
}

//try changing to this directory
if (!chdir($path))
{
	mysql_close();
	die("Error changing to the path to the logfolder you gave me: \"$path\"\n");
}

//we are in the directory.

//echo status
echo "Successfully inside desired killog folder.\nParsing logs to get entries...\n\n";

flush();

//get list of files with the file extension .txt that are in the directory
$logfiles = glob('*.txt');

//make sure that there are files found
if (empty($logfiles))
{
	mysql_close();
	die("No logfiles found in the folder you specified \"$path\".\n");
}

//total number of log files
$numlogfiles = count($logfiles);

//latest database log entry
$getlatestdate = mysql_fetch_row(mysql_query("select `date` from `{$db['prefix']}kills` order by `date` desc limit 1"));
$latestdate = $getlatestdate[0];
unset($getlatestdate);

//kills will be stored in this array
$entries = array();

//function that inserts entries into the database
function insertlogs(&$entries)
{
	global $latestdate,$db;
	
	//check if this entry is empty / there are no entries
	if (empty($entries))
		return;

	//loop through each value in the array
	foreach($entries as $eid => $k)
	{
		//query that gets the date of the latest kill recorded in the database
		//check if the killers name isn't in the players table yet, if it isn't, insert it
		if (mysql_num_rows(mysql_query("select null from `{$db['prefix']}players` where `name` = '{$k['k']}' limit 1")) == 0)
			@mysql_query("insert into `{$db['prefix']}players` (`name`) values ('{$k['k']}')") 
				or die('Error inserting killers name into database: '.mysql_error());

		//check if the victims name isn't in the players table yet, if it isn't insert it
		if ($k['s'] != 1) //skip this if the killer is the victim (suicide)
			if (mysql_num_rows(mysql_query("select null from `{$db['prefix']}players` where `name` = '{$k['v']}' limit 1")) == 0)
				@mysql_query("insert into `{$db['prefix']}players` (`name`) values ('{$k['v']}')") 
					or die('Error inserting victims name into database: '.mysql_error());

		//check if weapon is in weapons table, if it isn't, insert it
		if (mysql_num_rows(mysql_query("select null from `{$db['prefix']}weapons` where `name` = '{$k['w']}' limit 1")) == 0)
			@mysql_query("insert into `{$db['prefix']}weapons` (`name`) values ('{$k['w']}')") 
				or die('Error inserting weapon name into database: '.mysql_error());

		//get id's of killer, victim, and weapon used
		$ki = mysql_fetch_row(mysql_query("select `id` from `{$db['prefix']}players` where `name` = '{$k['k']}' limit 1"));
		$vi = mysql_fetch_row(mysql_query("select `id` from `{$db['prefix']}players` where `name` = '{$k['v']}' limit 1"));
		$wi = mysql_fetch_row(mysql_query("select `id` from `{$db['prefix']}weapons` where `name` = '{$k['w']}' limit 1"));
		$kid = $ki[0];
		$vid = $vi[0];
		$wid = $wi[0];
		unset($ki,$vi,$wi);

		//if a suicide
		if ($k['s'] == 1)
		{
			//insert kill info
			@mysql_query("insert into `{$db['prefix']}kills` (`killer`,`victim`,`weapon`,`suicide`,`date`) values ('$kid','$vid','$wid','1','{$k['d']}')")
				or die('Error inserting suicide kill info into database: '.mysql_error());
			//increment killers suicde and death count by one
			@mysql_query("update `{$db['prefix']}players` set `suicides` = `suicides` + 1, `deaths` = `deaths` + 1  where `id` = '$kid' limit 1")
				or die('Error increasing the players suicide and death count: '.mysql_error());
			//increment the weapon's suicides by one
			@mysql_query("update `{$db['prefix']}weapons` set `suicides` = `suicides` + 1 where `id` = '$wid' limit 1")
				or die('Error increasing the weapon\'s suicide count: '.mysql_error());
			//skip whats below
			continue;
		}

		//if a regular kill
		//insert kill info
		@mysql_query("insert into `{$db['prefix']}kills` set `killer` = '$kid', `victim` = '$vid', `weapon` = '$wid', `date` = '{$k['d']}'")
			or die('Error inserting regular kill info into database: '.mysql_error());

		//increment the killers kills by one
		@mysql_query("update `{$db['prefix']}players` set `kills` = `kills` + 1 where `id` = '$kid' limit 1")
			or die('Error increasing the killers kill count: '.mysql_error());

		//increment the victims deaths by one
		@mysql_query("update `{$db['prefix']}players` set `deaths` = `deaths` + 1 where `id` = '$vid' limit 1")
			or die('Error increasing the killers death count: '.mysql_error());

		//increment the weapon's kills by one
		@mysql_query("update `{$db['prefix']}weapons` set `kills` = `kills` + 1 where `id` = '$wid' limit 1")
			or die('Error increasing the weapon\'s kill count: '.mysql_error());

		//delete stuff we don't need anymore
		unset($kid,$vid,$wid,$k);
	}
}


//these will be the total number of new kills and suicides
$new_kills = 0;
$new_suicides = 0;

//go through and work with each logfile
foreach($logfiles as $file)
{
	//make sure we can access this file
	if (!is_file($file))
	{
		echo "$file cannot be read. Skipping...\n";
		flush();
		continue;
	}
	
	//the entire contents of the current logfile
	$contents = file_get_contents($file);
	
	//make sure the file isn't empty
	if (empty($contents))
	{
		echo "$file is empty.\n";
		flush();
		continue;
	}
	
	//get the two halves of the file (the first part and the last)
	$halves = explode("\n",$contents,2);
	
	//delete the entire files contents from memory
	unset($contents);
	
	//make sure the second halve of the file contains kills
	if (empty($halves[1]))
	{
		echo "$file does not contain any entries.\n";
		flush();
		continue;
	}
	
	//the second halve of the file as an array every four lines
	$kills = array_chunk(explode("\n",$halves[1]),4);
	

	//save ram by deleting the two halves of the file
	unset($halves);
	
	//counter for the number of entries contained in the current log folder
	$this_entries = 0;
	
	//go through each kill
	foreach($kills as $k)
	{
		//automatically insert all entries every 50 entries
		if ($this_entries % 50 == 0 && count($entries) > 0)
		{
			//entry inserting function
			insertlogs($entries);
			//mega save ram
			//totally kill the gigantic entries array
			unset($entries);
			//start it off new and fresh
			$entries = array();
		}	

		//if array is empty, just skip this entry
		if (empty($k[0]))
			continue;

		//temporary array that holds info.		
		$t = array();

		//date of killing in unix timestamp
		$t['d'] = strtotime(str_replace('--- ','',$k[0]));

		//escaped name of killer
		$t['k'] = trim(db_prot($k[1]));

		//name of victim
		$t['v'] = trim(db_prot($k[2]));

		//weapon
		$t['w'] = trim($k[3]);

		//determine if a bugged up logfile or not
		if ($t['k'] == '' || $t['v'] == '' || $t['w'] == '')
			continue;

		//determine if a suicide or not
		//if victim equals killer and weapon equals selfkill
		if ($t['k'] == $t['v'] && $t['w'] == 'Selfkill')
			$t['s'] = 1;
		//if victim equals killer and weapon doesn't equal selfkill
		elseif($t['k'] == $t['v'] && $t['w'] != 'Selfkill')
			$t['s'] = 1;
		//bug in 1.4 where USSOCOM kills are recorded as suicide. Should be a normal kill
		elseif($t['k'] != $t['v'] && $t['w'] == 'Selfkill')
		{
			$t['w'] = 'USSOCOM';
			$t['s'] = 0;
		}

		//normal kill
		elseif($t['k'] != $t['v'] && $t['w'] != 'Selfkill')
			$t['s'] = 0;

		//barret possible mispelling
		$t['w'] = str_replace('Barrett','Barret',$t['w']);

		//if kill older than latest on DB 
		if ($latestdate >= $t['d'])
		{
			//save ram
			unset($k);
			//skip the rest
			continue;
		}
		
		//counters for statistics
		if (empty($t['s']))
			$new_kills++;
		else
			$new_suicides++;
		
		//insert this info into main kills array
		$entries[] = $t;

		//increment the number of entries contained in this log file
		$this_entries++;

		//kill temporary stuff we just used to save ram
		unset($k,$t);
	}
	
	//echo stat for this file
	echo "$file contains ".number_format($this_entries)." new entries.\n";
	flush();
	
	//save some ram
	unset($this_entries);
	
	//insert the entries into the database if there are more than 0 entries
	if (count($entries) > 0)
		insertlogs($entries);
		
	//mega save ram
	//totally kill the gigantic entries array
	unset($entries);
	//start it off new and fresh
	$entries = array();
}


//close connection to database
mysql_close();	
	
echo "\n-----------------
|   Finished!   |
-----------------\n";

echo "\n".number_format($new_kills)." new kills and ".number_format($new_suicides)." new suicides.\n";
echo "This took ".round((microtime(true) - $start),4)." seconds.\n";

flush();

die;
?>
