<?php
/*	
This file is part of JRG Stats.

JRG Stats is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3 of the License, or
(at your option) any later version.

JRG Stats is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

//antihack
defined('instats') or die;

//if no player name passed
if (trim($_GET['id']) == '')
{
	lt_head('Player ID missing');
	echo '<p>Player ID missing from url. <a href="'.$_SERVER['PHP_SELF'].'">Go Back</a></p>';
	lt_foot();
	mysql_close();
	die;
}

//db safe player id
$pid = db_prot($_GET['id']);

//get player info query
$query = mysql_query("select `name`, `deaths`, `kills`, `suicides`, (`kills` / `deaths`) as kd from `{$db['prefix']}players` where `id` = '$pid' limit 1");

//check if player id exists in database
if (mysql_num_rows($query) == 0)
{
	lt_head('Invalid player id');
	echo '<p>Invalid player ID of the name you typed does not exist. <a href="'.$_SERVER['PHP_SELF'].'">Go Back</a></p>';
	lt_foot();
	mysql_close();
	die;
}

//player found, snag info into an array
$in = mysql_fetch_assoc($query);
lt_head('Player Profile: '.htmlentities(stripslashes($in['name'])));
mysql_free_result($query);

//my stats percents of totals
$kill_percent = ($total_kills == 0) ? 0 : round($in['kills'] / $total_kills,3) * 100;
$death_percent = ($total_deaths == 0) ? 0 : round($in['deaths'] / $total_deaths,3) * 100;
$suicide_percent = ($total_suicides == 0) ? 0 : round($in['suicides'] / $total_suicides,3) * 100;

//get my rank, if ranking enabled
if ($min_ranked_kills != false)
{
	if ($in['kills'] < $min_ranked_kills)
		$rank = '<em>Not ranked*</em>';
	else
	{
		//temp array
		$rankers = array();
		//gets id's of ranked players
		$query = mysql_query("select `id` from `{$db['prefix']}players` where `kills` >= $min_ranked_kills order by `kills` desc");
		//total number of ranked players
		$total_ranked = mysql_num_rows($query);
		//loop through query inserting the values into the temporary array
		while ($i = mysql_fetch_row($query))
			$rankers[] = $i[0];
		//save ram
		mysql_free_result($query);
		//loop through the temp array
		foreach($rankers as $r => $i)
		{
			//if me
			if ($i == $pid)
			{
				//this is my rank
				$rank = ($r + 1);
				//stop looking for me
				break;	
			}
		}
		//save ram
		unset($rankers);
	
	}
}

//get my favorite weapons
$wep_query = mysql_query("
select
	`{$db['prefix']}weapons`.`name`
from
	`{$db['prefix']}kills`,
	`{$db['prefix']}weapons`
where 
	`{$db['prefix']}kills`.`killer` = '$pid'
	AND `{$db['prefix']}kills`.`suicide` = 0
	AND `{$db['prefix']}weapons`.`id` = `{$db['prefix']}kills`.`weapon`");
if (mysql_num_rows($wep_query) == 0)
{
	mysql_free_result($wep_query);
	$fav_wep_n = false;
	$fav_wep_i = false;
	$fav_weps = false;
}
else
{
	//temp array to hold info
	$fav_weps = array();
	
	//loop through query, working with the array above to store weapon stats
	while($f = mysql_fetch_row($wep_query))
	{
		if (!isset($fav_weps[$f[0]]) || empty($fav_weps[$f[0]]))
			$fav_weps[$f[0]] = 1;
		else
			$fav_weps[$f[0]]++;
	}
	
	//save ram
	mysql_free_result($wep_query);

	//sort array
	array_multisort($fav_weps,SORT_DESC);

	//name and ID of favorite wep
	$fav_wep_n = array_values(array_flip($fav_weps));
	$fav_wep_i = mysql_fetch_row(mysql_query("select `id` from `{$db['prefix']}weapons` where `name` = '{$fav_wep_n[0]}' limit 1"));
}

//statistics table
echo '<h2>Statistics</h2>
<table cellpadding="0" cellspacing="0">';
	if ($min_ranked_kills != false)
	echo '
<tr>
		<th>Rank</th>
		<td class="num">',(is_numeric($rank)) ? $rank.' out of '.$total_ranked.' ranked players' : $rank,'</td>
	</tr>';
echo '
	<tr>
		<th>Kills</th>
		<td class="num">'.number_format($in['kills']).' <em>('.$kill_percent.'% of total)</em></td>
	</tr>
	<tr>
		<th>Deaths</th>
		<td class="num">'.number_format($in['deaths']).' <em>('.$death_percent.'% of total)</em></td>
	</tr>
	<tr>
		<th>Suicides</th>
		<td class="num">'.number_format($in['suicides']).' <em>('.$suicide_percent.'% of total)</em></td>
	</tr>
	<tr>
		<th>K:D Ratio</th>
		<td class="num">'.round($in['kd'],2).'</td>
	</tr>
	<tr>
		<th>Favorite Weapon</th>
		<td class="num">
			',($fav_weps != false) ? '<a href="'.$_SERVER['PHP_SELF'].'?sa=weapon_stats&amp;id='.$fav_wep_i[0].'"><img src="img/'.str_replace(' ','_',$fav_wep_n[0]).'.gif" alt="'.$fav_wep_n[0].'" /></a>' : 
			'<em>none</em>', '
		</td>
	</tr>
</table>';
//tell how many more kills needed to be ranked
if (!is_numeric($rank) && $min_ranked_kills != false)
echo '
<p>*<em>You need atleast '.($min_ranked_kills - $in['kills']).' more kills to be ranked.</em></p>
';

//save ram
unset($kill_percent,$death_percent,$suicide_percent,$fav_wep);

//this players favorite weapons
echo '
<h2>Favorite Weapons</h2>
';

if ($fav_weps != false)
{
echo '
<table cellpadding="0" cellspacing="0">
<tr>
	<th class="rank_cell">#</th>
	<th>Weapon</th>
	<th class="num">Kills</th>
</tr>
';

$i = 0;
$r = 1;
foreach($fav_weps as $n => $k)
{
	$w = mysql_fetch_row(mysql_query("select `id` from `{$db['prefix']}weapons` where `name` = '$n' limit 1"));
	echo '
<tr',($i % 2) ? ' class="alt"' : '' ,'>
	<td>'.$r.'</td>
	<td><a href="'.$_SERVER['PHP_SELF'].'?sa=weapon_stats&amp;id='.$w[0].'">'.$n.'</a></td>
	<td class="num">'.number_format($k).'</td>
</tr>
	';
	$i++;
	$r++;
	unset($fav_weps[$n],$w);
}

echo '</table>';
}
else
echo '
<p><em>This player has no kills with any weapon</em></p>
';


unset($i,$r,$fav_weps);

//most recent 20 kills by this player
echo '
<h2>Latest 20 Kills</h2>
';

//big arse kills query
$kill_query = mysql_query("
select
	`{$db['prefix']}kills`.`victim` as vid,
	`{$db['prefix']}kills`.`weapon` as wid,
	`{$db['prefix']}weapons`.`name` as wn,
	`{$db['prefix']}players`.`name` as vn,
	`{$db['prefix']}kills`.`date` as d,
	`{$db['prefix']}kills`.`suicide` as s
from
	`{$db['prefix']}kills`,
	`{$db['prefix']}weapons`,
	`{$db['prefix']}players`
where
	`{$db['prefix']}kills`.`killer` = $pid
	AND
	`{$db['prefix']}players`.`id` = `{$db['prefix']}kills`.`victim`
	AND
	`{$db['prefix']}weapons`.`id` = `{$db['prefix']}kills`.`weapon`
order by `{$db['prefix']}kills`.`date` desc limit 20
");

if (mysql_num_rows($kill_query) > 0)
{
echo '
<table cellpadding="0" cellspacing="0">
<tr>
	<th>Victim</th>
	<th>Weapon</th>
	<th>Date</th>
</tr>
';

//loop through the query
for ($i = 0; $k = mysql_fetch_assoc($kill_query); $i++)
{
echo '<tr',($i % 2) ? ' class="alt"' : '','>
';
	if ($k['s'] != 1)
	echo '
	<td><a href="'.$_SERVER['PHP_SELF'].'?sa=player&amp;id='.$k['vid'].'">'.htmlentities(stripslashes($k['vn'])).'</a></td>
	<td><a href="'.$_SERVER['PHP_SELF'].'?sa=weapon_stats&amp;id='.$k['wid'].'"><img src="img/'.str_replace(' ','_',$k['wn']).'.gif" alt="'.$k['wn'].'" /></a></td>
	';
	elseif($k['s'] == 1 && $k['wn'] != 'Selfkill')
	echo '
	<td><em>Suicide</em></td>
	<td><a href="'.$_SERVER['PHP_SELF'].'?sa=weapon_stats&amp;id='.$k['wid'].'"><img src="img/'.str_replace(' ','_',$k['wn']).'.gif" alt="'.$k['wn'].'" /></a></td>
	';
	elseif($k['s'] == 1 && $k['wn'] == 'Selfkill')
	echo '
	<td colspan="2"><em>Suicide</em></td>
	';
echo '<td>'.date('m-d-Y g:i:s A',$k['d']).'</td>
</tr>
';
}
mysql_free_result($kill_query);
unset($kill_query);
echo '</table>
';
}
else
	echo '<p><em>This player has no kills</em></p>';

echo '<p><a href="'.$_SERVER['PHP_SELF'].'">Go Back</a></p>';

//layout footer
lt_foot();
?>
