<?php
/*	
This file is part of JRG Stats.

JRG Stats is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3 of the License, or
(at your option) any later version.

JRG Stats is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

//antihack
defined('instats') or die;

//rows per page
$perpage = 50;

//number of pages
$pages = floor($total_kills / $perpage);

//current page
if (is_numeric($_GET['page']) && $_GET['page'] > 1 && $_GET['page'] <= $pages)
	$current_page = $_GET['page'];
else
	$current_page = 1;

//limit
if ($current_page == 1)
	$limit = 0;
else
	$limit = $perpage * $current_page;

//layout header
if ($total_kills > $perpage)
	lt_head('Kill History');
else
	lt_head('Kill History - Page ' . $current_page);

//decide whether or not to display the pagination links
if ($total_kills > $perpage)
{
	echo '<p>Page: ';
	for ($i = 1; $i <= $pages; $i++)
		echo ($i != $current_page) ? '<a href="'.$_SERVER['PHP_SELF'].'?sa=history&amp;page='.$i.'">'.$i.'</a>'."\n" : '<strong>'.$i.'</strong>'."\n";
	echo '</p>';
}

echo '
<table cellpadding="0" cellspacing="0">
<colgroup>
	<col style="width: 30%;" />
	<col style="width: 30%;" />
	<col style="width: 54px;" />
	<col style="width: 40%; text-align: center;" />
</colgroup>
<tr>
	<th>Killer</th>
	<th>Victim</th>
	<th>Weapon</th>
	<th>Date</th>
</tr>';

//get kill history query
$query = mysql_query("
select
	`{$db['prefix']}kills`.`killer` as kid,
	`{$db['prefix']}kills`.`victim` as vid,
	`{$db['prefix']}kills`.`weapon` as wid,
	`{$db['prefix']}kills`.`date` as d,
	`{$db['prefix']}kills`.`suicide` as s,
	`{$db['prefix']}players`.`name` as kn,
	`{$db['prefix']}weapons`.`name` as wn,
	(select `name` from `{$db['prefix']}players` where `id` = vid) as vn
from
	`{$db['prefix']}kills`,
	`{$db['prefix']}players`,
	`{$db['prefix']}weapons`
where
	`{$db['prefix']}kills`.`killer` = `{$db['prefix']}players`.`id`
	AND
	`{$db['prefix']}kills`.`weapon` = `{$db['prefix']}weapons`.`id`
order
by d desc limit ".$limit.','.$perpage);

//loop through kills
for($i = 0; $p = mysql_fetch_assoc($query); $i++)
{
	if ($p['s'] == 1)
	echo '<tr',($i % 2) ? ' class="alt"' : '','>
	<td><a href="'.$_SERVER['PHP_SELF'].'?sa=player&amp;id='.$p['kid'].'">'.htmlentities(stripslashes($p['kn'])).'</a></td>'
	,($p['wn'] == 'Selfkill') ? 
	'<td colspan="2"><em>suicide</em></td>' : '<td><em>suicide</em></td><td><a href="'.$_SERVER['PHP_SELF'].'?sa=weapon_stats&amp;id='.$p['wid'].'"><img src="img/'.str_replace(' ','_',$p['wn']).'.gif" alt="'.$p['wn'].'" /></a></td>','
	<td>'.date('m-d-Y g:i:s A',$p['d']).'</td>
</tr>
	';
	else
	echo '<tr',($i % 2) ? ' class="alt"' : '','>
	<td><a href="'.$_SERVER['PHP_SELF'].'?sa=player&amp;id='.$p['kid'].'">'.htmlentities(stripslashes($p['kn'])).'</a></td>
	<td><a href="'.$_SERVER['PHP_SELF'].'?sa=player&amp;id='.$p['vid'].'">'.htmlentities(stripslashes($p['vn'])).'</a></td>
	<td><a href="'.$_SERVER['PHP_SELF'].'?sa=weapon_stats&amp;id='.$p['wid'].'"><img src="img/'.str_replace(' ','_',$p['wn']).'.gif" alt="'.$p['wn'].'" /></a></td>
	<td>'.date('m-d-Y g:i:s A',$p['d']).'</td>
</tr>
	';
	unset($p);
}

//loop save ram used by query
mysql_free_result($query);
echo '
</table>';

//decide whether or not to display the pagination links
if ($total_kills > $perpage)
{
	echo '<p>Page: ';
	for ($i = 1; $i <= $pages; $i++)
		echo ($i != $current_page) ? '<a href="'.$_SERVER['PHP_SELF'].'?sa=history&amp;page='.$i.'">'.$i.'</a>'."\n" : '<strong>'.$i.'</strong>'."\n";
	echo '</p>';
}


echo '
<p>
	<a href="'.$_SERVER['PHP_SELF'].'">Go Back</a>
</p>
';

//layout footer
lt_foot();
?>
