<?php
/*	
This file is part of JRG Stats.

JRG Stats is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3 of the License, or
(at your option) any later version.

JRG Stats is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
//anti hack
define('instats',true);

//load config file
require_once 'inc.php';

//connect to mysql
db_connect();

//query for getting the number of kills
$numkills = mysql_num_rows(mysql_query("select null from `{$db['prefix']}kills` limit 1"));

/*
//query for getting the total number of kills, not counting suicides
$total_kills = mysql_num_rows(mysql_query("select null from `{$db['prefix']}kills` where `suicide` = 0"));

//query for getting the total number of suicides
$total_suicides_a = mysql_fetch_assoc(mysql_query("select sum(`suicides`) from `{$db['prefix']}players`"));
$total_suicides = $total_deaths_a['sum(`deaths`)'];
unset($total_suicides_a);

//query for getting the total number of deaths
$total_deaths_a = mysql_fetch_assoc(mysql_query("select sum(`deaths`) from `{$db['prefix']}players`"));
$total_deaths = $total_deaths_a['sum(`deaths`)'];
unset($total_deaths_a);
*/

//totals for everything
$tq = mysql_fetch_assoc(mysql_query("select sum(`kills`) as k, sum(`deaths`) as d, sum(`suicides`) as s from `{$db['prefix']}players` limit 1"));
$total_kills = $tq['k'];
$total_deaths = $tq['d'];
$total_suicides = $tq['s'];
unset($tq);


//if no kills whatsoever
if ($numkills == 0)
{
	lt_head('No kills yet');
	echo '<p>No kills have been recorded yet</p>';
	lt_foot();
	mysql_close();
	die;
}
unset($numkills);


//so we've got kills, decide what to do next....
if (@$_GET['sa'] == 'player')
{
	//if no player name passed
	if (trim($_GET['name']) == '')
	{
		lt_head('Didn\'t type player name.');
		echo '<p>You did not type a player name.<a href="'.$_SERVER['PHP_SELF'].'">Go Back</a></p>';
		lt_foot();
		mysql_close();
		die;
	}
	//safe player name
	$name = trim(db_prot(urldecode($_GET['name'])));
	
	//get player info query
	$query = mysql_query("select `id`, `name`, `deaths`, `kills`, `suicides`, (`kills` / `deaths`) as kd from `{$db['prefix']}players` where `name` = '$name' limit 1");
	
	unset($name);
	
	//check if name exists in database
	if (mysql_num_rows($query) == 0)
	{
		lt_head('Invalid player name');
		echo '<p>Sorry, a player of the name you typed does not exist. <a href="'.$_SERVER['PHP_SELF'].'">Go Back</a></p>';
		lt_foot();
		mysql_close();
		die;
	}

//player found, snag info into an array
$in = mysql_fetch_assoc($query);
lt_head('Player Profile: '.htmlentities(stripslashes($in['name'])));
mysql_free_result($query);
unset ($query);

//get my latest kills
$kill_query = mysql_query("select `victim`,`date`,`suicide`,`weapon` from `{$db['prefix']}kills` where `killer` = '{$in['name']}' order by `id` desc limit 20");

//check if I have kills, if I do, get my weapons used
if (mysql_num_rows($kill_query) > 0)
{
	//query
	$weps_query = mysql_query("select `weapon` from `{$db['prefix']}kills` where `killer` = '{$in['name']}'");
	//array that will contain the weapons
	$weps = array();
	//loop through query
	while ($w = mysql_fetch_assoc($weps_query))
	{
		$w = $w['weapon'];
		//skip suicides / possible logging bugs
		if (strtolower($w) == 'selfkill' || trim($w) == '')
			continue;
		if (!$weps[$w] || $weps[$w] == 0)
			$weps[$w] = 1;
		else
			$weps[$w]++;
	}
	//save ram
	mysql_free_result($weps_query);
	unset($w);
	//sort array
	array_multisort($weps,SORT_DESC);
	//favorite weapon
	$fav_wep = array_values(array_flip($weps));
}
else
	$weps = false;

$kill_percent = ($total_kills < 1) ? 0 : round($in['kills'] / $total_kills,3) * 100;
$death_percent = ($total_deaths < 1) ? 0 : round($in['deaths'] / $total_deaths,3) * 100;
$suicide_percent = ($total_suicides < 1) ? 0 : round($in['suicides'] / $total_suicides,3) * 100;

//statistics table
echo '<h2>Statistics</h2>
<table cellpadding="0" cellspacing="0">
	<tr>
		<th>Kills</th>
		<td class="num">'.number_format($in['kills']).' <em>('.$kill_percent.'% of total)</em></td>
	</tr>
	<tr>
		<th>Deaths</th>
		<td class="num">'.number_format($in['deaths']).' <em>('.$death_percent.'% of total)</em></td>
	</tr>
	<tr>
		<th>Suicides</th>
		<td class="num">'.number_format($in['suicides']).' <em>('.$suicide_percent.'% of total)</em></td>
	</tr>
	<tr>
		<th>K:D Ratio</th>
		<td class="num">'.round($in['kd'],2).'</td>
	</tr>
	<tr>
		<th>Favorite Weapon</th>
		<td>', ($weps != false) ? '<a href="'.$_SERVER['PHP_SELF'].'?sa=weapon_stats&amp;weapon='.urlencode($fav_wep[0]).'"><img src="img/'.str_replace(' ','_',$fav_wep[0]).'.gif" alt="'.$fav_wep[0].'" /></a>' : '<em>Unknown</em>' ,'</td>
	</tr>
</table>';

unset($kill_percent,$death_percent,$suicide_percent);

//players favorite weapon stats
echo '
<h2>Favorite Weapons</h2>
';
if ($weps != false)
{
unset($fav_wep);
$i = 0;
echo '
<table cellpadding="0" cellspacing="0">
<tr>
	<th>Weapon</th>
	<th>Kills</th>
</tr>	
';
foreach($weps as $w => $n)
{
echo '
<tr',($i % 2) ? ' class="alt"' : '' ,'>
	<td><a href="'.$_SERVER['PHP_SELF'].'?sa=weapon_stats&amp;weapon='.urlencode($w).'"><img src="img/'.str_replace(' ','_',$w).'.gif" alt="'.$w.'" /></a></td>
	<td>'.number_format($n).'</td>
</tr>
';
$i++;
}
unset($i,$weps,$w,$n);
echo '
</table>
';
}
else
	echo '<p>This player has no kills.';
	
	
//most recent 20 kills by this player
echo '
<h2>Latest 20 Kills</h2>
';
if (mysql_num_rows($kill_query) > 0)
{
echo '
<table cellpadding="0" cellspacing="0">
<tr>
	<th>Victim</th>
	<th>Weapon</th>
	<th>Date</th>
</tr>
';
for ($i = 0; $k = mysql_fetch_assoc($kill_query); $i++)
{
echo '
<tr',($i % 2) ? ' class="alt"' : '','>
';
	if ($k['suicide'] != 1)
	echo '
	<td><a href="'.$_SERVER['PHP_SELF'].'?sa=player&amp;name='.urlencode(stripslashes($k['victim'])).'">'.htmlentities(stripslashes($k['victim'])).'</a></td>
	<td><a href="'.$_SERVER['PHP_SELF'].'?sa=weapon_stats&amp;weapon='.urlencode($k['weapon']).'"><img src="img/'.str_replace(' ','_',$k['weapon']).'.gif" alt="'.$k['weapon'].'" /></a></td>
	';
	elseif($k['suicide'] == 1 && strtolower($k['weapon']) != 'selfkill')
	echo '
	<td><em>Suicide</em></td>
	<td><a href="'.$_SERVER['PHP_SELF'].'?sa=weapon_stats&amp;weapon='.urlencode($k['weapon']).'"><img src="img/'.str_replace(' ','_',$k['weapon']).'.gif" alt="'.$k['weapon'].'" /></a></td>
	';
	elseif($k['suicide'] == 1 && strtolower($k['weapon']) == 'selfkill')
	echo '
	<td colspan="2"><em>Suicide</em></td>
	';
echo '
	<td>'.date('m-d-Y g:i:s A',$k['date']).'</td>
</tr>
';
}
mysql_free_result($kill_query);
unset($kill_query);
echo '
</table>
';
}
else
	echo '<p>This player has no kills</p>';

echo '<p><a href="'.$_SERVER['PHP_SELF'].'">Go Back</a></p>';
lt_foot();
}

//full kill history. all nice and paginationatised
elseif(@$_GET['sa'] == 'history')
{

##pagination related
//total # of kills
$kills = mysql_num_rows(mysql_query("select null from `{$db['prefix']}kills`"));
//rows per page
$perpage = 50;
//# of pages
$pages = floor($kills / $perpage);
//current page
if (is_numeric($_GET['page']) && $_GET['page'] > 1 && $_GET['page'] <= $pages)
	$current_page = $_GET['page'];
else
	$current_page = 1;
//limit
if ($current_page == 1)
	$limit = 0;
else
	$limit = $perpage * $current_page;

//get kill history query
$query = mysql_query("select `killer`,`victim`,`weapon`,`date`,`suicide` from `{$db['prefix']}kills` order by `id` desc limit ".$limit.','.$perpage);
lt_head('Kill History - Page '.$current_page);
if ($kills > $perpage)
{
	echo '<p>Page: ';
	for ($i = 1; $i <= $pages; $i++)
		echo ($i != $current_page) ? '<a href="'.$_SERVER['PHP_SELF'].'?sa=history&amp;page='.$i.'">'.$i.'</a>'."\n" : '<strong>'.$i.'</strong>'."\n";
	echo '</p>';
}
echo '
<table cellpadding="0" cellspacing="0">
<colgroup>
	<col style="width: 30%;" />
	<col style="width: 30%;" />
	<col style="width: 54px;" />
	<col style="width: 40%; text-align: center;" />
</colgroup>
<tr>
	<th>Killer</th>
	<th>Victim</th>
	<th>Weapon</th>
	<th>Date</th>
</tr>
';
unset($i);
for($i = 0; $p = mysql_fetch_assoc($query); $i++)
{
if ($p['suicide'] == 1)
echo '
<tr',($i % 2) ? ' class="alt"' : '','>
	<td><a href="'.$_SERVER['PHP_SELF'].'?sa=player&amp;name='.urlencode(stripslashes($p['killer'])).'">'.htmlentities(stripslashes($p['killer'])).'</a></td>
	',(strtolower($p['weapon']) == 'selfkill') ? '<td colspan="2"><em>suicide</em></td>' : '<td><em>suicide</em></td><td><a href="'.$_SERVER['PHP_SELF'].'?sa=weapon_stats&amp;weapon='.urlencode($p['weapon']).'"><img src="img/'.str_replace(' ','_',$p['weapon']).'.gif" alt="'.$p['weapon'].'" /></a></td>','
	<td>'.date('m-d-Y g:i:s A',$p['date']).'</td>
</tr>
';
else
echo '
<tr',($i % 2) ? ' class="alt"' : '','>
	<td><a href="'.$_SERVER['PHP_SELF'].'?sa=player&amp;name='.urlencode(stripslashes($p['killer'])).'">'.htmlentities(stripslashes($p['killer'])).'</a></td>
	<td><a href="'.$_SERVER['PHP_SELF'].'?sa=player&amp;name='.urlencode(stripslashes($p['victim'])).'">'.htmlentities(stripslashes($p['victim'])).'</a></td>
	<td><a href="'.$_SERVER['PHP_SELF'].'?sa=weapon_stats&amp;weapon='.urlencode($p['weapon']).'"><img src="img/'.str_replace(' ','_',$p['weapon']).'.gif" alt="'.$p['weapon'].'" /></a></td>
	<td>'.date('m-d-Y g:i:s A',$p['date']).'</td>
</tr>
';
unset($p);
}
unset($i);
mysql_free_result($query);
echo '
</table>';
if ($kills > $perpage)
{
	echo '<p>Page: ';
	for ($i = 1; $i <= $pages; $i++)
		echo ($i != $current_page) ? '<a href="'.$_SERVER['PHP_SELF'].'?sa=history&amp;page='.$i.'">'.$i.'</a>'."\n" : '<strong>'.$i.'</strong>'."\n";
	echo '</p>';
}
echo '
<p>
	<a href="'.$_SERVER['PHP_SELF'].'">Go Back</a>
</p>
';
lt_foot();
}

//full player list
elseif($_GET['sa'] == 'player_list')
{
$query = mysql_query("select `name`,`kills`,`deaths`,`suicides`, (`kills` / `deaths`) as kd from `{$db['prefix']}players` order by `kills` desc");
lt_head('Player List ('.mysql_num_rows($query).')');
echo '
<table cellpadding="0" cellspacing="0">
<tr>
	<th class="rank_cell">#</th>
	<th>Name</th>
	<th>Kills</th>
	<th>Deaths</th>
	<th>Suicides</th>
	<th>K:D Ratio</th>
</tr>
';
for ($i = 0; $p = mysql_fetch_assoc($query); $i++)
{
$n = $i + 1;
echo '
<tr',($i % 2) ? ' class="alt"' : '','>
	<td class="num">'.$n.'</td>
	<td><a href="'.$_SERVER['PHP_SELF'].'?sa=player&amp;name='.urlencode(stripslashes($p['name'])).'">'.htmlentities(stripslashes($p['name'])).'</a></td>
	<td class="num">'.number_format($p['kills']).'</td>
	<td class="num">'.number_format($p['deaths']).'</td>
	<td class="num">'.number_format($p['suicides']).'</td>
	<td class="num">'.round($p['kd'],2).'</td>
</tr>
';
}
mysql_free_result($query);
unset($query);
echo '</table>
<p>
<a href="'.$_SERVER['PHP_SELF'].'">Go Back</a>
</p>
';
lt_foot();
}

//list of the most used weapons
elseif($_GET['sa'] == 'top_weps')
{
//get weapons
$wepq = mysql_query("select `weapon` from `{$db['prefix']}kills`");
//array that will hold each weapon
$weps = array();
//loop through weapons
while ($wa = mysql_fetch_assoc($wepq))
{
	//weapon name
	$w = $wa['weapon'];
	//skip selfkills
	if (strtolower($w) == 'selfkill')
		continue;
	//skip weird arse possibly possible bugs
	if (trim($w) == '')
		continue;
	//check if it's in the array
	if (!$weps[$w] || $weps[$w] == 0)
		$weps[$w] = 1; //if it isn't, start it off at 1
	else
		$weps[$w]++; //if it is, increment it by 1
	//we don't need this again. until the next time where it is started off as something different
	unset($w);
}
//save ram as always
mysql_free_result($wepq);
unset($wepq,$wa);

//sort the array! (descending according to the number of kills with each weapon)
array_multisort($weps,SORT_DESC);

//start displaying the info we just concieved
lt_head('Most Popular Weapons');
echo '
<table cellpadding="0" cellspacing="0">
<tr>
	<th class="num">#</th>
	<th>Weapon</th>
	<th class="num">Kills</th>
</tr>
';

//simple number that is incremented by one with each row. this is only used for the alternating row background colors
$i = 0;

//loop through weapons
foreach($weps as $w => $k)
{
$tn = $i + 1;
echo '
<tr',($i % 2) ? ' class="alt"' : '','>
	<td class="num">'.$tn.'</td>
	<td><a href="'.$_SERVER['PHP_SELF'].'?sa=weapon_stats&amp;weapon='.urlencode($w).'"><img src="img/'.str_replace(' ','_',$w).'.gif" alt="'.$w.'" /></a></td>
	<td class="num">'.number_format($k).'</td>
</tr>
';
unset($tn);
$i++;
}

//save ram by killing those vars that are now uneeded
unset($i,$w,$k,$weps);
echo '
</table>
<p><a href="'.$_SERVER['PHP_SELF'].'">Go Back</a></p>
';
lt_foot();
}

//this shows the best killers with a specific weapon
elseif($_GET['sa'] == 'weapon_stats')
{
//make sure weapon specified
if (trim($_GET['weapon']) == '')
{
	lt_head('No Weapon Specified');
echo '
<p>You did not specify a weapon. <a href="'.$_SERVER['PHP_SELF'].'">Go Back</a></p>
';
	lt_foot();
	mysql_close();
	die;
}

//get dbsafe version of weapon
$wep = trim(db_prot($_GET['weapon']));

//query that gets the number of kills and the player name with this weapon
$wepq = mysql_query("select `killer`,`victim` from `{$db['prefix']}kills` where `weapon` = '$wep' AND `killer` != `victim`");

//num kills
$num_kills = mysql_num_rows($wepq);

//make sure that there are kills with this weapon
if ($num_kills == 0)
{
	lt_head('No Kills With This Weapon');
echo '
<p>Sorry, no one has used this weapon to kill. <a href="'.$_SERVER['PHP_SELF'].'">Go Back</a></p>
';
	lt_foot();
	mysql_close();
	die;		
}


//start echoing out info
lt_head('Weapon Stats: ' . stripslashes($wep));

//query that gets the last kill date
$last_kill = mysql_fetch_assoc(mysql_query("select `date` from `{$db['prefix']}kills` where `weapon` = '$wep' order by `id` desc limit 1"));

//echo simple stats
echo '
<h2>Info</h2>
<ul>
	<li>Number of kills with this weapon: '.number_format($num_kills).'</li>
	<li>Last kill with this weapon: '.date('m-d-Y g:i:s A',$last_kill['date']).'</li>
</ul>
';

unset($last_kill);

//array that holds player name and number of kills (excludes suicides)
$kills = array();

//loop through query
while($ka = mysql_fetch_assoc($wepq))
{
	$k = stripslashes($ka['killer']);
	unset($ka);
	//skip suicides / logging bugs
	if (trim($k) == '')
		continue;
	//check if the killer is already in the array
	if (!$kills[$k] || $kills[$k] == 0)
		$kills[$k] = 1; // if the killer isn't, start him / her off at 1
	else
		$kills[$k]++; //if the killer is, increment their kills by one
	unset($k,$v);
}

//save ram
mysql_free_result($wepq);

//sort array
array_multisort($kills,SORT_DESC);

//start top ten kills table
echo '
<h2>Top Ten Killers With '.stripslashes($wep).'</h2>
<table cellpadding="0" cellspacing="0">
<tr>
	<th class="rank_cell">#</th>
	<th>Name</th>
	<th>Kills</th>
</tr>
';
//value used for alternating row colors and rank number
$i = 0;

//loop through array
foreach ($kills as $k => $n)
{
//the limit is 10
if ($i == 10)
	break;
$r = $i + 1;
echo '
<tr',($i % 2) ? ' class="alt"' : '','>
	<td class="num">'.$r.'</td>
	<td><a href="'.$_SERVER['PHP_SELF'].'?sa=player&amp;name='.urlencode($k).'">'.htmlentities($k).'</a></td>
	<td class="num">'.number_format($n).'</td>
</tr>
';
unset($k,$n,$r);
$i++;
}

//save ram, kill that array and counter
unset($kills,$i);

//end table
echo '
</table>
<p><a href="'.$_SERVER['PHP_SELF'].'">Go Back</a></p>
';

//layout footer
lt_foot();
}


//simple rankings page (this is like the stats homepage)
else
{
lt_head('Rankings');

//associative array of the total number of kills and suicides
$s = mysql_fetch_assoc(mysql_query("select sum(`kills`) as k, sum(`suicides`) as c from `{$db['prefix']}players` limit 1"));

//suicides and kill stats
echo '
<h2>Stats</h2>
<ul>
	<li>Total kills: '.number_format($s['k']).'</li>
	<li>Total Suicides: '.number_format($s['c']).'</li>
</ul>
';
unset($s);


//top ten kills list
echo '
<h2>Top 10 Killers</h2>
';
$top10killers = mysql_query("select `name`,`kills` from `{$db['prefix']}players` order by `kills` desc limit 10");
echo '
<table cellpadding="0" cellspacing="0">
<tr>
	<th class="rank_cell">#</th>
	<th>Name</th>
	<th>Kills</th>
</tr>
';

//loop through query
for ($i = 0; $p = mysql_fetch_assoc($top10killers); $i++)
{
$n = $i + 1;
echo '
<tr',($i % 2) ? ' class="alt"' : '','>
	<td class="num">'.$n.'</td>
	<td><a href="'.$_SERVER['PHP_SELF'].'?sa=player&amp;name='.urlencode(stripslashes($p['name'])).'">'.htmlentities(stripslashes($p['name'])).'</a></td>
	<td class="num">'.number_format($p['kills']).'</td>
</tr>
';
}
mysql_free_result($top10killers);
echo '</table>';

//top ten K:D ratio list
echo '
<h2>Top 10 K:D</h2>
';
$top10kd = mysql_query("select `name`, (`kills` / `deaths`) as `kd` from `{$db['prefix']}players` order by `kd` desc limit 10");
echo '
<table cellpadding="0" cellspacing="0">
<tr>
	<th class="rank_cell">#</th>
	<th>Name</th>
	<th>K:D</th>
</tr>
';

//loop through query
for ($i = 0; $p = mysql_fetch_assoc($top10kd); $i++)
{
$n = $i + 1;
echo '
<tr',($i % 2) ? ' class="alt"' : '','>
	<td class="num">'.$n.'</td>
	<td><a href="'.$_SERVER['PHP_SELF'].'?sa=player&amp;name='.urlencode(stripslashes($p['name'])).'">'.htmlentities(stripslashes($p['name'])).'</a></td>
	<td class="num">'.round($p['kd'],2).'</td>
</tr>
';
}
mysql_free_result($top10kd);
echo '</table>';


//top ten victims list
echo '
<h2>Top 10 Victims</h2>
';
$top10victims = mysql_query("select `name`,`deaths` from `{$db['prefix']}players` order by `deaths` desc limit 10");
echo '
<table cellpadding="0" cellspacing="0">
<tr>
	<th class="rank_cell">#</th>
	<th>Name</th>
	<th>Deaths</th>
</tr>
';

//loop through query
for($i = 0; $p = mysql_fetch_assoc($top10victims); $i++)
{
$n = $i + 1;
echo '
<tr',($i % 2) ? ' class="alt"' : '','>
	<td class="num">'.$n.'</td>
	<td><a href="'.$_SERVER['PHP_SELF'].'?sa=player&amp;name='.urlencode(stripslashes($p['name'])).'">'.htmlentities(stripslashes($p['name'])).'</a></td>
	<td class="num">'.number_format($p['deaths']).'</td>
</tr>
';
}

//clear ram used by query
mysql_free_result($top10victims);

echo '
</table>
<h2>Search For Player</h2>
<form action="'.$_SERVER['PHP_SELF'].'" method="get">
	<input type="hidden" id="sa" name="sa" value="player" />
	<label for="name">Player Name: </label> <input type="text" id="name" name="name" /> <input type="submit" value="Search!" />
</form>
<h2>More</h2>
<ul>
	<li><a href="'.$_SERVER['PHP_SELF'].'?sa=top_weps">View the most popular weapons</a></li>
	<li><a href="'.$_SERVER['PHP_SELF'].'?sa=player_list">View full player list</a></li>
	<li><a href="'.$_SERVER['PHP_SELF'].'?sa=history">View kill history</a></li>
</ul>
';
lt_foot();
}

//close mysql
mysql_close();
?>
