<?php
/*	
This file is part of JRG Stats.

JRG Stats is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3 of the License, or
(at your option) any later version.

JRG Stats is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
//anti hack

@ignore_user_abort(true);
@set_time_limit(0);

define('instats',true);

//load config file
require_once 'inc.php';

//send header as plain text
header('Content-type: text/plain');

//path of logs
//$path = 'logs/kills/';
//try changing to it
if (!chdir($path))
	die("Error changing to the path you gave me: $path\n");

//connect to mysql
db_connect();

//get array of filenames
$files = glob('KillLog-**-**-**-**.txt');

//array that holds every kill
$total_kills = array();

//number of log files used (this increments later on)
$total_files_used = 0;

echo "Parsing logs to get kills......\n";

//get each file
foreach($files as $filename)
{
	//make sure file is existant and readable
	if (!is_file)
	{
		echo "File <em>$filename</em> is not readable / doesn't exist.\n";
		continue;
	}
	
	//get the two halves of the file (the first part and the last)
	$halves = explode("\n",file_get_contents($filename),2);
	
	unset($filename);
	
	//every for lines of the file into a multi deminsional array
	$players_kills = array_chunk(explode("\n",$halves[1]),4);
	
	unset($halves);
	
	//go through each kill
	foreach($players_kills as $k)
	{
		//if array is empty, just continue
		if (empty($k[0]))
			continue;
		
		//temporary array that holds info.		
		$ti = array();
		
		//date of killing in unix timestamp
		$ti['date'] = strtotime(str_replace('--- ','',$k[0]));
		
		//escaped name of killer
		$ti['killer'] = trim(db_prot($k[1]));
		
		//name of victim
		$ti['victim'] = trim(db_prot($k[2]));
		
		//weapon
		$ti['weapon'] = trim($k[3]);
		
		//insert this info into main kills array
		$total_kills[] = $ti;
		
		//kill temporary stuff we just used to save ram
		unset($k,$ti);
	}
	
	//save ram by getting rid of the stuff we just used and don't need anymore
	unset($players_kills);
	
	//increment the log file count by one
	$total_files_used++;
}

//we won't need the list of files again
unset($files);

//tell what we got and in out of how many log files
echo '...Done parsing. Got '.number_format(count($total_kills)).' kills in '.number_format($total_files_used)." log file(s)\n\n";

//kill that variable as we don't need it and it was just supposed to be a interesting statistic anyway
unset($total_files_used);

echo "Inserting info into mysql database.....\n\n";

//lets insert info into mysql database

//query that gets the date of the latest kill recorded in the database
$getlatestdate = mysql_fetch_assoc(mysql_query("select `date` from `{$db['prefix']}kills` order by `id` desc limit 1"));
$latestdbkill = $getlatestdate['date'];
unset($getlatestdate);

//start going at it

$kills_recorded = 0;

//insert kills and players
foreach($total_kills as $k)
{
	//if current kill older than latest on DB 
	if ($latestdbkill >= $k['date'])
		continue;
	
	//increment kills recorded by one
	$kills_recorded++;
	
	//check if the killers name isn't in the players table yet, if it isn't, insert it
	if (mysql_num_rows(mysql_query("select null from `{$db['prefix']}players` where `name` = '{$k['killer']}' limit 1")) == 0)
		@mysql_query("insert into `{$db['prefix']}players` (`name`) values ('{$k['killer']}')") 
			or die('Error inserting killers name into database: '.mysql_error());
		
	//check if the victims name isn't in the players table yet, if it isn't insert it
	if (mysql_num_rows(mysql_query("select null from `{$db['prefix']}players` where `name` = '{$k['victim']}' limit 1")) == 0)
		@mysql_query("insert into `{$db['prefix']}players` (`name`) values ('{$k['victim']}')") 
			or die('Error inserting victims name into database: '.mysql_error());
	
	//if a suicide
	if ($k['killer'] == $k['victim'] || strtolower($p['weapon']) == 'selfkill')
	{
		//insert kill info
		@mysql_query("insert into `{$db['prefix']}kills` (`killer`,`victim`,`weapon`,`suicide`,`date`) values ('{$k['killer']}','{$k['victim']}','{$k['weapon']}','1','{$k['date']}')")
			or die('Error inserting kill info into database: '.mysql_error());
		//increment killers suicde count by one
		@mysql_query("update `{$db['prefix']}players` set `suicides` = `suicides` + 1 where `name` = '{$k['killer']}' limit 1")
			or die('error increasing the players suicide count: '.mysql_error());
		//skip whats below
		continue;
	}
	
	//if a regular kill
	
	//insert kill info
	@mysql_query("insert into `{$db['prefix']}kills` (`killer`,`victim`,`weapon`,`suicide`,`date`) values ('{$k['killer']}','{$k['victim']}','{$k['weapon']}','0','{$k['date']}')")
		or die('Error inserting kill info into database: '.mysql_error());
		
	//increment the killers kills by one
	@mysql_query("update `{$db['prefix']}players` set `kills` = `kills` + 1 where `name` = '{$k['killer']}' limit 1")
		or die('error increasing the killers kill count: '.mysql_error());
		
	//increment the victims deaths by one
	@mysql_query("update `{$db['prefix']}players` set `deaths` = `deaths` + 1 where `name` = '{$k['victim']}' limit 1")
		or die('error increasing the killers death count: '.mysql_error());
	
	unset($k);
}
if ($kills_recorded == 0)
	echo "\nNo New kills.\n";
else
	echo "\n" . number_format($kills_recorded) . " New kills successfully recorded.\n";

mysql_close();

echo "\n....Done\n\nThis took ".round((microtime(true) - $start),4)." 
seconds\n";
?>
