<?php
/*	
This file is part of JRG Stats.

JRG Stats is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3 of the License, or
(at your option) any later version.

JRG Stats is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
//anti hack
define('instats',true);

//load config file
require_once 'inc.php';

//connect to mysql
db_connect();

//query for getting the number of kills
$numkills = mysql_num_rows(mysql_query("select null from `{$db['prefix']}kills` limit 1"));

//if no kills whatsoever
if ($numkills == 0)
{
	lt_head('No kills yet');
	echo '<p>No kills have been recorded yet</p>';
	lt_foot();
	mysql_close();
	die;
}
unset($numkills);


//so we've got kills, decide what to do next....
if (@$_GET['sa'] == 'player')
{
	//if no player name passed
	if (trim($_GET['name']) == '')
	{
		lt_head('Didn\'t type player name.');
		echo '<p>You did not type a player name.<a href="'.$_SERVER['PHP_SELF'].'">Go Back</a></p>';
		lt_foot();
		mysql_close();
		die;
	}
	//safe player name
	$name = trim(db_prot(urldecode($_GET['name'])));
	
	//get player info query
	$query = mysql_query("select `id`, `name`, `deaths`, `kills`, `suicides`, (`kills` / `deaths`) as kd from `{$db['prefix']}players` where `name` = '$name' limit 1");
	
	unset($name);
	
	//check if name exists in database
	if (mysql_num_rows($query) == 0)
	{
		lt_head('Invalid player name');
		echo '<p>Sorry, a player of the name you typed does not exist. <a href="'.$_SERVER['PHP_SELF'].'">Go Back</a></p>';
		lt_foot();
		mysql_close();
		die;
	}

//player found, snag info into an array
$in = mysql_fetch_assoc($query);
lt_head('Player Profile: '.htmlentities(stripslashes($in['name'])));
mysql_free_result($query);
unset ($query);

//get my latest kills
$kill_query = mysql_query("select `victim`,`date`,`suicide`,`weapon` from `{$db['prefix']}kills` where `killer` = '{$in['name']}' order by `id` desc limit 20");

//check if I have kills, if I do, get my weapons used
if (mysql_num_rows($kill_query) > 0)
{
	//query
	$weps_query = mysql_query("select `weapon` from `{$db['prefix']}kills` where `killer` = '{$in['name']}'");
	//array that will contain the weapons
	$weps = array();
	//loop through query
	while ($w = mysql_fetch_assoc($weps_query))
	{
		$w = $w['weapon'];
		//skip suicides / possible logging bugs
		if (strtolower($w) == 'selfkill' || trim($w) == '')
			continue;
		if (!$weps[$w] || $weps[$w] == 0)
			$weps[$w] = 1;
		else
			$weps[$w]++;
	}
	//save ram
	mysql_free_result($weps_query);
	unset($w);
	//sort array
	array_multisort($weps,SORT_DESC);
	//favorite weapon
	$fav_wep = array_values(array_flip($weps));
}
else
	$weps = false;


//statistics table
echo '<h2>Statistics</h2>
<table cellpadding="0" cellspacing="0">
	<tr>
		<th>Kills</th>
		<td class="num">'.number_format($in['kills']).'</td>
	</tr>
	<tr>
		<th>Deaths</th>
		<td class="num">'.number_format($in['deaths']).'</td>
	</tr>
	<tr>
		<th>Suicides</th>
		<td class="num">'.number_format($in['suicides']).'</td>
	</tr>
	<tr>
		<th>K:D Ratio</th>
		<td class="num">'.round($in['kd'],2).'</td>
	</tr>
	<tr>
		<th>Favorite Weapon</th>
		<td>', ($weps != false) ? '<img src="img/'.str_replace(' ','_',$fav_wep[0]).'.gif" alt="'.$fav_wep[0].'" />' : '<em>Unknown</em>' ,'</td>
	</tr>
</table>';


//players favorite weapon stats
echo '
<h2>Favorite Weapons</h2>
';
if ($weps != false)
{
unset($fav_wep);
$i = 0;
echo '
<table cellpadding="0" cellspacing="0">
<tr>
	<th>Weapon</th>
	<th>Kills</th>
</tr>	
';
foreach($weps as $w => $n)
{
echo '
<tr',($i % 2) ? ' class="alt"' : '' ,'>
	<td><img src="img/'.str_replace(' ','_',$w).'.gif" alt="'.$w.'" /></td>
	<td>'.number_format($n).'</td>
</tr>
';
$i++;
}
unset($i,$weps,$w,$n);
echo '
</table>
';
}
else
	echo '<p>This player has no kills.';
	
	
//most recent 20 kills by this player
echo '
<h2>Latest 20 Kills</h2>
';
if (mysql_num_rows($kill_query) > 0)
{
echo '
<table cellpadding="0" cellspacing="0">
<tr>
	<th>Victim</th>
	<th>Weapon</th>
	<th>Date</th>
</tr>
';
for ($i = 0; $k = mysql_fetch_assoc($kill_query); $i++)
{
echo '
<tr',($i % 2) ? ' class="alt"' : '','>
';
	if ($k['suicide'] != 1 && strtolower($k['weapon']) != 'selfkill' && $k['victim'] != $in['name'])
	echo '
	<td><a href="'.$_SERVER['PHP_SELF'].'?sa=player&amp;name='.urlencode(stripslashes($k['victim'])).'">'.htmlentities(stripslashes($k['victim'])).'</a></td>
	<td><img src="img/'.str_replace(' ','_',$k['weapon']).'.gif" alt="'.$k['weapon'].'" /></td>
	';
	elseif($k['victim'] == $in['name'] && strtolower($k['weapon']) != 'selfkill')
	echo '
	<td><em>Suicide</em></td>
	<td><img src="img/'.str_replace(' ','_',$k['weapon']).'.gif" alt="'.$k['weapon'].'" /></td>
	';
	elseif($k['victim'] == $in['name'] && strtolower($k['weapon']) == 'selfkill')
	echo '
	<td colspan="2"><em>Suicide</em></td>
	';
echo '
	<td>'.date('m-d-Y g:i:s A',$k['date']).'</td>
</tr>
';
}
mysql_free_result($kill_query);
unset($kill_query);
echo '
</table>
';
}
else
	echo '<p>This player has no kills</p>';

echo '<p><a href="'.$_SERVER['PHP_SELF'].'">Go Back</a></p>';
lt_foot();
}

//full kill history. all nice and paginationatised
elseif(@$_GET['sa'] == 'history')
{

##pagination related
//total # of kills
$total_kills = mysql_num_rows(mysql_query("select null from `{$db['prefix']}kills`"));
//rows per page
$perpage = 100;
//# of pages
$pages = floor($total_kills / $perpage);
//current page
if (is_numeric($_GET['page']) && $_GET['page'] > 1 && $_GET['page'] <= $pages)
	$current_page = $_GET['page'];
else
	$current_page = 1;
//limit
if ($current_page == 1)
	$limit = 0;
else
	$limit = $perpage * $current_page;

//get kill history query
$query = mysql_query("select `killer`,`victim`,`weapon`,`date`,`suicide` from `{$db['prefix']}kills` order by `id` desc limit ".$limit.','.$perpage);
lt_head('Kill History - Page '.$current_page);
if ($total_kills > $perpage)
{
	echo '<p>Page: ';
	for ($i = 1; $i <= $pages; $i++)
		echo ($i != $current_page) ? '<a href="'.$_SERVER['PHP_SELF'].'?sa=history&amp;page='.$i.'">'.$i.'</a>'."\n" : '<strong>'.$i.'</strong>'."\n";
	echo '</p>';
}
echo '
<table cellpadding="0" cellspacing="0">
<tr>
	<th>Killer</th>
	<th>Victim</th>
	<th>Weapon</th>
	<th>Date</th>
</tr>
';
unset($i);
for($i = 0; $p = mysql_fetch_assoc($query); $i++)
{
if ($p['suicide'] == 1)
echo '
<tr',($i % 2) ? ' class="alt"' : '','>
	<td><a href="'.$_SERVER['PHP_SELF'].'?sa=player&amp;name='.urlencode(stripslashes($p['killer'])).'">'.htmlentities(stripslashes($p['killer'])).'</a></td>
	',(strtolower($p['weapon']) == 'selfkill') ? '<td colspan="2"><em>suicide</em></td>' : '<td><em>suicide</em></td><td><img src="img/'.str_replace(' ','_',$p['weapon']).'.gif" alt="'.$p['weapon'].'" /></td>','
	<td>'.date('m-d-Y g:i:s A',$p['date']).'</td>
</tr>
';
else
echo '
<tr',($i % 2) ? ' class="alt"' : '','>
	<td><a href="'.$_SERVER['PHP_SELF'].'?sa=player&amp;name='.urlencode(stripslashes($p['killer'])).'">'.htmlentities(stripslashes($p['killer'])).'</a></td>
	<td><a href="'.$_SERVER['PHP_SELF'].'?sa=player&amp;name='.urlencode(stripslashes($p['victim'])).'">'.htmlentities(stripslashes($p['victim'])).'</a></td>
	<td><img src="img/'.str_replace(' ','_',$p['weapon']).'.gif" alt="'.$p['weapon'].'" /></td>
	<td>'.date('m-d-Y g:i:s A',$p['date']).'</td>
</tr>
';
}
unset($i);
echo '
</table>';
if ($total_kills > $perpage)
{
	echo '<p>Page: ';
	for ($i = 1; $i <= $pages; $i++)
		echo ($i != $current_page) ? '<a href="'.$_SERVER['PHP_SELF'].'?sa=history&amp;page='.$i.'">'.$i.'</a>'."\n" : '<strong>'.$i.'</strong>'."\n";
	echo '</p>';
}echo '
<p>
	<a href="'.$_SERVER['PHP_SELF'].'">Go Back</a>
</p>
';
lt_foot();
}

//full player list
elseif($_GET['sa'] == 'player_list')
{
$query = mysql_query("select `name`,`kills`,`deaths`,`suicides`, (`kills` / `deaths`) as kd from `{$db['prefix']}players` order by `kills` desc");
lt_head('Player List ('.mysql_num_rows($query).')');
echo '
<table cellpadding="0" cellspacing="0">
<tr>
	<th class="rank_cell">#</th>
	<th>Name</th>
	<th>Kills</th>
	<th>Deaths</th>
	<th>Suicides</th>
	<th>K:D Ratio</th>
</tr>
';
for ($i = 0; $p = mysql_fetch_assoc($query); $i++)
{
$n = $i + 1;
echo '
<tr',($i % 2) ? ' class="alt"' : '','>
	<td class="num">'.$n.'</td>
	<td><a href="?sa=player&amp;name='.urlencode(stripslashes($p['name'])).'">'.htmlentities(stripslashes($p['name'])).'</a></td>
	<td class="num">'.number_format($p['kills']).'</td>
	<td class="num">'.number_format($p['deaths']).'</td>
	<td class="num">'.number_format($p['suicides']).'</td>
	<td class="num">'.round($p['kd'],2).'</td>
</tr>
';
}
mysql_free_result($query);
unset($query);
echo '</table>
<p>
<a href="'.$_SERVER['PHP_SELF'].'">Go Back</a>
</p>
';
lt_foot();
}

//list of the most used weapons
elseif($_GET['sa'] == 'top_weps')
{
//get weapons
$query = mysql_query("select `weapon` from `{$db['prefix']}kills`");
//array that will hold each weapon
$weps = array();
//loop through weapons
while ($wa = mysql_fetch_assoc($query))
{
	//weapon name
	$w = $wa['weapon'];
	//skip selfkills
	if (strtolower($w) == 'selfkill')
		continue;
	//skip weird arse possibly possible bugs
	if (trim($w) == '')
		continue;
	//check if it's in the array
	if (!$weps[$w] || $weps[$w] == 0)
		$weps[$w] = 1; //if it isn't, start it off at 1
	else
		$weps[$w]++; //if it is, increment it by 1
	unset($w);
}
//save ram as always
mysql_free_result($query);
unset($query,$wa);
//sort the array!
array_multisort($weps,SORT_DESC);
//start displaying the info we just concieved
lt_head('Most Popular Weapons');
echo '
<table cellpadding="0" cellspacing="0">
<tr>
	<th class="num">#</th>
	<th>Weapon</th>
	<th class="num">Kills</th>
</tr>
';
$i = 0;
foreach($weps as $w => $k)
{
$tn = $i + 1;
echo '
<tr',($i % 2) ? ' class="alt"' : '','>
	<td class="num">'.$tn.'</td>
	<td><img src="img/'.str_replace(' ','_',$w).'.gif" alt="'.$w.'" /></td>
	<td class="num">'.number_format($k).'</td>
</tr>
';
unset($tn);
$i++;
}
unset($i,$w,$k,$weps);
echo '
</table>
<p><a href="'.$_SERVER['PHP_SELF'].'">Go Back</a></p>
';
lt_foot();
}

//simple rankings page
else
{
lt_head('Rankings');
$s = mysql_fetch_assoc(mysql_query("select sum(`kills`) as k, sum(`suicides`) as c from `{$db['prefix']}players` limit 1"));
echo '
<h2>Stats</h2>
<ul>
	<li>Total kills: '.number_format($s['k']).'</li>
	<li>Total Suicides: '.number_format($s['c']).'</li>
</ul>
';
echo "<h2>Top 10 Killers</h2>\n";
$query = mysql_query("select `name`,`kills` from `{$db['prefix']}players` order by `kills` desc limit 10");
echo '
<table cellpadding="0" cellspacing="0">
<tr>
	<th class="rank_cell">#</th>
	<th>Name</th>
	<th>Kills</th>
</tr>
';
for ($i = 0; $p = mysql_fetch_assoc($query); $i++)
{
$n = $i + 1;
echo '
<tr',($i % 2) ? ' class="alt"' : '','>
	<td class="num">'.$n.'</td>
	<td><a href="'.$_SERVER['PHP_SELF'].'?sa=player&amp;name='.urlencode(stripslashes($p['name'])).'">'.htmlentities(stripslashes($p['name'])).'</a></td>
	<td class="num">'.number_format($p['kills']).'</td>
</tr>
';
}
mysql_free_result($query);
unset($query);
echo "</table>\n<h2>Top 10 K:D</h2>\n";
$query = mysql_query("select `name`, (`kills` / `deaths`) as `kd` from `{$db['prefix']}players` order by `kd` desc limit 10");
echo '
<table cellpadding="0" cellspacing="0">
<tr>
	<th class="rank_cell">#</th>
	<th>Name</th>
	<th>K:D</th>
</tr>
';
for ($i = 0; $p = mysql_fetch_assoc($query); $i++)
{
$n = $i + 1;
echo '
<tr',($i % 2) ? ' class="alt"' : '','>
	<td class="num">'.$n.'</td>
	<td><a href="'.$_SERVER['PHP_SELF'].'?sa=player&amp;name='.urlencode(stripslashes($p['name'])).'">'.htmlentities(stripslashes($p['name'])).'</a></td>
	<td class="num">'.round($p['kd'],2).'</td>
</tr>
';
}
mysql_free_result($query);
unset($query);
echo "</table>\n<h2>Top 10 Victims</h2>\n";
$query = mysql_query("select `name`,`deaths` from `{$db['prefix']}players` order by `deaths` desc limit 10");
echo '
<table cellpadding="0" cellspacing="0">
<tr>
	<th class="rank_cell">#</th>
	<th>Name</th>
	<th>Deaths</th>
</tr>
';
for($i = 0; $p = mysql_fetch_assoc($query); $i++)
{
$n = $i + 1;
echo '
<tr',($i % 2) ? ' class="alt"' : '','>
	<td class="num">'.$n.'</td>
	<td><a href="'.$_SERVER['PHP_SELF'].'?sa=player&amp;name='.urlencode(stripslashes($p['name'])).'">'.htmlentities(stripslashes($p['name'])).'</a></td>
	<td class="num">'.number_format($p['deaths']).'</td>
</tr>
';
}
echo '</table>';
echo '
<h2>Search For Player</h2>
<form action="'.$_SERVER['PHP_SELF'].'" method="get">
	<input type="hidden" id="sa" name="sa" value="player" />
	<label for="name">Player Name: </label> <input type="text" id="name" name="name" /> <input type="submit" value="Search!" />
</form>
<h2>More</h2>
<ul>
	<li><a href="'.$_SERVER['PHP_SELF'].'?sa=top_weps">View the most popular weapons</a></li>
	<li><a href="'.$_SERVER['PHP_SELF'].'?sa=player_list">View full player list</a></li>
	<li><a href="'.$_SERVER['PHP_SELF'].'?sa=history">View kill history</a></li>
</ul>
';
lt_foot();
}
mysql_close();

?>
