/*
 * Copyright 2005 Richard Davies
 *
 *
 * This file is part of SARJ.
 *
 * SARJ is free software; you can redistribute it and/or modify it under the terms of
 * the GNU General Public License as published by the Free Software Foundation;
 * either version 2 of the License, or (at your option) any later version.
 * 
 * SARJ is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * SARJ; if not, write to the Free Software Foundation, Inc., 59 Temple Place,
 * Suite 330, Boston, MA 02111-1307 USA 
 */
 
package sarj;

import javax.swing.*;

/**
 * The ScriptButton class is a specialised button that contains an associated
 * name and filename of a script to execute when clicked. ScriptButtons appear
 * on the panel at the bottom of the GUI.
 */
public class ScriptButton extends JButton
{
	private static final long serialVersionUID = 5947847346149275958L;
	
	private String name;
	private String scriptFile;
	
	/**
	 * Creates a new QuickButton object with the specigied name and script file
	 * 
	 * @param name the name of the button. This is also the caption displayed on
	 *			   the button
	 * @param scriptFile the filename of the script to execute when the button is
	 *				 clicked
	 */
	public ScriptButton(String name, String scriptFile)
	{
		super(name);
		this.name = name;
		this.scriptFile = scriptFile;
	}
	
	/**
	 * Returns a {@link String} containing the name of the button
	 *
	 * @return the name of the QuickButton
	 */
	public String getName()
	{
		return name;
	}
	
	/**
	 * Sets the name of the button
	 *
	 * @param newName the new name of the button
	 */
	public void setName(String newName)
	{
		name = newName;
		setText(newName);
	}
	
	/**
	 * Returns a {@link String} containing the filename of the script to execute
	 * when the button is clicked
	 *
	 * @return the filename of the script to execute when clicked
	 */
	public String getScriptFile()
	{
		return scriptFile;
	}
	
	/**
	 * Sets the script file associated with the button
	 *
	 * @param newScriptFile the new script file to associate with the button
	 */
	public void setScriptFile(String newScriptFile)
	{
		scriptFile = newScriptFile;
	}
	
	/**
	 * Returns a string representation of the button
	 *
	 * @return the name/caption of the button
	 */
	public String toString()
	{
		return name;
	}
}