/*
 * Copyright 2005 Richard Davies
 *
 *
 * This file is part of SARJ.
 *
 * SARJ is free software; you can redistribute it and/or modify it under the terms of
 * the GNU General Public License as published by the Free Software Foundation;
 * either version 2 of the License, or (at your option) any later version.
 * 
 * SARJ is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * SARJ; if not, write to the Free Software Foundation, Inc., 59 Temple Place,
 * Suite 330, Boston, MA 02111-1307 USA 
 */
 
package sarj;

import javax.swing.*;
import java.awt.*;

/**
 * A custom Swing component to show an image in a panel
 */
public class ImagePanel extends Canvas
{
	private static final long serialVersionUID = 5947847346149275958L;
	
	ImageIcon imageIcon;

	/**
	 * @param imageFile the file path of the image to draw in this image panel
	 */
	public ImagePanel(String imageFile)
	{
		super();
		imageIcon = new ImageIcon(getClass().getResource(imageFile));
		
		setSize(imageIcon.getIconWidth(), imageIcon.getIconHeight());
	}

	/**
 	* Paints the image on to the panel
 	*
 	* @param g the {@link Graphics} object to draw to
 	*/
	public void paint(Graphics g)
	{
		g.drawImage(imageIcon.getImage(),0,0,this);
	}
}