/*
 * Copyright 2005 Richard Davies
 *
 *
 * This file is part of SARJ.
 *
 * SARJ is free software; you can redistribute it and/or modify it under the terms of
 * the GNU General Public License as published by the Free Software Foundation;
 * either version 2 of the License, or (at your option) any later version.
 * 
 * SARJ is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * SARJ; if not, write to the Free Software Foundation, Inc., 59 Temple Place,
 * Suite 330, Boston, MA 02111-1307 USA 
 */
 
package sarj;

/**
 * An exception thrown when a specified scripting event cannot be found
 */
public class EventNotFoundException extends Exception
{
	private static final long serialVersionUID = 5947847346149275958L;
	
	private String eventNotFound;
	
	/** Constructor
	 *
	 * @param s the error message to associate with this exception
	 */
	public EventNotFoundException(String s)
	{
		eventNotFound = s;
	}
	
	/**
	 * Returns a string representation of this exception
	 *
	 * @return a {@link String} object containing the details of the exception
	 */
	public String toString()
	{
		return "Event not found: " + eventNotFound;
	}
}