/*
 * Copyright 2005 Richard Davies
 *
 *
 * This file is part of SARJ.
 *
 * SARJ is free software; you can redistribute it and/or modify it under the terms of
 * the GNU General Public License as published by the Free Software Foundation;
 * either version 2 of the License, or (at your option) any later version.
 * 
 * SARJ is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * SARJ; if not, write to the Free Software Foundation, Inc., 59 Temple Place,
 * Suite 330, Boston, MA 02111-1307 USA 
 */
 
package sarj;

/**
 * Defines a listener interface for a events generated by a connection with a
 * Soldat server
 */
public interface ConnectionListener
{
	/**
	 * Called when a connection is successfully established with a server, as a
	 * result of calling the connect method of a {@link Connection} object.
	 */
	public void onConnected();
	
	/**
	 * Called when a connection to a server is lost, either gracefully or due to
	 * error
	 */
	public void onDisconnected();
	
	/**
	 * Called when a connection error occurrs
	 *
	 * @param message the error message
	 */
	public void onError(String message);
}