/*
 * Copyright 2005 Richard Davies
 *
 *
 * This file is part of SARJ.
 *
 * SARJ is free software; you can redistribute it and/or modify it under the terms of
 * the GNU General Public License as published by the Free Software Foundation;
 * either version 2 of the License, or (at your option) any later version.
 * 
 * SARJ is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * SARJ; if not, write to the Free Software Foundation, Inc., 59 Temple Place,
 * Suite 330, Boston, MA 02111-1307 USA 
 */
 
package sarj;

import javax.swing.*;
import java.awt.*;
import java.awt.event.*;

/**
 * The dialog window showing credits and contact information regarding SARJ
 */
public class AboutDialog extends JDialog implements ActionListener
{
	private static final long serialVersionUID = 5947847346149275958L;
	
	final static String aboutImageLocation = "/images/abouttitle.gif";
	
	private ImageIcon aboutIcon;
	private JButton okButton;
	private ImagePanel imagePanel;
	
	/**
	 * @param owner the parent frame of the dialog
	 */
	public AboutDialog(JFrame owner)
	{
		super(owner, "About SARJ", true);
		
		okButton = new JButton("Ok", Sarj.OK_ICON);
		okButton.addActionListener(this);
		
		JPanel topPanel = new JPanel();
		JPanel middlePanel = new JPanel();
		JPanel bottomPanel = new JPanel();
		
		imagePanel = new ImagePanel(aboutImageLocation);
		topPanel.add(imagePanel);
		
		
		middlePanel.setLayout(new BoxLayout(middlePanel, BoxLayout.PAGE_AXIS));
		middlePanel.setAlignmentX(Component.CENTER_ALIGNMENT);
		middlePanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
		middlePanel.add(new JLabel("<html><font size=3 color=#AAAAAA>Version " + Sarj.VERSION + "</font></html>"));
		middlePanel.add(new JLabel("<html><font size=3 color=#000000>Homepage: </font><font size=3 color=#0000CC>http://sarj.turva-hosting.de</font></html>"));
		middlePanel.add(new JLabel("<html><font size=3 color=#000000>E-mail: </font><font size=3 color=#0000CC>intothevoid@linuxmail.org</font></html>"));
		middlePanel.add(new JLabel("<html><br><font size=2 color=#000000>Copyright &copy 2005 Richard Davies</font></html>"));
		middlePanel.add(new JLabel("<html><br><font size=2 color=#000000>SARJ is released under the GNU General Public License</font></html>"));
		middlePanel.add(new JLabel("<html><br><font size=2 color=#000000>Testers: Optik, AWH_ReApEr and K3mp</font></html>"));
			
		bottomPanel.add(okButton);
		
		setLayout(new BorderLayout());
		add(topPanel, BorderLayout.NORTH);
		add(middlePanel, BorderLayout.CENTER);
		add(bottomPanel, BorderLayout.SOUTH);
		
		setResizable(false);
		pack();
		setLocationRelativeTo(owner);
	}
	
	/**
	 * Called as a result of implementing ActionListener
	 *
	 * @param e an object containing details of the action event
	 */
	public void actionPerformed(ActionEvent e)
	{
		Object source = e.getSource();
		
		if(source == okButton)
		{
			setVisible(false);
		}
	}
}