/*
 * Decompiled with CFR 0.152.
 */
package scripting;

import FESI.jslib.JSException;
import FESI.jslib.JSGlobalObject;
import FESI.jslib.JSUtil;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import sarj.Sarj;
import scripting.InterpreterDriver;
import scripting.InterpreterDriverManager;

public class JSInterpreterDriver
implements InterpreterDriver,
Runnable {
    private static JSGlobalObject interpreter;
    private static JSInterpreterDriver instance;
    private String scriptData;
    private String[] argNames;
    private String[] argValues;

    public JSInterpreterDriver() throws JSException {
        String[] stringArray = new String[]{"FESI.Extensions.BasicIO", "FESI.Extensions.FileIO", "FESI.Extensions.JavaAccess"};
        try {
            interpreter = JSUtil.makeEvaluator(stringArray);
        }
        catch (JSException jSException) {
            Sarj.printError("Exception: Cannot initialise FESI interpreter (" + jSException.getMessage() + ")");
            throw jSException;
        }
    }

    public void executeScript(String string, String[] stringArray, String[] stringArray2) throws InterpreterDriver.InterpreterException {
        this.scriptData = string;
        this.argNames = stringArray;
        this.argValues = stringArray2;
        Thread thread = new Thread(this);
        thread.start();
    }

    public void executeScriptFile(String string, String[] stringArray, String[] stringArray2) throws InterpreterDriver.InterpreterException {
        Object object;
        try {
            this.scriptData = "";
            object = new String();
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            while (object != null) {
                object = bufferedReader.readLine();
                if (object == null) continue;
                this.scriptData = this.scriptData + (String)object + "\n";
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new InterpreterDriver.InterpreterException(fileNotFoundException);
        }
        catch (IOException iOException) {
            throw new InterpreterDriver.InterpreterException(iOException);
        }
        this.argNames = stringArray;
        this.argValues = stringArray2;
        object = new Thread(this);
        ((Thread)object).start();
    }

    public String[] getSupportedExtensions() {
        return new String[]{"js", "es"};
    }

    public String[] getSupportedLanguages() {
        return new String[]{"JavaScript", "EcmaScript"};
    }

    public void setVariable(String string, String string2) {
        if (interpreter != null) {
            try {
                interpreter.setMember(string, string2);
            }
            catch (JSException jSException) {
                // empty catch block
            }
        }
    }

    public void run() {
        Object object = null;
        try {
            object = interpreter.evalAsFunction(this.scriptData, this.argNames, this.argValues);
            if (object != null) {
                Sarj.printError((String)object);
            }
        }
        catch (JSException jSException) {
            Sarj.printError("Interpreter exception: " + jSException);
        }
    }

    static {
        try {
            instance = new JSInterpreterDriver();
            InterpreterDriverManager.registerDriver(instance);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

