/*
 * Decompiled with CFR 0.152.
 */
package scripting;

import java.util.ArrayList;
import java.util.HashMap;
import sarj.Sarj;
import scripting.InterpreterDriver;

public class InterpreterDriverManager {
    private static HashMap<String, InterpreterDriver> extensionDriverMap = new HashMap();
    private static HashMap<String, InterpreterDriver> languageDriverMap = new HashMap();
    private static ArrayList<InterpreterDriver> driverList = new ArrayList();

    private InterpreterDriverManager() {
    }

    public static void registerDriver(InterpreterDriver interpreterDriver) {
        if (interpreterDriver == null) {
            return;
        }
        driverList.add(interpreterDriver);
        String[] stringArray = interpreterDriver.getSupportedExtensions();
        for (int i = 0; i < stringArray.length; ++i) {
            extensionDriverMap.put(stringArray[i], interpreterDriver);
        }
        String[] stringArray2 = interpreterDriver.getSupportedLanguages();
        for (int i = 0; i < stringArray2.length; ++i) {
            languageDriverMap.put(stringArray2[i], interpreterDriver);
        }
    }

    public static void executeScript(String string, String string2, String[] stringArray, String[] stringArray2) throws InterpreterDriver.InterpreterException {
        InterpreterDriver interpreterDriver = languageDriverMap.get(string2);
        if (interpreterDriver == null) {
            Sarj.printError("No driver installed to handle language: " + string2);
            return;
        }
        interpreterDriver.executeScript(string, stringArray, stringArray2);
    }

    public static void executeScriptFile(String string, String[] stringArray, String[] stringArray2) throws InterpreterDriver.InterpreterException {
        InterpreterDriver interpreterDriver;
        if (string == null) {
            return;
        }
        String string2 = string.substring(string.lastIndexOf(46) + 1);
        if (string2 == null || string2.length() < 0) {
            Sarj.printError("Invalid script file extension: " + string);
        }
        if ((interpreterDriver = extensionDriverMap.get(string2)) == null) {
            Sarj.printError("No driver installed to handle extension: " + string2);
            return;
        }
        interpreterDriver.executeScriptFile(string, stringArray, stringArray2);
    }

    public static void setVariable(String string, String string2) {
        for (InterpreterDriver interpreterDriver : driverList) {
            interpreterDriver.setVariable(string, string2);
        }
    }
}

