/*
 * Decompiled with CFR 0.152.
 */
package sarj;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.TableColumn;
import sarj.EventNotFoundException;
import sarj.EventScriptListTableModel;
import sarj.GUI;
import sarj.Sarj;
import sarj.TimedScriptListTableModel;

public class ScriptDialog
extends JDialog
implements ActionListener,
FocusListener {
    private static final long serialVersionUID = 5947847346149275958L;
    public static final String EXTENSION_js = "js";
    public static final String EXTENSION_es = "es";
    private static final String openImageLocation = "/images/open.gif";
    private static final String addImageLocation = "/images/addsb.gif";
    private static final String deleteImageLocation = "/images/delete.gif";
    private String settingsFile;
    private GUI owner;
    private JTabbedPane tabbedPane;
    private ImageIcon openImage;
    private ImageIcon addImage;
    private ImageIcon deleteImage;
    private JPanel eventScriptsPanel;
    private JTable eventScriptsTable;
    private JLabel eventScriptDetailsLabel;
    private JTextField eventScriptFilenameField;
    private JCheckBox eventScriptEnabledBox;
    private JButton eventScriptChooseButton;
    private JButton okButton;
    private JButton cancelButton;
    private JPanel timedScriptsPanel;
    private JTable timedScriptsTable;
    private JRadioButton timedScriptDelayButton;
    private JTextField timedScriptHoursDelayField;
    private JTextField timedScriptMinutesDelayField;
    private JTextField timedScriptSecondsDelayField;
    private JRadioButton timedScriptTimeButton;
    private JTextField timedScriptHoursTimeField;
    private JTextField timedScriptMinutesTimeField;
    private JComboBox timedScriptAMPMBox;
    private JTextField timedScriptFilenameField;
    private JCheckBox timedScriptEnabledBox;
    private JButton timedScriptChooseButton;
    private JButton timedScriptAddButton;
    private JButton timedScriptRemoveButton;

    public ScriptDialog(GUI gUI, String string, String string2) {
        super(gUI.getMainFrame(), string, true);
        TableColumn tableColumn;
        this.settingsFile = string2;
        this.owner = gUI;
        this.setLocationRelativeTo(null);
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 3));
        this.openImage = new ImageIcon(this.getClass().getResource(openImageLocation));
        this.addImage = new ImageIcon(this.getClass().getResource(addImageLocation));
        this.deleteImage = new ImageIcon(this.getClass().getResource(deleteImageLocation));
        this.tabbedPane = new JTabbedPane();
        this.eventScriptsPanel = new JPanel();
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        JPanel jPanel4 = new JPanel();
        JPanel jPanel5 = new JPanel();
        this.eventScriptDetailsLabel = new JLabel();
        jPanel.setLayout(new GridLayout(12, 1, 10, 13));
        jPanel2.setLayout(new GridLayout(12, 1, 10, 9));
        jPanel3.setLayout(new GridLayout(12, 1, 10, 5));
        this.eventScriptsPanel.setLayout(new BoxLayout(this.eventScriptsPanel, 3));
        this.eventScriptsPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        jPanel4.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), BorderFactory.createTitledBorder("Script details")));
        this.eventScriptsTable = new JTable(new EventScriptListTableModel());
        this.eventScriptsTable.setToolTipText("Event script details");
        this.eventScriptsTable.setPreferredScrollableViewportSize(new Dimension(460, this.eventScriptsTable.getRowHeight() * 8));
        this.eventScriptsTable.setAutoResizeMode(0);
        this.eventScriptsTable.setForeground(Color.BLUE);
        this.eventScriptsTable.setSelectionMode(0);
        ListSelectionModel listSelectionModel = this.eventScriptsTable.getSelectionModel();
        listSelectionModel.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ListSelectionModel listSelectionModel;
                if (listSelectionEvent.getValueIsAdjusting()) {
                    // empty if block
                }
                if (!(listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource()).isSelectionEmpty()) {
                    int n = listSelectionModel.getMinSelectionIndex();
                    EventScriptListTableModel eventScriptListTableModel = (EventScriptListTableModel)ScriptDialog.this.eventScriptsTable.getModel();
                    Object[] objectArray = eventScriptListTableModel.getRow(n);
                    ScriptDialog.this.loadEventScriptDetails((String)objectArray[0], (String)objectArray[1], (Boolean)objectArray[2]);
                }
            }
        });
        block10: for (int i = 0; i < 3; ++i) {
            tableColumn = this.eventScriptsTable.getColumnModel().getColumn(i);
            switch (i) {
                case 0: {
                    tableColumn.setPreferredWidth(145);
                    continue block10;
                }
                case 1: {
                    tableColumn.setPreferredWidth(270);
                    continue block10;
                }
                case 2: {
                    tableColumn.setPreferredWidth(55);
                    continue block10;
                }
            }
        }
        JScrollPane jScrollPane = new JScrollPane(this.eventScriptsTable);
        this.eventScriptFilenameField = new JTextField(20);
        this.eventScriptFilenameField.setToolTipText("This is the file path of the script to execute on the event");
        this.eventScriptFilenameField.addActionListener(this);
        this.eventScriptFilenameField.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                int n = ScriptDialog.this.eventScriptFilenameField.getCaretPosition();
                ScriptDialog.this.updateCurrentEventSelection();
                ScriptDialog.this.eventScriptFilenameField.setCaretPosition(n);
            }
        });
        this.eventScriptEnabledBox = new JCheckBox("Enable this event script");
        this.eventScriptEnabledBox.addActionListener(this);
        this.eventScriptChooseButton = new JButton(this.openImage);
        this.eventScriptChooseButton.setToolTipText("Click here to select a script file to associate with this event");
        this.eventScriptChooseButton.addActionListener(this);
        this.eventScriptChooseButton.setPreferredSize(new Dimension(25, 25));
        this.eventScriptChooseButton.setMinimumSize(new Dimension(25, 25));
        this.eventScriptFilenameField.setMaximumSize(new Dimension(Integer.MAX_VALUE, 20));
        this.setEventScriptLabelText("", "", "");
        this.eventScriptFilenameField.setEnabled(false);
        this.eventScriptEnabledBox.setEnabled(false);
        this.eventScriptChooseButton.setEnabled(false);
        jPanel4.setLayout(new BoxLayout(jPanel4, 2));
        JPanel jPanel6 = new JPanel();
        JPanel jPanel7 = new JPanel();
        JPanel jPanel8 = new JPanel();
        jPanel6.setLayout(new BoxLayout(jPanel6, 3));
        jPanel7.setLayout(new BoxLayout(jPanel7, 3));
        jPanel6.setPreferredSize(new Dimension(200, 70));
        jPanel6.add(this.eventScriptDetailsLabel);
        jPanel8.setLayout(new BoxLayout(jPanel8, 2));
        jPanel8.setAlignmentX(0.0f);
        jPanel8.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel8.add(this.eventScriptFilenameField);
        jPanel8.add(Box.createHorizontalStrut(10));
        jPanel8.add(this.eventScriptChooseButton);
        jPanel7.add(new JLabel("Script to execute:"));
        jPanel7.add(jPanel8);
        jPanel7.add(this.eventScriptEnabledBox);
        jPanel4.add(jPanel6);
        jPanel4.add(jPanel7);
        this.eventScriptsPanel.add(jScrollPane);
        this.eventScriptsPanel.add(jPanel4);
        this.timedScriptsTable = new JTable(new TimedScriptListTableModel());
        this.timedScriptsTable.setToolTipText("Timed script details");
        this.timedScriptsTable.setPreferredScrollableViewportSize(new Dimension(460, this.eventScriptsTable.getRowHeight() * 8));
        this.timedScriptsTable.setAutoResizeMode(0);
        this.timedScriptsTable.setForeground(Color.BLUE);
        this.timedScriptsTable.setSelectionMode(0);
        listSelectionModel = this.timedScriptsTable.getSelectionModel();
        listSelectionModel.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ListSelectionModel listSelectionModel;
                if (listSelectionEvent.getValueIsAdjusting()) {
                    // empty if block
                }
                if (!(listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource()).isSelectionEmpty()) {
                    int n = listSelectionModel.getMinSelectionIndex();
                    TimedScriptListTableModel timedScriptListTableModel = (TimedScriptListTableModel)ScriptDialog.this.timedScriptsTable.getModel();
                    Object[] objectArray = timedScriptListTableModel.getRow(n);
                    ScriptDialog.this.loadTimedScriptDetails((String)objectArray[0], (String)objectArray[1], (Boolean)objectArray[2], (Integer)objectArray[3], (Integer)objectArray[4]);
                }
            }
        });
        block11: for (int i = 0; i < 2; ++i) {
            tableColumn = this.timedScriptsTable.getColumnModel().getColumn(i);
            switch (i) {
                case 0: {
                    tableColumn.setPreferredWidth(350);
                    continue block11;
                }
                case 1: {
                    tableColumn.setPreferredWidth(60);
                    continue block11;
                }
                case 2: {
                    tableColumn.setPreferredWidth(60);
                    continue block11;
                }
            }
        }
        TimedScriptListTableModel timedScriptListTableModel = (TimedScriptListTableModel)this.timedScriptsTable.getModel();
        timedScriptListTableModel.addScript("test file 1", "Interval", true, 100, 100);
        timedScriptListTableModel.addScript("test file 2", "Interval", false, 10, 10);
        timedScriptListTableModel.addScript("test file 3", "Time", false, 10, 721);
        timedScriptListTableModel.addScript("test file 4", "Interval", false, 10, 10);
        JScrollPane jScrollPane2 = new JScrollPane(this.timedScriptsTable);
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout(new BoxLayout(jPanel9, 2));
        this.timedScriptAddButton = new JButton("Add", this.addImage);
        this.timedScriptAddButton.setToolTipText("Add a new timed script");
        this.timedScriptAddButton.addActionListener(this);
        this.timedScriptRemoveButton = new JButton("Remove", this.deleteImage);
        this.timedScriptRemoveButton.setToolTipText("Remove the selected timed script");
        this.timedScriptRemoveButton.addActionListener(this);
        jPanel9.add(this.timedScriptAddButton);
        jPanel9.add(Box.createRigidArea(new Dimension(5, 0)));
        jPanel9.add(this.timedScriptRemoveButton);
        JPanel jPanel10 = new JPanel();
        jPanel10.setLayout(new BoxLayout(jPanel10, 3));
        jPanel10.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Script details"), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.timedScriptDelayButton = new JRadioButton("Execute this script after a certain time delay");
        this.timedScriptDelayButton.addActionListener(this);
        jPanel10.add(this.timedScriptDelayButton);
        jPanel10.setAlignmentX(0.5f);
        JPanel jPanel11 = new JPanel();
        jPanel11.setLayout(new BoxLayout(jPanel11, 2));
        jPanel11.add(Box.createRigidArea(new Dimension(50, 0)));
        jPanel11.add(new JLabel("Time interval: "));
        jPanel11.add(Box.createRigidArea(new Dimension(5, 0)));
        this.timedScriptHoursDelayField = new JTextField(4);
        this.timedScriptHoursDelayField.setMaximumSize(new Dimension(30, 20));
        this.timedScriptHoursDelayField.setMinimumSize(new Dimension(30, 20));
        this.timedScriptHoursDelayField.setForeground(Color.BLUE);
        this.timedScriptHoursDelayField.setToolTipText("Number of hours delay between script execution");
        this.timedScriptHoursDelayField.addFocusListener(this);
        this.timedScriptHoursDelayField.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                ScriptDialog.this.updateCurrentTimedSelection();
            }
        });
        jPanel11.add(this.timedScriptHoursDelayField);
        jPanel11.add(Box.createRigidArea(new Dimension(5, 0)));
        jPanel11.add(new JLabel("hours "));
        this.timedScriptMinutesDelayField = new JTextField(2);
        this.timedScriptMinutesDelayField.setMaximumSize(new Dimension(25, 20));
        this.timedScriptMinutesDelayField.setMinimumSize(new Dimension(25, 20));
        this.timedScriptMinutesDelayField.setForeground(Color.BLUE);
        this.timedScriptMinutesDelayField.setToolTipText("Number of minutes delay between script execution");
        this.timedScriptMinutesDelayField.addFocusListener(this);
        this.timedScriptMinutesDelayField.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                ScriptDialog.this.updateCurrentTimedSelection();
            }
        });
        jPanel11.add(this.timedScriptMinutesDelayField);
        jPanel11.add(Box.createRigidArea(new Dimension(5, 0)));
        jPanel11.add(new JLabel("minutes "));
        jPanel11.setAlignmentX(0.0f);
        this.timedScriptDelayButton.setAlignmentX(0.0f);
        this.timedScriptSecondsDelayField = new JTextField(2);
        this.timedScriptSecondsDelayField.setMaximumSize(new Dimension(25, 20));
        this.timedScriptSecondsDelayField.setMinimumSize(new Dimension(25, 20));
        this.timedScriptSecondsDelayField.setForeground(Color.BLUE);
        this.timedScriptSecondsDelayField.setToolTipText("Number of seconds delay between script execution");
        this.timedScriptSecondsDelayField.addFocusListener(this);
        this.timedScriptSecondsDelayField.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                ScriptDialog.this.updateCurrentTimedSelection();
            }
        });
        jPanel11.add(this.timedScriptSecondsDelayField);
        jPanel11.add(Box.createRigidArea(new Dimension(5, 0)));
        jPanel11.add(new JLabel("seconds "));
        jPanel10.add(jPanel11);
        this.timedScriptTimeButton = new JRadioButton("Execute this script at a specific time");
        this.timedScriptTimeButton.addActionListener(this);
        jPanel10.add(this.timedScriptTimeButton);
        JPanel jPanel12 = new JPanel();
        jPanel12.setLayout(new BoxLayout(jPanel12, 2));
        jPanel12.setAlignmentX(0.0f);
        jPanel12.add(Box.createRigidArea(new Dimension(50, 0)));
        jPanel12.add(new JLabel("Execution time: "));
        jPanel12.add(Box.createRigidArea(new Dimension(5, 0)));
        this.timedScriptHoursTimeField = new JTextField(2);
        this.timedScriptHoursTimeField.setMaximumSize(new Dimension(20, 20));
        this.timedScriptHoursTimeField.setMinimumSize(new Dimension(20, 20));
        this.timedScriptHoursTimeField.setForeground(Color.BLUE);
        this.timedScriptHoursTimeField.setToolTipText("The hour of the day to execute the script");
        this.timedScriptHoursTimeField.addFocusListener(this);
        this.timedScriptHoursTimeField.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                ScriptDialog.this.updateCurrentTimedSelection();
            }
        });
        jPanel12.add(this.timedScriptHoursTimeField);
        jPanel12.add(Box.createRigidArea(new Dimension(5, 0)));
        jPanel12.add(new JLabel(": "));
        this.timedScriptMinutesTimeField = new JTextField(2);
        this.timedScriptMinutesTimeField.setMaximumSize(new Dimension(20, 20));
        this.timedScriptMinutesTimeField.setMinimumSize(new Dimension(20, 20));
        this.timedScriptMinutesTimeField.setForeground(Color.BLUE);
        this.timedScriptMinutesTimeField.setToolTipText("Minutes passed the hour to execute the script");
        this.timedScriptMinutesTimeField.addFocusListener(this);
        this.timedScriptMinutesTimeField.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                ScriptDialog.this.updateCurrentTimedSelection();
            }
        });
        jPanel12.add(this.timedScriptMinutesTimeField);
        jPanel12.add(Box.createRigidArea(new Dimension(5, 0)));
        this.timedScriptAMPMBox = new JComboBox<String>(new String[]{"AM", "PM"});
        this.timedScriptAMPMBox.setMaximumSize(new Dimension(50, 20));
        this.timedScriptAMPMBox.setToolTipText("Select either AM or PM time");
        this.timedScriptAMPMBox.setForeground(Color.BLUE);
        this.timedScriptAMPMBox.addActionListener(this);
        jPanel12.add(this.timedScriptAMPMBox);
        jPanel10.add(jPanel12);
        this.timedScriptFilenameField = new JTextField(20);
        this.timedScriptFilenameField.setToolTipText("This is the file path of the script to execute");
        this.timedScriptFilenameField.addActionListener(this);
        this.timedScriptFilenameField.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                int n = ScriptDialog.this.timedScriptFilenameField.getCaretPosition();
                ScriptDialog.this.updateCurrentTimedSelection();
                ScriptDialog.this.timedScriptFilenameField.setCaretPosition(n);
            }
        });
        this.timedScriptChooseButton = new JButton(this.openImage);
        this.timedScriptChooseButton.setToolTipText("Click here to select a script file");
        this.timedScriptChooseButton.addActionListener(this);
        this.timedScriptChooseButton.setPreferredSize(new Dimension(25, 25));
        this.timedScriptChooseButton.setMinimumSize(new Dimension(25, 25));
        this.timedScriptFilenameField.setMaximumSize(new Dimension(Integer.MAX_VALUE, 20));
        this.timedScriptEnabledBox = new JCheckBox("Enable this timed script");
        this.timedScriptEnabledBox.addActionListener(this);
        jPanel8 = new JPanel();
        jPanel8.setLayout(new BoxLayout(jPanel8, 2));
        jPanel8.setAlignmentX(0.0f);
        jPanel8.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel8.add(new JLabel("Script to execute: "));
        jPanel8.add(this.timedScriptFilenameField);
        jPanel8.add(Box.createHorizontalStrut(10));
        jPanel8.add(this.timedScriptChooseButton);
        jPanel10.add(jPanel8);
        jPanel10.add(this.timedScriptEnabledBox);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.timedScriptDelayButton);
        buttonGroup.add(this.timedScriptTimeButton);
        JPanel jPanel13 = new JPanel();
        jPanel13.setLayout(new BoxLayout(jPanel13, 3));
        jPanel13.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        jPanel13.add(jScrollPane2);
        jPanel13.add(Box.createRigidArea(new Dimension(0, 5)));
        jPanel13.add(jPanel9);
        jPanel13.add(jPanel10);
        this.getContentPane().setLayout(new BorderLayout());
        this.tabbedPane.addTab("Event scripts", this.eventScriptsPanel);
        this.tabbedPane.addTab("Timed scripts", jPanel13);
        this.getContentPane().add((Component)this.tabbedPane, "Center");
        this.okButton = new JButton("Ok", Sarj.OK_ICON);
        this.okButton.setToolTipText("Save settings and close window");
        this.okButton.addActionListener(this);
        this.cancelButton = new JButton("Cancel", Sarj.CANCEL_ICON);
        this.cancelButton.setToolTipText("Cancel changes made");
        this.cancelButton.addActionListener(this);
        jPanel5.add(this.okButton);
        jPanel5.add(this.cancelButton);
        this.getContentPane().add((Component)jPanel5, "South");
        this.pack();
        this.setLocationRelativeTo(null);
        this.timedScriptDelayButton.setEnabled(false);
        this.timedScriptHoursDelayField.setEnabled(false);
        this.timedScriptMinutesDelayField.setEnabled(false);
        this.timedScriptSecondsDelayField.setEnabled(false);
        this.timedScriptTimeButton.setEnabled(false);
        this.timedScriptHoursTimeField.setEnabled(false);
        this.timedScriptMinutesTimeField.setEnabled(false);
        this.timedScriptAMPMBox.setEnabled(false);
        this.timedScriptFilenameField.setEnabled(false);
        this.timedScriptChooseButton.setEnabled(false);
        this.timedScriptEnabledBox.setEnabled(false);
        this.timedScriptRemoveButton.setEnabled(false);
    }

    public void addEventScript(String string, String string2, boolean bl) {
        EventScriptListTableModel eventScriptListTableModel = (EventScriptListTableModel)this.eventScriptsTable.getModel();
        eventScriptListTableModel.addScript(string, string2, bl);
    }

    private void loadEventScriptDetails(String string, String string2, boolean bl) {
        this.eventScriptChooseButton.setEnabled(true);
        this.eventScriptFilenameField.setEnabled(true);
        this.eventScriptEnabledBox.setEnabled(true);
        this.eventScriptEnabledBox.setSelected(bl);
        this.eventScriptFilenameField.setText(string2);
        if ("onLoad".equals(string)) {
            this.setEventScriptLabelText(string, "When SARJ initially loads", "none");
        } else if ("onExit".equals(string)) {
            this.setEventScriptLabelText(string, "When user exits SARJ", "none");
        } else if ("onConnect".equals(string)) {
            this.setEventScriptLabelText(string, "When SARJ client establishes a connection with the server", "none");
        } else if ("onDisconnect".equals(string)) {
            this.setEventScriptLabelText(string, "When the connection to the server is lost", "none");
        } else if ("onJoinRequest".equals(string)) {
            this.setEventScriptLabelText(string, "When a player requests to join the server", "PLAYER_IP, PLAYER_PORT");
        } else if ("onPlayerJoin".equals(string)) {
            this.setEventScriptLabelText(string, "When a player joins the game", "PLAYER_NAME, PLAYER_IP, PLAYER_PORT");
        } else if ("onPlayerLeave".equals(string)) {
            this.setEventScriptLabelText(string, "When a player leaves the game", "PLAYER_NAME");
        } else if ("onAdminConnect".equals(string)) {
            this.setEventScriptLabelText(string, "When an admin connects to the server", "none");
        } else if ("onAdminDisconnect".equals(string)) {
            this.setEventScriptLabelText(string, "When an admin disconnects from the server", "none");
        } else if ("onPlayerSpeak".equals(string)) {
            this.setEventScriptLabelText(string, "When a player speaks", "PLAYER_NAME, SPEECH_TEXT");
        } else if ("onTimeLeftNotify".equals(string)) {
            this.setEventScriptLabelText(string, "When a 'time left' notification is sent from the server", "TIME_LEFT");
        } else if ("onDataReceived".equals(string)) {
            this.setEventScriptLabelText(string, "When data is received from the server", "DATA_STRING");
        } else {
            this.setEventScriptLabelText("Unknown", "Unknown event", "");
        }
    }

    private void loadTimedScriptDetails(String string, String string2, boolean bl, int n, int n2) {
        this.timedScriptRemoveButton.setEnabled(true);
        this.timedScriptFilenameField.setEnabled(true);
        this.timedScriptFilenameField.setText(string);
        this.timedScriptDelayButton.setEnabled(true);
        this.timedScriptTimeButton.setEnabled(true);
        this.timedScriptChooseButton.setEnabled(true);
        this.timedScriptEnabledBox.setEnabled(true);
        this.timedScriptEnabledBox.setSelected(bl);
        if ("Interval".equals(string2)) {
            this.timedScriptDelayButton.setSelected(true);
            this.timedScriptTimeButton.setSelected(false);
            this.timedScriptHoursDelayField.setEnabled(true);
            this.timedScriptMinutesDelayField.setEnabled(true);
            this.timedScriptSecondsDelayField.setEnabled(true);
            this.timedScriptHoursTimeField.setText("");
            this.timedScriptMinutesTimeField.setText("");
            this.timedScriptAMPMBox.setSelectedIndex(0);
            this.timedScriptHoursTimeField.setEnabled(false);
            this.timedScriptMinutesTimeField.setEnabled(false);
            this.timedScriptAMPMBox.setEnabled(false);
        } else {
            this.timedScriptDelayButton.setSelected(false);
            this.timedScriptTimeButton.setSelected(true);
            this.timedScriptHoursDelayField.setText("");
            this.timedScriptMinutesDelayField.setText("");
            this.timedScriptSecondsDelayField.setText("");
            this.timedScriptHoursDelayField.setEnabled(false);
            this.timedScriptMinutesDelayField.setEnabled(false);
            this.timedScriptSecondsDelayField.setEnabled(false);
            this.timedScriptHoursTimeField.setEnabled(true);
            this.timedScriptMinutesTimeField.setEnabled(true);
            this.timedScriptAMPMBox.setEnabled(true);
        }
        int n3 = n;
        int n4 = n3 / 3600;
        int n5 = (n3 %= 3600) / 60;
        this.timedScriptHoursDelayField.setText(Integer.toString(n4, 10));
        this.timedScriptMinutesDelayField.setText(Integer.toString(n5, 10));
        this.timedScriptSecondsDelayField.setText(Integer.toString(n3 %= 60, 10));
        n3 = n2;
        if (n3 >= 720) {
            n3 -= 720;
            this.timedScriptAMPMBox.setSelectedIndex(1);
        } else {
            this.timedScriptAMPMBox.setSelectedIndex(0);
        }
        n4 = n3 / 60;
        this.timedScriptHoursTimeField.setText(Integer.toString(n4, 10));
        this.timedScriptMinutesTimeField.setText(Integer.toString(n3 %= 60, 10));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string;
        File file;
        int n;
        Serializable serializable;
        Object object = actionEvent.getSource();
        if (object == this.eventScriptChooseButton) {
            serializable = new JFileChooser();
            ((JFileChooser)serializable).setFileFilter(new FileFilter(){

                public boolean accept(File file) {
                    if (file.isDirectory()) {
                        return true;
                    }
                    String string = ScriptDialog.this.getExtension(file);
                    if (string != null) {
                        return string.equals(ScriptDialog.EXTENSION_js) || string.equals(ScriptDialog.EXTENSION_es);
                    }
                    return false;
                }

                public String getDescription() {
                    return "JavaScript / EcmaScript files";
                }
            });
            n = ((JFileChooser)serializable).showOpenDialog(this);
            if (n == 0) {
                file = ((JFileChooser)serializable).getSelectedFile();
                string = file.getAbsolutePath();
                this.eventScriptFilenameField.setText(string);
                this.updateCurrentEventSelection();
            }
        } else if (object == this.eventScriptEnabledBox) {
            this.updateCurrentEventSelection();
        } else if (object == this.eventScriptFilenameField) {
            this.updateCurrentEventSelection();
        } else if (object == this.timedScriptDelayButton) {
            this.timedScriptHoursTimeField.setEnabled(false);
            this.timedScriptMinutesTimeField.setEnabled(false);
            this.timedScriptAMPMBox.setEnabled(false);
            this.timedScriptHoursDelayField.setEnabled(true);
            this.timedScriptMinutesDelayField.setEnabled(true);
            this.timedScriptSecondsDelayField.setEnabled(true);
            this.updateCurrentTimedSelection();
        } else if (object == this.timedScriptTimeButton) {
            this.timedScriptHoursTimeField.setEnabled(true);
            this.timedScriptMinutesTimeField.setEnabled(true);
            this.timedScriptAMPMBox.setEnabled(true);
            this.timedScriptHoursDelayField.setEnabled(false);
            this.timedScriptMinutesDelayField.setEnabled(false);
            this.timedScriptSecondsDelayField.setEnabled(false);
            this.updateCurrentTimedSelection();
        } else if (object == this.timedScriptEnabledBox) {
            this.updateCurrentTimedSelection();
        }
        if (object == this.timedScriptChooseButton) {
            serializable = new JFileChooser();
            ((JFileChooser)serializable).setFileFilter(new FileFilter(){

                public boolean accept(File file) {
                    if (file.isDirectory()) {
                        return true;
                    }
                    String string = ScriptDialog.this.getExtension(file);
                    if (string != null) {
                        return string.equals(ScriptDialog.EXTENSION_js) || string.equals(ScriptDialog.EXTENSION_es);
                    }
                    return false;
                }

                public String getDescription() {
                    return "JavaScript / EcmaScript files";
                }
            });
            n = ((JFileChooser)serializable).showOpenDialog(this);
            if (n == 0) {
                file = ((JFileChooser)serializable).getSelectedFile();
                string = file.getAbsolutePath();
                this.timedScriptFilenameField.setText(string);
                this.updateCurrentTimedSelection();
            }
        } else if (object == this.timedScriptAddButton) {
            serializable = (TimedScriptListTableModel)this.timedScriptsTable.getModel();
            ((TimedScriptListTableModel)serializable).addScript("New script", "Interval", true, 0, 0);
        } else if (object == this.timedScriptRemoveButton) {
            serializable = (TimedScriptListTableModel)this.timedScriptsTable.getModel();
            ListSelectionModel listSelectionModel = this.timedScriptsTable.getSelectionModel();
            int n2 = listSelectionModel.getMinSelectionIndex();
            if (n2 >= 0) {
                ((TimedScriptListTableModel)serializable).removeScript(n2);
                this.timedScriptDelayButton.setEnabled(false);
                this.timedScriptHoursDelayField.setEnabled(false);
                this.timedScriptMinutesDelayField.setEnabled(false);
                this.timedScriptSecondsDelayField.setEnabled(false);
                this.timedScriptTimeButton.setEnabled(false);
                this.timedScriptHoursTimeField.setEnabled(false);
                this.timedScriptMinutesTimeField.setEnabled(false);
                this.timedScriptAMPMBox.setEnabled(false);
                this.timedScriptFilenameField.setEnabled(false);
                this.timedScriptChooseButton.setEnabled(false);
                this.timedScriptEnabledBox.setEnabled(false);
                this.timedScriptRemoveButton.setEnabled(false);
            }
        } else if (object == this.cancelButton) {
            this.loadSettings();
            this.setVisible(false);
        } else if (object == this.okButton) {
            this.saveSettings();
            this.setVisible(false);
        }
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public void focusLost(FocusEvent focusEvent) {
        Object object = focusEvent.getSource();
        if (object == this.timedScriptHoursDelayField) {
            try {
                int n = Integer.parseInt(this.timedScriptHoursDelayField.getText());
                if (n < 0) {
                    this.timedScriptHoursDelayField.setText("00");
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.timedScriptHoursDelayField.setText("00");
            }
        } else if (object == this.timedScriptMinutesDelayField) {
            try {
                int n = Integer.parseInt(this.timedScriptMinutesDelayField.getText());
                if (n < 0) {
                    this.timedScriptMinutesDelayField.setText("00");
                } else if (n > 59) {
                    this.timedScriptMinutesDelayField.setText("59");
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.timedScriptMinutesDelayField.setText("00");
            }
        } else if (object == this.timedScriptSecondsDelayField) {
            try {
                int n = Integer.parseInt(this.timedScriptSecondsDelayField.getText());
                if (n < 0) {
                    this.timedScriptSecondsDelayField.setText("00");
                } else if (n > 59) {
                    this.timedScriptSecondsDelayField.setText("59");
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.timedScriptSecondsDelayField.setText("00");
            }
        } else if (object == this.timedScriptHoursTimeField) {
            try {
                int n = Integer.parseInt(this.timedScriptHoursTimeField.getText());
                if (n < 0) {
                    this.timedScriptHoursTimeField.setText("00");
                } else if (n > 12) {
                    this.timedScriptHoursTimeField.setText("12");
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.timedScriptHoursTimeField.setText("00");
            }
        } else if (object == this.timedScriptMinutesTimeField) {
            try {
                int n = Integer.parseInt(this.timedScriptMinutesTimeField.getText());
                if (n < 0) {
                    this.timedScriptMinutesTimeField.setText("00");
                } else if (n > 59) {
                    this.timedScriptMinutesTimeField.setText("59");
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.timedScriptMinutesTimeField.setText("00");
            }
        }
        this.updateCurrentTimedSelection();
    }

    private void setEventScriptLabelText(String string, String string2, String string3) {
        this.eventScriptDetailsLabel.setText("<html><font size=4 color=#0000CC>" + string + "</font><br><font size=2 color=#000000></font><font size = #0000CC>Called: </font><font size=2 color=#000000>" + string2 + "<br></font><font size = #0000CC>Parameters: </font><font size=2 color=#000000>" + string3 + "</font></html>");
    }

    private String getExtension(File file) {
        String string = null;
        String string2 = file.getName();
        int n = string2.lastIndexOf(46);
        if (n > 0 && n < string2.length() - 1) {
            string = string2.substring(n + 1).toLowerCase();
        }
        return string;
    }

    private void updateCurrentEventSelection() {
        int n = this.eventScriptsTable.getSelectedRow();
        if (n == -1) {
            Sarj.printError("Event script details update requested on current item when no item selected");
            return;
        }
        EventScriptListTableModel eventScriptListTableModel = (EventScriptListTableModel)this.eventScriptsTable.getModel();
        eventScriptListTableModel.updateScript(n, null, this.eventScriptFilenameField.getText(), this.eventScriptEnabledBox.isSelected());
        ListSelectionModel listSelectionModel = this.eventScriptsTable.getSelectionModel();
        listSelectionModel.setSelectionInterval(n, n);
    }

    private void updateCurrentTimedSelection() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6 = this.timedScriptsTable.getSelectedRow();
        if (n6 == -1) {
            Sarj.printError("Timed script details update requested on current item when no item selected");
            return;
        }
        TimedScriptListTableModel timedScriptListTableModel = (TimedScriptListTableModel)this.timedScriptsTable.getModel();
        String string = this.timedScriptDelayButton.isSelected() ? "Interval" : "Time";
        try {
            n5 = Integer.parseInt(this.timedScriptHoursDelayField.getText());
        }
        catch (NumberFormatException numberFormatException) {
            n5 = 0;
        }
        try {
            n4 = Integer.parseInt(this.timedScriptMinutesDelayField.getText());
        }
        catch (NumberFormatException numberFormatException) {
            n4 = 0;
        }
        try {
            n3 = Integer.parseInt(this.timedScriptSecondsDelayField.getText());
        }
        catch (NumberFormatException numberFormatException) {
            n3 = 0;
        }
        int n7 = n5 * 3600 + n4 * 60 + n3;
        try {
            n2 = Integer.parseInt(this.timedScriptHoursTimeField.getText());
        }
        catch (NumberFormatException numberFormatException) {
            n2 = 0;
        }
        try {
            n = Integer.parseInt(this.timedScriptMinutesTimeField.getText());
        }
        catch (NumberFormatException numberFormatException) {
            n = 0;
        }
        if (n2 > 23) {
            n2 = 23;
        }
        if (n2 > 12) {
            n2 -= 12;
            this.timedScriptAMPMBox.setSelectedIndex(1);
        }
        int n8 = n2 * 60 + n;
        if (this.timedScriptAMPMBox.getSelectedIndex() == 1) {
            n8 += 720;
        }
        timedScriptListTableModel.updateScript(n6, this.timedScriptFilenameField.getText(), string, this.timedScriptEnabledBox.isSelected(), n7, n8);
        ListSelectionModel listSelectionModel = this.timedScriptsTable.getSelectionModel();
        listSelectionModel.setSelectionInterval(n6, n6);
    }

    public void loadSettings() {
        BufferedReader bufferedReader;
        String string = "";
        try {
            bufferedReader = new BufferedReader(new FileReader(new File(this.settingsFile)));
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this.owner.getMainFrame(), "Failed to open script settings file!", "Error", 0);
            return;
        }
        try {
            string = bufferedReader.readLine();
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(this.owner.getMainFrame(), "Warning: Exception occurred when reading script settings file!", "Error", 0);
            return;
        }
        EventScriptListTableModel eventScriptListTableModel = (EventScriptListTableModel)this.eventScriptsTable.getModel();
        eventScriptListTableModel.clear();
        TimedScriptListTableModel timedScriptListTableModel = (TimedScriptListTableModel)this.timedScriptsTable.getModel();
        timedScriptListTableModel.clear();
        while (string != null) {
            try {
                String[] stringArray;
                if (string != null && string.length() > 0 && !string.trim().startsWith("#") && (stringArray = string.split("=")).length > 1) {
                    int n;
                    for (n = 0; n < stringArray.length; ++n) {
                        stringArray[n] = stringArray[n].trim();
                    }
                    String string2 = stringArray[0];
                    String[] stringArray2 = stringArray[1].split(";");
                    for (n = 0; n < stringArray2.length; ++n) {
                        stringArray2[n] = stringArray2[n].trim();
                    }
                    if ("onLoad".equalsIgnoreCase(string2) || "onExit".equalsIgnoreCase(string2) || "onConnect".equalsIgnoreCase(string2) || "onDisconnect".equalsIgnoreCase(string2) || "onJoinRequest".equalsIgnoreCase(string2) || "onPlayerJoin".equalsIgnoreCase(string2) || "onPlayerLeave".equalsIgnoreCase(string2) || "onAdminConnect".equalsIgnoreCase(string2) || "onAdminDisconnect".equalsIgnoreCase(string2) || "onPlayerSpeak".equalsIgnoreCase(string2) || "onTimeLeftNotify".equalsIgnoreCase(string2) || "onDataReceived".equalsIgnoreCase(string2)) {
                        if (stringArray2.length < 2) {
                            Sarj.printError("Incorrent number of properties in setting '" + string + "'");
                        } else {
                            eventScriptListTableModel.addScript(string2, stringArray2[0], this.isTrue(stringArray2[1]));
                        }
                    } else if ("timed".equalsIgnoreCase(string2)) {
                        if (stringArray2.length < 5) {
                            Sarj.printError("Incorrect number of properties in setting '" + string + "'");
                        } else {
                            timedScriptListTableModel.addScript(stringArray2[0], stringArray2[1], this.isTrue(stringArray2[2]), Integer.parseInt(stringArray2[3]), Integer.parseInt(stringArray2[4]));
                        }
                    }
                }
                string = bufferedReader.readLine();
            }
            catch (IOException iOException) {
                JOptionPane.showMessageDialog(this.owner.getMainFrame(), "Warning: Failed to read from config file!", "Error", 0);
                return;
            }
        }
        try {
            bufferedReader.close();
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(this.owner.getMainFrame(), "Warning: Exception occurred when closing config file!", "Error", 0);
        }
    }

    public void saveSettings() {
        EventScriptListTableModel eventScriptListTableModel = (EventScriptListTableModel)this.eventScriptsTable.getModel();
        TimedScriptListTableModel timedScriptListTableModel = (TimedScriptListTableModel)this.timedScriptsTable.getModel();
        int n = eventScriptListTableModel.getRowCount();
        try {
            String string;
            int n2;
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(new File(this.settingsFile)));
            bufferedWriter.write("# SARJ script settings\r\n\r\n# Event-driven scripts\r\n");
            for (n2 = 0; n2 < n; ++n2) {
                string = (Boolean)eventScriptListTableModel.getValueAt(n2, 2) != false ? "true" : "false";
                bufferedWriter.write((String)eventScriptListTableModel.getValueAt(n2, 0) + "=" + (String)eventScriptListTableModel.getValueAt(n2, 1) + ";" + string + "\r\n");
            }
            n = timedScriptListTableModel.getRowCount();
            bufferedWriter.write("\r\n# Timed scripts\r\n");
            for (n2 = 0; n2 < n; ++n2) {
                string = (Boolean)timedScriptListTableModel.getValueAt(n2, 2) != false ? "true" : "false";
                bufferedWriter.write("timed=" + (String)timedScriptListTableModel.getValueAt(n2, 0) + ";" + (String)timedScriptListTableModel.getValueAt(n2, 1) + ";" + string + ";" + (Integer)timedScriptListTableModel.getValueAt(n2, 3) + ";" + (Integer)timedScriptListTableModel.getValueAt(n2, 4) + "\r\n");
            }
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(this.owner.getMainFrame(), "Warning: Failed to save script settings!", "Error", 0);
            return;
        }
    }

    private boolean isTrue(String string) {
        return "1".equals(string) || "true".equalsIgnoreCase(string) || "yes".equalsIgnoreCase(string) || "on".equalsIgnoreCase(string);
    }

    public String getFilenameForEvent(String string) throws EventNotFoundException {
        EventScriptListTableModel eventScriptListTableModel = (EventScriptListTableModel)this.eventScriptsTable.getModel();
        int n = eventScriptListTableModel.getRowCount();
        for (int i = 0; i < n; ++i) {
            String string2 = (String)eventScriptListTableModel.getValueAt(i, 0);
            if (!string.equalsIgnoreCase(string2)) continue;
            return (String)eventScriptListTableModel.getValueAt(i, 1);
        }
        throw new EventNotFoundException(string);
    }

    public boolean isEventEnabled(String string) throws EventNotFoundException {
        EventScriptListTableModel eventScriptListTableModel = (EventScriptListTableModel)this.eventScriptsTable.getModel();
        int n = eventScriptListTableModel.getRowCount();
        for (int i = 0; i < n; ++i) {
            String string2 = (String)eventScriptListTableModel.getValueAt(i, 0);
            if (!string.equalsIgnoreCase(string2)) continue;
            return (Boolean)eventScriptListTableModel.getValueAt(i, 2);
        }
        throw new EventNotFoundException(string);
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl) {
            this.eventScriptFilenameField.setText("");
            this.eventScriptEnabledBox.setSelected(false);
            this.eventScriptFilenameField.setEnabled(false);
            this.eventScriptEnabledBox.setEnabled(false);
            this.eventScriptChooseButton.setEnabled(false);
            ListSelectionModel listSelectionModel = this.eventScriptsTable.getSelectionModel();
            listSelectionModel.clearSelection();
            this.timedScriptDelayButton.setEnabled(false);
            this.timedScriptHoursDelayField.setText("");
            this.timedScriptHoursDelayField.setEnabled(false);
            this.timedScriptMinutesDelayField.setText("");
            this.timedScriptMinutesDelayField.setEnabled(false);
            this.timedScriptSecondsDelayField.setText("");
            this.timedScriptSecondsDelayField.setEnabled(false);
            this.timedScriptTimeButton.setEnabled(false);
            this.timedScriptHoursTimeField.setText("");
            this.timedScriptHoursTimeField.setEnabled(false);
            this.timedScriptMinutesTimeField.setText("");
            this.timedScriptMinutesTimeField.setEnabled(false);
            this.timedScriptAMPMBox.setSelectedIndex(0);
            this.timedScriptAMPMBox.setEnabled(false);
            this.timedScriptFilenameField.setText("");
            this.timedScriptFilenameField.setEnabled(false);
            this.timedScriptChooseButton.setEnabled(false);
            this.timedScriptEnabledBox.setSelected(true);
            this.timedScriptEnabledBox.setEnabled(false);
            this.timedScriptRemoveButton.setEnabled(false);
            listSelectionModel = this.timedScriptsTable.getSelectionModel();
            listSelectionModel.clearSelection();
        }
    }

    public Object[][] getTimedScriptDetails() {
        TimedScriptListTableModel timedScriptListTableModel = (TimedScriptListTableModel)this.timedScriptsTable.getModel();
        return timedScriptListTableModel.getData();
    }
}

