/*
 * Decompiled with CFR 0.152.
 */
package sarj;

import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import sarj.EditScriptDialog;
import sarj.GUIListener;
import sarj.ScriptButton;

public class ScriptButtonPanel
extends JPanel
implements ActionListener,
MouseListener {
    private static final long serialVersionUID = 5947847346149275958L;
    private ArrayList<ScriptButton> buttonList;
    private GUIListener listener;
    private String settingsFile;
    private JPopupMenu sbMenu;
    private JMenuItem sbAddItem;
    private JMenuItem sbEditItem;
    private JMenuItem sbRemoveItem;
    private ScriptButton selectedButton = null;
    private EditScriptDialog editScriptDialog;

    public ScriptButtonPanel(JFrame jFrame, String string, GUIListener gUIListener) {
        this.settingsFile = string;
        this.listener = gUIListener;
        this.buttonList = new ArrayList();
        this.sbMenu = new JPopupMenu("ScriptButton menu");
        this.sbAddItem = new JMenuItem("Add a new script button");
        this.sbAddItem.addActionListener(this);
        this.sbMenu.add(this.sbAddItem);
        this.sbEditItem = new JMenuItem("Edit this script button");
        this.sbEditItem.addActionListener(this);
        this.sbMenu.add(this.sbEditItem);
        this.sbRemoveItem = new JMenuItem("Remove this script button");
        this.sbRemoveItem.addActionListener(this);
        this.sbMenu.add(this.sbRemoveItem);
        this.setLayout(new FlowLayout(0, 5, 5));
        this.setToolTipText("Left click to launch, or right click to configure");
        this.loadSettings();
        this.editScriptDialog = new EditScriptDialog(jFrame, "Edit script button", this);
    }

    public ScriptButton addScriptButton(String string, String string2) {
        ScriptButton scriptButton = new ScriptButton(string, string2);
        scriptButton.setToolTipText(string2);
        scriptButton.addActionListener(this);
        scriptButton.addMouseListener(this);
        this.buttonList.add(scriptButton);
        this.add(scriptButton);
        this.revalidate();
        this.saveSettings();
        return scriptButton;
    }

    public void removeScriptButton(String string) {
        for (ScriptButton scriptButton : this.buttonList) {
            if (!string.equals(scriptButton.getName())) continue;
            this.buttonList.remove(scriptButton);
            this.remove(scriptButton);
            this.revalidate();
            this.repaint();
            this.saveSettings();
            return;
        }
    }

    public void removeScriptButton(ScriptButton scriptButton) {
        this.buttonList.remove(scriptButton);
        this.remove(scriptButton);
        this.revalidate();
        this.repaint();
        this.saveSettings();
    }

    public ScriptButton[] getScriptButtons() {
        return this.buttonList.toArray(new ScriptButton[this.buttonList.size()]);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.sbAddItem) {
            this.addNewButton();
        } else if (object == this.sbEditItem) {
            this.editScriptDialog.associateWith(this.selectedButton);
            this.editScriptDialog.setVisible(true);
        } else if (object == this.sbRemoveItem) {
            this.removeScriptButton(this.selectedButton);
        } else {
            ScriptButton scriptButton = (ScriptButton)actionEvent.getSource();
            this.listener.onScriptButtonClick(scriptButton.getName(), scriptButton.getScriptFile());
        }
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.maybeShowPopup(mouseEvent);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.maybeShowPopup(mouseEvent);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    private void maybeShowPopup(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger() && mouseEvent.getSource() instanceof ScriptButton) {
            this.selectedButton = (ScriptButton)mouseEvent.getSource();
            ScriptButton scriptButton = (ScriptButton)mouseEvent.getSource();
            this.sbMenu.setEnabled(true);
            this.sbMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }
    }

    public void addNewButton() {
        ScriptButton scriptButton = this.addScriptButton("New button", "New action");
    }

    public void loadSettings() {
        BufferedReader bufferedReader;
        this.buttonList.clear();
        this.removeAll();
        String string = "";
        try {
            bufferedReader = new BufferedReader(new FileReader(new File(this.settingsFile)));
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(null, "Failed to open " + this.settingsFile + "!", "Error", 0);
            return;
        }
        try {
            string = bufferedReader.readLine();
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(null, "Warning: Exception occurred when reading " + this.settingsFile + "!", "Error", 0);
            return;
        }
        while (string != null) {
            try {
                String[] stringArray;
                if (string != null && string.length() > 0 && !string.trim().startsWith("#") && (stringArray = string.split("=")).length > 1) {
                    for (int i = 0; i < stringArray.length; ++i) {
                        stringArray[i] = stringArray[i].trim();
                    }
                    this.addScriptButton(stringArray[0], stringArray[1]);
                }
                string = bufferedReader.readLine();
            }
            catch (IOException iOException) {
                JOptionPane.showMessageDialog(null, "Warning: Failed to read from " + this.settingsFile + "!", "Error", 0);
                return;
            }
        }
        try {
            bufferedReader.close();
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(null, "Warning: Exception occurred when closing " + this.settingsFile + "!", "Error", 0);
        }
    }

    public void saveSettings() {
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(new File(this.settingsFile)));
            bufferedWriter.write("# SARJ Script button settings\r\n\r\n");
            for (ScriptButton scriptButton : this.buttonList) {
                bufferedWriter.write(scriptButton.getName() + "=" + scriptButton.getScriptFile() + "\r\n");
            }
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(null, "Warning: Failed to save configuration settings to " + this.settingsFile + "!", "Error", 0);
            return;
        }
    }
}

