/*
 * Decompiled with CFR 0.152.
 */
package sarj;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.io.IOException;
import java.net.UnknownHostException;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.Timer;
import javax.swing.UIManager;
import sarj.ConfigDialog;
import sarj.Connection;
import sarj.ConnectionListener;
import sarj.EventNotFoundException;
import sarj.GUI;
import sarj.GUIListener;
import sarj.ScriptingFacade;
import scripting.InterpreterDriver;
import scripting.InterpreterDriverManager;

public class Sarj
extends WindowAdapter
implements Runnable,
GUIListener,
ConnectionListener,
ScriptingFacade {
    static final String configFileLocation = "config.txt";
    static final String scriptSettingsFileLocation = "scripts.cfg";
    static final String scriptButtonSettingsFileLocation = "scriptbuttons.cfg";
    static final String VERSION = "1.2.0";
    static final Sarj instance = new Sarj();
    static final String SERVMSG_ADMIN_CONNECTED = "Admin connected.";
    static final String SERVMSG_ADMIN_DISCONNECTED = "Admin disconnected.";
    static final String SERVMSG_TIME_LEFT = "Time Left: ";
    static final String SERVMSG_JOIN_REQUEST = " requesting game...";
    static final String SERVMSG_PLAYER_JOINING = " joining game ";
    static final String SERVMSG_PLAYER_LEAVE = " has left the game.";
    static final String SERVMSG_PLAYER_JOINED = " has joined the game.";
    static final int SCRIPT_TIME_INTERVAL = 1000;
    public static ImageIcon OK_ICON = new ImageIcon(instance.getClass().getResource("/images/ok.gif"));
    public static ImageIcon CANCEL_ICON = new ImageIcon(instance.getClass().getResource("/images/cancel.gif"));
    private String mapName = "?";
    private String gameType = "?";
    private int scoreLimit;
    private int timeLimit;
    private int timeLeft;
    private int numPlayers;
    private int refreshDelay;
    private int refreshClock;
    private boolean autoRefresh;
    private GUI myGUI;
    private Connection myConnection;
    private Timer scriptTimer;
    private long timePassed;

    public static void main(String[] stringArray) {
        try {
            UIManager.setLookAndFeel(ConfigDialog.getUIClassNameFromConfigFile(configFileLocation));
        }
        catch (Exception exception) {
            Sarj.printError("Exception: " + exception.getMessage());
        }
        try {
            Class.forName("scripting.InterpreterDriverManager");
            Class.forName("scripting.JSInterpreterDriver");
        }
        catch (ClassNotFoundException classNotFoundException) {
            Sarj.printError("Exception: " + classNotFoundException.getMessage());
            return;
        }
        Thread thread = new Thread(instance);
        thread.start();
    }

    protected void Sarj() {
    }

    public static Sarj instance() {
        return instance;
    }

    public void run() {
        JFrame.setDefaultLookAndFeelDecorated(true);
        JDialog.setDefaultLookAndFeelDecorated(true);
        this.myGUI = new GUI(configFileLocation, scriptSettingsFileLocation, scriptButtonSettingsFileLocation, this);
        this.myConnection = new Connection(this);
        this.refreshClock = 0;
        this.scriptTimer = new Timer(1000, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Sarj.this.checkTimedScripts(1000);
            }
        });
        this.scriptTimer.start();
        this.timePassed = 0L;
        this.myGUI.show();
        this.dispatchEventScript("onLoad", null, null);
        int[] nArray = new int[1188];
        boolean bl = false;
        while (true) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.myConnection.isClosed()) continue;
            try {
                while (true) {
                    String string;
                    if ((string = this.myConnection.readString()).startsWith("REFRESH")) {
                        int n;
                        int n2 = this.myConnection.read();
                        if (n2 == 82) {
                            this.myConnection.skip(8);
                            n = 0;
                        } else {
                            nArray[0] = n2;
                            n = 1;
                        }
                        while (n < 1188) {
                            nArray[n] = this.myConnection.read();
                            ++n;
                        }
                        this.parseRefresh(nArray);
                    } else {
                        Object object;
                        String[] stringArray;
                        String[] stringArray2;
                        if (string.trim().equals(SERVMSG_ADMIN_CONNECTED)) {
                            this.dispatchEventScript("onAdminConnect", null, null);
                        } else if (string.trim().equals(SERVMSG_ADMIN_DISCONNECTED)) {
                            this.dispatchEventScript("onAdminDisconnect", null, null);
                        } else if (string.startsWith(SERVMSG_TIME_LEFT)) {
                            stringArray2 = new String[]{string.substring(11, 12)};
                            stringArray2[0] = stringArray2[0].trim();
                            this.dispatchEventScript("onTimeLeftNotify", new String[]{"TIME_LEFT"}, stringArray2);
                        } else if (string.trim().endsWith(SERVMSG_JOIN_REQUEST)) {
                            stringArray2 = new String[2];
                            stringArray = string.substring(0, string.indexOf(SERVMSG_JOIN_REQUEST));
                            stringArray = stringArray.trim();
                            object = stringArray.split(":");
                            stringArray2[0] = object[0];
                            stringArray2[1] = object[1];
                            this.dispatchEventScript("onJoinRequest", new String[]{"PLAYER_IP", "PLAYER_PORT"}, stringArray2);
                        } else if (string.trim().indexOf(SERVMSG_PLAYER_JOINING) != -1) {
                            stringArray2 = string.trim().split(SERVMSG_PLAYER_JOINING);
                            stringArray = new String[3];
                            object = stringArray2[1].trim().split(":");
                            stringArray[0] = stringArray2[0].trim();
                            stringArray[1] = object[0].substring(1);
                            stringArray[2] = object[1].substring(0, object[1].length() - 1);
                            this.dispatchEventScript("onPlayerJoin", new String[]{"PLAYER_NAME", "PLAYER_IP", "PLAYER_PORT"}, stringArray);
                        } else if (string.trim().endsWith(SERVMSG_PLAYER_LEAVE)) {
                            stringArray2 = string.substring(0, string.indexOf(SERVMSG_PLAYER_LEAVE));
                            stringArray = new String[]{stringArray2.trim()};
                            this.dispatchEventScript("onPlayerLeave", new String[]{"PLAYER_NAME"}, stringArray);
                        } else if (!string.trim().endsWith(SERVMSG_PLAYER_JOINED) && string.trim().startsWith("[")) {
                            int n = string.indexOf("] ");
                            if (n < 0) {
                                return;
                            }
                            stringArray = this.getPlayerData();
                            if (stringArray == null) {
                                return;
                            }
                            boolean bl2 = false;
                            for (int i = 0; i < stringArray.length && ((String)stringArray[i]).length >= 1; ++i) {
                                object = stringArray[i][0];
                                if (!string.substring(1).startsWith((String)object)) continue;
                                bl2 = true;
                                String string2 = string.substring(((String)object).length() + 3);
                                string2 = string2.trim();
                                String[] stringArray3 = new String[]{object, string2};
                                this.dispatchEventScript("onPlayerSpeak", new String[]{"PLAYER_NAME", "SPEECH_TEXT"}, stringArray3);
                            }
                            if (!bl2) {
                                Sarj.printError(string);
                                Sarj.printError("Player name not found");
                            }
                        }
                        this.myGUI.writeToConsole(string);
                        stringArray2 = new String[]{string};
                        this.dispatchEventScript("onDataReceived", new String[]{"DATA_STRING"}, stringArray2);
                    }
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            catch (IOException iOException) {
                if (this.myConnection.isClosed()) continue;
                this.myConnection.disconnect();
                this.myGUI.disconnected();
                this.myGUI.stopRefreshTimer();
                continue;
            }
            break;
        }
    }

    public static void printError(String string) {
        GUI.printError(string);
    }

    private synchronized void parseRefresh(int[] nArray) {
        int n;
        char[] cArray;
        int n2;
        int[] nArray2 = new int[32];
        String[] stringArray = new String[32];
        int[] nArray3 = new int[32];
        int[] nArray4 = new int[32];
        int[] nArray5 = new int[32];
        int[] nArray6 = new int[32];
        int[] nArray7 = new int[32];
        String[] stringArray2 = new String[32];
        int[] nArray8 = new int[4];
        int[] nArray9 = new int[4];
        int[] nArray10 = new int[4];
        int[] nArray11 = new int[4];
        if (nArray.length < 1188) {
            return;
        }
        for (n2 = 0; n2 < 32; ++n2) {
            stringArray[n2] = new String();
        }
        for (n2 = 0; n2 < 4; ++n2) {
            nArray9[n2] = 0;
            nArray10[n2] = 0;
            nArray11[n2] = 0;
        }
        this.numPlayers = 0;
        int n3 = 800;
        while (nArray[n3] != 255 && this.numPlayers < 32) {
            nArray3[this.numPlayers] = nArray[n3];
            ++this.numPlayers;
            ++n3;
        }
        n3 = 0;
        for (n2 = 0; n2 < this.numPlayers; ++n2) {
            nArray2[n2] = nArray[n3];
            ++n3;
            if (nArray2[n2] < 1) break;
            cArray = new char[nArray2[n2]];
            for (n = 0; n < nArray2[n2]; ++n) {
                cArray[n] = (char)nArray[n3];
                ++n3;
            }
            while (n < 24) {
                ++n3;
                ++n;
            }
            stringArray[n2] = new String(cArray);
        }
        n3 = 1177;
        this.timeLimit = (nArray[n3 + 3] << 24 | nArray[n3 + 2] << 16 | nArray[n3 + 1] << 8 | nArray[n3]) / 60;
        n3 = 1181;
        this.timeLeft = (nArray[n3 + 3] << 24 | nArray[n3 + 2] << 16 | nArray[n3 + 1] << 8 | nArray[n3]) / 60;
        n3 = 832;
        n2 = 0;
        while (n2 < this.numPlayers) {
            nArray4[n2] = nArray[n3];
            int n4 = n2++;
            nArray4[n4] = nArray4[n4] | nArray[n3 + 1] << 8;
            n3 += 2;
        }
        n3 = 896;
        for (n2 = 0; n2 < this.numPlayers; ++n2) {
            nArray5[n2] = nArray[n3];
            n3 += 2;
        }
        n3 = 960;
        for (n2 = 0; n2 < this.numPlayers; ++n2) {
            nArray7[n2] = nArray[n3];
            ++n3;
        }
        n3 = 992;
        for (n2 = 0; n2 < this.numPlayers; ++n2) {
            nArray6[n2] = nArray[n3];
            ++n3;
        }
        n3 = 1024;
        for (n2 = 0; n2 < this.numPlayers; ++n2) {
            int[] nArray12 = new int[4];
            for (n = 0; n < 4; ++n) {
                nArray12[n] = nArray[n3];
                ++n3;
            }
            stringArray2[n2] = nArray12[0] + "." + nArray12[1] + "." + nArray12[2] + "." + nArray12[3];
        }
        n3 = 1185;
        this.scoreLimit = nArray[n3];
        n3 = 1187;
        int n5 = nArray[n3];
        switch (n5) {
            case 0: {
                this.gameType = "Deathmatch";
                break;
            }
            case 1: {
                this.gameType = "Pointmatch";
                break;
            }
            case 2: {
                this.gameType = "Teammatch";
                break;
            }
            case 3: {
                this.gameType = "CTF";
                break;
            }
            case 4: {
                this.gameType = "Rambomatch";
                break;
            }
            case 5: {
                this.gameType = "Infiltration";
                break;
            }
            default: {
                this.gameType = "Unknown";
            }
        }
        n3 = 1152;
        for (n2 = 0; n2 < 4; ++n2) {
            nArray8[n2] = nArray[n3] | nArray[n3 + 1] << 8;
            n3 += 2;
        }
        n3 = 1160;
        int n6 = nArray[n3];
        int n7 = Integer.parseInt(new Integer(n6).toString());
        cArray = new char[n7];
        for (n2 = 0; n2 < n7; ++n2) {
            cArray[n2] = (char)nArray[++n3];
        }
        this.mapName = new String(cArray);
        this.myGUI.setTitle("SARJ 1.2.0 :: Connected [" + this.numPlayers + " players]");
        this.myGUI.clearPlayerTable();
        for (int i = 0; i < this.numPlayers; ++i) {
            String string;
            if (nArray4[i] == 0) {
                string = "0";
            } else if (nArray5[i] == 0) {
                string = "*";
            } else {
                float f = (float)nArray4[i] / (float)nArray5[i];
                f = (float)Math.round(f * 100.0f) / 100.0f;
                string = new Float(f).toString();
            }
            this.myGUI.addPlayer(stringArray[i], nArray4[i], nArray5[i], string, nArray7[i], nArray3[i], stringArray2[i], nArray6[i]);
        }
        int[] nArray13 = new int[4];
        for (n2 = 0; n2 < 4; ++n2) {
            nArray13[n2] = 0;
        }
        for (n2 = 0; n2 < this.numPlayers; ++n2) {
            if (nArray3[n2] >= 5 || nArray3[n2] <= 0) continue;
            int n8 = nArray3[n2] - 1;
            nArray13[n8] = nArray13[n8] + 1;
            int n9 = nArray3[n2] - 1;
            nArray10[n9] = nArray10[n9] + nArray4[n2];
            int n10 = nArray3[n2] - 1;
            nArray9[n10] = nArray9[n10] + nArray5[n2];
            int n11 = nArray3[n2] - 1;
            nArray11[n11] = nArray11[n11] + nArray7[n2];
        }
        for (n2 = 0; n2 < 4; ++n2) {
            if (nArray13[n2] <= 0) continue;
            int n12 = n2;
            nArray11[n12] = nArray11[n12] / nArray13[n2];
        }
        this.myGUI.clearTeamTable();
        this.myGUI.addTeam("<html><font color='#CC0000'>Alpha</font></html>", nArray8[0], nArray10[0], nArray9[0], nArray11[0]);
        this.myGUI.addTeam("<html><font color='#0000CC'>Bravo</font></html>", nArray8[1], nArray10[1], nArray9[1], nArray11[1]);
        this.myGUI.addTeam("<html><font color='#AAAA00'>Charlie</font></html>", nArray8[2], nArray10[2], nArray9[2], nArray11[2]);
        this.myGUI.addTeam("<html><font color='#00BB00'>Delta</font></html>", nArray8[3], nArray10[3], nArray9[3], nArray11[3]);
        this.myGUI.setMapName("<html>Map: <font color = '#0000FF'><b>" + this.mapName + "</b></font></html>");
        this.myGUI.setTimeLimit("<html>Time limit: <font color = '#0000FF'><b>" + Sarj.formatTime(this.timeLimit) + "</b></font></html>");
        this.myGUI.setTimeLeft("<html>Time left: <font color = '#0000FF'><b>" + Sarj.formatTime(this.timeLeft) + "</b></font></html>");
        this.myGUI.setScoreLimit("<html>Score limit: <font color = '#0000FF'><b>" + this.scoreLimit + "</b></font></html>");
        this.myGUI.setGameType("<html>Game: <font color = '#0000FF'><b>" + this.gameType + "</b></font></html>");
    }

    public void onConnect(String string, int n, String string2) {
        try {
            this.myGUI.writeToConsole("Connecting...\n");
            this.myConnection.connect(string, n);
        }
        catch (UnknownHostException unknownHostException) {
            this.myGUI.writeToConsole("Unknown host: '" + string + "'\n");
        }
        catch (IOException iOException) {
            this.myGUI.writeToConsole("Failed to connect to '" + string + "'\n");
        }
    }

    public void onDisconnect() {
        this.myConnection.disconnect();
        this.myGUI.disconnected();
    }

    public void onExit() {
        if (this.myConnection.isClosed() || JOptionPane.showConfirmDialog(this.myGUI.getMainFrame(), "You are still connected. Exit anyway?", "Exit SARJ?", 0, 3) == 0) {
            try {
                this.myConnection.disconnect();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.dispatchEventScript("onExit", null, null);
            System.exit(0);
        }
    }

    public void onAction(int n) {
        switch (n) {
            case 0: {
                if (JOptionPane.showConfirmDialog(this.myGUI.getMainFrame(), "Really shutdown the server?", "Shutdown server", 2, 3) != 0) break;
                this.myConnection.sendData("SHUTDOWN\n");
                this.myConnection.disconnect();
                break;
            }
            case 1: {
                String string = JOptionPane.showInputDialog(this.myGUI.getMainFrame(), "Server message:", "Server message", -1);
                if (string == null || string.length() <= 0) break;
                this.myConnection.sendData("/say " + string + "\n");
                break;
            }
            case 2: {
                String string = JOptionPane.showInputDialog(this.myGUI.getMainFrame(), "Name of bot to add:", "Add bot", -1);
                if (string == null || string.length() <= 0) break;
                Object[] objectArray = new String[]{"Alpha", "Bravo", "Charlie", "Delta"};
                int n2 = JOptionPane.showOptionDialog(this.myGUI.getMainFrame(), "Please select a team:", "Add bot", 0, -1, null, objectArray, null);
                if (n2 == -1) break;
                this.myConnection.sendData("/addbot" + (n2 + 1) + " " + string + "\n");
                break;
            }
            case 3: {
                String string = JOptionPane.showInputDialog(this.myGUI.getMainFrame(), "Player name/number:", "Kick player", -1);
                if (string == null || string.length() <= 0) break;
                this.myConnection.sendData("/kick " + string + "\n");
                break;
            }
            case 4: {
                String string = JOptionPane.showInputDialog(this.myGUI.getMainFrame(), "Player name/number:", "Ban player", -1);
                if (string == null || string.length() <= 0) break;
                this.myConnection.sendData("/ban " + string + "\n");
                break;
            }
            case 5: {
                String string = JOptionPane.showInputDialog(this.myGUI.getMainFrame(), "IP:", "Ban IP", -1);
                if (string == null || string.length() <= 0) break;
                int n3 = 0;
                for (int i = 0; i < string.length(); ++i) {
                    if (string.charAt(i) != '.') continue;
                    ++n3;
                }
                if (n3 != 3) {
                    JOptionPane.showMessageDialog(this.myGUI.getMainFrame(), "Sorry, that isn't a valid IP address", "Error", 0);
                    return;
                }
                this.myConnection.sendData("/banip " + string + "\n");
                break;
            }
            case 6: {
                String string = JOptionPane.showInputDialog(this.myGUI.getMainFrame(), "IP:", "Unban IP", -1);
                if (string == null || string.length() <= 0) break;
                int n4 = 0;
                for (int i = 0; i < string.length(); ++i) {
                    if (string.charAt(i) != '.') continue;
                    ++n4;
                }
                if (n4 != 3) {
                    JOptionPane.showMessageDialog(this.myGUI.getMainFrame(), "Sorry, that isn't a valid IP address", "Error", 0);
                    return;
                }
                this.myConnection.sendData("/unbanip " + string + "\n");
                break;
            }
            case 7: {
                String string = JOptionPane.showInputDialog(this.myGUI.getMainFrame(), "New map:", "Change map", -1);
                if (string == null || string.length() <= 0) break;
                this.myConnection.sendData("/map " + string + "\n");
                break;
            }
            case 8: {
                this.myConnection.sendData("/restart\n");
                break;
            }
            case 9: {
                this.myConnection.sendData("/nextmap\n");
                break;
            }
            case 10: {
                Object[] objectArray = new String[]{"Add by name", "Add by IP"};
                int n5 = JOptionPane.showOptionDialog(this.myGUI.getMainFrame(), "Please select an option:", "Add remote admin", 0, -1, null, objectArray, null);
                if (n5 == -1) break;
                String string = null;
                if (n5 == 0) {
                    String string2 = JOptionPane.showInputDialog(this.myGUI.getMainFrame(), "Player name:", "Add remote admin", -1);
                    if (string2 != null && string2.length() > 0) {
                        string = "/adm " + string2 + "\n";
                    }
                } else {
                    String string3 = JOptionPane.showInputDialog(this.myGUI.getMainFrame(), "Player IP:", "Add remote admin", -1);
                    if (string3 != null && string3.length() > 0) {
                        int n6 = 0;
                        for (int i = 0; i < string3.length(); ++i) {
                            if (string3.charAt(i) != '.') continue;
                            ++n6;
                        }
                        if (n6 != 3) {
                            JOptionPane.showMessageDialog(this.myGUI.getMainFrame(), "Sorry, that isn't a valid IP address", "Error", 0);
                            return;
                        }
                        string = "/admip " + string3 + "\n";
                    }
                }
                this.myConnection.sendData(string);
                break;
            }
            case 11: {
                String string = JOptionPane.showInputDialog(this.myGUI.getMainFrame(), "Player IP:", "Remove remote admin", -1);
                if (string == null || string.length() <= 0) break;
                int n7 = 0;
                for (int i = 0; i < string.length(); ++i) {
                    if (string.charAt(i) != '.') continue;
                    ++n7;
                }
                if (n7 != 3) {
                    JOptionPane.showMessageDialog(this.myGUI.getMainFrame(), "Sorry, that isn't a valid IP address", "Error", 0);
                    return;
                }
                this.myConnection.sendData("/unadm " + string + "\n");
                break;
            }
            case 12: {
                this.myConnection.sendData("/kicklast\n");
                break;
            }
            case 13: {
                int n8;
                String string = JOptionPane.showInputDialog(this.myGUI.getMainFrame(), "Respawn time (seconds):", "Set respawn time", -1);
                if (string == null || string.length() <= 0) break;
                try {
                    n8 = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    JOptionPane.showMessageDialog(this.myGUI.getMainFrame(), "Sorry, that isn't a valid respawn time", "Error", 0);
                    return;
                }
                if (n8 < 1 || n8 > 30) {
                    JOptionPane.showMessageDialog(this.myGUI.getMainFrame(), "Sorry, respawn time must be between 1 and 30 seconds", "Error", 0);
                    return;
                }
                this.myConnection.sendData("/respawntime " + string + "\n");
                break;
            }
            case 14: {
                int n9;
                String string = JOptionPane.showInputDialog(this.myGUI.getMainFrame(), "Maximum respawn time (seconds):", "Set maximum respawn time", -1);
                if (string == null || string.length() <= 0) break;
                try {
                    n9 = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    JOptionPane.showMessageDialog(this.myGUI.getMainFrame(), "Sorry, that isn't a valid respawn time", "Error", 0);
                    return;
                }
                if (n9 < 1 || n9 > 30) {
                    JOptionPane.showMessageDialog(this.myGUI.getMainFrame(), "Sorry, respawn time must be between 1 and 30 seconds", "Error", 0);
                    return;
                }
                this.myConnection.sendData("/maxrespawntime " + string + "\n");
                break;
            }
            case 15: {
                int n10;
                String string = JOptionPane.showInputDialog(this.myGUI.getMainFrame(), "Kill/point/capture limit:", "Set kill/point/capture limit", -1);
                if (string == null || string.length() <= 0) break;
                try {
                    n10 = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    JOptionPane.showMessageDialog(this.myGUI.getMainFrame(), "Sorry, that isn't a valid limit", "Error", 0);
                    return;
                }
                if (n10 < 1 || n10 > 30) {
                    JOptionPane.showMessageDialog(this.myGUI.getMainFrame(), "Sorry, limit must be between 1 and 30", "Error", 0);
                    return;
                }
                this.myConnection.sendData("/limit " + string + "\n");
                break;
            }
            case 16: {
                int n11;
                String string = JOptionPane.showInputDialog(this.myGUI.getMainFrame(), "Time limit (minutes):", "Set time limit", -1);
                if (string == null || string.length() <= 0) break;
                try {
                    n11 = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    JOptionPane.showMessageDialog(this.myGUI.getMainFrame(), "Sorry, that isn't a valid time limit", "Error", 0);
                    return;
                }
                if (n11 < 1 || n11 > 30) {
                    JOptionPane.showMessageDialog(this.myGUI.getMainFrame(), "Sorry, time limit must be between 1 and 30 minutes", "Error", 0);
                    return;
                }
                this.myConnection.sendData("/timelimit " + string + "\n");
                break;
            }
            case 17: {
                int n12;
                String string = JOptionPane.showInputDialog(this.myGUI.getMainFrame(), "Player limit:", "Set player limit", -1);
                if (string == null || string.length() <= 0) break;
                try {
                    n12 = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    JOptionPane.showMessageDialog(this.myGUI.getMainFrame(), "Sorry, that isn't a valid limit", "Error", 0);
                    return;
                }
                if (n12 < 1 || n12 > 32) {
                    JOptionPane.showMessageDialog(this.myGUI.getMainFrame(), "Sorry, limit must be between 1 and 32", "Error", 0);
                    return;
                }
                this.myConnection.sendData("/maxplayers " + string + "\n");
                break;
            }
            case 18: {
                String string = JOptionPane.showInputDialog(this.myGUI.getMainFrame(), "New game password:", "Set game password", -1);
                if (string == null || string.length() <= 0) break;
                this.myConnection.sendData("/password " + string + "\n");
                break;
            }
            case 19: {
                String string = JOptionPane.showInputDialog(this.myGUI.getMainFrame(), "New admin password:", "Set admin password", -1);
                if (string == null || string.length() <= 0) break;
                this.myConnection.sendData("/adminpass " + string + "\n");
                break;
            }
            case 20: {
                Object[] objectArray = new String[]{"On", "Off"};
                int n13 = JOptionPane.showOptionDialog(this.myGUI.getMainFrame(), "Select friendly fire state", "Friendly fire", 0, -1, null, objectArray, "Off");
                if (n13 == -1) break;
                String string = n13 == 0 ? "/friendlyfire 1\n" : "/friendlyfire 0\n";
                this.myConnection.sendData(string);
                break;
            }
            case 21: {
                int n14;
                String string = JOptionPane.showInputDialog(this.myGUI.getMainFrame(), "Vote percentage:", "Set vote percentage", -1);
                if (string == null || string.length() <= 0) break;
                try {
                    n14 = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    JOptionPane.showMessageDialog(this.myGUI.getMainFrame(), "Sorry, that isn't a valid percentage", "Error", 0);
                    return;
                }
                if (n14 < 1 || n14 > 100) {
                    JOptionPane.showMessageDialog(this.myGUI.getMainFrame(), "Sorry, percentage must be between 1 and 100", "Error", 0);
                    return;
                }
                this.myConnection.sendData("/vote% " + string + "\n");
                break;
            }
        }
    }

    public void onRefresh() {
        this.myConnection.sendData("REFRESH\n");
    }

    public void onCommand(String string) {
        this.myConnection.sendData(string);
    }

    public void onKickPlayer(int n) {
        this.myConnection.sendData("/kick " + n + "\n");
    }

    public void onBanPlayer(int n) {
        this.myConnection.sendData("/ban " + n + "\n");
    }

    public void onAddAdmin(String string) {
        this.myConnection.sendData("/admip " + string + "\n");
    }

    public void onRemoveAdmin(String string) {
        this.myConnection.sendData("/unadm " + string + "\n");
    }

    public void onSetTeam(int n, int n2) {
        this.myConnection.sendData("/setteam" + n2 + " " + n + "\n");
    }

    public void onScriptButtonClick(String string, String string2) {
        try {
            String[] stringArray = new String[]{"Richard"};
            String[] stringArray2 = new String[]{"Davies"};
            InterpreterDriverManager.executeScriptFile(string2, stringArray, stringArray2);
        }
        catch (InterpreterDriver.InterpreterException interpreterException) {
            Sarj.printError("Exception while executing script '" + string2 + "' : " + interpreterException);
        }
    }

    public void onConnected() {
        this.myConnection.sendData(this.myGUI.getPasswordField() + "\n");
        this.myConnection.sendData("REFRESH\n");
        this.myGUI.connected();
        this.dispatchEventScript("onConnect", null, null);
    }

    public void onDisconnected() {
        this.dispatchEventScript("onDisconnect", null, null);
    }

    public void onError(String string) {
        this.myGUI.writeToConsole("Connection error: " + string + "\n");
    }

    public static String formatTime(int n) {
        if (n < 0) {
            return "00:00";
        }
        int n2 = n / 60;
        int n3 = n % 60;
        String string = n2 < 10 ? "0" + n2 + ":" : n2 + ":";
        string = n3 < 10 ? string + "0" + n3 : string + n3;
        return string;
    }

    private void checkTimedScripts(int n) {
        this.timePassed += (long)n;
        String[] stringArray = this.myGUI.checkTimedScripts(this.timePassed);
        if (stringArray == null) {
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                InterpreterDriverManager.executeScriptFile(stringArray[i], null, null);
                continue;
            }
            catch (InterpreterDriver.InterpreterException interpreterException) {
                Sarj.printError("Interpreter exception: " + interpreterException);
            }
        }
    }

    private void dispatchEventScript(String string, String[] stringArray, String[] stringArray2) {
        try {
            String string2 = this.myGUI.getFilenameForEvent(string);
            if (this.myGUI.isEventEnabled(string)) {
                InterpreterDriverManager.executeScriptFile(string2, stringArray, stringArray2);
            }
        }
        catch (EventNotFoundException eventNotFoundException) {
            Sarj.printError("Event not found exception: " + eventNotFoundException);
        }
        catch (InterpreterDriver.InterpreterException interpreterException) {
            Sarj.printError("Interpreter exception: " + interpreterException);
        }
    }

    public void dispatchScript(String string) {
        try {
            InterpreterDriverManager.executeScriptFile(string, null, null);
        }
        catch (InterpreterDriver.InterpreterException interpreterException) {
            Sarj.printError("Interpreter exception: " + interpreterException);
        }
    }

    public String getCurrentMap() {
        return this.mapName;
    }

    public String getGameType() {
        return this.gameType;
    }

    public int getTimeLimit() {
        return this.timeLimit;
    }

    public int getTimeLeft() {
        return this.timeLeft;
    }

    public int getScoreLimit() {
        return this.scoreLimit;
    }

    public int getNumPlayers() {
        return this.numPlayers;
    }

    public void setWindowTitle(String string) {
        this.myGUI.getMainFrame().setTitle(string);
    }

    public String getWindowTitle() {
        return this.myGUI.getMainFrame().getTitle();
    }

    public String getIPField() {
        return this.myGUI.getIPField();
    }

    public String getPortField() {
        return this.myGUI.getPortField();
    }

    public String getPasswordField() {
        return this.myGUI.getPasswordField();
    }

    public String getCommandBox() {
        return this.myGUI.getCommandBox();
    }

    public void setIPField(String string) {
        this.myGUI.setIPField(string);
    }

    public void setPortField(String string) {
        this.myGUI.setPortField(string);
    }

    public void setPasswordField(String string) {
        this.myGUI.setPasswordField(string);
    }

    public void setCommandBox(String string) {
        this.myGUI.setCommandBox(string);
    }

    public void clearConsole() {
        this.myGUI.clearConsole();
    }

    public void disconnectClient() {
        this.myConnection.disconnect();
        this.myGUI.disconnected();
    }

    public void connectClient(String string, int n) {
        try {
            this.myConnection.connect(string, n);
        }
        catch (Exception exception) {
            Sarj.printError("Exception: " + exception);
        }
    }

    public void connectClient() {
        try {
            this.myConnection.connect(this.getIPField(), new Integer(this.getPortField()));
        }
        catch (Exception exception) {
            Sarj.printError("Exception: " + exception);
        }
    }

    public void writeToConsole(String string) {
        this.myGUI.writeToConsole(string);
    }

    public void sendData(String string) {
        this.myConnection.sendData(string);
    }

    public String[] getPlayerData(String string) {
        Object[] objectArray = this.myGUI.getPlayerData(string);
        String[] stringArray = new String[objectArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = objectArray[i].toString();
        }
        return stringArray;
    }

    public String[][] getPlayerData() {
        Object[][] objectArray = this.myGUI.getPlayerData();
        if (objectArray.length > 0) {
            String[][] stringArray = new String[objectArray.length][objectArray[0].length];
            for (int i = 0; i < stringArray.length; ++i) {
                for (int j = 0; j < stringArray[0].length; ++j) {
                    stringArray[i][j] = objectArray[i][j].toString();
                }
            }
            return stringArray;
        }
        return new String[][]{new String[0]};
    }

    public String[] getTeamData(String string) {
        Object[] objectArray = this.myGUI.getTeamData(string);
        String[] stringArray = new String[objectArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = objectArray[i].toString();
        }
        return stringArray;
    }

    public String[][] getTeamData() {
        Object[][] objectArray = this.myGUI.getTeamData();
        if (objectArray.length > 0) {
            String[][] stringArray = new String[objectArray.length][objectArray[0].length];
            for (int i = 0; i < stringArray.length; ++i) {
                for (int j = 0; j < stringArray[0].length; ++j) {
                    stringArray[i][j] = objectArray[i][j].toString();
                }
            }
            return stringArray;
        }
        return new String[][]{new String[0]};
    }
}

