/*
 * Decompiled with CFR 0.152.
 */
package sarj;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.Timer;
import javax.swing.table.TableColumn;
import sarj.AboutDialog;
import sarj.ConfigDialog;
import sarj.EventNotFoundException;
import sarj.GUIListener;
import sarj.LogDialog;
import sarj.PlayerTableModel;
import sarj.Sarj;
import sarj.ScriptButton;
import sarj.ScriptButtonPanel;
import sarj.ScriptDialog;
import sarj.TeamTableModel;

public class GUI
extends WindowAdapter
implements ActionListener,
MouseListener,
KeyListener {
    public static final boolean STATE_CONNECTED = true;
    public static final boolean STATE_DISCONNECTED = false;
    static final String refreshImageLocation = "/images/refresh.gif";
    static final String performImageLocation = "/images/perform.gif";
    static final String connectImageLocation = "/images/connect.gif";
    static final String disconnectImageLocation = "/images/disconnect.gif";
    static final String exitImageLocation = "/images/exit.gif";
    static final String configImageLocation = "/images/config.gif";
    static final String logoImageLocation = "/images/key.gif";
    static final String scriptSettingsImageLocation = "/images/script.gif";
    static final String addSBImageLocation = "/images/addsb.gif";
    static final String aboutImageLocation = "/images/about.gif";
    private static LogDialog logDialog = new LogDialog();
    private JFrame mainFrame;
    private ConfigDialog configDialog;
    private ScriptDialog scriptDialog;
    private AboutDialog aboutDialog;
    private JPanel workspacePanel;
    private JPanel leftPanel;
    private JPanel rightPanel;
    private JPanel gameInfoPanel;
    private JPanel actionPanel;
    private JPanel refreshButtonPanel;
    private ScriptButtonPanel scriptButtonPanel;
    private JButton connectButton;
    private JButton exitButton;
    private JButton configButton;
    private JButton actionButton;
    private JButton refreshButton;
    private JButton aboutButton;
    private JButton addSBButton;
    private JButton scriptSettingsButton;
    private JTable playerTable;
    private JTable teamTable;
    private JTextArea consoleArea;
    private JComboBox commandBox;
    private JComboBox actionBox;
    private JTextField ipField;
    private JTextField portField;
    private JPasswordField passwordField;
    private JToolBar toolBar;
    private JToolBar scriptButtonBar;
    private JLabel mapLabel;
    private JLabel scoreLimitLabel;
    private JLabel gameModeLabel;
    private JLabel timeLimitLabel;
    private JLabel timeLeftLabel;
    private ImageIcon connectImage;
    private ImageIcon disconnectImage;
    private ImageIcon configImage;
    private ImageIcon exitImage;
    private ImageIcon scriptSettingsImage;
    private ImageIcon addSBImage;
    private ImageIcon aboutImage;
    private Timer refreshTimer;
    private JScrollPane textScroll;
    private JScrollPane scriptButtonScrollPane;
    private JPopupMenu consoleMenu;
    private JPopupMenu playerMenu;
    private JMenu adminSubMenu;
    private JMenu teamSubMenu;
    private JMenuItem consoleCutItem;
    private JMenuItem consoleCopyItem;
    private JMenuItem consolePasteItem;
    private JMenuItem consoleClearItem;
    private JMenuItem consoleSaveItem;
    private JMenuItem consoleSelectAllItem;
    private JMenuItem consoleShowLogItem;
    private JMenuItem playerKickItem;
    private JMenuItem playerBanItem;
    private JMenuItem playerAdminAddItem;
    private JMenuItem playerAdminRemoveItem;
    private JMenuItem playerTeamAlphaItem;
    private JMenuItem playerTeamBravoItem;
    private JMenuItem playerTeamCharlieItem;
    private JMenuItem playerTeamDeltaItem;
    private Object[] tableCurrentSelection;
    private ArrayList<ScriptButton> SBList;
    private boolean autoRefresh;
    private boolean connectionState;
    private int refreshDelay;
    private int refreshClock;
    private final String[] actionCommands = new String[]{"Shutdown server", "Send server message", "Add bot", "Kick player", "Ban player", "Ban IP", "Unban IP", "Change map", "Restart match", "Load next map", "Add remote admin", "Remove remote admin", "Kick last player", "Set respawn time", "Set max respawn time", "Set kill/point/cap limit", "Set time limit", "Set max players", "Set game password", "Set admin password", "Set friendly fire", "Set vote percentage"};
    private GUIListener listener;

    public GUI(String string, String string2, String string3, GUIListener gUIListener) {
        this.listener = gUIListener;
        this.mainFrame = new JFrame("SARJ 1.2.0 :: Disconnected");
        this.mainFrame.setDefaultCloseOperation(0);
        this.mainFrame.getContentPane().setLayout(new BorderLayout());
        this.mainFrame.addWindowListener(this);
        this.mainFrame.setFocusable(true);
        this.mainFrame.addKeyListener(this);
        this.configDialog = new ConfigDialog(this, "Configuration", string);
        this.scriptDialog = new ScriptDialog(this, "Script settings", string2);
        this.aboutDialog = new AboutDialog(this.mainFrame);
        this.workspacePanel = new JPanel();
        this.workspacePanel.setLayout(new BoxLayout(this.workspacePanel, 2));
        this.leftPanel = new JPanel();
        this.leftPanel.setLayout(new BoxLayout(this.leftPanel, 3));
        this.leftPanel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.rightPanel = new JPanel();
        this.rightPanel.setLayout(new BoxLayout(this.rightPanel, 3));
        this.rightPanel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.rightPanel.setPreferredSize(new Dimension(200, 420));
        this.rightPanel.setMinimumSize(new Dimension(200, 420));
        this.rightPanel.setMaximumSize(new Dimension(200, 420));
        this.refreshButtonPanel = new JPanel();
        this.refreshButtonPanel.setLayout(new BoxLayout(this.refreshButtonPanel, 2));
        this.refreshButtonPanel.setMaximumSize(new Dimension(100, 30));
        this.refreshButton = new JButton("Refresh", new ImageIcon(this.getClass().getResource(refreshImageLocation)));
        this.refreshButton.setToolTipText("Refresh the server status");
        this.refreshButtonPanel.add(this.refreshButton);
        this.refreshButton.addActionListener(this);
        this.refreshButton.setEnabled(false);
        this.gameInfoPanel = new JPanel();
        this.gameInfoPanel.setPreferredSize(new Dimension(200, 160));
        this.gameInfoPanel.setMaximumSize(new Dimension(200, 160));
        this.gameInfoPanel.setMinimumSize(new Dimension(200, 160));
        this.gameInfoPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Game information"), BorderFactory.createEmptyBorder(0, 20, 0, 20)));
        this.gameInfoPanel.setLayout(new BoxLayout(this.gameInfoPanel, 3));
        this.mapLabel = new JLabel("<html>Map: <font color = '#0000FF'><i>?</i></font></html>");
        this.timeLimitLabel = new JLabel("<html>Time limit: <font color = '#0000FF'><i>?</i></font></html>");
        this.timeLeftLabel = new JLabel("<html>Time left: <font color = '#0000FF'><i>?</i></font></html>");
        this.scoreLimitLabel = new JLabel("<html>Score limit: <font color = '#0000FF'><i>?</i></font></html>");
        this.gameModeLabel = new JLabel("<html>Game: <font color = '#0000FF'><i>?</i></font></html>");
        this.gameInfoPanel.add(this.mapLabel);
        this.gameInfoPanel.add(Box.createRigidArea(new Dimension(0, 10)));
        this.gameInfoPanel.add(this.timeLimitLabel);
        this.gameInfoPanel.add(Box.createRigidArea(new Dimension(0, 10)));
        this.gameInfoPanel.add(this.timeLeftLabel);
        this.gameInfoPanel.add(Box.createRigidArea(new Dimension(0, 10)));
        this.gameInfoPanel.add(this.gameModeLabel);
        this.gameInfoPanel.add(Box.createRigidArea(new Dimension(0, 10)));
        this.gameInfoPanel.add(this.scoreLimitLabel);
        this.gameInfoPanel.setAlignmentX(0.5f);
        this.actionPanel = new JPanel();
        this.actionPanel.setLayout(new BoxLayout(this.actionPanel, 3));
        this.actionPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Perform action"), BorderFactory.createEmptyBorder(10, 10, 10, 10)));
        this.actionBox = new JComboBox<String>(this.actionCommands);
        this.actionBox.setPreferredSize(new Dimension(180, 20));
        this.actionBox.setFont(new Font("Arial", 0, 12));
        this.actionBox.setMaximumSize(new Dimension(180, 20));
        this.actionBox.setEnabled(false);
        this.actionButton = new JButton("Perform...", new ImageIcon(this.getClass().getResource(performImageLocation)));
        this.actionButton.setToolTipText("Perform the selected action");
        this.actionButton.setAlignmentX(0.5f);
        this.actionButton.addActionListener(this);
        this.actionButton.setEnabled(false);
        this.actionPanel.add(this.actionBox);
        this.actionPanel.add(Box.createRigidArea(new Dimension(0, 10)));
        this.actionPanel.add(this.actionButton);
        this.toolBar = new JToolBar();
        this.toolBar.setLayout(new FlowLayout(0, 10, 0));
        this.connectImage = new ImageIcon(this.getClass().getResource(connectImageLocation));
        this.disconnectImage = new ImageIcon(this.getClass().getResource(disconnectImageLocation));
        this.connectButton = new JButton(this.connectImage);
        this.connectButton.setToolTipText("Connect to the server");
        this.connectButton.addActionListener(this);
        this.exitImage = new ImageIcon(this.getClass().getResource(exitImageLocation));
        this.exitButton = new JButton(this.exitImage);
        this.exitButton.setToolTipText("Exit");
        this.exitButton.addActionListener(this);
        this.configImage = new ImageIcon(this.getClass().getResource(configImageLocation));
        this.configButton = new JButton(this.configImage);
        this.configButton.setToolTipText("Configuration");
        this.configButton.addActionListener(this);
        this.ipField = new JTextField();
        this.ipField.setToolTipText("IP address of the server");
        this.ipField.setFont(new Font("Lucida Console", 0, 12));
        this.ipField.setPreferredSize(new Dimension(120, 20));
        this.ipField.addKeyListener(this);
        this.portField = new JTextField();
        this.portField.setToolTipText("Server port");
        this.portField.setFont(new Font("Lucida Console", 0, 12));
        this.portField.setPreferredSize(new Dimension(50, 20));
        this.portField.addKeyListener(this);
        this.passwordField = new JPasswordField();
        this.passwordField.setToolTipText("Server password");
        this.passwordField.setFont(new Font("Lucida Console", 0, 12));
        this.passwordField.setPreferredSize(new Dimension(100, 20));
        this.passwordField.addKeyListener(this);
        this.aboutImage = new ImageIcon(this.getClass().getResource(aboutImageLocation));
        this.aboutButton = new JButton(this.aboutImage);
        this.aboutButton.setToolTipText("About SARJ");
        this.aboutButton.addActionListener(this);
        this.toolBar.add(this.connectButton);
        this.toolBar.add(this.configButton);
        this.toolBar.add(this.exitButton);
        this.toolBar.add(new JLabel("IP:"));
        this.toolBar.add(this.ipField);
        this.toolBar.add(new JLabel("Port:"));
        this.toolBar.add(this.portField);
        this.toolBar.add(new JLabel("Password:"));
        this.toolBar.add(this.passwordField);
        this.toolBar.addSeparator();
        this.toolBar.add(this.aboutButton);
        this.toolBar.setMinimumSize(new Dimension(620, 20));
        this.scriptButtonBar = new JToolBar();
        this.scriptButtonBar.setBorderPainted(true);
        this.addSBImage = new ImageIcon(this.getClass().getResource(addSBImageLocation));
        this.addSBButton = new JButton("Add script button", this.addSBImage);
        this.addSBButton.setToolTipText("Click to add a new ScriptButton");
        this.addSBButton.addActionListener(this);
        this.scriptSettingsImage = new ImageIcon(this.getClass().getResource(scriptSettingsImageLocation));
        this.scriptSettingsButton = new JButton("Script settings", this.scriptSettingsImage);
        this.scriptSettingsButton.setToolTipText("View scripting settings");
        this.scriptSettingsButton.addActionListener(this);
        this.scriptButtonBar.add(this.scriptSettingsButton);
        this.scriptButtonBar.add(this.addSBButton);
        this.scriptButtonBar.addSeparator();
        this.scriptButtonPanel = new ScriptButtonPanel(this.mainFrame, string3, gUIListener);
        this.scriptButtonScrollPane = new JScrollPane(this.scriptButtonPanel, 21, 32);
        this.scriptButtonBar.add(this.scriptButtonScrollPane);
        ScriptButton[] scriptButtonArray = this.getScriptButtons();
        for (int i = 0; i < scriptButtonArray.length; ++i) {
            this.scriptButtonPanel.add(scriptButtonArray[i]);
        }
        this.scriptButtonScrollPane.setPreferredSize(new Dimension(410, 55));
        this.playerTable = new JTable(new PlayerTableModel());
        this.playerTable.setToolTipText("Player details");
        this.playerTable.setPreferredScrollableViewportSize(new Dimension(460, this.playerTable.getRowHeight() * 4));
        this.playerTable.setAutoResizeMode(0);
        this.playerTable.setForeground(Color.BLUE);
        this.playerTable.addMouseListener(this);
        this.playerTable.addKeyListener(this);
        block18: for (int i = 0; i < 8; ++i) {
            TableColumn tableColumn = this.playerTable.getColumnModel().getColumn(i);
            switch (i) {
                case 0: {
                    tableColumn.setPreferredWidth(140);
                    continue block18;
                }
                case 1: {
                    tableColumn.setPreferredWidth(40);
                    continue block18;
                }
                case 2: {
                    tableColumn.setPreferredWidth(45);
                    continue block18;
                }
                case 3: {
                    tableColumn.setPreferredWidth(35);
                    continue block18;
                }
                case 4: {
                    tableColumn.setPreferredWidth(35);
                    continue block18;
                }
                case 5: {
                    tableColumn.setPreferredWidth(45);
                    continue block18;
                }
                case 6: {
                    tableColumn.setPreferredWidth(100);
                    continue block18;
                }
                case 7: {
                    tableColumn.setPreferredWidth(20);
                    continue block18;
                }
            }
        }
        JScrollPane jScrollPane = new JScrollPane(this.playerTable);
        this.leftPanel.add(jScrollPane);
        this.leftPanel.add(Box.createRigidArea(new Dimension(0, 10)));
        this.teamTable = new JTable(new TeamTableModel());
        this.teamTable.setToolTipText("Team details");
        this.teamTable.setPreferredScrollableViewportSize(new Dimension(200, this.teamTable.getRowHeight() * 4));
        this.teamTable.setAutoResizeMode(0);
        this.teamTable.setForeground(Color.BLUE);
        this.teamTable.addMouseListener(this);
        block19: for (int i = 0; i < 5; ++i) {
            TableColumn tableColumn = this.teamTable.getColumnModel().getColumn(i);
            switch (i) {
                case 0: {
                    tableColumn.setPreferredWidth(45);
                    continue block19;
                }
                case 1: {
                    tableColumn.setPreferredWidth(38);
                    continue block19;
                }
                case 2: {
                    tableColumn.setPreferredWidth(30);
                    continue block19;
                }
                case 3: {
                    tableColumn.setPreferredWidth(45);
                    continue block19;
                }
                case 4: {
                    tableColumn.setPreferredWidth(35);
                    continue block19;
                }
            }
        }
        JScrollPane jScrollPane2 = new JScrollPane(this.teamTable);
        jScrollPane2.setMaximumSize(new Dimension(Short.MAX_VALUE, 84));
        this.consoleArea = new JTextArea(8, 6);
        this.consoleArea.setFont(new Font("Lucida console", 0, 12));
        this.consoleArea.setForeground(Color.BLUE);
        this.consoleArea.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.consoleArea.addMouseListener(this);
        this.consoleArea.addKeyListener(this);
        this.textScroll = new JScrollPane(this.consoleArea);
        this.textScroll.setPreferredSize(new Dimension(400, 100));
        this.leftPanel.add(this.textScroll);
        this.commandBox = new JComboBox();
        this.commandBox.setEditable(true);
        this.commandBox.setMaximumSize(new Dimension(Short.MAX_VALUE, 20));
        this.commandBox.setFont(new Font("Lucida console", 0, 12));
        this.commandBox.addActionListener(this);
        this.commandBox.addKeyListener(this);
        this.commandBox.setEnabled(false);
        this.leftPanel.add(this.commandBox);
        this.consoleMenu = new JPopupMenu("Console menu");
        this.consoleCutItem = new JMenuItem("Cut");
        this.consoleCutItem.addActionListener(this);
        this.consoleCopyItem = new JMenuItem("Copy");
        this.consoleCopyItem.addActionListener(this);
        this.consolePasteItem = new JMenuItem("Paste");
        this.consolePasteItem.addActionListener(this);
        this.consoleClearItem = new JMenuItem("Clear");
        this.consoleClearItem.addActionListener(this);
        this.consoleSaveItem = new JMenuItem("Save to File...");
        this.consoleSaveItem.addActionListener(this);
        this.consoleSelectAllItem = new JMenuItem("Select All");
        this.consoleSelectAllItem.addActionListener(this);
        this.consoleShowLogItem = new JMenuItem("Show/hide log console");
        this.consoleShowLogItem.addActionListener(this);
        this.consoleMenu.add(this.consoleCutItem);
        this.consoleMenu.add(this.consoleCopyItem);
        this.consoleMenu.add(this.consolePasteItem);
        this.consoleMenu.addSeparator();
        this.consoleMenu.add(this.consoleClearItem);
        this.consoleMenu.add(this.consoleSaveItem);
        this.consoleMenu.addSeparator();
        this.consoleMenu.add(this.consoleSelectAllItem);
        this.consoleMenu.add(this.consoleShowLogItem);
        this.playerMenu = new JPopupMenu("Player menu");
        this.adminSubMenu = new JMenu("Remote Admin");
        this.teamSubMenu = new JMenu("Set Team");
        this.playerKickItem = new JMenuItem("Kick");
        this.playerKickItem.addActionListener(this);
        this.playerBanItem = new JMenuItem("Ban");
        this.playerBanItem.addActionListener(this);
        this.playerAdminAddItem = new JMenuItem("Add");
        this.playerAdminAddItem.addActionListener(this);
        this.playerAdminRemoveItem = new JMenuItem("Remove");
        this.playerAdminRemoveItem.addActionListener(this);
        this.playerTeamAlphaItem = new JMenuItem("Alpha");
        this.playerTeamAlphaItem.addActionListener(this);
        this.playerTeamBravoItem = new JMenuItem("Bravo");
        this.playerTeamBravoItem.addActionListener(this);
        this.playerTeamCharlieItem = new JMenuItem("Charlie");
        this.playerTeamCharlieItem.addActionListener(this);
        this.playerTeamDeltaItem = new JMenuItem("Delta");
        this.playerTeamDeltaItem.addActionListener(this);
        this.adminSubMenu.add(this.playerAdminAddItem);
        this.adminSubMenu.add(this.playerAdminRemoveItem);
        this.teamSubMenu.add(this.playerTeamAlphaItem);
        this.teamSubMenu.add(this.playerTeamBravoItem);
        this.teamSubMenu.add(this.playerTeamCharlieItem);
        this.teamSubMenu.add(this.playerTeamDeltaItem);
        this.playerMenu.add(this.playerKickItem);
        this.playerMenu.add(this.playerBanItem);
        this.playerMenu.add(this.adminSubMenu);
        this.playerMenu.add(this.teamSubMenu);
        this.rightPanel.add(this.refreshButtonPanel);
        this.rightPanel.add(Box.createRigidArea(new Dimension(0, 10)));
        this.rightPanel.add(jScrollPane2);
        this.rightPanel.add(this.gameInfoPanel);
        this.rightPanel.add(this.actionPanel);
        this.workspacePanel.add(this.leftPanel);
        this.workspacePanel.add(this.rightPanel);
        this.mainFrame.getContentPane().add((Component)this.toolBar, "First");
        this.mainFrame.getContentPane().add((Component)this.scriptButtonBar, "Last");
        this.mainFrame.getContentPane().add((Component)this.workspacePanel, "Center");
        this.mainFrame.getRootPane().setDefaultButton(this.connectButton);
        this.mainFrame.setIconImage(new ImageIcon(this.getClass().getResource(logoImageLocation)).getImage());
        this.configDialog.loadSettings();
        this.scriptDialog.loadSettings();
        this.connectionState = false;
        this.mainFrame.pack();
        this.mainFrame.setLocationRelativeTo(null);
    }

    public void show() {
        this.mainFrame.setVisible(true);
    }

    public void hide() {
        this.mainFrame.setVisible(false);
        this.stopRefreshTimer();
    }

    public static void printError(String string) {
        logDialog.printError(string);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.connectButton) {
            if (!this.connectionState) {
                int n;
                String string = this.getIPField();
                String string2 = this.getPasswordField();
                try {
                    n = Integer.parseInt(this.getPortField());
                }
                catch (NumberFormatException numberFormatException) {
                    JOptionPane.showMessageDialog(this.mainFrame, "Invalid port specified", "Error", 0);
                    return;
                }
                int n2 = 0;
                for (int i = 0; i < string.length(); ++i) {
                    if (string.charAt(i) != '.') continue;
                    ++n2;
                }
                if (n2 != 3) {
                    JOptionPane.showMessageDialog(this.mainFrame, "Invalid host IP specified", "Error", 0);
                    return;
                }
                if (n < 1 || n > 65535) {
                    JOptionPane.showMessageDialog(this.mainFrame, "Invalid port specified", "Error", 0);
                    return;
                }
                if (string2.length() < 1) {
                    JOptionPane.showMessageDialog(this.mainFrame, "Please specify a password", "Error", 0);
                    return;
                }
                this.listener.onConnect(string, n, string2);
            } else {
                this.listener.onDisconnect();
            }
        } else if (object == this.configButton) {
            if (!this.configDialog.isVisible()) {
                this.configDialog.setVisible(true);
            }
        } else if (object == this.exitButton) {
            this.listener.onExit();
        } else if (object == this.actionButton) {
            this.listener.onAction(this.actionBox.getSelectedIndex());
        } else if (object == this.commandBox) {
            if ("comboBoxEdited".equals(actionEvent.getActionCommand())) {
                String string = (String)this.commandBox.getSelectedItem() + "\n";
                this.commandBox.insertItemAt(string, 0);
                this.commandBox.setSelectedItem("");
                this.listener.onCommand(string);
            }
        } else if (object == this.refreshButton) {
            this.listener.onRefresh();
        } else if (object == this.refreshTimer) {
            if (!this.timeLeftLabel.getText().contains("?")) {
                try {
                    int n = Integer.parseInt(this.timeLeftLabel.getText().substring(44, 46));
                    int n3 = Integer.parseInt(this.timeLeftLabel.getText().substring(47, 49));
                    int n4 = n * 60 + n3;
                    this.setTimeLeft("<html>Time left: <font color = '#0000FF'><b>" + Sarj.formatTime(--n4) + "</b></font></html>");
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (this.autoRefresh) {
                ++this.refreshClock;
                if (this.refreshClock >= this.refreshDelay) {
                    this.refreshClock = 0;
                    this.listener.onRefresh();
                }
            }
        } else if (object == this.consoleCutItem) {
            this.consoleArea.cut();
        } else if (object == this.consoleCopyItem) {
            this.consoleArea.copy();
        } else if (object == this.consolePasteItem) {
            this.consoleArea.paste();
        } else if (object == this.consoleClearItem) {
            this.consoleArea.setText("");
        } else if (object == this.consoleSaveItem) {
            FileDialog fileDialog = new FileDialog((Frame)this.mainFrame, "Save console to file", 1);
            fileDialog.setVisible(true);
            String string = fileDialog.getDirectory();
            String string3 = fileDialog.getFile();
            if (string != null && string3 != null) {
                String string4 = string + string3;
                try {
                    BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(new File(string4)));
                    bufferedWriter.write(this.consoleArea.getText());
                    bufferedWriter.close();
                }
                catch (IOException iOException) {
                    JOptionPane.showMessageDialog(this.mainFrame, "Failed to save to '" + string3 + "'", "Error", 0);
                }
            }
        } else if (object == this.consoleSelectAllItem) {
            this.consoleArea.selectAll();
        } else if (object == this.consoleShowLogItem) {
            logDialog.setVisible(!logDialog.isVisible());
        } else if (object == this.playerKickItem) {
            Integer n = (Integer)this.tableCurrentSelection[7];
            this.listener.onKickPlayer(n);
        } else if (object == this.playerBanItem) {
            Integer n = (Integer)this.tableCurrentSelection[7];
            this.listener.onBanPlayer(n);
        } else if (object == this.playerAdminAddItem) {
            String string = (String)this.tableCurrentSelection[6];
            this.listener.onAddAdmin(string);
        } else if (object == this.playerAdminRemoveItem) {
            String string = (String)this.tableCurrentSelection[6];
            this.listener.onRemoveAdmin(string);
        } else if (object == this.playerTeamAlphaItem) {
            int n = (Integer)this.tableCurrentSelection[7];
            this.listener.onSetTeam(n, 1);
        } else if (object == this.playerTeamBravoItem) {
            int n = (Integer)this.tableCurrentSelection[7];
            this.listener.onSetTeam(n, 2);
        } else if (object == this.playerTeamCharlieItem) {
            int n = (Integer)this.tableCurrentSelection[7];
            this.listener.onSetTeam(n, 3);
        } else if (object == this.playerTeamDeltaItem) {
            int n = (Integer)this.tableCurrentSelection[7];
            this.listener.onSetTeam(n, 4);
        } else if (object == this.scriptSettingsButton) {
            this.scriptDialog.setVisible(true);
        } else if (object == this.addSBButton) {
            this.scriptButtonPanel.addNewButton();
        } else if (object == this.aboutButton) {
            this.aboutDialog.setVisible(true);
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 83 && keyEvent.isAltDown()) {
            logDialog.setVisible(!logDialog.isVisible());
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    private void maybeShowPopup(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            int n;
            if (mouseEvent.getSource() == this.consoleArea) {
                if (this.consoleArea.getSelectedText() == null) {
                    this.consoleCutItem.setEnabled(false);
                    this.consoleCopyItem.setEnabled(false);
                } else {
                    this.consoleCutItem.setEnabled(true);
                    this.consoleCopyItem.setEnabled(true);
                }
                this.consoleMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            } else if (mouseEvent.getSource() == this.playerTable && (n = this.playerTable.rowAtPoint(mouseEvent.getPoint())) != -1) {
                this.playerTable.changeSelection(n, 0, false, false);
                this.tableCurrentSelection = ((PlayerTableModel)this.playerTable.getModel()).getRow(n);
                this.teamSubMenu.setEnabled(true);
                this.playerTeamAlphaItem.setEnabled(true);
                this.playerTeamBravoItem.setEnabled(true);
                this.playerTeamCharlieItem.setEnabled(true);
                this.playerTeamDeltaItem.setEnabled(true);
                String string = (String)this.tableCurrentSelection[5];
                if (string.contains("Alpha")) {
                    this.playerTeamAlphaItem.setEnabled(false);
                } else if (string.contains("Bravo")) {
                    this.playerTeamBravoItem.setEnabled(false);
                } else if (string.contains("Charlie")) {
                    this.playerTeamCharlieItem.setEnabled(false);
                } else if (string.contains("Delta")) {
                    this.playerTeamDeltaItem.setEnabled(false);
                } else if (string.contains("Spectator")) {
                    this.teamSubMenu.setEnabled(false);
                }
                this.playerMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }

    public void setRefreshDelay(int n) {
        this.refreshDelay = n;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.maybeShowPopup(mouseEvent);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.maybeShowPopup(mouseEvent);
    }

    public void setTitle(String string) {
        if (string != null) {
            this.mainFrame.setTitle(string);
        } else {
            this.mainFrame.setTitle("<null>");
        }
    }

    public void setIPField(String string) {
        if (string != null) {
            this.ipField.setText(string);
        } else {
            this.ipField.setText("<null>");
        }
    }

    public void setPortField(String string) {
        if (string != null) {
            this.portField.setText(string);
        } else {
            this.portField.setText("<null>");
        }
    }

    public void setPasswordField(String string) {
        if (string != null) {
            this.passwordField.setText(string);
        }
    }

    public void setCommandBox(String string) {
        if (string != null) {
            this.commandBox.setSelectedItem(string);
        }
    }

    public String getCommandBox() {
        return (String)this.commandBox.getSelectedItem();
    }

    public void setAutoRefresh(boolean bl) {
        this.autoRefresh = bl;
    }

    public void setMapName(String string) {
        this.mapLabel.setText(string);
    }

    public void setGameType(String string) {
        this.gameModeLabel.setText(string);
    }

    public void setScoreLimit(String string) {
        this.scoreLimitLabel.setText(string);
    }

    public void setTimeLimit(String string) {
        this.timeLimitLabel.setText(string);
    }

    public void setTimeLeft(String string) {
        this.timeLeftLabel.setText(string);
    }

    public void clearConsole() {
        this.consoleArea.setText("");
    }

    public void clearPlayerTable() {
        PlayerTableModel playerTableModel = (PlayerTableModel)this.playerTable.getModel();
        playerTableModel.clear();
    }

    public void clearTeamTable() {
        TeamTableModel teamTableModel = (TeamTableModel)this.teamTable.getModel();
        teamTableModel.clear();
    }

    public synchronized void addPlayer(String string, int n, int n2, String string2, int n3, int n4, String string3, int n5) {
        PlayerTableModel playerTableModel = (PlayerTableModel)this.playerTable.getModel();
        playerTableModel.addPlayer(string, n, n2, string2, n3, n4, string3, n5);
    }

    public void addTeam(String string, int n, int n2, int n3, int n4) {
        TeamTableModel teamTableModel = (TeamTableModel)this.teamTable.getModel();
        teamTableModel.addTeam(string, n, n2, n3, n4);
    }

    public JFrame getMainFrame() {
        return this.mainFrame;
    }

    public String getIPField() {
        return this.ipField.getText();
    }

    public String getPortField() {
        return this.portField.getText();
    }

    public String getPasswordField() {
        return new String(this.passwordField.getPassword());
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.configDialog.saveSettings();
        this.listener.onExit();
    }

    public void writeToConsole(String string) {
        this.consoleArea.append(string);
        this.consoleArea.setCaretPosition(this.consoleArea.getDocument().getLength());
    }

    public void startRefreshTimer(int n) {
        this.refreshTimer = new Timer(n, this);
        this.refreshTimer.setDelay(n);
        this.refreshTimer.start();
    }

    public void stopRefreshTimer() {
        if (this.refreshTimer != null) {
            this.refreshTimer.stop();
        }
        this.refreshTimer = null;
    }

    public void connected() {
        this.actionBox.setEnabled(true);
        this.actionButton.setEnabled(true);
        this.commandBox.setEnabled(true);
        this.refreshButton.setEnabled(true);
        this.connectButton.setIcon(this.disconnectImage);
        this.connectButton.setToolTipText("Disconnect from the server");
        this.mainFrame.setTitle("SARJ 1.2.0 :: Connected");
        this.ipField.setEnabled(false);
        this.portField.setEnabled(false);
        this.passwordField.setEnabled(false);
        this.startRefreshTimer(1000);
        this.connectionState = true;
    }

    public void disconnected() {
        this.writeToConsole("Connection closed\n");
        this.actionBox.setEnabled(false);
        this.actionButton.setEnabled(false);
        this.commandBox.setEnabled(false);
        this.refreshButton.setEnabled(false);
        this.connectButton.setIcon(this.connectImage);
        this.connectButton.setToolTipText("Connect to the server");
        this.ipField.setEnabled(true);
        this.portField.setEnabled(true);
        this.passwordField.setEnabled(true);
        this.mainFrame.setTitle("SARJ 1.2.0 :: Disconnected");
        this.stopRefreshTimer();
        this.connectionState = false;
    }

    public void addScriptButton(String string, String string2) {
        this.scriptButtonPanel.addScriptButton(string, string2);
    }

    public void removeScriptButton(String string) {
        this.scriptButtonPanel.removeScriptButton(string);
    }

    public ScriptButton[] getScriptButtons() {
        return this.scriptButtonPanel.getScriptButtons();
    }

    public String getFilenameForEvent(String string) throws EventNotFoundException {
        return this.scriptDialog.getFilenameForEvent(string);
    }

    public boolean isEventEnabled(String string) throws EventNotFoundException {
        return this.scriptDialog.isEventEnabled(string);
    }

    public Object[] getPlayerData(String string) {
        PlayerTableModel playerTableModel = (PlayerTableModel)this.playerTable.getModel();
        int n = playerTableModel.getRowCount();
        for (int i = 0; i < n; ++i) {
            Object[] objectArray = playerTableModel.getRow(i);
            if (!((String)objectArray[0]).equals(string)) continue;
            return objectArray;
        }
        return new Object[0];
    }

    public Object[][] getPlayerData() {
        PlayerTableModel playerTableModel = (PlayerTableModel)this.playerTable.getModel();
        return playerTableModel.getData();
    }

    public Object[] getTeamData(String string) {
        TeamTableModel teamTableModel = (TeamTableModel)this.teamTable.getModel();
        int n = teamTableModel.getRowCount();
        for (int i = 0; i < n; ++i) {
            Object[] objectArray = teamTableModel.getRow(i);
            if (!((String)objectArray[0]).equals(string)) continue;
            return objectArray;
        }
        return new Object[0];
    }

    public Object[][] getTeamData() {
        TeamTableModel teamTableModel = (TeamTableModel)this.teamTable.getModel();
        return teamTableModel.getData();
    }

    public String[] checkTimedScripts(long l) {
        if (this.scriptDialog.isVisible()) {
            return null;
        }
        Object[][] objectArray = this.scriptDialog.getTimedScriptDetails();
        ArrayList<String> arrayList = new ArrayList<String>();
        if (objectArray == (Object[][])null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        long l2 = calendar.get(11) * 3600000 + calendar.get(12) * 60000 + calendar.get(13) * 1000 + calendar.get(14);
        for (int i = 0; i < objectArray.length; ++i) {
            String string = (String)objectArray[i][0];
            String string2 = (String)objectArray[i][1];
            boolean bl = (Boolean)objectArray[i][2];
            int n = (Integer)objectArray[i][3] * 1000;
            int n2 = (Integer)objectArray[i][4] * 60000;
            if (!bl) continue;
            if ("Time".equals(string2)) {
                long l3 = l2 - (long)n2;
                if (l3 < 0L || l3 >= 1000L) continue;
                arrayList.add(string);
                continue;
            }
            if ("Interval".equals(string2)) {
                if (n <= 0 || l % (long)n >= 1000L) continue;
                arrayList.add(string);
                continue;
            }
            Sarj.printError("Unknown timed script type: " + string2);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }
}

