/*
 * Decompiled with CFR 0.152.
 */
package sarj;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import sarj.ScriptButton;
import sarj.ScriptButtonPanel;

public class EditScriptDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 5947847346149275958L;
    public static final String EXTENSION_js = "js";
    public static final String EXTENSION_es = "es";
    ScriptButton button = null;
    ScriptButtonPanel owner;
    JButton okButton;
    JButton cancelButton;
    JButton scriptChooseButton;
    JTextField nameField;
    JTextField filenameField;

    public EditScriptDialog(JFrame jFrame, String string, ScriptButtonPanel scriptButtonPanel) {
        super(jFrame, string, true);
        this.setTitle(string);
        this.owner = scriptButtonPanel;
        this.okButton = new JButton("Ok");
        this.okButton.setToolTipText("Click to accept settings");
        this.okButton.addActionListener(this);
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.setToolTipText("Click to cancel any changes made");
        this.cancelButton.addActionListener(this);
        this.scriptChooseButton = new JButton("...");
        this.scriptChooseButton.setToolTipText("Click to select a script file for this button");
        this.scriptChooseButton.setPreferredSize(new Dimension(25, 20));
        this.scriptChooseButton.addActionListener(this);
        this.nameField = new JTextField(10);
        this.nameField.setToolTipText("The name of the button");
        this.nameField.setMaximumSize(new Dimension(240, 20));
        this.nameField.addActionListener(this);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 2));
        jPanel.setAlignmentX(0.0f);
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel.add(new JLabel("Name: "));
        jPanel.add(this.nameField);
        this.filenameField = new JTextField(20);
        this.filenameField.setToolTipText("The script file that will be executed when the script button is clicked");
        this.filenameField.setMaximumSize(new Dimension(Integer.MAX_VALUE, 20));
        this.filenameField.addActionListener(this);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 2));
        jPanel2.setAlignmentX(0.0f);
        jPanel2.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel2.add(new JLabel("Filename: "));
        jPanel2.add(this.filenameField);
        jPanel2.add(Box.createHorizontalStrut(10));
        jPanel2.add(this.scriptChooseButton);
        JPanel jPanel3 = new JPanel();
        jPanel3.add(this.okButton);
        jPanel3.add(this.cancelButton);
        this.setLayout(new BorderLayout());
        this.add((Component)jPanel, "North");
        this.add((Component)jPanel2, "Center");
        this.add((Component)jPanel3, "South");
        this.setLocationRelativeTo(jFrame);
        this.setResizable(false);
        this.pack();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.okButton) {
            this.updateAssociatedButton();
            this.owner.saveSettings();
            this.setVisible(false);
        } else if (object == this.cancelButton) {
            this.setVisible(false);
        } else if (object == this.scriptChooseButton) {
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setFileFilter(new FileFilter(){

                public boolean accept(File file) {
                    if (file.isDirectory()) {
                        return true;
                    }
                    String string = EditScriptDialog.this.getExtension(file);
                    if (string != null) {
                        return string.equals(EditScriptDialog.EXTENSION_js) || string.equals(EditScriptDialog.EXTENSION_es);
                    }
                    return false;
                }

                public String getDescription() {
                    return "JavaScript / EcmaScript files";
                }
            });
            int n = jFileChooser.showOpenDialog(this);
            if (n == 0) {
                File file = jFileChooser.getSelectedFile();
                this.filenameField.setText(file.getAbsolutePath());
            }
        }
    }

    public void associateWith(ScriptButton scriptButton) {
        this.button = scriptButton;
        if (scriptButton != null) {
            this.nameField.setText(scriptButton.getName());
            this.filenameField.setText(scriptButton.getScriptFile());
        }
    }

    private void updateAssociatedButton() {
        if (this.button != null) {
            this.button.setName(this.nameField.getText());
            this.button.setScriptFile(this.filenameField.getText());
        }
    }

    private String getExtension(File file) {
        String string = null;
        String string2 = file.getName();
        int n = string2.lastIndexOf(46);
        if (n > 0 && n < string2.length() - 1) {
            string = string2.substring(n + 1).toLowerCase();
        }
        return string;
    }
}

