/*
 * Decompiled with CFR 0.152.
 */
package sarj;

import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.net.UnknownHostException;
import sarj.ConnectionListener;
import sarj.Sarj;

public class Connection {
    private Socket socket;
    private ConnectionListener listener;
    private InputStream inputStream;

    public Connection(ConnectionListener connectionListener) {
        this.listener = connectionListener;
        this.socket = null;
    }

    public void connect(String string, int n) throws UnknownHostException, IOException {
        this.socket = new Socket(string, n);
        this.inputStream = this.socket.getInputStream();
        this.listener.onConnected();
    }

    public void disconnect() {
        if (this.socket != null && !this.socket.isClosed()) {
            try {
                this.socket.close();
                this.listener.onDisconnected();
            }
            catch (IOException iOException) {
                this.listener.onError("IO Exception while disconnecting");
            }
        }
    }

    public void sendData(String string) {
        if (this.socket != null && this.socket.isConnected() && string != null && string.trim().length() > 0) {
            try {
                this.socket.getOutputStream().write(string.getBytes());
            }
            catch (IOException iOException) {
                if (!this.socket.isClosed()) {
                    this.disconnect();
                    this.listener.onError("IO Exception while sending data");
                }
            }
        } else {
            Sarj.printError("Couldn't send: '" + string + "'");
        }
    }

    public boolean isClosed() {
        if (this.socket != null) {
            return this.socket.isClosed();
        }
        return true;
    }

    public boolean isConnected() {
        if (this.socket != null) {
            return this.socket.isConnected();
        }
        return false;
    }

    public int read() throws IOException {
        if (this.inputStream == null) {
            this.inputStream = this.socket.getInputStream();
        }
        return this.inputStream.read();
    }

    public String readString() throws IOException {
        if (this.inputStream == null) {
            this.inputStream = this.socket.getInputStream();
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n != 10 && n != -1) {
            n = this.inputStream.read();
            if (n == -1) {
                throw new IOException();
            }
            stringBuffer.append((char)n);
        }
        return stringBuffer.toString();
    }

    public void skip(int n) throws IOException {
        if (this.inputStream == null) {
            this.inputStream = this.socket.getInputStream();
        }
        this.inputStream.skip(n);
    }
}

