/*
 * Decompiled with CFR 0.152.
 */
package sarj;

import java.awt.Dimension;
import java.awt.ItemSelectable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import sarj.GUI;
import sarj.Sarj;

public class ConfigDialog
extends JDialog
implements ActionListener,
ItemListener {
    private String configFile;
    private JPanel refreshPanel;
    private JPanel refreshTimePanel;
    private JPanel buttonPanel;
    private JPanel lookAndFeelPanel;
    private JCheckBox autoRefreshBox;
    private JCheckBox javaUIBox;
    private JTextField refreshTimeField;
    private JButton okButton;
    private GUI owner;
    private JLabel preRefreshLabel;
    private JLabel postRefreshLabel;
    private JLabel noteLabel;
    private static boolean javaUI;
    private static final long serialVersionUID = 5947847346149275958L;

    public ConfigDialog(GUI gUI, String string, String string2) {
        super(gUI.getMainFrame(), string, true);
        this.configFile = string2;
        this.owner = gUI;
        this.setLocationRelativeTo(null);
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 3));
        this.refreshPanel = new JPanel();
        this.refreshPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), BorderFactory.createTitledBorder("Refresh options")));
        this.refreshPanel.setLayout(new BoxLayout(this.refreshPanel, 3));
        this.autoRefreshBox = new JCheckBox("Automatically refresh server status");
        this.autoRefreshBox.setAlignmentX(0.5f);
        this.autoRefreshBox.addItemListener(this);
        this.refreshPanel.add(this.autoRefreshBox);
        this.refreshTimePanel = new JPanel();
        this.refreshTimePanel.setLayout(new BoxLayout(this.refreshTimePanel, 2));
        this.preRefreshLabel = new JLabel("Refresh delay:");
        this.refreshTimePanel.add(this.preRefreshLabel);
        this.refreshTimePanel.add(Box.createRigidArea(new Dimension(10, 0)));
        this.refreshTimeField = new JTextField(3);
        this.refreshTimeField.setPreferredSize(new Dimension(30, 20));
        this.refreshTimeField.setMinimumSize(new Dimension(30, 20));
        this.refreshTimeField.setMaximumSize(new Dimension(30, 20));
        this.refreshTimePanel.add(this.refreshTimeField);
        this.refreshTimePanel.add(Box.createRigidArea(new Dimension(10, 0)));
        this.postRefreshLabel = new JLabel("seconds");
        this.refreshTimePanel.add(this.postRefreshLabel);
        this.refreshPanel.add(this.refreshTimePanel);
        this.buttonPanel = new JPanel();
        this.okButton = new JButton("Ok", Sarj.OK_ICON);
        this.okButton.addActionListener(this);
        this.buttonPanel.add(this.okButton);
        this.lookAndFeelPanel = new JPanel();
        this.lookAndFeelPanel.setLayout(new BoxLayout(this.lookAndFeelPanel, 3));
        this.lookAndFeelPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Look and Feel"), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.javaUIBox = new JCheckBox("Use Java Look and Feel");
        this.javaUIBox.addActionListener(this);
        this.lookAndFeelPanel.add(this.javaUIBox);
        this.noteLabel = new JLabel("<html><font size='2'>Note: You must restart SARJ for changes to take effect</font></html>");
        this.noteLabel.setAlignmentX(0.0f);
        this.lookAndFeelPanel.setAlignmentX(0.5f);
        this.lookAndFeelPanel.add(this.noteLabel);
        this.getContentPane().add(this.refreshPanel);
        this.getContentPane().add(this.lookAndFeelPanel);
        this.getContentPane().add(this.buttonPanel);
        this.setResizable(false);
        this.pack();
        this.setLocationRelativeTo(null);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.okButton) {
            this.saveSettings();
            this.setVisible(false);
        } else if (actionEvent.getSource() == this.javaUIBox) {
            javaUI = this.javaUIBox.isSelected();
        }
    }

    public void loadSettings() {
        BufferedReader bufferedReader;
        String string = "";
        this.owner.setIPField("0.0.0.0");
        this.owner.setPortField("23073");
        this.owner.setAutoRefresh(true);
        this.autoRefreshBox.setSelected(true);
        this.preRefreshLabel.setEnabled(true);
        this.refreshTimeField.setEnabled(true);
        this.postRefreshLabel.setEnabled(true);
        this.owner.setRefreshDelay(5);
        try {
            bufferedReader = new BufferedReader(new FileReader(new File(this.configFile)));
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this.owner.getMainFrame(), "Failed to open config file! Using default settings.", "Error", 0);
            return;
        }
        try {
            string = bufferedReader.readLine();
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(this.owner.getMainFrame(), "Warning: Exception occurred when reading config file! Using default settings.", "Error", 0);
            return;
        }
        while (string != null) {
            try {
                String[] stringArray;
                if (string != null && string.length() > 0 && !string.trim().startsWith("#") && (stringArray = string.split("=")).length > 1) {
                    int n;
                    for (n = 0; n < stringArray.length; ++n) {
                        stringArray[n] = stringArray[n].trim();
                    }
                    if ("AutoRefresh".equalsIgnoreCase(stringArray[0])) {
                        if ("1".equals(stringArray[1]) || "true".equalsIgnoreCase(stringArray[1]) || "yes".equalsIgnoreCase(stringArray[1]) || "on".equalsIgnoreCase(stringArray[1])) {
                            this.owner.setAutoRefresh(true);
                            this.autoRefreshBox.setSelected(true);
                            this.preRefreshLabel.setEnabled(true);
                            this.refreshTimeField.setEnabled(true);
                            this.postRefreshLabel.setEnabled(true);
                        } else {
                            this.owner.setAutoRefresh(false);
                            this.autoRefreshBox.setSelected(false);
                            this.preRefreshLabel.setEnabled(false);
                            this.refreshTimeField.setEnabled(false);
                            this.postRefreshLabel.setEnabled(false);
                        }
                    } else if ("RefreshDelay".equalsIgnoreCase(stringArray[0])) {
                        try {
                            n = Integer.parseInt(stringArray[1]);
                        }
                        catch (NumberFormatException numberFormatException) {
                            n = 5;
                        }
                        if (n < 1) {
                            n = 5;
                        }
                        this.refreshTimeField.setText(new Integer(n).toString());
                        this.owner.setRefreshDelay(n);
                    } else if ("IP".equalsIgnoreCase(stringArray[0])) {
                        this.owner.setIPField(stringArray[1]);
                    } else if ("Port".equalsIgnoreCase(stringArray[0])) {
                        this.owner.setPortField(stringArray[1]);
                    } else if ("JavaUI".equalsIgnoreCase(stringArray[0])) {
                        if ("1".equals(stringArray[1]) || "true".equalsIgnoreCase(stringArray[1]) || "yes".equalsIgnoreCase(stringArray[1]) || "on".equalsIgnoreCase(stringArray[1])) {
                            javaUI = true;
                            this.javaUIBox.setSelected(true);
                        } else {
                            javaUI = false;
                            this.javaUIBox.setSelected(false);
                        }
                    }
                }
                string = bufferedReader.readLine();
            }
            catch (IOException iOException) {
                JOptionPane.showMessageDialog(this.owner.getMainFrame(), "Warning: Failed to read from config file!", "Error", 0);
                return;
            }
        }
        try {
            bufferedReader.close();
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(this.owner.getMainFrame(), "Warning: Exception occurred when closing config file!", "Error", 0);
        }
    }

    public void saveSettings() {
        int n;
        try {
            n = Integer.parseInt(this.refreshTimeField.getText());
        }
        catch (NumberFormatException numberFormatException) {
            n = 5;
        }
        if (n < 0) {
            n = 5;
        }
        boolean bl = this.autoRefreshBox.isSelected();
        this.owner.setAutoRefresh(bl);
        this.owner.setRefreshDelay(n);
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(new File(this.configFile)));
            bufferedWriter.write("# SARJ configuration settings\r\n\r\n");
            bufferedWriter.write("AutoRefresh=" + (bl ? "1" : "0") + "\r\n");
            bufferedWriter.write("RefreshDelay=" + n + "\r\n");
            bufferedWriter.write("IP=" + this.owner.getIPField() + "\r\n");
            bufferedWriter.write("Port=" + this.owner.getPortField() + "\r\n");
            bufferedWriter.write("JavaUI=" + (javaUI ? "1" : "0") + "\r\n");
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(this.owner.getMainFrame(), "Warning: Failed to save configuration settings!", "Error", 0);
            return;
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        ItemSelectable itemSelectable = itemEvent.getItemSelectable();
        if (itemSelectable == this.autoRefreshBox) {
            if (this.autoRefreshBox.isSelected()) {
                this.preRefreshLabel.setEnabled(true);
                this.refreshTimeField.setEnabled(true);
                this.postRefreshLabel.setEnabled(true);
            } else {
                this.preRefreshLabel.setEnabled(false);
                this.refreshTimeField.setEnabled(false);
                this.postRefreshLabel.setEnabled(false);
            }
        }
    }

    public static String getUIClassNameFromConfigFile(String string) {
        String string2;
        BufferedReader bufferedReader;
        try {
            bufferedReader = new BufferedReader(new FileReader(new File(string)));
        }
        catch (Exception exception) {
            javaUI = false;
            return UIManager.getSystemLookAndFeelClassName();
        }
        try {
            string2 = bufferedReader.readLine();
        }
        catch (IOException iOException) {
            javaUI = false;
            return UIManager.getSystemLookAndFeelClassName();
        }
        while (string2 != null) {
            try {
                String[] stringArray;
                if (string2 != null && string2.length() > 0 && !string2.trim().startsWith("#") && (stringArray = string2.split("=")).length > 1) {
                    for (int i = 0; i < stringArray.length; ++i) {
                        stringArray[i] = stringArray[i].trim();
                    }
                    if ("JavaUI".equalsIgnoreCase(stringArray[0])) {
                        if ("1".equals(stringArray[1]) || "true".equalsIgnoreCase(stringArray[1]) || "yes".equalsIgnoreCase(stringArray[1]) || "on".equalsIgnoreCase(stringArray[1])) {
                            javaUI = true;
                            return UIManager.getCrossPlatformLookAndFeelClassName();
                        }
                        javaUI = false;
                        return UIManager.getSystemLookAndFeelClassName();
                    }
                }
                string2 = bufferedReader.readLine();
            }
            catch (Exception exception) {
                javaUI = false;
                return UIManager.getSystemLookAndFeelClassName();
            }
        }
        javaUI = false;
        return UIManager.getSystemLookAndFeelClassName();
    }
}

