/*
 * Decompiled with CFR 0.152.
 */
package FESI.swinggui;

import FESI.Exceptions.ProgrammingError;
import FESI.gui.InterpreterCommands;
import FESI.swinggui.Editor;
import FESI.swinggui.ExtendedConsole;
import FESI.swinggui.HelpWindow;
import FESI.swinggui.JConsoleArea;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;

public class SwingConsole
extends JFrame
implements ExtendedConsole {
    private static String eol = System.getProperty("line.separator", "\n");
    private static int newWindowCounter = 0;
    private Vector editorWindows = new Vector();
    private JConsoleArea theConsoleArea;
    private JScrollPane theScrollPane;
    private HelpWindow helpWindow = null;
    private static InputStream consoleIn;
    private static PrintStream consoleOut;
    private static InterpreterCommands itrp;
    TextAreaInputStream textAreaInputStream = null;

    private void editorWindowClosed(Editor editor) {
        this.editorWindows.removeElement(editor);
    }

    public InputStream getConsoleIn() {
        return consoleIn;
    }

    public PrintStream getConsoleOut() {
        return consoleOut;
    }

    public SwingConsole(InterpreterCommands itrpParam, String title, int rows, int columns) {
        super(title);
        if (itrp != null) {
            throw new ProgrammingError("Only a single console is allowed in an executable");
        }
        itrp = itrpParam;
        this.getContentPane().setLayout(new BorderLayout());
        this.theConsoleArea = new JConsoleArea(this, rows, columns);
        this.theConsoleArea.setFont(new Font("monospaced", 0, 12));
        this.theConsoleArea.setBackground(Color.lightGray);
        this.theScrollPane = new JScrollPane(this.theConsoleArea);
        this.theScrollPane.setVerticalScrollBarPolicy(22);
        this.getContentPane().add("Center", this.theScrollPane);
        this.theConsoleArea.setVisible(true);
        this.theConsoleArea.setBackground(Color.white);
        JMenuBar menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu("File");
        fileMenu.setMnemonic('F');
        JMenuItem newItem = new JMenuItem("New  Ctrl+N");
        newItem.setMnemonic('N');
        newItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent action) {
                SwingConsole.this.commandNew();
            }
        });
        fileMenu.add(newItem);
        this.theConsoleArea.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent action) {
                SwingConsole.this.commandNew();
            }
        }, KeyStroke.getKeyStroke(78, 2), 2);
        JMenuItem loadItem = new JMenuItem("Load...  Ctrl+L");
        loadItem.setMnemonic('L');
        loadItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent action) {
                SwingConsole.this.commandLoad();
            }
        });
        fileMenu.add(loadItem);
        this.theConsoleArea.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent action) {
                SwingConsole.this.commandLoad();
            }
        }, KeyStroke.getKeyStroke(76, 2), 2);
        JMenuItem openItem = new JMenuItem("Open...  Ctrl+O");
        openItem.setMnemonic('O');
        openItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent action) {
                SwingConsole.this.commandOpen();
            }
        });
        fileMenu.add(openItem);
        this.theConsoleArea.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent action) {
                SwingConsole.this.commandOpen();
            }
        }, KeyStroke.getKeyStroke(79, 2), 2);
        fileMenu.addSeparator();
        JMenuItem exitItem = new JMenuItem("Exit");
        exitItem.setMnemonic('x');
        exitItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent action) {
                SwingConsole.this.commandExit();
            }
        });
        fileMenu.add(exitItem);
        menuBar.add(fileMenu);
        JMenu editMenu = new JMenu("Edit");
        editMenu.setMnemonic('E');
        JMenuItem clearItem = new JMenuItem("Clear all");
        clearItem.setMnemonic('a');
        clearItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent action) {
                SwingConsole.this.clear();
            }
        });
        editMenu.add(clearItem);
        editMenu.addSeparator();
        JMenuItem cutItem = new JMenuItem("Cut");
        cutItem.setMnemonic('t');
        cutItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent action) {
                SwingConsole.this.theConsoleArea.cut();
            }
        });
        editMenu.add(cutItem);
        JMenuItem copyItem = new JMenuItem("Copy");
        copyItem.setMnemonic('C');
        copyItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent action) {
                SwingConsole.this.theConsoleArea.copy();
            }
        });
        editMenu.add(copyItem);
        JMenuItem pasteItem = new JMenuItem("Paste at end");
        pasteItem.setMnemonic('P');
        pasteItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent action) {
                SwingConsole.this.theConsoleArea.paste();
            }
        });
        editMenu.add(pasteItem);
        menuBar.add(editMenu);
        JMenu helpMenu = new JMenu("Help");
        helpMenu.setMnemonic('H');
        JMenuItem contentItem = new JMenuItem("Content  F1");
        contentItem.setMnemonic('C');
        contentItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent action) {
                SwingConsole.this.displayHelpWindow();
            }
        });
        helpMenu.add(contentItem);
        this.theConsoleArea.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent action) {
                SwingConsole.this.displayHelpWindow();
            }
        }, KeyStroke.getKeyStroke(112, 0), 2);
        JMenuItem commandsItem = new JMenuItem("Commands");
        commandsItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent action) {
                SwingConsole.this.displayHelpText();
            }
        });
        helpMenu.add(commandsItem);
        JMenuItem aboutItem = new JMenuItem("About");
        aboutItem.setMnemonic('A');
        aboutItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent action) {
                SwingConsole.this.displayAbout();
            }
        });
        helpMenu.addSeparator();
        helpMenu.add(aboutItem);
        menuBar.add(helpMenu);
        this.getContentPane().add("North", menuBar);
        this.pack();
        int scrwidth = Toolkit.getDefaultToolkit().getScreenSize().width;
        int scrheight = Toolkit.getDefaultToolkit().getScreenSize().height;
        int conwidth = this.getSize().width;
        int conheight = this.getSize().height;
        this.setLocation((scrwidth - conwidth) / 2, (scrheight - conheight) / 2);
        this.textAreaInputStream = new TextAreaInputStream(this.theConsoleArea);
        consoleIn = new LineInputStream(this.textAreaInputStream);
        consoleOut = new PrintStream(new TextAreaOutputStream(this.theConsoleArea), true);
        System.setOut(consoleOut);
        System.setIn(consoleIn);
        System.setErr(consoleOut);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent ev) {
                boolean abort = false;
                int nWindows = SwingConsole.this.editorWindows.size();
                for (int i = 0; i < nWindows && !abort; ++i) {
                    Editor editor = (Editor)SwingConsole.this.editorWindows.elementAt(i);
                    abort = editor.checkDirty();
                    if (abort) continue;
                    Frame editorFrame = editor.getFrame();
                    editorFrame.dispose();
                }
                if (!abort) {
                    SwingConsole.this.dispose();
                }
            }

            public void windowClosed(WindowEvent ev) {
                itrp.exit();
            }
        });
        this.show();
        this.theConsoleArea.requestFocus();
    }

    public void commandExit() {
        boolean abort = false;
        int nWindows = this.editorWindows.size();
        for (int i = 0; i < nWindows && !abort; ++i) {
            Editor editor = (Editor)this.editorWindows.elementAt(i);
            abort = editor.checkDirty();
        }
        if (!abort) {
            if (this.helpWindow != null) {
                this.helpWindow.dispose();
                this.helpWindow = null;
            }
            itrp.exit();
        }
    }

    public void commandLoad() {
        FileDialog fd = new FileDialog((Frame)this, "File to load");
        fd.show();
        String directoryName = fd.getDirectory();
        String fileName = fd.getFile();
        if (fileName != null && directoryName != null) {
            itrp.loadFile(directoryName, fileName);
        }
    }

    public void commandNew() {
        final JFrame frame = new JFrame("FESI Editor " + ++newWindowCounter);
        frame.getContentPane().setLayout(new BorderLayout());
        final Editor editor = new Editor(this);
        this.editorWindows.addElement(editor);
        frame.getContentPane().add("Center", editor);
        frame.pack();
        frame.setSize(500, 600);
        frame.show();
        frame.setDefaultCloseOperation(0);
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent ev) {
                if (!editor.checkDirty()) {
                    frame.dispose();
                    SwingConsole.this.toFront();
                }
            }

            public void windowClosed(WindowEvent ev) {
                SwingConsole.this.editorWindowClosed(editor);
            }
        });
    }

    public void commandOpen() {
        File directory;
        File file;
        FileDialog fd = new FileDialog((Frame)this, "File to open");
        fd.show();
        String directoryName = fd.getDirectory();
        String fileName = fd.getFile();
        if (fileName != null && directoryName != null && (file = new File(directory = new File(directoryName), fileName)).exists()) {
            JFrame frame = new JFrame("FESI Editor");
            Editor ed = new Editor(this);
            frame.getContentPane().setLayout(new BorderLayout());
            frame.getContentPane().add("Center", ed);
            frame.pack();
            frame.setSize(500, 600);
            frame.show();
            ed.loadFile(file);
        }
    }

    int executeString(String text, String source) {
        int status = itrp.executeString(text, source);
        this.theConsoleArea.atEnd();
        if (status <= 0) {
            this.toFront();
        }
        return status;
    }

    public synchronized void send(String text) {
        this.textAreaInputStream.send(text);
    }

    public synchronized void clear() {
        this.theConsoleArea.setText("");
        this.theConsoleArea.resetFirstInputLocation();
    }

    public boolean supportsEditing() {
        return true;
    }

    public void createEditor(String fileName) {
        File file = new File(fileName);
        JFrame frame = new JFrame("FESI Editor");
        Editor ed = new Editor(this);
        frame.getContentPane().setLayout(new BorderLayout());
        frame.getContentPane().add("Center", ed);
        frame.pack();
        frame.setSize(500, 600);
        frame.show();
        if (file.exists()) {
            ed.loadFile(file);
        }
    }

    public void displayAbout() {
        itrp.displayAboutText();
        this.toFront();
    }

    public void displayHelpText() {
        itrp.displayHelpText();
        this.toFront();
    }

    public void displayHelpWindow() {
        if (this.helpWindow == null) {
            String helpLocation = System.getProperty("FESI.help");
            if (helpLocation == null) {
                System.err.println("[[Property FESI.help not defined, should be help url]]");
                return;
            }
            Cursor cursor = this.getCursor();
            Cursor waitCursor = Cursor.getPredefinedCursor(3);
            this.setCursor(waitCursor);
            this.helpWindow = new HelpWindow(helpLocation);
            this.setCursor(cursor);
        } else {
            this.helpWindow.setVisible(true);
            this.helpWindow.toFront();
        }
    }

    static {
        itrp = null;
    }

    public class TextAreaInputStream
    extends PipedInputStream {
        JConsoleArea theConsoleArea;
        OutputStream out;
        int nbrOfKeyTyped;

        public TextAreaInputStream(JConsoleArea newTextArea) {
            try {
                this.theConsoleArea = newTextArea;
                this.out = new PipedOutputStream(this);
                this.nbrOfKeyTyped = 0;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        private void send(char ch) {
            try {
                if (ch == '\n') {
                    byte[] beol = eol.getBytes();
                    this.out.write(beol, 0, beol.length);
                    this.out.flush();
                    this.nbrOfKeyTyped = 0;
                } else if (ch >= ' ' && ch < '\u0100') {
                    this.out.write(ch);
                    ++this.nbrOfKeyTyped;
                } else if (ch != '\r') {
                    this.out.write(63);
                    ++this.nbrOfKeyTyped;
                }
            }
            catch (IOException e) {
                Toolkit.getDefaultToolkit().beep();
            }
        }

        private void send(String s) {
            for (int i = 0; i < s.length(); ++i) {
                this.send(s.charAt(i));
            }
        }
    }

    public class TextAreaOutputStream
    extends OutputStream {
        JConsoleArea theConsoleArea;
        String buffer = "";

        public TextAreaOutputStream(JConsoleArea textArea) {
            this.theConsoleArea = textArea;
        }

        public synchronized void flush() {
            this.theConsoleArea.append(this.buffer);
            this.buffer = "";
        }

        public synchronized void write(int b) {
            if (b < 0) {
                b += 256;
            }
            this.buffer = this.buffer + (char)b;
        }
    }

    public class LineInputStream
    extends FilterInputStream {
        byte[] byteArray;
        int arrayOffset;
        int arrayLength;

        public LineInputStream(InputStream in) {
            super(in);
        }

        public synchronized int read() throws IOException {
            if (this.byteArray != null && this.arrayOffset < this.arrayLength) {
                return this.byteArray[this.arrayOffset++];
            }
            this.byteArray = this.readLine();
            this.arrayOffset = 0;
            this.arrayLength = this.byteArray.length;
            if (this.byteArray != null && this.arrayOffset < this.arrayLength) {
                return this.byteArray[this.arrayOffset++];
            }
            return -1;
        }

        public synchronized int read(byte[] bytes, int offset, int length) throws IOException {
            if (this.byteArray != null && this.arrayOffset < this.arrayLength) {
                int available = this.available();
                if (length > available) {
                    length = available;
                }
                System.arraycopy(this.byteArray, this.arrayOffset, bytes, offset, length);
                this.arrayOffset += length;
                return length;
            }
            this.byteArray = this.readLine();
            this.arrayOffset = 0;
            this.arrayLength = this.byteArray.length;
            if (this.byteArray == null || this.arrayOffset >= this.arrayLength) {
                return -1;
            }
            int available = this.available();
            if (length > available) {
                length = available;
            }
            System.arraycopy(this.byteArray, this.arrayOffset, bytes, offset, length);
            this.arrayOffset += length;
            return length;
        }

        public synchronized int available() throws IOException {
            return this.arrayLength - this.arrayOffset + super.available();
        }

        public synchronized byte[] readLine() throws IOException {
            ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
            boolean ready = false;
            while (!ready) {
                int length;
                int ch = this.in.read();
                if (ch == -1) {
                    ready = true;
                    continue;
                }
                if (ch == 8) {
                    byte[] bytes = bytesOut.toByteArray();
                    bytesOut.reset();
                    length = bytes.length - 1;
                    if (length <= 0) continue;
                    bytesOut.write(bytes, 0, length);
                    continue;
                }
                if (ch == 21) {
                    bytesOut.reset();
                    length = 0;
                    continue;
                }
                if (ch == 10) {
                    bytesOut.write(ch);
                    ready = true;
                    continue;
                }
                bytesOut.write(ch);
            }
            return bytesOut.toByteArray();
        }
    }
}

