/*
 * Decompiled with CFR 0.152.
 */
package FESI.swinggui;

import FESI.Exceptions.ProgrammingError;
import FESI.swinggui.ExtendedConsole;
import java.awt.Font;
import java.awt.event.ActionEvent;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;
import javax.swing.text.TextAction;

public class JConsoleArea
extends JTextArea {
    private int firstInputLocation = -1;
    private int lastOutputLocation = -1;
    private static Keymap fesiKeymap = null;
    protected ExtendedConsole mainConsole;

    JConsoleArea(ExtendedConsole mainConsole, int rows, int columns) {
        super(rows, columns);
        this.mainConsole = mainConsole;
        this.setFont(new Font("Monospaced", 0, 12));
        if (fesiKeymap == null) {
            Keymap defaultKeymap = JTextComponent.getKeymap("default");
            if (defaultKeymap == null) {
                throw new ProgrammingError("Could not find default keymap");
            }
            fesiKeymap = JTextComponent.addKeymap("FESIKeyMap", defaultKeymap);
            fesiKeymap.setDefaultAction(new DefaultKeyTypedAction(this));
            fesiKeymap.addActionForKeyStroke(KeyStroke.getKeyStroke(10, 0), new ReturnKeyTypedAction(this));
            fesiKeymap.addActionForKeyStroke(KeyStroke.getKeyStroke(67, 2), new CopyAction());
            fesiKeymap.addActionForKeyStroke(KeyStroke.getKeyStroke(88, 2), new CutAction());
            fesiKeymap.addActionForKeyStroke(KeyStroke.getKeyStroke(86, 2), new PasteAction(this));
        }
        this.setKeymap(fesiKeymap);
    }

    protected void setFirstInputLocation(int loc) {
        if (this.firstInputLocation == -1) {
            this.firstInputLocation = loc;
        }
    }

    protected void resetFirstInputLocation() {
        this.firstInputLocation = -1;
    }

    protected int getFirstInputLocation() {
        if (this.firstInputLocation == -1 && this.lastOutputLocation != -1) {
            return this.lastOutputLocation;
        }
        return this.firstInputLocation;
    }

    protected void atEnd() {
        Document doc = this.getDocument();
        int dot = doc.getLength();
        this.setCaretPosition(dot);
    }

    public void paste() {
        Document doc = this.getDocument();
        int dot = doc.getLength();
        this.setCaretPosition(dot);
        this.setFirstInputLocation(dot);
        super.paste();
    }

    public void append(String str) {
        super.append(str);
        Document doc = this.getDocument();
        this.lastOutputLocation = doc.getLength();
        this.setCaretPosition(this.lastOutputLocation);
    }

    public static class PasteAction
    extends TextAction {
        JConsoleArea console;

        public PasteAction(JConsoleArea console) {
            super("paste-from-clipboard");
            this.console = console;
        }

        public void actionPerformed(ActionEvent e) {
            JTextComponent target = this.getTextComponent(e);
            if (target != null) {
                target.paste();
            }
        }
    }

    public static class CopyAction
    extends TextAction {
        public CopyAction() {
            super("copy-to-clipboard");
        }

        public void actionPerformed(ActionEvent e) {
            JTextComponent target = this.getTextComponent(e);
            if (target != null) {
                target.copy();
            }
        }
    }

    public static class CutAction
    extends TextAction {
        public CutAction() {
            super("cut-to-clipboard");
        }

        public void actionPerformed(ActionEvent e) {
            JTextComponent target = this.getTextComponent(e);
            if (target != null) {
                target.cut();
            }
        }
    }

    public static class ReturnKeyTypedAction
    extends TextAction {
        JConsoleArea console;

        public ReturnKeyTypedAction(JConsoleArea console) {
            super("return");
            this.console = console;
        }

        public void actionPerformed(ActionEvent e) {
            JTextComponent target = this.getTextComponent(e);
            if (target != null && e != null) {
                Document doc = target.getDocument();
                int dot = doc.getLength();
                target.setCaretPosition(dot);
                target.replaceSelection("\n");
                String inputText = null;
                int start = this.console.getFirstInputLocation();
                int length = dot - start + 1;
                if (start != -1 && length > 0) {
                    try {
                        inputText = doc.getText(start, length);
                    }
                    catch (BadLocationException ex) {
                        throw new ProgrammingError("Unexpected exception: " + ex.toString());
                    }
                    this.console.mainConsole.send(inputText);
                    this.console.resetFirstInputLocation();
                }
            }
        }
    }

    public static class DefaultKeyTypedAction
    extends TextAction {
        JConsoleArea console;

        public DefaultKeyTypedAction(JConsoleArea console) {
            super("default-typed");
            this.console = console;
        }

        public void actionPerformed(ActionEvent e) {
            JTextComponent target = this.getTextComponent(e);
            if (target != null && e != null) {
                char c;
                String content = e.getActionCommand();
                int mod = e.getModifiers();
                if (content != null && content.length() > 0 && (mod & 8) == 0 && !Character.isISOControl(c = content.charAt(0))) {
                    Document doc = target.getDocument();
                    int dot = doc.getLength();
                    target.setCaretPosition(dot);
                    this.console.setFirstInputLocation(dot);
                    target.replaceSelection(content);
                }
            }
        }
    }
}

