/*
 * Decompiled with CFR 0.152.
 */
package FESI.swinggui;

import FESI.swinggui.HtmlPane;
import FESI.swinggui.PageLoader;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Toolkit;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class HelpWindow
extends JFrame
implements HyperlinkListener {
    private HtmlPane html;
    private String helpLocation;
    private Vector history = new Vector();
    private URL contentPageURL = null;

    HelpWindow(String helpLocation) {
        this.helpLocation = helpLocation;
        this.setTitle("FESI Help");
        this.setSize(600, 500);
        this.setBackground(Color.gray);
        this.getContentPane().setLayout(new BorderLayout());
        int scrwidth = Toolkit.getDefaultToolkit().getScreenSize().width;
        int scrheight = Toolkit.getDefaultToolkit().getScreenSize().height;
        int conwidth = this.getSize().width;
        int conheight = this.getSize().height;
        this.setLocation((scrwidth - conwidth) / 2, (scrheight - conheight) / 2);
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new BorderLayout());
        this.getContentPane().add((Component)topPanel, "Center");
        try {
            this.contentPageURL = new URL(helpLocation);
            this.html = new HtmlPane(this, this.contentPageURL);
            this.html.setEditable(false);
            this.addHistory(this.contentPageURL);
            JScrollPane scrollPane = new JScrollPane();
            scrollPane.getViewport().add((Component)this.html, "Center");
            topPanel.add((Component)scrollPane, "Center");
            this.html.addHyperlinkListener(this);
        }
        catch (MalformedURLException e) {
            System.err.println("[[Error opening HELP url '" + helpLocation + "': " + e + "]]");
        }
        catch (IOException e) {
            System.err.println("[[Error accessing HELP url '" + helpLocation + "': " + e + "]]");
        }
        this.setDefaultCloseOperation(1);
        this.setVisible(true);
    }

    public void addHistory(URL url) {
        this.history.addElement(url);
    }

    public void gotoContentPage() {
        if (this.contentPageURL != null) {
            Cursor cursor = this.html.getCursor();
            Cursor waitCursor = Cursor.getPredefinedCursor(3);
            this.html.setCursor(waitCursor);
            SwingUtilities.invokeLater(new PageLoader(null, this.html, this.contentPageURL, cursor));
        }
    }

    public void backHistory() {
        int last = this.history.size() - 2;
        if (last >= 0) {
            URL url = (URL)this.history.elementAt(last);
            this.history.removeElementAt(last);
            Cursor cursor = this.html.getCursor();
            Cursor waitCursor = Cursor.getPredefinedCursor(3);
            this.html.setCursor(waitCursor);
            SwingUtilities.invokeLater(new PageLoader(null, this.html, url, cursor));
        }
    }

    public void hyperlinkUpdate(HyperlinkEvent event) {
        if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            Cursor cursor = this.html.getCursor();
            Cursor waitCursor = Cursor.getPredefinedCursor(3);
            this.html.setCursor(waitCursor);
            SwingUtilities.invokeLater(new PageLoader(this, this.html, event.getURL(), cursor));
        }
    }
}

