/*
 * Decompiled with CFR 0.152.
 */
package FESI.swinggui;

import FESI.Exceptions.ProgrammingError;
import FESI.swinggui.SwingConsole;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import javax.swing.BorderFactory;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;

public class Editor
extends JPanel {
    private JTextComponent editor;
    private JMenuBar menubar;
    private File currentFile = null;
    private boolean dirty = false;
    private String defaultTitle = null;
    protected FileDialog fileDialog;
    private SwingConsole mainConsole;
    private DocumentListener theDocumentListener = new DocumentListener(){

        public void changedUpdate(DocumentEvent e) {
            Editor.this.dirty = true;
            Editor.this.refreshTitle();
        }

        public void insertUpdate(DocumentEvent e) {
            Editor.this.dirty = true;
            Editor.this.refreshTitle();
        }

        public void removeUpdate(DocumentEvent e) {
            Editor.this.dirty = true;
            Editor.this.refreshTitle();
        }
    };

    Editor(SwingConsole console) {
        super(true);
        this.mainConsole = console;
        this.init();
    }

    void init() {
        this.setBorder(BorderFactory.createEtchedBorder());
        this.setLayout(new BorderLayout());
        this.editor = new JTextArea();
        this.editor.setFont(new Font("Monospaced", 0, 12));
        Document doc = this.editor.getDocument();
        doc.addDocumentListener(this.theDocumentListener);
        JScrollPane scroller = new JScrollPane();
        JViewport port = scroller.getViewport();
        port.add(this.editor);
        port.setBackingStoreEnabled(false);
        this.menubar = this.createMenubar();
        this.add("North", this.menubar);
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add("Center", scroller);
        this.add("Center", panel);
    }

    boolean checkDirty() {
        if (this.dirty) {
            int result = JOptionPane.showConfirmDialog(this, "Save changes in " + this.getWindowBaseTitle() + " ?", "FESI Editor", 1, 2, null);
            if (result == 2) {
                return true;
            }
            if (result == 0) {
                this.commandSave();
                return false;
            }
            return false;
        }
        return false;
    }

    protected Frame getFrame() {
        for (Container p = this.getParent(); p != null; p = p.getParent()) {
            if (!(p instanceof Frame)) continue;
            return (Frame)p;
        }
        return null;
    }

    protected JMenuBar getMenubar() {
        return this.menubar;
    }

    protected JMenuBar createMenubar() {
        JMenuBar menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu("File");
        fileMenu.setMnemonic('F');
        JMenuItem newItem = new JMenuItem("New  Ctrl+N");
        newItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent action) {
                Editor.this.commandNew();
            }
        });
        fileMenu.add(newItem);
        this.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent action) {
                Editor.this.commandNew();
            }
        }, KeyStroke.getKeyStroke(78, 2), 2);
        JMenuItem openItem = new JMenuItem("Open... Ctrl+O");
        openItem.setMnemonic('O');
        openItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent action) {
                Editor.this.commandOpen();
            }
        });
        fileMenu.add(openItem);
        this.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent action) {
                Editor.this.commandOpen();
            }
        }, KeyStroke.getKeyStroke(79, 2), 2);
        JMenuItem closeItem = new JMenuItem("Close");
        closeItem.setMnemonic('C');
        closeItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent action) {
                Editor.this.commandClose();
            }
        });
        fileMenu.add(closeItem);
        JMenuItem saveItem = new JMenuItem("Save  Ctrl+S");
        saveItem.setMnemonic('S');
        saveItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent action) {
                Editor.this.commandSave();
            }
        });
        fileMenu.add(saveItem);
        this.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent action) {
                Editor.this.commandSave();
            }
        }, KeyStroke.getKeyStroke(83, 2), 2);
        JMenuItem saveAsItem = new JMenuItem("Save as..");
        saveAsItem.setMnemonic('a');
        saveAsItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent action) {
                Editor.this.commandSaveAs();
            }
        });
        fileMenu.add(saveAsItem);
        menuBar.add(fileMenu);
        JMenu editMenu = new JMenu("Edit");
        editMenu.setMnemonic('E');
        JMenuItem cutItem = new JMenuItem("Cut");
        cutItem.setMnemonic('t');
        cutItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent action) {
                Editor.this.editor.cut();
            }
        });
        editMenu.add(cutItem);
        JMenuItem copyItem = new JMenuItem("Copy");
        copyItem.setMnemonic('C');
        copyItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent action) {
                Editor.this.editor.copy();
            }
        });
        editMenu.add(copyItem);
        JMenuItem pasteItem = new JMenuItem("Paste");
        pasteItem.setMnemonic('P');
        pasteItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent action) {
                Editor.this.editor.paste();
            }
        });
        editMenu.add(pasteItem);
        menuBar.add(editMenu);
        JMenu runMenu = new JMenu("Run");
        runMenu.setMnemonic('R');
        JMenuItem executeItem = new JMenuItem("Execute F4");
        executeItem.setMnemonic('E');
        executeItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent action) {
                Editor.this.commandExecute();
            }
        });
        runMenu.add(executeItem);
        this.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent action) {
                Editor.this.commandExecute();
            }
        }, KeyStroke.getKeyStroke(115, 0), 2);
        menuBar.add(runMenu);
        JMenu helpMenu = new JMenu("Help");
        helpMenu.setMnemonic('H');
        JMenuItem contentItem = new JMenuItem("Content F1");
        contentItem.setMnemonic('C');
        contentItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent action) {
                Editor.this.mainConsole.displayHelpWindow();
            }
        });
        helpMenu.add(contentItem);
        this.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent action) {
                Editor.this.mainConsole.displayHelpWindow();
            }
        }, KeyStroke.getKeyStroke(112, 0), 2);
        JMenuItem commandsItem = new JMenuItem("Commands");
        commandsItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent action) {
                Editor.this.mainConsole.displayHelpText();
            }
        });
        helpMenu.add(commandsItem);
        JMenuItem aboutItem = new JMenuItem("About");
        aboutItem.setMnemonic('A');
        aboutItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent action) {
                Editor.this.mainConsole.displayAbout();
            }
        });
        helpMenu.addSeparator();
        helpMenu.add(aboutItem);
        menuBar.add(helpMenu);
        return menuBar;
    }

    public String getWindowBaseTitle() {
        Frame frame = this.getFrame();
        if (this.defaultTitle == null) {
            this.defaultTitle = frame.getTitle();
        }
        if (this.defaultTitle == null) {
            this.defaultTitle = "FESI Editor";
        }
        String title = this.currentFile == null ? this.defaultTitle : this.currentFile.getPath();
        return title;
    }

    public String getWindowTitle() {
        String title = this.getWindowBaseTitle() + (this.dirty ? " *" : "");
        return title;
    }

    private void refreshTitle() {
        Frame frame = this.getFrame();
        frame.setTitle(this.getWindowTitle());
    }

    private void setTitle(File file) {
        this.currentFile = file;
        this.dirty = false;
        this.refreshTitle();
    }

    public void loadFile(File file) {
        PlainDocument doc = new PlainDocument();
        this.editor.setDocument(doc);
        this.setTitle(file);
        FileLoader loader = new FileLoader(file, this.editor.getDocument());
        loader.start();
    }

    void commandClose() {
        if (this.checkDirty()) {
            return;
        }
        Frame frame = this.getFrame();
        frame.dispose();
    }

    void commandOpen() {
        if (this.checkDirty()) {
            return;
        }
        Frame frame = this.getFrame();
        if (this.fileDialog == null) {
            this.fileDialog = new FileDialog(frame);
        }
        this.fileDialog.setMode(0);
        this.fileDialog.show();
        String file = this.fileDialog.getFile();
        if (file == null) {
            return;
        }
        String directory = this.fileDialog.getDirectory();
        File f = new File(directory, file);
        if (f.exists()) {
            this.loadFile(f);
        }
    }

    public void saveFile(File file) {
        this.setTitle(file);
        try {
            FileWriter out = new FileWriter(file);
            Document doc = this.editor.getDocument();
            String text = null;
            try {
                text = doc.getText(0, doc.getLength());
            }
            catch (BadLocationException e) {
                throw new ProgrammingError("Unexpected exception: " + e);
            }
            out.write(text);
            ((Writer)out).close();
            this.dirty = false;
            this.refreshTitle();
        }
        catch (IOException e) {
            System.out.println("IO Error " + e);
        }
    }

    void commandSaveAs() {
        Frame frame = this.getFrame();
        if (this.fileDialog == null) {
            this.fileDialog = new FileDialog(frame);
        }
        this.fileDialog.setMode(1);
        this.fileDialog.show();
        String file = this.fileDialog.getFile();
        if (file == null) {
            return;
        }
        String directory = this.fileDialog.getDirectory();
        File f = new File(directory, file);
        this.saveFile(f);
    }

    void commandSave() {
        if (this.currentFile == null) {
            this.commandSaveAs();
        } else {
            this.saveFile(this.currentFile);
        }
    }

    void commandExecute() {
        Document doc = this.editor.getDocument();
        String text = null;
        try {
            text = doc.getText(0, doc.getLength());
        }
        catch (BadLocationException e) {
            throw new ProgrammingError("Unexpected exception: " + e);
        }
        Frame frame = this.getFrame();
        int errorLine = this.mainConsole.executeString(text, frame.getTitle());
        if (errorLine > 0) {
            int length = text.length();
            char[] cs = new char[length];
            text.getChars(0, length, cs, 0);
            --errorLine;
            int found = -1;
            for (int i = 0; i < length; ++i) {
                if (errorLine == 0) {
                    found = i;
                    break;
                }
                if (cs[i] != '\n') continue;
                --errorLine;
            }
            if (found >= 0) {
                this.editor.setCaretPosition(found);
            }
        }
    }

    void commandNew() {
        if (this.checkDirty()) {
            return;
        }
        PlainDocument doc = new PlainDocument();
        doc.addDocumentListener(this.theDocumentListener);
        this.editor.setDocument(doc);
        this.revalidate();
    }

    class FileLoader
    extends Thread {
        Document doc;
        File f;

        FileLoader(File f, Document doc) {
            this.setPriority(4);
            this.f = f;
            this.doc = doc;
        }

        public void run() {
            try {
                int nch;
                FileReader in = new FileReader(this.f);
                char[] buff = new char[4096];
                while ((nch = ((Reader)in).read(buff, 0, buff.length)) != -1) {
                    this.doc.insertString(this.doc.getLength(), new String(buff, 0, nch), null);
                }
                this.doc.addDocumentListener(Editor.this.theDocumentListener);
            }
            catch (IOException e) {
                System.err.println(e.toString());
            }
            catch (BadLocationException e) {
                System.err.println(e.getMessage());
            }
        }
    }
}

