/*
 * Decompiled with CFR 0.152.
 */
package FESI.awtgui;

import FESI.awtgui.MultiLineLabel;
import FESI.gui.PromptBox;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

public class AwtPromptBox
implements PromptBox {
    private boolean waiting = true;
    private String response = null;

    public AwtPromptBox(String title, String prompt, String defaultResponse) {
        this.response = defaultResponse == null ? "" : defaultResponse;
        final Frame frame = new Frame(title);
        frame.setLayout(new BorderLayout(10, 10));
        frame.setBackground(Color.lightGray);
        MultiLineLabel mll = new MultiLineLabel(prompt, 15, 15);
        frame.add("Center", mll);
        Panel panel = new Panel();
        panel.setLayout(new FlowLayout(1, 10, 10));
        frame.add("South", panel);
        final TextField tf = new TextField(this.response, 20);
        if (!this.response.equals("")) {
            tf.setSelectionStart(0);
            tf.setSelectionEnd(this.response.length());
        }
        panel.add(tf);
        Button bOK = new Button("OK");
        panel.add(bOK);
        frame.pack();
        Dimension dimScreen = frame.getToolkit().getScreenSize();
        Dimension dimWindow = frame.getSize();
        frame.setLocation(dimScreen.width / 2 - dimWindow.width / 2, dimScreen.height / 2 - dimWindow.height / 2);
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                AwtPromptBox.this.response = "";
                frame.setVisible(false);
                frame.dispose();
                AwtPromptBox.this.completed();
            }
        });
        bOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AwtPromptBox.this.response = tf.getText();
                frame.setVisible(false);
                frame.dispose();
                AwtPromptBox.this.completed();
            }
        });
        tf.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AwtPromptBox.this.response = tf.getText();
                frame.setVisible(false);
                frame.dispose();
                AwtPromptBox.this.completed();
            }
        });
        frame.show();
    }

    private synchronized void completed() {
        this.waiting = false;
        this.notifyAll();
    }

    public synchronized String waitResponse() {
        while (this.waiting) {
            try {
                this.wait();
            }
            catch (Exception exception) {}
        }
        return this.response;
    }
}

