/*
 * Decompiled with CFR 0.152.
 */
package FESI.awtgui;

import FESI.Exceptions.ProgrammingError;
import FESI.gui.Console;
import FESI.gui.InterpreterCommands;
import java.awt.Color;
import java.awt.Font;
import java.awt.Frame;
import java.awt.TextArea;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.ByteArrayOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;

public class AwtConsole
extends Frame
implements Console {
    private static String eol = System.getProperty("line.separator", "\n");
    private TextArea theTextArea;
    private static InputStream consoleIn;
    private static PrintStream consoleOut;
    private static InterpreterCommands itrp;
    static boolean initialized;
    static boolean needsAppend;

    public InputStream getConsoleIn() {
        return consoleIn;
    }

    public PrintStream getConsoleOut() {
        return consoleOut;
    }

    public AwtConsole(InterpreterCommands itrpParam, String title, int rows, int columns) {
        super(title);
        itrp = itrpParam;
        this.theTextArea = new TextArea(rows, columns);
        this.theTextArea.setFont(new Font("monospaced", 0, 12));
        this.theTextArea.setBackground(Color.lightGray);
        this.add(this.theTextArea);
        this.theTextArea.setVisible(true);
        this.pack();
        int scrwidth = Toolkit.getDefaultToolkit().getScreenSize().width;
        int scrheight = Toolkit.getDefaultToolkit().getScreenSize().height;
        int conwidth = this.getSize().width;
        int conheight = this.getSize().height;
        this.setLocation((scrwidth - conwidth) / 2, (scrheight - conheight) / 2);
        consoleIn = new LineInputStream(new TextAreaInputStream(this.theTextArea));
        consoleOut = new PrintStream(new TextAreaOutputStream(this.theTextArea), true);
        System.setOut(consoleOut);
        System.setIn(consoleIn);
        System.setErr(consoleOut);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                itrp.exit();
            }
        });
        this.show();
    }

    public synchronized void clear() {
        this.theTextArea.setText("");
    }

    public boolean supportsEditing() {
        return false;
    }

    public void createEditor(String fileName) {
        throw new ProgrammingError("Create editor called in non supported environment");
    }

    public void displayAbout() {
        itrp.displayAboutText();
    }

    public void displayHelpText() {
        itrp.displayHelpText();
    }

    public void displayHelpWindow() {
    }

    static boolean needsAppend() {
        if (!initialized) {
            initialized = true;
            try {
                String tk = System.getProperty("awt.toolkit", "");
                needsAppend = tk == null || tk.indexOf("com.ms") < 0;
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        return needsAppend;
    }

    static {
        itrp = null;
        initialized = false;
        needsAppend = false;
    }

    public class TextAreaInputStream
    extends PipedInputStream
    implements KeyListener {
        TextArea theTextArea;
        OutputStream out;
        int nbrOfKeyTyped;

        public TextAreaInputStream(TextArea newTextArea) {
            try {
                this.theTextArea = newTextArea;
                this.theTextArea.addKeyListener(this);
                this.out = new PipedOutputStream(this);
                this.nbrOfKeyTyped = 0;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        private void send(char ch) {
            try {
                if (ch == '\n') {
                    if (AwtConsole.needsAppend()) {
                        this.theTextArea.append(eol);
                    }
                    byte[] beol = eol.getBytes();
                    this.out.write(beol, 0, beol.length);
                    this.out.flush();
                    this.nbrOfKeyTyped = 0;
                } else if (ch >= ' ' && ch < '\u0100') {
                    if (AwtConsole.needsAppend()) {
                        this.theTextArea.append(String.valueOf(ch));
                    }
                    this.out.write(ch);
                    ++this.nbrOfKeyTyped;
                } else if (ch != '\r') {
                    this.theTextArea.append("?");
                    this.out.write(63);
                    ++this.nbrOfKeyTyped;
                }
            }
            catch (IOException e) {
                Toolkit.getDefaultToolkit().beep();
            }
        }

        private void send(String s) {
            for (int i = 0; i < s.length(); ++i) {
                this.send(s.charAt(i));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void keyTyped(KeyEvent keyEvent) {
            boolean consume = true;
            try {
                char ch = keyEvent.getKeyChar();
                if (ch == '\b') {
                    if (this.nbrOfKeyTyped > 0) {
                        this.theTextArea.append("");
                        this.out.write(ch);
                        --this.nbrOfKeyTyped;
                        consume = false;
                    }
                } else if (ch == '\r' || ch == '\n') {
                    this.send('\n');
                } else if (ch == '\u0015') {
                    if (this.nbrOfKeyTyped > 0) {
                        String text = this.theTextArea.getText();
                        this.theTextArea.setText(text.substring(0, text.length() - this.nbrOfKeyTyped));
                        this.theTextArea.append("");
                        this.out.write(21);
                    }
                } else if (ch >= ' ' && ch < '\u00e1') {
                    this.send(ch);
                } else if (ch == '\u0003') {
                    consume = false;
                } else if (ch == '\u001a') {
                    itrp.exit();
                } else if (ch == '\u0016') {
                    Clipboard c = Toolkit.getDefaultToolkit().getSystemClipboard();
                    Transferable t = c.getContents(this);
                    String s = "";
                    try {
                        s = (String)t.getTransferData(DataFlavor.stringFlavor);
                        this.send(s);
                    }
                    catch (UnsupportedFlavorException e) {
                        Toolkit.getDefaultToolkit().beep();
                    }
                } else {
                    Toolkit.getDefaultToolkit().beep();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                if (consume) {
                    keyEvent.consume();
                }
            }
        }

        public void keyPressed(KeyEvent e) {
        }

        public void keyReleased(KeyEvent e) {
        }
    }

    public class TextAreaOutputStream
    extends OutputStream {
        TextArea theTextArea;
        String buffer = "";

        public TextAreaOutputStream(TextArea textArea) {
            this.theTextArea = textArea;
        }

        public synchronized void flush() {
            this.theTextArea.append(this.buffer);
            String text = this.theTextArea.getText();
            this.theTextArea.setCaretPosition(text.length());
            this.buffer = "";
        }

        public synchronized void write(int b) {
            if (b < 0) {
                b += 256;
            }
            this.buffer = this.buffer + (char)b;
        }
    }

    public class LineInputStream
    extends FilterInputStream {
        byte[] byteArray;
        int arrayOffset;
        int arrayLength;

        public LineInputStream(InputStream in) {
            super(in);
        }

        public synchronized int read() throws IOException {
            if (this.byteArray != null && this.arrayOffset < this.arrayLength) {
                return this.byteArray[this.arrayOffset++];
            }
            this.byteArray = this.readLine();
            this.arrayOffset = 0;
            this.arrayLength = this.byteArray.length;
            if (this.byteArray != null && this.arrayOffset < this.arrayLength) {
                return this.byteArray[this.arrayOffset++];
            }
            return -1;
        }

        public synchronized int read(byte[] bytes, int offset, int length) throws IOException {
            if (this.byteArray != null && this.arrayOffset < this.arrayLength) {
                int available = this.available();
                if (length > available) {
                    length = available;
                }
                System.arraycopy(this.byteArray, this.arrayOffset, bytes, offset, length);
                this.arrayOffset += length;
                return length;
            }
            this.byteArray = this.readLine();
            this.arrayOffset = 0;
            this.arrayLength = this.byteArray.length;
            if (this.byteArray == null || this.arrayOffset >= this.arrayLength) {
                return -1;
            }
            int available = this.available();
            if (length > available) {
                length = available;
            }
            System.arraycopy(this.byteArray, this.arrayOffset, bytes, offset, length);
            this.arrayOffset += length;
            return length;
        }

        public synchronized int available() throws IOException {
            return this.arrayLength - this.arrayOffset + super.available();
        }

        public synchronized byte[] readLine() throws IOException {
            ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
            boolean ready = false;
            while (!ready) {
                int length;
                int ch = this.in.read();
                if (ch == -1) {
                    ready = true;
                    continue;
                }
                if (ch == 8) {
                    byte[] bytes = bytesOut.toByteArray();
                    bytesOut.reset();
                    length = bytes.length - 1;
                    if (length <= 0) continue;
                    bytesOut.write(bytes, 0, length);
                    continue;
                }
                if (ch == 21) {
                    bytesOut.reset();
                    length = 0;
                    continue;
                }
                if (ch == 10) {
                    bytesOut.write(ch);
                    ready = true;
                    continue;
                }
                bytesOut.write(ch);
            }
            return bytesOut.toByteArray();
        }
    }
}

