/*
 * Decompiled with CFR 0.152.
 */
package FESI.awtgui;

import FESI.awtgui.MultiLineLabel;
import FESI.gui.ConfirmationBox;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

public class AwtConfirmationBox
implements ConfirmationBox {
    private boolean waiting = true;
    private boolean response = false;

    public AwtConfirmationBox(String title, String message) {
        final Frame frame = new Frame(title);
        frame.setLayout(new BorderLayout(10, 10));
        frame.setBackground(Color.lightGray);
        MultiLineLabel mll = new MultiLineLabel(message, 15, 15);
        frame.add("Center", mll);
        Panel panel = new Panel();
        panel.setLayout(new FlowLayout(1, 10, 10));
        frame.add("South", panel);
        Button bYes = new Button("  Yes  ");
        panel.add(bYes);
        Button bNo = new Button("  No  ");
        panel.add(bNo);
        frame.pack();
        Dimension dimScreen = frame.getToolkit().getScreenSize();
        Dimension dimWindow = frame.getSize();
        frame.setLocation(dimScreen.width / 2 - dimWindow.width / 2, dimScreen.height / 2 - dimWindow.height / 2);
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                frame.setVisible(false);
                frame.dispose();
                AwtConfirmationBox.this.response = false;
                AwtConfirmationBox.this.completed();
            }
        });
        bYes.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                frame.setVisible(false);
                frame.dispose();
                AwtConfirmationBox.this.response = true;
                AwtConfirmationBox.this.completed();
            }
        });
        bNo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                frame.setVisible(false);
                frame.dispose();
                AwtConfirmationBox.this.response = false;
                AwtConfirmationBox.this.completed();
            }
        });
        frame.show();
    }

    private synchronized void completed() {
        this.waiting = false;
        this.notifyAll();
    }

    public synchronized boolean waitYesOrNo() {
        while (this.waiting) {
            try {
                this.wait();
            }
            catch (Exception exception) {}
        }
        return this.response;
    }
}

