/*
 * Decompiled with CFR 0.152.
 */
package FESI.Tests;

import FESI.Bsf.BsfEngine;
import FESI.jslib.JSException;
import FESI.jslib.JSGlobalObject;
import FESI.jslib.JSObject;
import java.util.Vector;
import org.apache.bsf.BSFEngine;
import org.apache.bsf.BSFException;
import org.apache.bsf.BSFManager;

public class BSFTest {
    public static void main(String[] args) {
        System.out.println("Testing BSF interface");
        try {
            BSFManager mgr = new BSFManager();
            String[] extensions = new String[]{"es"};
            BSFManager.registerScriptingEngine((String)"ecmascript", (String)"FESI.Bsf.BsfEngine", (String[])extensions);
            Object result = mgr.eval("ecmascript", "testString", 0, 0, (Object)"2+32");
            BSFTest.checkResult(result, new Byte(34));
            result = mgr.apply("ecmascript", "testString", 0, 0, (Object)"return 4+6", null, null);
            BSFTest.checkResult(result, new Byte(10));
            Vector<String> argNames = new Vector<String>();
            argNames.add("arg_1");
            argNames.add("arg_2");
            Vector<Integer> argValues = new Vector<Integer>();
            argValues.add(new Integer(12));
            argValues.add(new Integer(14));
            result = mgr.apply("ecmascript", "testString", 0, 0, (Object)"return arg_1 + arg_2", argNames, argValues);
            BSFTest.checkResult(result, new Byte(26));
            BsfTestBean testBean = new BsfTestBean();
            mgr.registerBean("TestBsf", (Object)testBean);
            testBean.value = 50000;
            result = mgr.eval("ecmascript", "testString", 0, 0, (Object)"x = bsf.lookupBean (\"TestBsf\");  x.value");
            BSFTest.checkResult(result, new Integer(50000));
            result = mgr.eval("ecmascript", "testString", 0, 0, (Object)"o = new Object();  o.field=12.3; o");
            JSObject jso = (JSObject)result;
            JSGlobalObject global = jso.getGlobalObject();
            result = mgr.eval("ecmascript", "testString", 0, 0, (Object)"viaScript = 12.3;");
            BSFTest.checkResult(result, new Double(12.3));
            result = global.getMember("viaScript");
            BSFTest.checkResult(result, new Double(12.3));
            BSFEngine fesiEngine = mgr.loadScriptingEngine("ecmascript");
            BsfEngine fe = (BsfEngine)fesiEngine;
            JSGlobalObject g = fe.getJSGlobalObject();
            Object r = g.getMember("viaScript");
            BSFTest.checkResult(r, new Double(12.3));
        }
        catch (BSFException ex) {
            System.out.println("Error testing BSF");
            ex.printStackTrace();
            System.exit(1);
        }
        catch (JSException ex) {
            System.out.println("Error testing BSF");
            ex.printStackTrace();
            System.exit(1);
        }
        System.out.println("BSFTest completed successfully");
    }

    private static void checkResult(Object result, Object expected) {
        if (!expected.equals(result)) {
            throw new RuntimeException("BSF test failed, expected " + expected + " of class " + result.getClass().getName() + ", got " + result + " of class " + result.getClass().getName());
        }
    }

    public static class BsfTestBean {
        public int value;
    }
}

