/*
 * Decompiled with CFR 0.152.
 */
package FESI.Interpreter;

import FESI.Data.ESObject;
import FESI.Data.ESReference;
import FESI.Data.ESValue;
import FESI.Exceptions.EcmaScriptException;
import FESI.Interpreter.Evaluator;

public class ScopeChain {
    private ScopeChain previousElement;
    private ESObject thisElement;

    ScopeChain(ESObject thisElement, ScopeChain previousElement) {
        this.previousElement = previousElement;
        this.thisElement = thisElement;
    }

    ScopeChain previousScope() {
        return this.previousElement;
    }

    public ESReference getReference(String identifier) throws EcmaScriptException {
        return this.getReference(identifier, identifier.hashCode());
    }

    public ESReference getReference(String identifier, int hash) throws EcmaScriptException {
        ScopeChain theChain = this;
        do {
            if (!theChain.thisElement.hasProperty(identifier, hash)) continue;
            return new ESReference(theChain.thisElement, identifier, hash);
        } while ((theChain = theChain.previousElement) != null);
        return new ESReference(null, identifier, hash);
    }

    public ESValue getValue(String identifier) throws EcmaScriptException {
        return this.getValue(identifier, identifier.hashCode());
    }

    public ESValue getValue(String identifier, int hash) throws EcmaScriptException {
        return this.thisElement.getPropertyInScope(identifier, this.previousElement, hash);
    }

    public ESValue doIndirectCall(Evaluator evaluator, ESObject thisObject, String functionName, int hash, ESValue[] arguments) throws EcmaScriptException {
        return this.thisElement.doIndirectCallInScope(evaluator, this.previousElement, thisObject, functionName, hash, arguments);
    }
}

