/*
 * Decompiled with CFR 0.152.
 */
package FESI.Interpreter;

import FESI.Data.ESLoader;
import FESI.Exceptions.EcmaScriptException;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class LocalClassLoader
extends ClassLoader {
    public static final String urlPrefix = "FESI";
    public static final String resourceName = "fesiresource";
    private static Hashtable loadersByCookie = new Hashtable();
    private static Hashtable loadersByFilename = new Hashtable();
    private static final String protocolPathProp = "java.protocol.handler.pkgs";
    private static int cookieCount = 1;
    private static char fileSep = System.getProperty("file.separator", "/").charAt(0);
    private boolean asJar;
    private String myCookie;
    private ZipFile zipFile = null;
    private File directoryFile = null;

    private LocalClassLoader(File dir) {
        this.directoryFile = dir;
        this.asJar = false;
        this.myCookie = "fcl" + cookieCount++;
        loadersByCookie.put(this.myCookie, this);
        if (ESLoader.isDebugLoader()) {
            System.out.println(" ** New class loader: " + this);
        }
    }

    private LocalClassLoader(ZipFile zipFile) {
        this.asJar = true;
        this.zipFile = zipFile;
        this.myCookie = "fcl" + cookieCount++;
        loadersByCookie.put(this.myCookie, this);
        if (ESLoader.isDebugLoader()) {
            System.out.println(" ** New class loader: " + this);
        }
    }

    public static synchronized LocalClassLoader makeLocalClassLoader(String filename) throws EcmaScriptException {
        LocalClassLoader loader = null;
        boolean asJar = false;
        File file = new File(filename);
        String fullname = null;
        if (file.isFile()) {
            try {
                fullname = file.getCanonicalPath();
            }
            catch (IOException e) {
                fullname = file.getAbsolutePath();
            }
            loader = (LocalClassLoader)loadersByFilename.get(fullname);
            if (loader == null) {
                ZipFile zipFile = null;
                try {
                    zipFile = new ZipFile(fullname);
                }
                catch (IOException e) {
                    throw new EcmaScriptException("IO Error opening zip file '" + fullname + "' : " + e);
                }
                loader = new LocalClassLoader(zipFile);
                loadersByFilename.put(fullname, loader);
            } else if (ESLoader.isDebugLoader()) {
                System.out.println(" ** loader in cache: " + loader);
            }
        } else if (file.isDirectory()) {
            try {
                fullname = file.getCanonicalPath();
            }
            catch (IOException e) {
                fullname = file.getAbsolutePath();
            }
            loader = (LocalClassLoader)loadersByFilename.get(fullname);
            if (loader == null) {
                loader = new LocalClassLoader(file);
                loadersByFilename.put(fullname, loader);
            } else if (ESLoader.isDebugLoader()) {
                System.out.println(" ** loader in cache: " + loader);
            }
        } else {
            throw new EcmaScriptException("No file or directory '" + filename + "' found");
        }
        return loader;
    }

    public Class loadClass(String name) throws ClassNotFoundException {
        return this.loadClass(name, true);
    }

    public Class loadClass(String classname, boolean resolve) throws ClassNotFoundException {
        try {
            Class<?> c = this.findLoadedClass(classname);
            if (c == null) {
                try {
                    c = this.findSystemClass(classname);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (c == null) {
                String asEntryName = classname.replace('.', this.asJar ? (char)'/' : (char)fileSep) + ".class";
                byte[] classbytes = this.getResourceBuffer(asEntryName);
                if (classbytes == null) {
                    if (ESLoader.isDebugLoader()) {
                        System.out.println(" ** class '" + classname + "' not loaded");
                    }
                    throw new ClassNotFoundException("Class '" + classname + "' not foud by " + this);
                }
                if (ESLoader.isDebugLoader()) {
                    System.out.println(" ** class '" + classname + "' loaded");
                }
                c = this.defineClass(classname, classbytes, 0, classbytes.length);
            }
            if (resolve) {
                this.resolveClass(c);
            }
            return c;
        }
        catch (Exception e) {
            if (ESLoader.isDebugLoader()) {
                System.out.println(" ** Error loading '" + classname + "' by loader: " + this + ", " + e);
            }
            throw new ClassNotFoundException(e.toString());
        }
    }

    public URL getResource(String name) {
        URL url;
        block6: {
            if (ESLoader.isDebugLoader()) {
                System.out.println(" ** getResource: '" + name + "' asked to: " + this);
            }
            if ((url = LocalClassLoader.getSystemResource(name)) != null) {
                if (ESLoader.isDebugLoader()) {
                    System.out.println(" ** URL found in system as: " + url);
                }
                return url;
            }
            try {
                url = new URL(resourceName, null, "/FESI" + this.myCookie + "/+/" + name);
                if (ESLoader.isDebugLoader()) {
                    System.out.println(" ** URL found as " + url);
                }
            }
            catch (MalformedURLException e) {
                if (!ESLoader.isDebugLoader()) break block6;
                System.out.println(" ** Bad URL " + url + " " + e);
            }
        }
        return url;
    }

    public InputStream getResourceAsStream(String name) {
        InputStream back;
        if (ESLoader.isDebugLoader()) {
            System.out.println(" ** getResourceAsStream: '" + name + "' asked to: " + this);
        }
        if ((back = LocalClassLoader.getSystemResourceAsStream(name)) != null) {
            if (ESLoader.isDebugLoader()) {
                System.out.println(" ** getResourceAsStream(" + name + ") is a system resource");
            }
            return back;
        }
        return this.getLocalResourceAsStream(name);
    }

    private byte[] getResourceBuffer(String name) {
        byte[] buf = null;
        if (ESLoader.isDebugLoader()) {
            System.out.println(" ** getResourceBuffer, resource '" + name + "'");
        }
        if (this.asJar) {
            ZipEntry zipEntry = this.zipFile.getEntry(name);
            if (zipEntry == null) {
                if (ESLoader.isDebugLoader()) {
                    System.out.println(" ** Resource '" + name + "'not found in jar by: " + this);
                }
                return null;
            }
            try {
                int ct;
                InputStream inputStream = this.zipFile.getInputStream(zipEntry);
                int limit = (int)zipEntry.getSize();
                buf = new byte[limit];
                for (int total = 0; total < limit; total += ct) {
                    ct = inputStream.read(buf, total, limit - total);
                    if (ct != 0) continue;
                    if (ESLoader.isDebugLoader()) {
                        System.out.println(" ** Error read entry '" + name + "' in jar, loader: " + this);
                        System.out.println("Only " + total + " bytes out of " + limit + " read from entry '" + name + "' in jar '" + this.zipFile.getName() + "'");
                    }
                    throw new IOException("Only " + total + " bytes out of " + limit + " read from entry '" + name + "' in jar '" + this.zipFile.getName() + "'");
                }
                inputStream.close();
            }
            catch (IOException e) {
                if (ESLoader.isDebugLoader()) {
                    System.out.println(" ** Error reading jar: " + e);
                }
                return null;
            }
        }
        try {
            File f = new File(this.directoryFile, name);
            int length = (int)f.length();
            buf = new byte[length];
            DataInputStream in = new DataInputStream(new FileInputStream(f));
            in.readFully(buf);
            in.close();
        }
        catch (IOException e) {
            if (ESLoader.isDebugLoader()) {
                System.out.println(" ** Error reading file: " + e);
            }
            return null;
        }
        return buf;
    }

    private Object getLocalResource(String name) {
        byte[] buf;
        if (ESLoader.isDebugLoader()) {
            System.out.println(" ** getLocalResource, resource '" + name + "' asked to: " + this);
        }
        if ((buf = this.getResourceBuffer(name)) == null) {
            return null;
        }
        if (name.endsWith(".gif") || name.endsWith(".jpeg")) {
            Image image = Toolkit.getDefaultToolkit().createImage(buf);
            if (ESLoader.isDebugLoader()) {
                System.out.println(" ** Returning image resource: " + image);
            }
            return image;
        }
        ByteArrayInputStream s = new ByteArrayInputStream(buf);
        if (ESLoader.isDebugLoader()) {
            System.out.println(" ** Returning stream resource: " + s);
        }
        return s;
    }

    private InputStream getLocalResourceAsStream(String name) {
        block11: {
            if (ESLoader.isDebugLoader()) {
                System.out.println(" ** getLocalResourceAsStream,  resource '" + name + "' asked to: " + this);
            }
            if (this.asJar) {
                try {
                    ZipEntry zipEntry = this.zipFile.getEntry(name);
                    if (zipEntry != null) {
                        InputStream inputStream = this.zipFile.getInputStream(zipEntry);
                        if (ESLoader.isDebugLoader()) {
                            System.out.println(" ** Resource found, returned as stream: " + inputStream);
                        }
                        return inputStream;
                    }
                    break block11;
                }
                catch (Exception e) {
                    if (ESLoader.isDebugLoader()) {
                        System.out.println(" ** Exception when loading resource: " + name + ": " + e);
                    }
                    break block11;
                }
            }
            File f = new File(this.directoryFile, name);
            try {
                FileInputStream inputStream = new FileInputStream(f);
                if (ESLoader.isDebugLoader()) {
                    System.out.println(" ** Resource found, returned as stream: " + inputStream);
                }
                return inputStream;
            }
            catch (IOException e) {
                if (!ESLoader.isDebugLoader()) break block11;
                System.out.println(" ** Exception when loading resource: " + name + ": " + e);
            }
        }
        if (ESLoader.isDebugLoader()) {
            System.out.println(" ** Resource not found: " + name);
        }
        return null;
    }

    public static InputStream getLocalResourceAsStream(String cookie, String name) {
        LocalClassLoader cl;
        if (ESLoader.isDebugLoader()) {
            System.out.println(" ** static getLocalResourceAsStream, cookie: " + cookie + ", resource: " + name);
        }
        if ((cl = (LocalClassLoader)loadersByCookie.get(cookie)) == null) {
            if (ESLoader.isDebugLoader()) {
                System.err.println(" @@ LocalClassLoader cookie: " + cookie + " NOT FOUND !");
            }
            return null;
        }
        if (ESLoader.isDebugLoader()) {
            System.out.println(" ** Classloader found: " + cl);
        }
        return cl.getLocalResourceAsStream(name);
    }

    public static Object getLocalResource(String cookie, String name) {
        LocalClassLoader cl;
        if (ESLoader.isDebugLoader()) {
            System.out.println(" ** static getLocalResource, cookie: " + cookie + ", resource: " + name);
        }
        if ((cl = (LocalClassLoader)loadersByCookie.get(cookie)) == null) {
            if (ESLoader.isDebugLoader()) {
                System.out.println(" @@ LocalClassLoader cookie: " + cookie + " NOT FOUND !");
            }
            return null;
        }
        if (ESLoader.isDebugLoader()) {
            System.out.println(" ** Classloader found: " + cl);
        }
        return cl.getLocalResource(name);
    }

    public String toString() {
        return "LocalClassLoader[" + this.myCookie + "]:" + (this.asJar ? "JAR='" + this.zipFile.getName() : "DIR='" + this.directoryFile) + "'";
    }

    static {
        Properties newP = new Properties(System.getProperties());
        newP.put(protocolPathProp, newP.getProperty(protocolPathProp) + "|FESI.Interpreter");
        System.setProperties(newP);
    }
}

