/*
 * Decompiled with CFR 0.152.
 */
package FESI.Interpreter;

import FESI.Data.ArrayPrototype;
import FESI.Data.ESLoader;
import FESI.Data.ESObject;
import FESI.Data.ESString;
import FESI.Data.ESUndefined;
import FESI.Data.ESValue;
import FESI.Data.ESWrapper;
import FESI.Data.GlobalObject;
import FESI.Data.ValueDescription;
import FESI.Exceptions.EcmaScriptException;
import FESI.Extensions.BasicIOInterface;
import FESI.Extensions.OptionalRegExp;
import FESI.Interpreter.Command;
import FESI.Interpreter.Evaluator;
import FESI.Interpreter.FileEvaluationSource;
import FESI.gui.Console;
import FESI.gui.GuiFactory;
import FESI.gui.InterpreterCommands;
import FESI.gui.MessageBox;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.StringTokenizer;

public class Interpret
implements InterpreterCommands {
    protected static final InputStream originalIn = System.in;
    protected static final PrintStream originalOut = System.out;
    protected static final PrintStream originalErr = System.err;
    protected InputStream inputStream = System.in;
    protected PrintStream printStream = System.out;
    protected PrintStream errorStream = System.err;
    private boolean versionPrinted = false;
    protected boolean interactive = false;
    protected boolean windowOnly = false;
    protected boolean isAWT = true;
    protected boolean anyError = false;
    protected boolean anyMainTest = false;
    private static String eol = System.getProperty("line.separator", "\n");
    protected ESObject document = null;
    protected Evaluator evaluator = new Evaluator();
    protected DataInputStream lineReader = null;
    protected GuiFactory guiFactory = null;
    protected Console console = null;
    protected ESValue lastResult = null;
    protected long timeOfEval = 0L;
    protected long startTime = 0L;
    protected ESValue theValue = ESUndefined.theUndefined;
    protected String[] esArgs = new String[0];
    protected String regularExpressionExtensionName = "FESI.Extensions.OptionalRegExp";

    public Interpret() {
        this.setupCommands();
    }

    protected void errorExit() {
        System.exit(1);
    }

    public void exit() {
        System.exit(this.anyError ? 1 : 0);
    }

    void clearLastResult() {
        this.lastResult = null;
    }

    protected void loadCommonExtensions() {
        try {
            this.evaluator.addMandatoryExtension("FESI.Extensions.JavaAccess");
        }
        catch (EcmaScriptException e) {
            this.errorStream.println("Cannot initialize JavaAccess - exiting: " + eol + e);
            e.printStackTrace();
            this.errorExit();
        }
        try {
            this.evaluator.addMandatoryExtension("FESI.Extensions.Database");
        }
        catch (EcmaScriptException e) {
            this.errorStream.println("Cannot initialize Database - exiting: " + eol + e);
            e.printStackTrace();
            this.errorExit();
        }
        if (!OptionalRegExp.hasLoadedRegExp()) {
            try {
                this.evaluator.addMandatoryExtension(this.regularExpressionExtensionName);
            }
            catch (EcmaScriptException e) {
                this.errorStream.println("Cannot initialize " + this.regularExpressionExtensionName + " - exiting: " + eol + e);
                e.printStackTrace();
                this.errorExit();
            }
        }
    }

    protected void reset() throws EcmaScriptException {
        if (this.windowOnly && this.console != null) {
            if (this.isAWT) {
                System.setIn(originalIn);
                System.setOut(originalOut);
                System.setErr(originalErr);
                this.inputStream = originalIn;
                this.printStream = originalOut;
                this.errorStream = originalErr;
                this.console.dispose();
                this.console = null;
            } else {
                this.console.clear();
            }
        }
        this.evaluator.reset();
        if (this.windowOnly && this.isAWT) {
            BasicIOInterface basicIOw = null;
            try {
                basicIOw = (BasicIOInterface)this.evaluator.addMandatoryExtension("FESI.Extensions.BasicIOw");
            }
            catch (EcmaScriptException e) {
                this.errorStream.println("Cannot initialize BasicIOw - exiting: " + eol + e);
                e.printStackTrace();
                this.errorExit();
            }
            this.document = basicIOw.getDocument();
        } else if (this.windowOnly && !this.isAWT) {
            BasicIOInterface basicIOs = null;
            try {
                basicIOs = (BasicIOInterface)this.evaluator.addMandatoryExtension("FESI.Extensions.BasicIOs");
            }
            catch (EcmaScriptException e) {
                this.errorStream.println("Cannot initialize BasicIOs - exiting: " + eol + e);
                e.printStackTrace();
                this.errorExit();
            }
            this.document = basicIOs.getDocument();
        } else {
            BasicIOInterface basicIO = null;
            try {
                basicIO = (BasicIOInterface)this.evaluator.addMandatoryExtension("FESI.Extensions.BasicIO");
            }
            catch (EcmaScriptException e) {
                this.errorStream.println("Cannot initialize BasicIO - exiting: " + eol + e);
                e.printStackTrace();
                this.errorExit();
            }
            this.document = basicIO.getDocument();
        }
        this.loadCommonExtensions();
        if (this.windowOnly && this.interactive) {
            if (this.console == null) {
                try {
                    this.guiFactory = this.isAWT ? (GuiFactory)Class.forName("FESI.awtgui.AwtGuiFactory").newInstance() : (GuiFactory)Class.forName("FESI.swinggui.SwingGuiFactory").newInstance();
                }
                catch (ClassNotFoundException ex) {
                    this.errorStream.println("Cannot load GUI - exiting: " + eol + ex);
                    ex.printStackTrace();
                    this.errorExit();
                }
                catch (IllegalAccessException ex) {
                    this.errorStream.println("Cannot load GUI - exiting: " + eol + ex);
                    ex.printStackTrace();
                    this.errorExit();
                }
                catch (InstantiationException ex) {
                    this.errorStream.println("Cannot load GUI - exiting: " + eol + ex);
                    ex.printStackTrace();
                    this.errorExit();
                }
            }
            this.console = this.guiFactory.makeConsole(this, this.getTitle(), 25, 80);
            this.inputStream = this.console.getConsoleIn();
            this.printStream = this.console.getConsoleOut();
            this.errorStream = this.console.getConsoleOut();
            this.lineReader = new DataInputStream(this.inputStream);
            System.setIn(this.inputStream);
            System.setOut(this.printStream);
            System.setErr(this.errorStream);
        } else if (this.interactive) {
            this.lineReader = new DataInputStream(this.inputStream);
        }
        try {
            this.evaluator.addMandatoryExtension("FESI.Extensions.FileIO");
        }
        catch (EcmaScriptException e) {
            this.errorStream.println("Cannot initialize FileIO - exiting: " + eol + e);
            e.printStackTrace();
            this.errorExit();
        }
        if (this.interactive) {
            this.printVersion();
        }
    }

    protected void printVersion() {
        this.printStream.println(Evaluator.getWelcomeText());
        this.versionPrinted = true;
    }

    public void displayAboutText() {
        this.printAbout();
    }

    protected String getTitle() {
        return "FESI - EcmaScript interpreter";
    }

    protected void printAbout() {
        this.printVersion();
        this.printStream.println();
        this.printStream.println("Provided 'as is', use at your own risk, no support available.");
        this.printStream.println("Can be freely used and redistributed as long as this notice is included.");
        this.printStream.println("Feedback may be sent to 'jmlugrin@worldcom.ch', but I may not");
        this.printStream.println("be able (or willing) to answer all mails.");
    }

    protected void finalMessage(String str) {
        if (this.windowOnly && this.guiFactory != null) {
            MessageBox mb = this.guiFactory.displayMessageBox("FESI Error", str);
            mb.waitOK();
        } else {
            this.errorStream.println(str);
        }
    }

    protected void usage() {
        this.errorStream.println("usage: fesi [-waivD] [-e ext] [-T file] [-h file] [-f file] [-m module] [-o outfile] file -A ...");
        this.errorStream.println("      -w  Use message box for alert and AWT GUI if interactive");
        this.errorStream.println("      -s  As -w, but use Swing instead of AWT");
        this.errorStream.println("      -i  Start interactive read-eval-print loop");
        this.errorStream.println("      -v  display version even if not interactive");
        this.errorStream.println("      -e ext   Load the extension class ext");
        this.errorStream.println("      -R ext   Load the specified regular expression extension");
        this.errorStream.println("      -T file   Process an estest file, exit 1 if any failure");
        this.errorStream.println("      -h file   Expand the script in an html file");
        this.errorStream.println("      -D  turnon all debug flags");
        this.errorStream.println("      -f file   Load and execute the specified file");
        this.errorStream.println("      -m module Load and execute the specified module from FESI.path");
        this.errorStream.println("      -o file   Redirect standard output to that file");
        this.errorStream.println("      file  Load file in editor or interpret it");
        this.errorStream.println("      --  Standard input to load (loaded last if not present)");
        this.errorStream.println("      -A...  Remaining arguments are for EcmaScript args[]");
        this.errorStream.println("  By default silently interprets stdin");
        this.errorStream.println();
    }

    public void doWork(String[] args) {
        char c;
        int j;
        String arg;
        int i;
        boolean someFileLoaded = false;
        block17: for (i = 0; i < args.length; ++i) {
            arg = args[i];
            if (!arg.startsWith("-")) continue;
            for (j = 1; j < arg.length(); ++j) {
                c = arg.charAt(j);
                if (c == 'i') {
                    this.interactive = true;
                    continue;
                }
                if (c == 'w') {
                    this.windowOnly = true;
                    continue;
                }
                if (c == 's') {
                    this.windowOnly = true;
                    this.isAWT = false;
                    continue;
                }
                if (c == 'R') {
                    if (j < arg.length() - 1) {
                        if (!this.windowOnly) {
                            this.usage();
                        }
                        this.finalMessage("-R must be last option in '-' string");
                        if (this.interactive) {
                            this.errorExit();
                        }
                        return;
                    }
                    if (i + 1 >= args.length) {
                        if (!this.windowOnly) {
                            this.usage();
                        }
                        this.finalMessage("-R requires a file parameter");
                        if (this.interactive) {
                            this.errorExit();
                        }
                        return;
                    }
                    this.regularExpressionExtensionName = args[++i];
                    continue block17;
                }
                if (c == 'A') break block17;
            }
        }
        try {
            this.reset();
        }
        catch (EcmaScriptException e) {
            this.errorStream.println("[[Error during initialization: " + e.getMessage() + "]]");
            e.printStackTrace();
            return;
        }
        block19: for (i = 0; i < args.length; ++i) {
            arg = args[i];
            if (!arg.startsWith("-") || arg.equals("--")) continue;
            for (j = 1; j < arg.length(); ++j) {
                c = arg.charAt(j);
                if (c == 'o') {
                    if (j < arg.length() - 1) {
                        if (!this.windowOnly) {
                            this.usage();
                        }
                        this.finalMessage("-o must be last option in '-' string");
                        if (this.interactive) {
                            this.errorExit();
                        }
                        return;
                    }
                    if (i < args.length) {
                        String fileName = args[++i];
                        File outFile = new File(fileName);
                        try {
                            this.printStream = new PrintStream(new FileOutputStream(outFile));
                            System.setOut(this.printStream);
                            continue block19;
                        }
                        catch (IOException e) {
                            this.finalMessage("[[IO Error creating output file' " + fileName + "']]" + eol + "[[IO Error: " + e.getMessage() + "]]");
                            if (this.interactive) {
                                this.errorExit();
                            }
                            return;
                        }
                    }
                    if (!this.windowOnly) {
                        this.usage();
                    }
                    this.finalMessage("-o requires a file parameter");
                    if (this.interactive) {
                        this.errorExit();
                    }
                    return;
                }
                if (c == 'i') continue;
                if (c == 'D') {
                    ESLoader.setDebugJavaAccess(true);
                    ESLoader.setDebugLoader(true);
                    ESWrapper.setDebugEvent(true);
                    this.evaluator.setDebugParse(true);
                    continue;
                }
                if (c == 'v') {
                    if (this.versionPrinted) continue;
                    this.printVersion();
                    continue;
                }
                if (c == 'w' || c == 's') continue;
                if (c == 'e') {
                    if (j < arg.length() - 1) {
                        if (!this.windowOnly) {
                            this.usage();
                        }
                        this.finalMessage("-e must be last option in '-' string");
                        if (this.interactive) {
                            this.errorExit();
                        }
                        return;
                    }
                    if (i + 1 >= args.length) {
                        if (!this.windowOnly) {
                            this.usage();
                        }
                        this.finalMessage("-e requires a file parameter");
                        if (this.interactive) {
                            this.errorExit();
                        }
                        return;
                    }
                    ++i;
                    continue block19;
                }
                if (c == 'T') {
                    if (j < arg.length() - 1) {
                        if (!this.windowOnly) {
                            this.usage();
                        }
                        this.finalMessage("-T must be last option in '-' string");
                        if (this.interactive) {
                            this.errorExit();
                        }
                        return;
                    }
                    if (i + 1 >= args.length) {
                        if (!this.windowOnly) {
                            this.usage();
                        }
                        this.finalMessage("-T requires a file parameter");
                        if (this.interactive) {
                            this.errorExit();
                        }
                        return;
                    }
                    ++i;
                    continue block19;
                }
                if (c == 'R') {
                    ++i;
                    continue block19;
                }
                if (c == 'f') {
                    if (j < arg.length() - 1) {
                        if (!this.windowOnly) {
                            this.usage();
                        }
                        this.finalMessage("-f must be last option in '-' string");
                        if (this.interactive) {
                            this.errorExit();
                        }
                        return;
                    }
                    if (i + 1 >= args.length) {
                        if (!this.windowOnly) {
                            this.usage();
                        }
                        this.finalMessage("-f requires a file parameter");
                        if (this.interactive) {
                            this.errorExit();
                        }
                        return;
                    }
                    ++i;
                    continue block19;
                }
                if (c == 'm') {
                    if (j < arg.length() - 1) {
                        if (!this.windowOnly) {
                            this.usage();
                        }
                        this.finalMessage("-m must be last option in '-' string");
                        if (this.interactive) {
                            this.errorExit();
                        }
                        return;
                    }
                    if (i + 1 >= args.length) {
                        if (!this.windowOnly) {
                            this.usage();
                        }
                        this.finalMessage("-m requires a file parameter");
                        if (this.interactive) {
                            this.errorExit();
                        }
                        return;
                    }
                    ++i;
                    continue block19;
                }
                if (c == 'h') {
                    if (j < arg.length() - 1) {
                        if (!this.windowOnly) {
                            this.usage();
                        }
                        this.finalMessage("-h must be last option in '-' string");
                        if (this.interactive) {
                            this.errorExit();
                        }
                        return;
                    }
                    if (i + 1 >= args.length) {
                        if (!this.windowOnly) {
                            this.usage();
                        }
                        this.finalMessage("-h requires a file parameter");
                        if (this.interactive) {
                            this.errorExit();
                        }
                        return;
                    }
                    ++i;
                    continue block19;
                }
                if (c == 'A') {
                    if (j < arg.length() - 1) {
                        if (!this.windowOnly) {
                            this.usage();
                        }
                        this.finalMessage("-A must be last option in '-' string");
                        if (this.interactive) {
                            this.errorExit();
                        }
                        return;
                    }
                    int l = args.length - ++i;
                    this.esArgs = new String[l];
                    int k = 0;
                    while (i < args.length) {
                        this.esArgs[k] = args[i];
                        ++i;
                        ++k;
                    }
                    break block19;
                }
                if (!this.windowOnly) {
                    this.usage();
                }
                this.finalMessage("Unrecognize option '" + c + "' on command line");
                if (this.interactive) {
                    this.errorExit();
                }
                return;
            }
        }
        try {
            ESObject ap = this.evaluator.getArrayPrototype();
            ArrayPrototype argsArray = new ArrayPrototype(ap, this.evaluator);
            for (int i2 = 0; i2 < this.esArgs.length; ++i2) {
                argsArray.putProperty(i2, new ESString(this.esArgs[i2]));
            }
            GlobalObject go = this.evaluator.getGlobalObject();
            String ARGSstring = "args".intern();
            go.putProperty(ARGSstring, argsArray, ARGSstring.hashCode());
        }
        catch (EcmaScriptException e) {
            // empty catch block
        }
        block23: for (int i3 = 0; i3 < args.length; ++i3) {
            arg = args[i3];
            if (arg.startsWith("-") && !args.equals("--")) {
                for (int j2 = 1; j2 < arg.length(); ++j2) {
                    String fileName;
                    char c2 = arg.charAt(j2);
                    if (c2 == 'i' || c2 == 'v' || c2 == 'w' || c2 == 's' || c2 == 'D') continue;
                    if (c2 == 'o') {
                        ++i3;
                        continue block23;
                    }
                    if (c2 == 'R') {
                        ++i3;
                        continue block23;
                    }
                    if (c2 == 'T') {
                        fileName = args[++i3];
                        someFileLoaded = true;
                        this.doTest(fileName);
                        this.anyMainTest = true;
                        continue block23;
                    }
                    if (c2 == 'e') {
                        String extensionName = args[++i3];
                        try {
                            this.evaluator.addMandatoryExtension(extensionName);
                        }
                        catch (EcmaScriptException e) {
                            this.errorStream.println("Cannot load extension extensionName - exiting: " + eol + e);
                            this.errorExit();
                        }
                        continue block23;
                    }
                    if (c2 == 'f') {
                        fileName = args[++i3];
                        someFileLoaded = true;
                        this.doLoadFile(fileName);
                        continue block23;
                    }
                    if (c2 == 'm') {
                        String moduleName = args[++i3];
                        someFileLoaded = true;
                        this.doLoad(moduleName);
                        continue block23;
                    }
                    if (c2 == 'h') {
                        fileName = args[++i3];
                        someFileLoaded = true;
                        this.doExpand(fileName);
                        continue block23;
                    }
                    if (c2 == 'A') break block23;
                }
                continue;
            }
            String fileName = args[i3];
            if (fileName.equals("--")) {
                if (this.interactive) {
                    this.errorStream.println("Argument '--' not allowed in interactive mode");
                    this.errorExit();
                    continue;
                }
                someFileLoaded = true;
                try {
                    this.evaluator.evaluate(new BufferedReader(new InputStreamReader(System.in)), null, new FileEvaluationSource("<System.in>", null), false);
                    continue;
                }
                catch (EcmaScriptException e) {
                    this.finalMessage(e.getMessage() + eol + "[[Error loading file '" + fileName + "']]");
                    if (this.interactive) {
                        this.errorExit();
                    }
                    return;
                }
            }
            if (this.interactive && this.console.supportsEditing()) {
                this.console.createEditor(fileName);
                continue;
            }
            this.doLoad(fileName);
        }
        if (this.interactive) {
            this.printStream.println("Interactive read eval print loop - type @help for a list of commands");
            try {
                this.printStream.print("> ");
                this.printStream.flush();
                String line = this.lineReader.readLine();
                while (line != null) {
                    if (line.startsWith("@")) {
                        StringTokenizer st = new StringTokenizer(line);
                        String command = null;
                        String parameter = null;
                        command = st.nextToken().toLowerCase().trim();
                        if (st.hasMoreTokens()) {
                            parameter = st.nextToken().trim();
                        }
                        if (Command.executeCommand(this, this.printStream, command, parameter)) {
                        }
                    } else if (!line.equals("")) {
                        while (true) {
                            this.lastResult = null;
                            try {
                                this.startTime = System.currentTimeMillis();
                                this.theValue = this.evaluator.evaluate(line);
                                this.timeOfEval = System.currentTimeMillis() - this.startTime;
                                this.lastResult = this.theValue;
                                if (this.theValue == null) break;
                                this.printStream.println("@@ Result: " + this.theValue.toString());
                            }
                            catch (EcmaScriptException e) {
                                if (e.isIncomplete()) {
                                    this.printStream.print("More> ");
                                    this.printStream.flush();
                                    String moreLine = this.lineReader.readLine();
                                    if (moreLine != null) {
                                        if (moreLine.startsWith("@end")) {
                                            this.printStream.println("[[Error: " + e.getMessage() + "]]");
                                            break;
                                        }
                                        if (moreLine.startsWith("@")) {
                                            this.printStream.println("[[Only command @end allowed when reading script end]]");
                                            this.printStream.println("[[Command and script ignored]]");
                                            break;
                                        }
                                        line = line + eol + moreLine;
                                        continue;
                                    }
                                }
                                this.printStream.println("[[Error: " + e.getMessage() + "]]");
                            }
                            catch (Exception e) {
                                this.printStream.println("[[**Uncatched error: " + e + "]]");
                                e.printStackTrace();
                            }
                            break;
                        }
                    }
                    this.printStream.print("> ");
                    this.printStream.flush();
                    line = this.lineReader.readLine();
                }
            }
            catch (IOException e) {
                this.errorStream.println("[[IO error reading line: " + e + "]]");
                this.errorExit();
            }
        } else if (!someFileLoaded) {
            try {
                this.evaluator.evaluate(new BufferedReader(new InputStreamReader(System.in)), null, new FileEvaluationSource("<System.in>", null), false);
                someFileLoaded = true;
            }
            catch (EcmaScriptException e) {
                this.finalMessage(e.getMessage() + eol + "[[Error interpreting standard input]]");
                if (this.interactive) {
                    this.errorExit();
                }
                return;
            }
        }
        if (this.interactive || this.anyMainTest) {
            this.exit();
        }
    }

    protected void doPwd() {
        String ud = System.getProperty("user.dir", "");
        this.printStream.println("[[User directory: " + ud + "]]");
    }

    protected void doPath() {
        String pathSource = "FESI.path";
        String path = System.getProperty(pathSource, null);
        pathSource = "java.class.path";
        if (path == null) {
            path = System.getProperty("java.class.path", null);
        }
        if (path == null) {
            pathSource = "DEFAULT";
            path = ".";
        }
        this.printStream.println("[[Load path (" + pathSource + "): " + path + "]]");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doLoad(String moduleName) {
        if (moduleName == null || moduleName.equals("")) {
            this.printStream.println("[[Module name missing for @load.]]");
            return;
        }
        try {
            try {
                this.document.putHiddenProperty("URL", new ESString("module://" + moduleName));
            }
            catch (EcmaScriptException ignore) {
                // empty catch block
            }
            this.printStream.println("@@ Loading module '" + moduleName + "' . . .");
            this.startTime = System.currentTimeMillis();
            this.theValue = this.evaluator.evaluateLoadModule(moduleName);
            this.timeOfEval = System.currentTimeMillis() - this.startTime;
            this.lastResult = this.theValue;
            if (this.theValue != null) {
                this.printStream.println("@@ Resulting in: " + this.theValue);
            }
        }
        catch (EcmaScriptException e) {
            this.printStream.println("[[Error loading the module '" + moduleName + "']]");
            this.printStream.println("[[Error: " + e.getMessage() + "]]");
        }
        catch (Exception e) {
            this.printStream.println("[[**Uncatched error: " + e + "]]");
            e.printStackTrace();
        }
        finally {
            try {
                this.document.putHiddenProperty("URL", new ESString("module://<stdin>"));
            }
            catch (EcmaScriptException ignore) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void loadFile(String directoryName, String fileName) {
        File directory = new File(directoryName);
        File file = new File(directory, fileName);
        if (file.exists()) {
            try {
                try {
                    this.document.putHiddenProperty("URL", new ESString("file://" + file.getCanonicalPath()));
                }
                catch (EcmaScriptException ignore) {
                }
                catch (IOException ignore) {
                    // empty catch block
                }
                this.printStream.println("@@ Loading file '" + file.getPath() + "' . . .");
                this.theValue = this.evaluator.evaluateLoadFile(file);
                if (!this.interactive || this.theValue == null) return;
                this.printStream.println("@@ Resulting in: " + this.theValue);
                return;
            }
            catch (EcmaScriptException e) {
                this.errorStream.println(e.getMessage() + eol + "[[Error loading file' " + file.getPath() + "']]");
                return;
            }
            finally {
                try {
                    this.document.putHiddenProperty("URL", new ESString("file://<stdin>"));
                }
                catch (EcmaScriptException ignore) {}
            }
        }
        this.errorStream.println("[[File " + file.getPath() + " not found]]");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeString(String text, String source) {
        try {
            try {
                this.document.putHiddenProperty("URL", new ESString("source://" + source));
            }
            catch (EcmaScriptException ignore) {
                // empty catch block
            }
            this.printStream.println("@@ Executing '" + source + "' . . .");
            this.theValue = this.evaluator.evaluate(text, source);
            if (this.interactive && this.theValue != null) {
                this.printStream.println("@@ Resulting in: " + this.theValue);
            }
        }
        catch (EcmaScriptException e) {
            this.errorStream.println(e.getMessage() + eol + "[[Error executing '" + source + "']]");
            int n = e.getLineNumber();
            return n;
        }
        finally {
            try {
                this.document.putHiddenProperty("URL", new ESString("file://<stdin>"));
            }
            catch (EcmaScriptException ignore) {}
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void doLoadFile(String fileName) {
        File file = new File(fileName);
        if (!file.exists()) {
            file = new File(fileName + ".es");
        }
        if (!file.exists()) {
            file = new File(fileName + ".esw");
        }
        if (!file.exists()) {
            file = new File(fileName + ".js");
        }
        if (file.exists()) {
            try {
                try {
                    this.document.putHiddenProperty("URL", new ESString("file://" + file.getCanonicalPath()));
                }
                catch (EcmaScriptException ignore) {
                }
                catch (IOException ignore) {
                    // empty catch block
                }
                if (this.interactive) {
                    this.printStream.println("@@ Loading file '" + file.getPath() + "' . . .");
                }
                this.theValue = this.evaluator.evaluateLoadFile(file);
                if (!this.interactive || this.theValue == null) return;
                this.printStream.println("@@ Resulting in: " + this.theValue);
                return;
            }
            catch (EcmaScriptException e) {
                this.finalMessage(e.getMessage() + eol + "[[Error loading file' " + file.getPath() + "']]");
                if (this.interactive) return;
                this.errorExit();
                return;
            }
            finally {
                try {
                    this.document.putHiddenProperty("URL", new ESString("file://<stdin>"));
                }
                catch (EcmaScriptException ignore) {}
            }
        }
        this.finalMessage("File " + file.getPath() + " not found");
        if (!this.interactive) return;
        this.errorExit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void doExpand(String fileName) {
        block38: {
            BufferedReader lr;
            File file;
            block35: {
                if (fileName == null || fileName.equals("")) {
                    this.errorStream.println("[[File name missing for @expand.]]");
                    if (!this.interactive) {
                        this.errorExit();
                    }
                    return;
                }
                file = new File(fileName);
                if (!file.exists()) {
                    file = new File(fileName + ".html");
                }
                if (!file.exists()) {
                    file = new File(fileName + ".htm");
                }
                lr = null;
                this.document.putHiddenProperty("URL", new ESString("file://" + file.getAbsolutePath()));
                lr = new BufferedReader(new FileReader(file));
                if (this.interactive) {
                    this.printStream.println("@@ Expanding html file '" + file.getPath() + "' . . .");
                }
                boolean inScript = false;
                StringBuffer script = null;
                String src = lr.readLine();
                String srclc = src.toLowerCase();
                int lineNumber = 0;
                while (src != null) {
                    ++lineNumber;
                    if (inScript && srclc.indexOf("</script>") != -1) {
                        inScript = false;
                        this.evaluator.evaluate(script.toString());
                    } else if (inScript) {
                        script.append(src + eol);
                    } else if (srclc.indexOf("<script>") != -1) {
                        inScript = true;
                        script = new StringBuffer();
                    } else {
                        this.printStream.println(src);
                    }
                    src = lr.readLine();
                    srclc = src == null ? null : src.toLowerCase();
                }
                if (!inScript) break block35;
                this.errorStream.println("[[Error - end of file reached with openened <script>]]");
            }
            Object var10_12 = null;
            try {
                this.document.putHiddenProperty("URL", new ESString("file://<stdin>"));
            }
            catch (EcmaScriptException e2) {
                // empty catch block
            }
            if (lr != null) {
                try {
                    lr.close();
                }
                catch (IOException e2) {}
            }
            break block38;
            {
                catch (FileNotFoundException e) {
                    this.errorStream.println("[[File '" + fileName + "' not found.]]");
                    Object var10_13 = null;
                    try {
                        this.document.putHiddenProperty("URL", new ESString("file://<stdin>"));
                    }
                    catch (EcmaScriptException e2) {
                        // empty catch block
                    }
                    if (lr != null) {
                        try {
                            lr.close();
                        }
                        catch (IOException e2) {}
                    }
                    break block38;
                }
                catch (EcmaScriptException e) {
                    this.errorStream.println("[[Error expanding the file '" + file.getPath() + "']]");
                    this.errorStream.println("[[Error: " + e.getMessage() + "]]");
                    Object var10_14 = null;
                    try {
                        this.document.putHiddenProperty("URL", new ESString("file://<stdin>"));
                    }
                    catch (EcmaScriptException e2) {
                        // empty catch block
                    }
                    if (lr != null) {
                        try {
                            lr.close();
                        }
                        catch (IOException e2) {}
                    }
                    break block38;
                }
                catch (Exception e) {
                    this.errorStream.println("[[**Uncatched error: " + e + "]]");
                    e.printStackTrace(this.errorStream);
                    Object var10_15 = null;
                    try {
                        this.document.putHiddenProperty("URL", new ESString("file://<stdin>"));
                    }
                    catch (EcmaScriptException e2) {
                        // empty catch block
                    }
                    if (lr != null) {
                        try {
                            lr.close();
                        }
                        catch (IOException e2) {}
                    }
                }
            }
            catch (Throwable throwable) {
                Object var10_16 = null;
                try {
                    this.document.putHiddenProperty("URL", new ESString("file://<stdin>"));
                }
                catch (EcmaScriptException e2) {
                    // empty catch block
                }
                if (lr != null) {
                    try {
                        lr.close();
                    }
                    catch (IOException e2) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void doTest(String fileName) {
        int nErrors;
        int nSuccess;
        int nTests;
        block36: {
            Exception e2;
            BufferedReader lr;
            File file;
            block34: {
                block33: {
                    boolean success;
                    String scriptString;
                    if (fileName == null || fileName.equals("")) {
                        this.errorStream.println("[[File name missing for @test.]]");
                        if (!this.interactive) {
                            this.errorExit();
                        }
                        return;
                    }
                    file = new File(fileName);
                    if (!file.exists()) {
                        file = new File(fileName + ".estest");
                    }
                    lr = null;
                    nTests = 0;
                    nSuccess = 0;
                    nErrors = 0;
                    lr = new BufferedReader(new FileReader(file));
                    this.document.putHiddenProperty("URL", new ESString("file://" + file.getAbsolutePath()));
                    this.printStream.println("@@ Processing test file '" + file.getPath() + "' . . .");
                    String currentTest = null;
                    StringBuffer scriptBuffer = new StringBuffer();
                    String src = lr.readLine();
                    String srclc = src.toLowerCase();
                    int lineNumber = 0;
                    while (src != null) {
                        ++lineNumber;
                        if (srclc.startsWith("@test")) {
                            scriptString = new String(scriptBuffer);
                            if (currentTest != null) {
                                ++nTests;
                                success = this.testString(currentTest, scriptString, file);
                                if (success) {
                                    ++nSuccess;
                                } else {
                                    ++nErrors;
                                    this.anyError = true;
                                }
                            } else {
                                this.evaluator.evaluate(scriptString);
                            }
                            scriptBuffer = new StringBuffer();
                            currentTest = src;
                        } else {
                            scriptBuffer.append(src);
                            scriptBuffer.append("\n");
                        }
                        src = lr.readLine();
                        srclc = src == null ? null : src.toLowerCase();
                    }
                    if (currentTest == null) break block33;
                    ++nTests;
                    scriptString = new String(scriptBuffer);
                    success = this.testString(currentTest, scriptString, file);
                    if (success) {
                        ++nSuccess;
                        break block33;
                    }
                    ++nErrors;
                    this.anyError = true;
                }
                Object var15_17 = null;
                if (lr == null) break block34;
                try {
                    lr.close();
                }
                catch (IOException e2) {
                    // empty catch block
                }
            }
            try {
                this.document.putHiddenProperty("URL", new ESString("file://<stdin>"));
            }
            catch (EcmaScriptException e2) {}
            break block36;
            {
                catch (FileNotFoundException e3) {
                    this.errorStream.println("[[File '" + fileName + "' not found.]]");
                    Object var15_18 = null;
                    if (lr != null) {
                        try {
                            lr.close();
                        }
                        catch (IOException e2) {
                            // empty catch block
                        }
                    }
                    try {
                        this.document.putHiddenProperty("URL", new ESString("file://<stdin>"));
                    }
                    catch (EcmaScriptException e2) {}
                    break block36;
                }
                catch (EcmaScriptException e4) {
                    this.errorStream.println("[[Error expanding the file '" + file.getPath() + "']]");
                    this.errorStream.println("[[Error: " + e4.getMessage() + "]]");
                    Object var15_19 = null;
                    if (lr != null) {
                        try {
                            lr.close();
                        }
                        catch (IOException e2) {
                            // empty catch block
                        }
                    }
                    try {
                        this.document.putHiddenProperty("URL", new ESString("file://<stdin>"));
                    }
                    catch (EcmaScriptException e2) {}
                    break block36;
                }
                catch (Exception e5) {
                    this.errorStream.println("[[**Uncatched error: " + e5 + "]]");
                    e5.printStackTrace(this.errorStream);
                    Object var15_20 = null;
                    if (lr != null) {
                        try {
                            lr.close();
                        }
                        catch (IOException e2) {
                            // empty catch block
                        }
                    }
                    try {
                        this.document.putHiddenProperty("URL", new ESString("file://<stdin>"));
                    }
                    catch (EcmaScriptException e2) {}
                }
            }
            catch (Throwable throwable) {
                Object var15_21 = null;
                if (lr != null) {
                    try {
                        lr.close();
                    }
                    catch (IOException e2) {
                        // empty catch block
                    }
                }
                try {
                    this.document.putHiddenProperty("URL", new ESString("file://<stdin>"));
                }
                catch (EcmaScriptException e2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        this.printStream.println("@@ " + nTests + " tests, " + nSuccess + " successes, " + nErrors + " errors.");
    }

    protected boolean testString(String currentTest, String scriptString, File file) {
        this.printStream.println("@@ Testing " + currentTest);
        try {
            ESValue theValue = this.evaluator.evaluate(scriptString);
            if (theValue == null) {
                throw new EcmaScriptException("No value returned from @test");
            }
            boolean success = false;
            try {
                success = theValue.booleanValue();
            }
            catch (EcmaScriptException e) {
                throw new EcmaScriptException("@test did not return a boolean value");
            }
            if (!success) {
                throw new EcmaScriptException("@test did not return 'true'");
            }
            return true;
        }
        catch (Exception e) {
            this.printStream.println("[[Test " + currentTest + " in file " + file.getPath() + " failed]]");
            this.printStream.println("[[Error: " + e.getMessage() + "]]");
            return false;
        }
    }

    protected void printDetail() {
        if (this.lastResult == null) {
            this.printStream.println("** No last result available");
        } else {
            this.printStream.println("** Result: " + this.lastResult.toDetailString());
            this.printStream.println("** Evaluated in " + this.timeOfEval + " ms (note: +/-20 ms precision!)");
        }
    }

    protected void toggleDebugParse() {
        this.evaluator.setDebugParse(!this.evaluator.isDebugParse());
        this.printStream.println("@@ debugParse is now: " + this.evaluator.isDebugParse());
    }

    protected void toggleDebugJavaAccess() {
        ESLoader.setDebugJavaAccess(!ESLoader.isDebugJavaAccess());
        this.printStream.println("@@ debugJavaAccess is now: " + ESLoader.isDebugJavaAccess());
    }

    protected void toggleDebugLoader() {
        ESLoader.setDebugLoader(!ESLoader.isDebugLoader());
        this.printStream.println("@@ debugLoader is now: " + ESLoader.isDebugLoader());
    }

    protected void toggleDebugEvent() {
        ESWrapper.setDebugEvent(!ESWrapper.isDebugEvent());
        this.printStream.println("@@ debugJavaAccess is now: " + ESWrapper.isDebugEvent());
    }

    protected void listExtensions() {
        int i = 0;
        Enumeration e = this.evaluator.getExtensions();
        while (e.hasMoreElements()) {
            this.printStream.println(" " + e.nextElement());
            ++i;
        }
        this.printStream.println(" " + i + " extensions loaded");
    }

    public void displayHelpText() {
        this.printHelp();
    }

    protected void printHelp() {
        Command.printHelp(this.printStream);
    }

    protected void resetEvaluator() {
        try {
            this.printStream.println("@@ Reseting global object to default values");
            this.reset();
        }
        catch (EcmaScriptException e) {
            this.errorStream.println("[[Error during initialization: " + e.getMessage() + "]]");
            e.printStackTrace();
            return;
        }
    }

    protected void listMemory() {
        Runtime rt = Runtime.getRuntime();
        long fm = rt.freeMemory();
        long tm = rt.totalMemory();
        this.printStream.println("@@ Total memory: " + tm + ", free memory: " + fm);
    }

    protected void listProperties(String parameter) {
        ESObject listObject = this.evaluator.getGlobalObject();
        try {
            if (parameter != null) {
                ESValue listValue = this.evaluator.evaluate(parameter);
                if (!(listValue instanceof ESObject)) {
                    this.printStream.println("Cannot evaluate '" + parameter + "' to an object");
                    return;
                }
                listObject = (ESObject)listValue;
            }
            boolean directEnumeration = listObject.isDirectEnumerator();
            Enumeration e = listObject.getProperties();
            while (e.hasMoreElements()) {
                int ieol;
                String property = e.nextElement().toString();
                this.printStream.print(property);
                if (directEnumeration) continue;
                String propertyValue = listObject.getProperty(property, property.hashCode()).toString();
                while (propertyValue.indexOf("\n") == 0) {
                    propertyValue = propertyValue.substring(1);
                }
                while (propertyValue.indexOf(eol) == 0) {
                    propertyValue = propertyValue.substring(eol.length());
                }
                if (propertyValue.length() > 250) {
                    propertyValue = propertyValue.substring(0, 250) + "...";
                }
                if ((ieol = propertyValue.indexOf(eol)) == -1) {
                    ieol = propertyValue.indexOf("\n");
                }
                if (ieol != -1) {
                    propertyValue = propertyValue.substring(0, ieol) + "...";
                }
                this.printStream.println(": " + propertyValue);
            }
        }
        catch (Exception e) {
            this.printStream.println("Cannot evaluate '" + parameter + "' properties");
            this.printStream.println(e);
        }
    }

    protected void listAllProperties(String parameter) {
        ESObject listObject = this.evaluator.getGlobalObject();
        try {
            if (parameter != null) {
                ESValue listValue = this.evaluator.evaluate(parameter);
                if (!(listValue instanceof ESObject)) {
                    this.printStream.println("Cannot evaluate '" + parameter + "' to an object");
                    return;
                }
                listObject = (ESObject)listValue;
            }
            Enumeration e = listObject.getAllProperties();
            while (e.hasMoreElements()) {
                String property = e.nextElement().toString();
                ESValue propertyValue = listObject.getProperty(property, property.hashCode());
                this.printStream.println(propertyValue.getDescription(property));
            }
        }
        catch (Exception e) {
            this.printStream.println("Cannot evaluate '" + parameter + "' properties");
            this.printStream.println(e);
        }
    }

    protected void clearConsole() {
        if (this.console != null) {
            this.console.clear();
        }
    }

    protected void describe(String parameter) {
        ESValue toBeDescribed = this.evaluator.getGlobalObject();
        try {
            if (parameter != null) {
                toBeDescribed = this.evaluator.evaluate(parameter);
            } else {
                parameter = "global";
            }
            this.printStream.println(toBeDescribed.getDescription(parameter));
            if (toBeDescribed.isComposite()) {
                Enumeration e = toBeDescribed.getAllDescriptions();
                while (e.hasMoreElements()) {
                    ValueDescription description = (ValueDescription)e.nextElement();
                    this.printStream.println("   " + description.toString());
                }
            }
        }
        catch (Exception e) {
            this.printStream.println("Cannot evaluate '" + parameter + "'");
            this.printStream.println(e);
        }
    }

    protected void setupCommands() {
        new Command("about", "display general information"){

            boolean doCommand(Interpret interpreter, String parameter) {
                interpreter.printAbout();
                return false;
            }
        };
        new Command("clear", "Clear console output"){

            boolean doCommand(Interpret interpreter, String parameter) {
                interpreter.clearConsole();
                return false;
            }
        };
        new Command("debugEvent", "Toggle debug flag for event processing"){

            boolean doCommand(Interpret interpreter, String parameter) {
                interpreter.toggleDebugEvent();
                return false;
            }
        };
        new Command("debugLoader", "Toggle debug flag for dynamic loading"){

            boolean doCommand(Interpret interpreter, String parameter) {
                interpreter.toggleDebugLoader();
                return false;
            }
        };
        new Command("debugJavaAccess", "Toggle debug flag for java interfacing"){

            boolean doCommand(Interpret interpreter, String parameter) {
                interpreter.toggleDebugJavaAccess();
                return false;
            }
        };
        new Command("debugParse", "Toggle debug flag for parsing"){

            boolean doCommand(Interpret interpreter, String parameter) {
                interpreter.toggleDebugParse();
                return false;
            }
        };
        new Command("describe", "Display details on the value given as parameter"){

            boolean doCommand(Interpret interpreter, String parameter) {
                interpreter.describe(parameter);
                return false;
            }
        };
        new Command("detail", "Display details on last result of an evaluation"){

            boolean doCommand(Interpret interpreter, String parameter) {
                interpreter.printDetail();
                return false;
            }
        };
        new Command("exit", "Exit the interpreter"){

            boolean doCommand(Interpret interpreter, String parameter) {
                return true;
            }
        };
        new Command("expand", "Expand between <script></script> in an .html file"){

            boolean doCommand(Interpret interpreter, String parameter) {
                interpreter.clearLastResult();
                interpreter.doExpand(parameter);
                return false;
            }
        };
        new Command("extensions", "Display the list of loaded extensions"){

            boolean doCommand(Interpret interpreter, String parameter) {
                interpreter.listExtensions();
                return false;
            }
        };
        new Command("help", "Display the list of commands"){

            boolean doCommand(Interpret interpreter, String parameter) {
                interpreter.printHelp();
                return false;
            }
        };
        new Command("list", "List the enumerated properties of the object"){

            boolean doCommand(Interpret interpreter, String parameter) {
                interpreter.listProperties(parameter);
                return false;
            }
        };
        new Command("listAll", "List all properties of the object"){

            boolean doCommand(Interpret interpreter, String parameter) {
                interpreter.listAllProperties(parameter);
                return false;
            }
        };
        new Command("load", "Load a .js, .es or .esw file"){

            boolean doCommand(Interpret interpreter, String parameter) {
                interpreter.clearLastResult();
                interpreter.doLoadFile(parameter);
                return false;
            }
        };
        new Command("module", "Load a .js, .es or .esw file via the FESI.path"){

            boolean doCommand(Interpret interpreter, String parameter) {
                interpreter.clearLastResult();
                interpreter.doLoad(parameter);
                return false;
            }
        };
        new Command("memory", "Give information on available memory"){

            boolean doCommand(Interpret interpreter, String parameter) {
                interpreter.listMemory();
                return false;
            }
        };
        new Command("path", "Display the current load path"){

            boolean doCommand(Interpret interpreter, String parameter) {
                interpreter.doPath();
                return false;
            }
        };
        new Command("pwd", "Display the current user directory"){

            boolean doCommand(Interpret interpreter, String parameter) {
                interpreter.doPwd();
                return false;
            }
        };
        new Command("reset", "Restore the interpreter to the initial state"){

            boolean doCommand(Interpret interpreter, String parameter) {
                interpreter.clearLastResult();
                interpreter.resetEvaluator();
                return false;
            }
        };
        new Command("test", "Execute a test file (.estest)"){

            boolean doCommand(Interpret interpreter, String parameter) {
                interpreter.clearLastResult();
                interpreter.doTest(parameter);
                return false;
            }
        };
        new Command("version", "Display the version of the interpreter"){

            boolean doCommand(Interpret interpreter, String parameter) {
                interpreter.printVersion();
                return false;
            }
        };
    }

    public static void main(String[] args) {
        Interpret i = new Interpret();
        i.doWork(args);
    }
}

