/*
 * Decompiled with CFR 0.152.
 */
package FESI.Interpreter;

import FESI.ClassFile.EventAdaptorClassFile;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public final class EventAdaptorGenerator
extends ClassLoader {
    private static String packagePrefix = "FESI.ClassFile";
    private static String adaptorInfix = ".DYN_EE_ADAPTOR.";
    private static String adaptorClassNamePrefix = packagePrefix + adaptorInfix;
    private static EventAdaptorGenerator generator = new EventAdaptorGenerator();

    private boolean debug() {
        return false;
    }

    private EventAdaptorGenerator() {
    }

    private static Class loadClassNamed(String className) throws ClassNotFoundException {
        return generator.loadClass(className);
    }

    static Class getAdaptorClassForListenerClass(Class lc) throws ClassNotFoundException {
        return EventAdaptorGenerator.loadClassNamed(EventAdaptorGenerator.mapListenerNameToAdaptorName(lc.getName()));
    }

    static Class getAdaptorClassForListenerClass(String lcn) throws ClassNotFoundException {
        return EventAdaptorGenerator.loadClassNamed(EventAdaptorGenerator.mapListenerNameToAdaptorName(lcn));
    }

    protected Class loadClass(String className, boolean resolve) throws ClassNotFoundException {
        Class<?> c = this.findLoadedClass(className);
        if (this.debug()) {
            System.err.println("loadClass(" + className + ")");
        }
        if (c == null) {
            if (EventAdaptorGenerator.isAdaptorClassName(className)) {
                c = this.generateAdaptorClass(className);
            } else {
                try {
                    ClassLoader mycl = this.getClass().getClassLoader();
                    if (mycl != null) {
                        c = mycl.loadClass(className);
                    }
                    if (c == null) {
                        c = this.findSystemClass(className);
                    }
                }
                catch (NoClassDefFoundError ncdfe) {
                    throw new ClassNotFoundException(ncdfe.getMessage());
                }
            }
        }
        if (c != null) {
            if (resolve) {
                this.resolveClass(c);
            }
        } else {
            throw new ClassNotFoundException(className);
        }
        if (this.debug()) {
            System.err.println("loaded: " + c.getName());
        }
        return c;
    }

    private static String mapListenerNameToAdaptorName(String listenerName) {
        return adaptorClassNamePrefix + listenerName;
    }

    private static boolean isAdaptorClassName(String className) {
        return className.startsWith(adaptorClassNamePrefix);
    }

    public static String getBaseNameFromAdaptorName(String className) {
        return className != null && EventAdaptorGenerator.isAdaptorClassName(className) ? className.substring(adaptorClassNamePrefix.length()) : null;
    }

    private Class generateAdaptorClass(String className) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(512);
        byte[] cimpl = null;
        Class<?> clazz = null;
        if (this.debug()) {
            System.err.println("generateAdaptorClass(" + className + ")");
        }
        try {
            new EventAdaptorClassFile(className, baos);
        }
        catch (IOException ioe) {
            return null;
        }
        catch (ClassNotFoundException cnfe) {
            return null;
        }
        cimpl = baos.toByteArray();
        try {
            clazz = this.defineClass(className, cimpl, 0, cimpl.length);
        }
        catch (ClassFormatError ex) {
            System.err.println("Failed to define adaptor for " + className);
            System.err.println("Caught: " + ex);
            ex.printStackTrace();
        }
        return clazz;
    }
}

