/*
 * Decompiled with CFR 0.152.
 */
package FESI.Interpreter;

import FESI.AST.ASTProgram;
import FESI.AST.ASTStatement;
import FESI.AST.ASTStatementList;
import FESI.Data.ESLoader;
import FESI.Data.ESObject;
import FESI.Data.ESPackages;
import FESI.Data.ESReference;
import FESI.Data.ESUndefined;
import FESI.Data.ESValue;
import FESI.Data.ESWrapper;
import FESI.Data.GlobalObject;
import FESI.Data.JSGlobalWrapper;
import FESI.Exceptions.EcmaScriptException;
import FESI.Exceptions.EcmaScriptLexicalException;
import FESI.Exceptions.EcmaScriptParseException;
import FESI.Extensions.Extension;
import FESI.Interpreter.EcmaScriptEvaluateVisitor;
import FESI.Interpreter.EcmaScriptFunctionVisitor;
import FESI.Interpreter.EcmaScriptVariableVisitor;
import FESI.Interpreter.EvaluationSource;
import FESI.Interpreter.FileEvaluationSource;
import FESI.Interpreter.JarEvaluationSource;
import FESI.Interpreter.ParsedProgram;
import FESI.Interpreter.ScopeChain;
import FESI.Interpreter.StringEvaluationSource;
import FESI.Interpreter.UserEvaluationSource;
import FESI.Parser.EcmaScript;
import FESI.Parser.ParseException;
import FESI.Parser.TokenMgrError;
import FESI.jslib.JSException;
import FESI.jslib.JSExtension;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class Evaluator {
    private static String eol = System.getProperty("line.separator", "\n");
    private boolean debugParse = false;
    private GlobalObject globalObject = null;
    private ESObject objectPrototype = null;
    private ESObject functionPrototype = null;
    private ESObject functionObject = null;
    private ESObject stringPrototype = null;
    private ESObject numberPrototype = null;
    private ESObject booleanPrototype = null;
    private ESObject arrayPrototype = null;
    private ESObject datePrototype = null;
    private ESObject packageObject = null;
    private ScopeChain theScopeChain = null;
    private ESObject currentVariableObject = null;
    private ESObject currentThisObject = null;
    private EcmaScriptFunctionVisitor functionDeclarationVisitor = null;
    private EcmaScriptVariableVisitor varDeclarationVisitor = null;
    private Hashtable extensions = null;

    public static String getVersion() {
        return "1.1.8 (29-Sep-2003)";
    }

    public static String getWelcomeText() {
        return "FESI (pronounced like 'fuzzy'): an EcmaScript Interpreter" + eol + "Copyright (c) Jean-Marc Lugrin, 1998-2003 - Version: " + Evaluator.getVersion() + eol + "Running under " + System.getProperty("java.version") + " of " + System.getProperty("java.vendor");
    }

    protected void reset() {
        this.functionDeclarationVisitor = new EcmaScriptFunctionVisitor(this);
        this.varDeclarationVisitor = new EcmaScriptVariableVisitor(this);
        this.globalObject = GlobalObject.makeGlobalObject(this);
        this.packageObject = new ESPackages(this);
        this.extensions = new Hashtable();
    }

    public Evaluator() {
        this.reset();
    }

    public EcmaScriptVariableVisitor getVarDeclarationVisitor() {
        return this.varDeclarationVisitor;
    }

    public ESObject getThisObject() {
        return this.currentThisObject;
    }

    public GlobalObject getGlobalObject() {
        return this.globalObject;
    }

    public void setDebugParse(boolean dp) {
        this.debugParse = dp;
    }

    public boolean isDebugParse() {
        return this.debugParse;
    }

    public void setObjectPrototype(ESObject o) {
        this.objectPrototype = o;
    }

    public ESObject getObjectPrototype() {
        return this.objectPrototype;
    }

    public void setFunctionPrototype(ESObject o) {
        this.functionPrototype = o;
    }

    public ESObject getFunctionPrototype() {
        return this.functionPrototype;
    }

    public void setFunctionObject(ESObject o) {
        this.functionObject = o;
    }

    public ESObject getFunctionObject() {
        return this.functionObject;
    }

    public void setStringPrototype(ESObject o) {
        this.stringPrototype = o;
    }

    public ESObject getStringPrototype() {
        return this.stringPrototype;
    }

    public void setNumberPrototype(ESObject o) {
        this.numberPrototype = o;
    }

    public ESObject getNumberPrototype() {
        return this.numberPrototype;
    }

    public void setBooleanPrototype(ESObject o) {
        this.booleanPrototype = o;
    }

    public ESObject getBooleanPrototype() {
        return this.booleanPrototype;
    }

    public void setArrayPrototype(ESObject o) {
        this.arrayPrototype = o;
    }

    public ESObject getArrayPrototype() {
        return this.arrayPrototype;
    }

    public void setDatePrototype(ESObject o) {
        this.datePrototype = o;
    }

    public ESObject getDatePrototype() {
        return this.datePrototype;
    }

    public ESObject getPackageObject() {
        return this.packageObject;
    }

    public Extension getExtension(String name) {
        return (Extension)this.extensions.get(name);
    }

    public Enumeration getExtensions() {
        return this.extensions.keys();
    }

    public Object addExtension(String name) throws EcmaScriptException {
        Extension extension = this.getExtension(name);
        if (extension == null) {
            try {
                extension = Class.forName(name).newInstance();
                if (extension instanceof Extension) {
                    extension.initializeExtension(this);
                } else if (extension instanceof JSExtension) {
                    GlobalObject go = this.getGlobalObject();
                    JSGlobalWrapper jgo = new JSGlobalWrapper(go, this);
                    try {
                        ((JSExtension)((Object)extension)).initializeExtension(jgo);
                    }
                    catch (JSException e) {
                        return null;
                    }
                } else {
                    return null;
                }
                this.extensions.put(name, extension);
            }
            catch (ClassNotFoundException e) {
                extension = null;
            }
            catch (NoClassDefFoundError e) {
                extension = null;
            }
            catch (IllegalAccessException e) {
                extension = null;
            }
            catch (InstantiationException e) {
                extension = null;
            }
        }
        return extension;
    }

    public Object addMandatoryExtension(String name) throws EcmaScriptException {
        Extension extension = this.getExtension(name);
        if (extension == null) {
            try {
                extension = Class.forName(name).newInstance();
                if (extension instanceof Extension) {
                    extension.initializeExtension(this);
                } else if (extension instanceof JSExtension) {
                    GlobalObject go = this.getGlobalObject();
                    JSGlobalWrapper jgo = new JSGlobalWrapper(go, this);
                    try {
                        ((JSExtension)((Object)extension)).initializeExtension(jgo);
                    }
                    catch (JSException e) {
                        throw new EcmaScriptException("Error initializing extension " + name, e);
                    }
                } else {
                    throw new EcmaScriptException("Extenstion object " + name + " of wrong type " + extension.getClass());
                }
                this.extensions.put(name, extension);
            }
            catch (ClassNotFoundException e) {
                throw new EcmaScriptException("Error loading extension " + name, e);
            }
            catch (NoClassDefFoundError e) {
                throw new EcmaScriptException("Error loading extension " + name, e);
            }
            catch (IllegalAccessException e) {
                throw new EcmaScriptException("Error loading extension " + name, e);
            }
            catch (InstantiationException e) {
                throw new EcmaScriptException("Error loading extension " + name, e);
            }
        }
        return extension;
    }

    public Object addMandatoryExtension(String name, JSExtension extension) throws EcmaScriptException {
        GlobalObject go = this.getGlobalObject();
        JSGlobalWrapper jgo = new JSGlobalWrapper(go, this);
        try {
            extension.initializeExtension(jgo);
        }
        catch (JSException e) {
            throw new EcmaScriptException("Error initializing extension " + name, e);
        }
        this.extensions.put(name, extension);
        return extension;
    }

    public ESReference getReference(String identifier) throws EcmaScriptException {
        return this.theScopeChain.getReference(identifier);
    }

    public ESReference getReference(String identifier, int hash) throws EcmaScriptException {
        return this.theScopeChain.getReference(identifier, hash);
    }

    public ESValue getValue(String identifier) throws EcmaScriptException {
        return this.theScopeChain.getValue(identifier);
    }

    public ESValue getValue(String identifier, int hash) throws EcmaScriptException {
        return this.theScopeChain.getValue(identifier, hash);
    }

    public ESValue doIndirectCall(ESObject thisObject, String functionName, int hash, ESValue[] arguments) throws EcmaScriptException {
        return this.theScopeChain.doIndirectCall(this, thisObject, functionName, hash, arguments);
    }

    public void createVariable(String name, int hashCode) throws EcmaScriptException {
        if (!this.currentVariableObject.hasProperty(name, hashCode)) {
            ESReference newVar = new ESReference(this.currentVariableObject, name, hashCode);
            newVar.putValue(this.currentVariableObject, ESUndefined.theUndefined);
        }
    }

    public void putValue(ESReference leftValue, ESValue rightValue) throws EcmaScriptException {
        leftValue.putValue(this.globalObject, rightValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ESValue evaluateEvalString(String theSource) throws EcmaScriptException {
        ESValue theValue = ESUndefined.theUndefined;
        ASTProgram programNode = null;
        StringEvaluationSource es = new StringEvaluationSource(theSource, null);
        if (!theSource.endsWith("\n")) {
            theSource = theSource + "\n";
        }
        StringReader is = new StringReader(theSource);
        EcmaScript parser = new EcmaScript(is);
        try {
            programNode = (ASTProgram)parser.Program();
            if (this.debugParse) {
                System.out.println();
                System.out.println("Dump parse tree of eval (debugParse true)");
                programNode.dump("");
            }
        }
        catch (ParseException e) {
            if (this.debugParse) {
                System.out.println("[[PARSING ERROR DETECTED: (debugParse true)]]");
                System.out.println(e.getMessage());
                System.out.println("[[BY ROUTINE:]]");
                e.printStackTrace();
                System.out.println();
            }
            throw new EcmaScriptParseException(e, es);
        }
        catch (TokenMgrError e) {
            if (this.debugParse) {
                System.out.println("[[LEXICAL ERROR DETECTED: (debugParse true)]]");
                System.out.println(e.getMessage());
                System.out.println("[[BY ROUTINE:]]");
                e.printStackTrace();
                System.out.println();
            }
            throw new EcmaScriptLexicalException(e, es);
        }
        ESObject savedVariableObject = this.currentVariableObject;
        this.currentVariableObject = this.globalObject;
        try {
            this.functionDeclarationVisitor.processFunctionDeclarations(programNode, es);
            this.varDeclarationVisitor.processVariableDeclarations(programNode, (EvaluationSource)es);
            EcmaScriptEvaluateVisitor evaluationVisitor = new EcmaScriptEvaluateVisitor(this);
            theValue = evaluationVisitor.evaluateProgram(programNode, es);
            if (theValue == null) {
                theValue = ESUndefined.theUndefined;
            }
            if (evaluationVisitor.getCompletionCode() != 0) {
                throw new EcmaScriptException("Unexpected " + evaluationVisitor.getCompletionCodeString() + " in eval parameter top level");
            }
        }
        finally {
            this.currentVariableObject = savedVariableObject;
        }
        return theValue;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ESValue evaluateLoadFile(File file) throws EcmaScriptException {
        void var2_5;
        ESUndefined eSUndefined = ESUndefined.theUndefined;
        if (!file.isFile()) {
            throw new EcmaScriptException("File '" + file.getPath() + "' does not exist or is not a text file");
        }
        FileEvaluationSource es = new FileEvaluationSource(file.getPath(), null);
        FileReader fr = null;
        try {
            try {
                fr = new FileReader(file);
                ESValue eSValue = this.evaluate(fr, null, es, false);
                if (eSValue == null) {
                    ESUndefined eSUndefined2 = ESUndefined.theUndefined;
                }
            }
            catch (IOException e) {
                throw new EcmaScriptException("IO Error loading file " + file + ": " + e);
            }
            Object var7_8 = null;
            if (fr == null) return var2_5;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            if (fr == null) throw throwable;
            try {
                fr.close();
                throw throwable;
            }
            catch (IOException ignore) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException ignore) {}
        fr.close();
        return var2_5;
    }

    public ESValue evaluateLoadModule(String moduleName) throws EcmaScriptException {
        String tryPath;
        String lcModuleName;
        ESUndefined theValue = ESUndefined.theUndefined;
        if (moduleName == null) {
            throw new EcmaScriptException("Missing file or module name for load");
        }
        String path = System.getProperty("FESI.path", null);
        if (path == null) {
            path = System.getProperty("java.class.path", null);
        }
        ESValue value = ESUndefined.theUndefined;
        if (path == null) {
            File file = new File(moduleName);
            try {
                value = this.evaluateLoadFile(file);
            }
            catch (EcmaScriptParseException e) {
                e.setNeverIncomplete();
                throw e;
            }
        }
        boolean hasSuffix = (lcModuleName = moduleName.toLowerCase()).endsWith(".es") || lcModuleName.endsWith(".esw") || lcModuleName.endsWith(".js");
        String separator = System.getProperty("path.separator", ";");
        StringTokenizer st = new StringTokenizer(path, separator);
        while (st.hasMoreTokens() && (value = this.tryLoad(tryPath = st.nextToken(), moduleName, hasSuffix)) == null) {
        }
        if (value == null) {
            throw new EcmaScriptException("Module " + moduleName + " not found in " + path);
        }
        return value;
    }

    private ESValue tryLoad(String tryPath, String moduleName, boolean hasSuffix) throws EcmaScriptException {
        File dir = new File(tryPath);
        if (dir.isDirectory()) {
            File file;
            if (hasSuffix) {
                file = new File(dir, moduleName);
            } else {
                file = new File(dir, moduleName + ".es");
                if (!file.exists()) {
                    file = new File(dir, moduleName + ".esw");
                }
                if (!file.exists()) {
                    file = new File(dir, moduleName + ".js");
                }
            }
            if (!file.exists()) {
                return null;
            }
            try {
                String cp = file.getCanonicalPath();
            }
            catch (IOException e) {
                throw new EcmaScriptException("IO error accessing module " + moduleName + " in directory  " + dir, e);
            }
            return this.evaluateLoadFile(file);
        }
        if (dir.isFile()) {
            ZipEntry zipEntry;
            ZipFile zipFile;
            try {
                String cp = dir.getCanonicalPath();
                zipFile = new ZipFile(cp);
            }
            catch (IOException e) {
                return null;
            }
            if (hasSuffix) {
                zipEntry = zipFile.getEntry(moduleName);
            } else {
                zipEntry = zipFile.getEntry(moduleName + ".es");
                if (zipEntry == null) {
                    zipEntry = zipFile.getEntry(moduleName + ".esw");
                }
                if (zipEntry == null) {
                    zipEntry = zipFile.getEntry(moduleName + ".js");
                }
            }
            if (zipEntry == null) {
                return null;
            }
            byte[] buf = null;
            try {
                int ct;
                InputStream inputStream = zipFile.getInputStream(zipEntry);
                int limit = (int)zipEntry.getSize();
                buf = new byte[limit];
                for (int total = 0; total < limit; total += ct) {
                    ct = inputStream.read(buf, total, limit - total);
                    if (ct != 0) continue;
                    throw new IOException("Only " + total + " bytes out of " + limit + " read from entry '" + moduleName + "' in jar '" + zipFile.getName() + "'");
                }
                inputStream.close();
            }
            catch (IOException e) {
                if (ESLoader.isDebugLoader()) {
                    System.out.println(" ** Error reading jar: " + e);
                }
                return null;
            }
            JarEvaluationSource es = new JarEvaluationSource(dir.getPath(), moduleName, null);
            StringReader r = new StringReader(new String(buf));
            ESValue theValue = this.evaluate(r, null, es, false);
            if (theValue == null) {
                theValue = ESUndefined.theUndefined;
            }
            return theValue;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ESValue evaluateFunction(ASTStatementList node, EvaluationSource es, ESObject variableObject, Vector localVariableNames, ESObject thisObject) throws EcmaScriptException {
        ESValue theValue = ESUndefined.theUndefined;
        ESObject savedVariableObject = this.currentVariableObject;
        ESObject savedThisObject = this.currentThisObject;
        ScopeChain previousScopeChain = this.theScopeChain;
        this.currentVariableObject = variableObject;
        this.currentThisObject = thisObject;
        this.theScopeChain = new ScopeChain(this.globalObject, null);
        this.theScopeChain = new ScopeChain(variableObject, this.theScopeChain);
        try {
            Enumeration e = localVariableNames.elements();
            while (e.hasMoreElements()) {
                String variable = (String)e.nextElement();
                this.createVariable(variable, variable.hashCode());
            }
            EcmaScriptEvaluateVisitor evaluationVisitor = new EcmaScriptEvaluateVisitor(this);
            theValue = evaluationVisitor.evaluateFunction(node, es);
            int cc = evaluationVisitor.getCompletionCode();
            if (cc != 0 && cc != 1) {
                throw new EcmaScriptException("Unexpected " + evaluationVisitor.getCompletionCodeString() + " in function");
            }
            Object var13_13 = null;
            this.currentVariableObject = savedVariableObject;
            this.theScopeChain = previousScopeChain;
            this.currentThisObject = savedThisObject;
        }
        catch (Throwable throwable) {
            Object var13_14 = null;
            this.currentVariableObject = savedVariableObject;
            this.theScopeChain = previousScopeChain;
            this.currentThisObject = savedThisObject;
            throw throwable;
        }
        return theValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ESValue evaluateWith(ASTStatement node, ESObject scopeObject, EvaluationSource es) throws EcmaScriptException {
        ESValue theValue = ESUndefined.theUndefined;
        this.theScopeChain = new ScopeChain(scopeObject, this.theScopeChain);
        try {
            EcmaScriptEvaluateVisitor evaluationVisitor = new EcmaScriptEvaluateVisitor(this);
            theValue = evaluationVisitor.evaluateWith(node, es);
        }
        finally {
            this.theScopeChain = this.theScopeChain.previousScope();
        }
        return theValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ESValue evaluate(ParsedProgram program, ESObject thisObject, boolean acceptReturn) throws EcmaScriptException {
        ASTProgram node = program.getProgramNode();
        ESValue theValue = ESUndefined.theUndefined;
        ESObject savedVariableObject = this.currentVariableObject;
        ESObject savedThisObject = this.currentThisObject;
        ScopeChain previousScopeChain = this.theScopeChain;
        this.theScopeChain = new ScopeChain(this.globalObject, null);
        this.currentVariableObject = this.globalObject;
        if (thisObject == null) {
            this.currentThisObject = this.globalObject;
        } else {
            this.theScopeChain = new ScopeChain(thisObject, this.theScopeChain);
            this.currentThisObject = thisObject;
        }
        EcmaScriptEvaluateVisitor evaluationVisitor = new EcmaScriptEvaluateVisitor(this);
        try {
            this.functionDeclarationVisitor.processFunctionDeclarations(node, program.getEvaluationSource());
            Vector variables = program.getVariableNames();
            Enumeration e = variables.elements();
            while (e.hasMoreElements()) {
                String variable = (String)e.nextElement();
                this.createVariable(variable, variable.hashCode());
            }
            theValue = evaluationVisitor.evaluateProgram(node, program.getEvaluationSource());
            Object var14_14 = null;
            this.currentVariableObject = savedVariableObject;
            this.theScopeChain = previousScopeChain;
            this.currentThisObject = savedThisObject;
        }
        catch (Throwable throwable) {
            Object var14_15 = null;
            this.currentVariableObject = savedVariableObject;
            this.theScopeChain = previousScopeChain;
            this.currentThisObject = savedThisObject;
            throw throwable;
        }
        int completionCode = evaluationVisitor.getCompletionCode();
        if (completionCode != 0) {
            if (completionCode != 1) {
                throw new EcmaScriptException("Unexpected " + evaluationVisitor.getCompletionCodeString() + " in main program");
            }
            if (!acceptReturn) {
                throw new EcmaScriptException("Return is not accepted in main program with the 'eval' interface");
            }
        }
        return theValue;
    }

    public synchronized void evaluateEvent(ESWrapper sourceObject, ESObject theFunction, Object[] args) throws EcmaScriptException {
        ESValue[] esArgs = new ESValue[args.length];
        for (int i = 0; i < args.length; ++i) {
            esArgs[i] = ESLoader.normalizeValue(args[i], this);
        }
        theFunction.callFunction(sourceObject, esArgs);
    }

    public synchronized ESValue evaluate(Reader is, ESObject thisObject, EvaluationSource es, boolean acceptReturn) throws EcmaScriptException {
        ESValue theValue = ESUndefined.theUndefined;
        EcmaScript parser = new EcmaScript(is);
        ASTProgram programNode = null;
        try {
            programNode = (ASTProgram)parser.Program();
            if (this.debugParse) {
                System.out.println();
                System.out.println("@@ Dumping parse tree (debugParse true)");
                programNode.dump("");
            }
        }
        catch (ParseException e) {
            if (this.debugParse) {
                System.out.println("[[PARSING ERROR DETECTED: (debugParse true)]]");
                System.out.println(e.getMessage());
                System.out.println("[[BY ROUTINE:]]");
                e.printStackTrace();
                System.out.println();
            }
            throw new EcmaScriptParseException(e, es);
        }
        catch (TokenMgrError e) {
            if (this.debugParse) {
                System.out.println("[[LEXICAL ERROR DETECTED: (debugParse true)]]");
                System.out.println(e.getMessage());
                System.out.println("[[BY ROUTINE:]]");
                e.printStackTrace();
                System.out.println();
            }
            throw new EcmaScriptLexicalException(e, es);
        }
        Vector variableList = this.varDeclarationVisitor.processVariableDeclarations(programNode, es);
        ParsedProgram program = new ParsedProgram(programNode, variableList, es);
        theValue = this.evaluate(program, thisObject, acceptReturn);
        return theValue;
    }

    public synchronized ESValue evaluate(Reader is, ESObject thisObject) throws EcmaScriptException {
        UserEvaluationSource es = new UserEvaluationSource("<Anonymous stream>", null);
        return this.evaluate(is, thisObject, es, false);
    }

    public synchronized ESValue evaluate(Reader is) throws EcmaScriptException {
        return this.evaluate(is, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized ESValue evaluate(String text, String source) throws EcmaScriptException {
        StringReader is = null;
        ESValue v = null;
        UserEvaluationSource es = new UserEvaluationSource(source, null);
        try {
            if (!text.endsWith("\n")) {
                text = text + "\n";
            }
            is = new StringReader(text);
            v = this.evaluate(is, this.globalObject, es, false);
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
        return v;
    }

    public synchronized ESValue evaluate(File file) throws EcmaScriptException, IOException {
        return this.evaluate(file, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized ESValue evaluate(File file, ESObject thisObject) throws EcmaScriptException, IOException {
        FileEvaluationSource es = new FileEvaluationSource(file.getPath(), null);
        FileReader fr = null;
        ESValue value = null;
        try {
            fr = new FileReader(file);
            value = this.evaluate(fr, thisObject, es, false);
            Object var7_6 = null;
            if (fr == null) return value;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (fr == null) throw throwable;
            try {
                fr.close();
                throw throwable;
            }
            catch (IOException ignore) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            fr.close();
            return value;
        }
        catch (IOException ignore) {}
        return value;
    }

    public synchronized ESValue evaluate(String theSource) throws EcmaScriptException {
        return this.evaluate(theSource, null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized ESValue evaluate(String theSource, ESObject thisObject, boolean returnAccepted) throws EcmaScriptException {
        StringReader is = null;
        ESValue v = null;
        StringEvaluationSource es = new StringEvaluationSource(theSource, null);
        if (!theSource.endsWith("\n")) {
            theSource = theSource + "\n";
        }
        try {
            is = new StringReader(theSource);
            v = this.evaluate(is, thisObject, es, returnAccepted);
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
        return v;
    }
}

