/*
 * Decompiled with CFR 0.152.
 */
package FESI.Interpreter;

import FESI.AST.ASTAllocationExpression;
import FESI.AST.ASTAndExpressionSequence;
import FESI.AST.ASTAssignmentExpression;
import FESI.AST.ASTBinaryExpressionSequence;
import FESI.AST.ASTBreakStatement;
import FESI.AST.ASTCompositeReference;
import FESI.AST.ASTConditionalExpression;
import FESI.AST.ASTContinueStatement;
import FESI.AST.ASTEmptyExpression;
import FESI.AST.ASTExpressionList;
import FESI.AST.ASTForInStatement;
import FESI.AST.ASTForStatement;
import FESI.AST.ASTForVarInStatement;
import FESI.AST.ASTForVarStatement;
import FESI.AST.ASTFormalParameterList;
import FESI.AST.ASTFunctionCallParameters;
import FESI.AST.ASTFunctionDeclaration;
import FESI.AST.ASTIdentifier;
import FESI.AST.ASTIfStatement;
import FESI.AST.ASTLiteral;
import FESI.AST.ASTOperator;
import FESI.AST.ASTOrExpressionSequence;
import FESI.AST.ASTPostfixExpression;
import FESI.AST.ASTProgram;
import FESI.AST.ASTPropertyIdentifierReference;
import FESI.AST.ASTPropertyValueReference;
import FESI.AST.ASTReturnStatement;
import FESI.AST.ASTStatement;
import FESI.AST.ASTStatementList;
import FESI.AST.ASTThisReference;
import FESI.AST.ASTUnaryExpression;
import FESI.AST.ASTVariableDeclaration;
import FESI.AST.ASTWhileStatement;
import FESI.AST.ASTWithStatement;
import FESI.AST.EcmaScriptVisitor;
import FESI.AST.SimpleNode;
import FESI.Exceptions.ProgrammingError;
import FESI.Interpreter.EvaluationSource;
import FESI.Interpreter.Evaluator;
import FESI.Parser.EcmaScriptConstants;
import java.util.Vector;

public class EcmaScriptVariableVisitor
implements EcmaScriptVisitor,
EcmaScriptConstants {
    private Evaluator evaluator = null;
    private boolean debug = false;
    private Vector variableList = null;

    public EcmaScriptVariableVisitor(Evaluator evaluator) {
        this.evaluator = evaluator;
    }

    public Vector processVariableDeclarations(ASTProgram node, EvaluationSource evaluationSource) {
        if (this.debug) {
            System.out.println("processVariableDeclarations for program: " + node);
        }
        this.variableList = new Vector();
        node.jjtAccept(this, evaluationSource);
        return this.variableList;
    }

    public Vector processVariableDeclarations(ASTStatementList node, EvaluationSource evaluationSource) {
        if (this.debug) {
            System.out.println("processVariableDeclarations for function body: " + node);
        }
        this.variableList = new Vector();
        node.jjtAccept(this, evaluationSource);
        return this.variableList;
    }

    private void badAST() {
        throw new ProgrammingError("Bad AST walk in EcmaScriptVariableVisitor");
    }

    public Object visit(SimpleNode node, Object data) {
        this.badAST();
        return data;
    }

    public Object visit(ASTProgram node, Object data) {
        data = node.childrenAccept(this, data);
        return data;
    }

    public Object visit(ASTStatementList node, Object data) {
        data = node.childrenAccept(this, data);
        return data;
    }

    public Object visit(ASTFunctionDeclaration node, Object data) {
        return data;
    }

    public Object visit(ASTFormalParameterList node, Object data) {
        this.badAST();
        return data;
    }

    public Object visit(ASTStatement node, Object data) {
        data = node.childrenAccept(this, data);
        return data;
    }

    public Object visit(ASTVariableDeclaration node, Object data) {
        int nChildren = node.jjtGetNumChildren();
        if (nChildren < 1 || nChildren > 2) {
            throw new ProgrammingError("Bad AST in variable declaration");
        }
        ASTIdentifier idNode = (ASTIdentifier)node.jjtGetChild(0);
        if (this.debug) {
            System.out.println("VAR DECL: " + idNode.getName());
        }
        this.variableList.addElement(idNode.getName());
        return data;
    }

    public Object visit(ASTIfStatement node, Object data) {
        data = node.childrenAccept(this, data);
        return data;
    }

    public Object visit(ASTContinueStatement node, Object data) {
        return data;
    }

    public Object visit(ASTWhileStatement node, Object data) {
        data = node.childrenAccept(this, data);
        return data;
    }

    public Object visit(ASTForStatement node, Object data) {
        data = node.childrenAccept(this, data);
        return data;
    }

    public Object visit(ASTForInStatement node, Object data) {
        data = node.childrenAccept(this, data);
        return data;
    }

    public Object visit(ASTForVarStatement node, Object data) {
        data = node.childrenAccept(this, data);
        return data;
    }

    public Object visit(ASTForVarInStatement node, Object data) {
        data = node.childrenAccept(this, data);
        return data;
    }

    public Object visit(ASTBreakStatement node, Object data) {
        return data;
    }

    public Object visit(ASTReturnStatement node, Object data) {
        return data;
    }

    public Object visit(ASTWithStatement node, Object data) {
        node.setEvaluationSource(data);
        data = node.childrenAccept(this, data);
        return data;
    }

    public Object visit(ASTThisReference node, Object data) {
        return data;
    }

    public Object visit(ASTCompositeReference node, Object data) {
        return data;
    }

    public Object visit(ASTFunctionCallParameters node, Object data) {
        return data;
    }

    public Object visit(ASTPropertyValueReference node, Object data) {
        return data;
    }

    public Object visit(ASTPropertyIdentifierReference node, Object data) {
        return data;
    }

    public Object visit(ASTAllocationExpression node, Object data) {
        return data;
    }

    public Object visit(ASTOperator node, Object data) {
        this.badAST();
        return data;
    }

    public Object visit(ASTPostfixExpression node, Object data) {
        return data;
    }

    public Object visit(ASTUnaryExpression node, Object data) {
        return data;
    }

    public Object visit(ASTBinaryExpressionSequence node, Object data) {
        return data;
    }

    public Object visit(ASTAndExpressionSequence node, Object data) {
        return data;
    }

    public Object visit(ASTOrExpressionSequence node, Object data) {
        return data;
    }

    public Object visit(ASTConditionalExpression node, Object data) {
        return data;
    }

    public Object visit(ASTAssignmentExpression node, Object data) {
        return data;
    }

    public Object visit(ASTExpressionList node, Object data) {
        return data;
    }

    public Object visit(ASTEmptyExpression node, Object data) {
        return data;
    }

    public Object visit(ASTLiteral node, Object data) {
        return data;
    }

    public Object visit(ASTIdentifier node, Object data) {
        return data;
    }
}

