/*
 * Decompiled with CFR 0.152.
 */
package FESI.Interpreter;

import FESI.AST.ASTAllocationExpression;
import FESI.AST.ASTAndExpressionSequence;
import FESI.AST.ASTAssignmentExpression;
import FESI.AST.ASTBinaryExpressionSequence;
import FESI.AST.ASTBreakStatement;
import FESI.AST.ASTCompositeReference;
import FESI.AST.ASTConditionalExpression;
import FESI.AST.ASTContinueStatement;
import FESI.AST.ASTEmptyExpression;
import FESI.AST.ASTExpressionList;
import FESI.AST.ASTForInStatement;
import FESI.AST.ASTForStatement;
import FESI.AST.ASTForVarInStatement;
import FESI.AST.ASTForVarStatement;
import FESI.AST.ASTFormalParameterList;
import FESI.AST.ASTFunctionCallParameters;
import FESI.AST.ASTFunctionDeclaration;
import FESI.AST.ASTIdentifier;
import FESI.AST.ASTIfStatement;
import FESI.AST.ASTLiteral;
import FESI.AST.ASTOperator;
import FESI.AST.ASTOrExpressionSequence;
import FESI.AST.ASTPostfixExpression;
import FESI.AST.ASTProgram;
import FESI.AST.ASTPropertyIdentifierReference;
import FESI.AST.ASTPropertyValueReference;
import FESI.AST.ASTReturnStatement;
import FESI.AST.ASTStatement;
import FESI.AST.ASTStatementList;
import FESI.AST.ASTThisReference;
import FESI.AST.ASTUnaryExpression;
import FESI.AST.ASTVariableDeclaration;
import FESI.AST.ASTWhileStatement;
import FESI.AST.ASTWithStatement;
import FESI.AST.EcmaScriptVisitor;
import FESI.AST.SimpleNode;
import FESI.Data.ConstructedFunctionObject;
import FESI.Data.ESReference;
import FESI.Data.GlobalObject;
import FESI.Exceptions.EcmaScriptException;
import FESI.Exceptions.ProgrammingError;
import FESI.Interpreter.EcmaScriptVariableVisitor;
import FESI.Interpreter.EvaluationSource;
import FESI.Interpreter.Evaluator;
import FESI.Interpreter.FunctionEvaluationSource;
import FESI.Parser.EcmaScriptConstants;
import java.util.Vector;

public class EcmaScriptFunctionVisitor
implements EcmaScriptVisitor,
EcmaScriptConstants {
    private Evaluator evaluator = null;
    private boolean debug = false;
    private EvaluationSource currentEvaluationSource = null;

    public EcmaScriptFunctionVisitor(Evaluator evaluator) {
        this.evaluator = evaluator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processFunctionDeclarations(ASTProgram node, EvaluationSource evaluationSource) {
        if (this.debug) {
            System.out.println("processFunctionDeclarations: " + node);
        }
        if (this.currentEvaluationSource != null) {
            throw new ProgrammingError("illegal recursive function definition");
        }
        this.currentEvaluationSource = evaluationSource;
        try {
            node.jjtAccept(this, null);
        }
        finally {
            this.currentEvaluationSource = null;
        }
    }

    private void badAST() {
        throw new ProgrammingError("Bad AST walk in EcmaScriptFunctionVisitor");
    }

    public Object visit(SimpleNode node, Object data) {
        this.badAST();
        return data;
    }

    public Object visit(ASTProgram node, Object data) {
        data = node.childrenAccept(this, data);
        return data;
    }

    public Object visit(ASTStatementList node, Object data) {
        this.badAST();
        return data;
    }

    public Object visit(ASTFunctionDeclaration node, Object data) {
        int nChildren = node.jjtGetNumChildren();
        if (nChildren != 3) {
            throw new ProgrammingError("Bad AST in function declaration");
        }
        ASTIdentifier idNode = (ASTIdentifier)node.jjtGetChild(0);
        FunctionEvaluationSource fes = new FunctionEvaluationSource(this.currentEvaluationSource, idNode.getName());
        ASTFormalParameterList fpl = (ASTFormalParameterList)node.jjtGetChild(1);
        ASTStatementList sl = (ASTStatementList)node.jjtGetChild(2);
        EcmaScriptVariableVisitor varDeclarationVisitor = this.evaluator.getVarDeclarationVisitor();
        Vector variableNames = varDeclarationVisitor.processVariableDeclarations(sl, (EvaluationSource)fes);
        if (this.debug) {
            System.out.println("FUNC DECL: " + idNode.getName());
        }
        GlobalObject go = this.evaluator.getGlobalObject();
        try {
            ESReference newVar = new ESReference(go, idNode.getName(), idNode.hashCode());
            ConstructedFunctionObject func = ConstructedFunctionObject.makeNewConstructedFunction(this.evaluator, idNode.getName(), fes, node.getSourceString(), fpl.getArguments(), variableNames, sl);
            this.evaluator.putValue(newVar, func);
        }
        catch (EcmaScriptException e) {
            e.printStackTrace();
            throw new ProgrammingError("Unexpected error registering function" + e.getMessage());
        }
        return data;
    }

    public Object visit(ASTFormalParameterList node, Object data) {
        this.badAST();
        return data;
    }

    public Object visit(ASTStatement node, Object data) {
        return data;
    }

    public Object visit(ASTVariableDeclaration node, Object data) {
        this.badAST();
        return data;
    }

    public Object visit(ASTIfStatement node, Object data) {
        this.badAST();
        return data;
    }

    public Object visit(ASTContinueStatement node, Object data) {
        this.badAST();
        return data;
    }

    public Object visit(ASTWhileStatement node, Object data) {
        this.badAST();
        return data;
    }

    public Object visit(ASTForStatement node, Object data) {
        this.badAST();
        return data;
    }

    public Object visit(ASTForInStatement node, Object data) {
        this.badAST();
        return data;
    }

    public Object visit(ASTForVarStatement node, Object data) {
        this.badAST();
        return data;
    }

    public Object visit(ASTForVarInStatement node, Object data) {
        this.badAST();
        return data;
    }

    public Object visit(ASTBreakStatement node, Object data) {
        this.badAST();
        return data;
    }

    public Object visit(ASTReturnStatement node, Object data) {
        this.badAST();
        return data;
    }

    public Object visit(ASTWithStatement node, Object data) {
        this.badAST();
        return data;
    }

    public Object visit(ASTThisReference node, Object data) {
        this.badAST();
        return data;
    }

    public Object visit(ASTCompositeReference node, Object data) {
        this.badAST();
        return data;
    }

    public Object visit(ASTFunctionCallParameters node, Object data) {
        this.badAST();
        return data;
    }

    public Object visit(ASTPropertyValueReference node, Object data) {
        this.badAST();
        return data;
    }

    public Object visit(ASTPropertyIdentifierReference node, Object data) {
        this.badAST();
        return data;
    }

    public Object visit(ASTAllocationExpression node, Object data) {
        this.badAST();
        return data;
    }

    public Object visit(ASTOperator node, Object data) {
        this.badAST();
        return data;
    }

    public Object visit(ASTPostfixExpression node, Object data) {
        this.badAST();
        return data;
    }

    public Object visit(ASTUnaryExpression node, Object data) {
        this.badAST();
        return data;
    }

    public Object visit(ASTBinaryExpressionSequence node, Object data) {
        this.badAST();
        return data;
    }

    public Object visit(ASTAndExpressionSequence node, Object data) {
        this.badAST();
        return data;
    }

    public Object visit(ASTOrExpressionSequence node, Object data) {
        this.badAST();
        return data;
    }

    public Object visit(ASTConditionalExpression node, Object data) {
        this.badAST();
        return data;
    }

    public Object visit(ASTAssignmentExpression node, Object data) {
        this.badAST();
        return data;
    }

    public Object visit(ASTExpressionList node, Object data) {
        this.badAST();
        return data;
    }

    public Object visit(ASTEmptyExpression node, Object data) {
        this.badAST();
        return data;
    }

    public Object visit(ASTLiteral node, Object data) {
        this.badAST();
        return data;
    }

    public Object visit(ASTIdentifier node, Object data) {
        this.badAST();
        return data;
    }
}

