/*
 * Decompiled with CFR 0.152.
 */
package FESI.Interpreter;

import FESI.AST.ASTAllocationExpression;
import FESI.AST.ASTAndExpressionSequence;
import FESI.AST.ASTAssignmentExpression;
import FESI.AST.ASTBinaryExpressionSequence;
import FESI.AST.ASTBreakStatement;
import FESI.AST.ASTCompositeReference;
import FESI.AST.ASTConditionalExpression;
import FESI.AST.ASTContinueStatement;
import FESI.AST.ASTEmptyExpression;
import FESI.AST.ASTExpressionList;
import FESI.AST.ASTForInStatement;
import FESI.AST.ASTForStatement;
import FESI.AST.ASTForVarInStatement;
import FESI.AST.ASTForVarStatement;
import FESI.AST.ASTFormalParameterList;
import FESI.AST.ASTFunctionCallParameters;
import FESI.AST.ASTFunctionDeclaration;
import FESI.AST.ASTIdentifier;
import FESI.AST.ASTIfStatement;
import FESI.AST.ASTLiteral;
import FESI.AST.ASTOperator;
import FESI.AST.ASTOrExpressionSequence;
import FESI.AST.ASTPostfixExpression;
import FESI.AST.ASTProgram;
import FESI.AST.ASTPropertyIdentifierReference;
import FESI.AST.ASTPropertyValueReference;
import FESI.AST.ASTReturnStatement;
import FESI.AST.ASTStatement;
import FESI.AST.ASTStatementList;
import FESI.AST.ASTThisReference;
import FESI.AST.ASTUnaryExpression;
import FESI.AST.ASTVariableDeclaration;
import FESI.AST.ASTWhileStatement;
import FESI.AST.ASTWithStatement;
import FESI.AST.EcmaScriptVisitor;
import FESI.AST.Node;
import FESI.AST.SimpleNode;
import FESI.Data.ESArguments;
import FESI.Data.ESBoolean;
import FESI.Data.ESLoader;
import FESI.Data.ESNull;
import FESI.Data.ESNumber;
import FESI.Data.ESObject;
import FESI.Data.ESPrimitive;
import FESI.Data.ESReference;
import FESI.Data.ESString;
import FESI.Data.ESUndefined;
import FESI.Data.ESValue;
import FESI.Exceptions.EcmaScriptException;
import FESI.Exceptions.ProgrammingError;
import FESI.Interpreter.EvaluationSource;
import FESI.Interpreter.Evaluator;
import FESI.Interpreter.LineEvaluationSource;
import FESI.Interpreter.PackagedException;
import FESI.Parser.EcmaScriptConstants;
import java.util.Enumeration;

public class EcmaScriptEvaluateVisitor
implements EcmaScriptVisitor,
EcmaScriptConstants {
    public static final int C_NORMAL = 0;
    public static final int C_RETURN = 1;
    public static final int C_BREAK = 2;
    public static final int C_CONTINUE = 3;
    private static final int COMPARE_TRUE = -1;
    private static final int COMPARE_UNDEFINED = 0;
    private static final int COMPARE_FALSE = 1;
    private boolean debug = false;
    private static final Object FOR_VALUE = new Object();
    private static final Object FOR_REFERENCE = new Object();
    private Evaluator evaluator;
    private int completionCode = -1;

    public EcmaScriptEvaluateVisitor(Evaluator evaluator) {
        this.evaluator = evaluator;
    }

    public int getCompletionCode() {
        return this.completionCode;
    }

    public String getCompletionCodeString() {
        String[] data = new String[]{"normal", "return", "break", "continue"};
        return data[this.completionCode];
    }

    public ESValue evaluateProgram(ASTProgram node, EvaluationSource es) throws EcmaScriptException {
        EvaluationSource evaluationSource = es;
        if (this.completionCode != -1) {
            throw new ProgrammingError("Multiple use of evalution visitor");
        }
        this.completionCode = 0;
        ESValue result = null;
        if (this.debug) {
            System.out.println("evaluateProgram for: " + node);
        }
        try {
            result = (ESValue)node.jjtAccept(this, FOR_VALUE);
        }
        catch (PackagedException e) {
            e.exception.appendEvaluationSource(new LineEvaluationSource(e.node.getLineNumber(), es));
            throw e.exception;
        }
        if (this.debug) {
            System.out.println("evaluateProgram result: " + result);
        }
        return result;
    }

    public ESValue evaluateFunction(ASTStatementList node, EvaluationSource es) throws EcmaScriptException {
        if (this.completionCode != -1) {
            throw new ProgrammingError("Multiple use of evaluation visitor");
        }
        this.completionCode = 0;
        EvaluationSource evaluationSource = es;
        ESValue result = null;
        if (this.debug) {
            System.out.println("evaluateFunction for: " + node);
        }
        try {
            result = (ESValue)node.jjtAccept(this, FOR_VALUE);
        }
        catch (PackagedException e) {
            e.exception.appendEvaluationSource(new LineEvaluationSource(e.node.getLineNumber(), es));
            throw e.exception;
        }
        if (this.debug) {
            System.out.println("evaluateFunction result: " + result);
        }
        return result;
    }

    public ESValue evaluateWith(ASTStatement node, EvaluationSource es) throws EcmaScriptException {
        if (this.completionCode != -1) {
            throw new ProgrammingError("Multiple use of evalution visitor");
        }
        this.completionCode = 0;
        ESValue result = null;
        if (this.debug) {
            System.out.println("evaluateWith for: " + node);
        }
        try {
            result = (ESValue)node.jjtAccept(this, FOR_VALUE);
        }
        catch (PackagedException e) {
            e.exception.appendEvaluationSource(new LineEvaluationSource(e.node.getLineNumber(), es));
            throw e.exception;
        }
        if (this.debug) {
            System.out.println("evaluateWith result: " + result);
        }
        return result;
    }

    private int compare(ESValue v1, ESValue v2) throws EcmaScriptException {
        ESValue v1p = v1.toESPrimitive(4);
        ESValue v2p = v2.toESPrimitive(4);
        if (v1p instanceof ESString && v2p instanceof ESString) {
            String s2;
            String s1 = v1.toString();
            int c = s1.compareTo(s2 = v2.toString());
            return c < 0 ? -1 : 1;
        }
        double d1 = v1.doubleValue();
        double d2 = v2.doubleValue();
        if (Double.isNaN(d1) || Double.isNaN(d2)) {
            return 0;
        }
        int c = v1.doubleValue() < v2.doubleValue() ? -1 : 1;
        return c;
    }

    private boolean equal(ESValue v1, ESValue v2) throws EcmaScriptException {
        if (v1.getTypeOf() == v2.getTypeOf()) {
            if (v1 instanceof ESUndefined) {
                return true;
            }
            if (v1 instanceof ESNull) {
                return true;
            }
            if (v1 instanceof ESNumber) {
                double d2;
                double d1 = v1.doubleValue();
                return d1 == (d2 = v2.doubleValue());
            }
            if (v1 instanceof ESString) {
                String s1 = v1.toString();
                String s2 = v2.toString();
                return s1.equals(s2);
            }
            if (v1 instanceof ESBoolean) {
                boolean b2;
                boolean b1 = v1.booleanValue();
                return b1 == (b2 = v2.booleanValue());
            }
            return v1 == v2;
        }
        if (v1 instanceof ESUndefined && v2 instanceof ESNull) {
            return true;
        }
        if (v2 instanceof ESUndefined && v1 instanceof ESNull) {
            return true;
        }
        if (v1 instanceof ESNumber && v2 instanceof ESString || v2 instanceof ESNumber && v1 instanceof ESString) {
            double d2;
            double d1 = v1.doubleValue();
            return d1 == (d2 = v2.doubleValue());
        }
        if (v1 instanceof ESBoolean || v2 instanceof ESBoolean) {
            double d2;
            double d1 = v1.doubleValue();
            return d1 == (d2 = v2.doubleValue());
        }
        if (v1 instanceof ESNumber && v2 instanceof ESObject || v1 instanceof ESString && v2 instanceof ESObject) {
            return this.equal(v1, v2.toESPrimitive());
        }
        if (v2 instanceof ESNumber && v1 instanceof ESObject || v2 instanceof ESString && v1 instanceof ESObject) {
            return this.equal(v2, v1.toESPrimitive());
        }
        return false;
    }

    public Object visit(SimpleNode node, Object data) {
        throw new ProgrammingError("Visitor not implemented for node type " + node.getClass());
    }

    public Object visit(ASTProgram node, Object data) {
        int n = node.jjtGetNumChildren();
        if (n <= 0) {
            throw new ProgrammingError("Empty program not implemented");
        }
        Object result = node.jjtGetChild(0).jjtAccept(this, FOR_VALUE);
        for (int i = 1; i < node.jjtGetNumChildren(); ++i) {
            Node statement = node.jjtGetChild(i);
            result = statement.jjtAccept(this, FOR_VALUE);
        }
        return result;
    }

    public Object visit(ASTStatementList node, Object data) {
        int n = node.jjtGetNumChildren();
        Object result = ESUndefined.theUndefined;
        for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
            if (this.completionCode != 0) {
                return result;
            }
            Node statement = node.jjtGetChild(i);
            result = statement.jjtAccept(this, FOR_VALUE);
        }
        return result;
    }

    public Object visit(ASTFunctionDeclaration node, Object data) {
        return null;
    }

    public Object visit(ASTFormalParameterList node, Object data) {
        throw new ProgrammingError("Should not visit this");
    }

    public Object visit(ASTStatement node, Object data) {
        Object result = null;
        int nChildren = node.jjtGetNumChildren();
        if (nChildren == 1) {
            result = node.jjtGetChild(0).jjtAccept(this, FOR_VALUE);
        } else if (nChildren != 0) {
            throw new ProgrammingError("Bad AST in statement (>1 child");
        }
        return result;
    }

    public Object visit(ASTVariableDeclaration node, Object data) {
        ESValue result = null;
        int nChildren = node.jjtGetNumChildren();
        if (nChildren < 1 || nChildren > 2) {
            throw new ProgrammingError("Bad AST in variable declaration");
        }
        if (nChildren == 2) {
            try {
                Object lvo = node.jjtGetChild(0).jjtAccept(this, FOR_REFERENCE);
                if (!(lvo instanceof ESReference)) {
                    throw new ProgrammingError("Value '" + lvo.toString() + "' is not a variable");
                }
                ESReference lv = (ESReference)lvo;
                ESValue rv = (ESValue)node.jjtGetChild(1).jjtAccept(this, FOR_VALUE);
                lv.putValue(null, rv);
                result = rv;
            }
            catch (EcmaScriptException e) {
                throw new PackagedException(e, node);
            }
        }
        return result;
    }

    public Object visit(ASTIfStatement node, Object data) {
        Object result = null;
        int nChildren = node.jjtGetNumChildren();
        if (nChildren < 2 || nChildren > 3) {
            throw new ProgrammingError("Bad AST in IF statement");
        }
        try {
            ESValue testValue = EcmaScriptEvaluateVisitor.acceptNull(node.jjtGetChild(0).jjtAccept(this, FOR_VALUE));
            boolean test = testValue.booleanValue();
            if (test) {
                result = node.jjtGetChild(1).jjtAccept(this, FOR_VALUE);
            } else if (nChildren == 3) {
                result = node.jjtGetChild(2).jjtAccept(this, FOR_VALUE);
            }
        }
        catch (EcmaScriptException e) {
            throw new PackagedException(e, node);
        }
        return result;
    }

    public Object visit(ASTWhileStatement node, Object data) {
        Object result = null;
        node.assertTwoChildren();
        try {
            ESValue testValue = EcmaScriptEvaluateVisitor.acceptNull(node.jjtGetChild(0).jjtAccept(this, FOR_VALUE));
            while (testValue.booleanValue()) {
                result = node.jjtGetChild(1).jjtAccept(this, FOR_VALUE);
                if (this.completionCode == 1) {
                    return result;
                }
                if (this.completionCode == 2) {
                    this.completionCode = 0;
                    return result;
                }
                if (this.completionCode == 3) {
                    testValue = EcmaScriptEvaluateVisitor.acceptNull(node.jjtGetChild(0).jjtAccept(this, FOR_VALUE));
                    this.completionCode = 0;
                    continue;
                }
                testValue = EcmaScriptEvaluateVisitor.acceptNull(node.jjtGetChild(0).jjtAccept(this, FOR_VALUE));
            }
        }
        catch (EcmaScriptException e) {
            throw new PackagedException(e, node);
        }
        return result;
    }

    public Object visit(ASTForStatement node, Object data) {
        Object result = null;
        try {
            node.assertFourChildren();
            node.jjtGetChild(0).jjtAccept(this, FOR_VALUE);
            Node testNode = node.jjtGetChild(1);
            ESValue testValue = testNode instanceof ASTEmptyExpression ? ESBoolean.makeBoolean(true) : EcmaScriptEvaluateVisitor.acceptNull(testNode.jjtAccept(this, FOR_VALUE));
            while (((ESValue)testValue).booleanValue()) {
                result = node.jjtGetChild(3).jjtAccept(this, FOR_VALUE);
                if (this.completionCode == 1) {
                    return result;
                }
                if (this.completionCode == 2) {
                    this.completionCode = 0;
                    return result;
                }
                if (this.completionCode == 3) {
                    node.jjtGetChild(2).jjtAccept(this, FOR_VALUE);
                    testValue = testNode instanceof ASTEmptyExpression ? ESBoolean.makeBoolean(true) : EcmaScriptEvaluateVisitor.acceptNull(testNode.jjtAccept(this, FOR_VALUE));
                    this.completionCode = 0;
                    continue;
                }
                node.jjtGetChild(2).jjtAccept(this, FOR_VALUE);
                if (testNode instanceof ASTEmptyExpression) {
                    testValue = ESBoolean.makeBoolean(true);
                    continue;
                }
                testValue = EcmaScriptEvaluateVisitor.acceptNull(testNode.jjtAccept(this, FOR_VALUE));
            }
        }
        catch (EcmaScriptException e) {
            throw new PackagedException(e, node);
        }
        return result;
    }

    public Object visit(ASTForVarStatement node, Object data) {
        Object result = null;
        try {
            node.assertFourChildren();
            node.jjtGetChild(0).jjtAccept(this, FOR_VALUE);
            Node testNode = node.jjtGetChild(1);
            ESValue testValue = testNode instanceof ASTEmptyExpression ? ESBoolean.makeBoolean(true) : EcmaScriptEvaluateVisitor.acceptNull(testNode.jjtAccept(this, FOR_VALUE));
            while (((ESValue)testValue).booleanValue()) {
                result = node.jjtGetChild(3).jjtAccept(this, FOR_VALUE);
                if (this.completionCode == 1) {
                    return result;
                }
                if (this.completionCode == 2) {
                    this.completionCode = 0;
                    return result;
                }
                if (this.completionCode == 3) {
                    node.jjtGetChild(2).jjtAccept(this, FOR_VALUE);
                    testValue = testNode instanceof ASTEmptyExpression ? ESBoolean.makeBoolean(true) : EcmaScriptEvaluateVisitor.acceptNull(testNode.jjtAccept(this, FOR_VALUE));
                    this.completionCode = 0;
                    continue;
                }
                node.jjtGetChild(2).jjtAccept(this, FOR_VALUE);
                if (testNode instanceof ASTEmptyExpression) {
                    testValue = ESBoolean.makeBoolean(true);
                    continue;
                }
                testValue = EcmaScriptEvaluateVisitor.acceptNull(testNode.jjtAccept(this, FOR_VALUE));
            }
        }
        catch (EcmaScriptException e) {
            throw new PackagedException(e, node);
        }
        return result;
    }

    public Object visit(ASTForInStatement node, Object data) {
        Object result = null;
        node.assertThreeChildren();
        try {
            ESValue ob = EcmaScriptEvaluateVisitor.acceptNull(node.jjtGetChild(1).jjtAccept(this, FOR_VALUE));
            ESObject obj = (ESObject)ob.toESObject(this.evaluator);
            boolean directEnumeration = obj.isDirectEnumerator();
            Enumeration e = obj.getProperties();
            while (e.hasMoreElements()) {
                Object en = e.nextElement();
                ESValue s = directEnumeration ? ESLoader.normalizeValue(en, this.evaluator) : new ESString(en.toString());
                Object lvo = node.jjtGetChild(0).jjtAccept(this, FOR_REFERENCE);
                if (!(lvo instanceof ESReference)) {
                    throw new EcmaScriptException("Value '" + lvo.toString() + "' is not an assignable object or property");
                }
                ESReference lv = (ESReference)lvo;
                this.evaluator.putValue(lv, s);
                result = node.jjtGetChild(2).jjtAccept(this, FOR_VALUE);
                if (this.completionCode == 1) break;
                if (this.completionCode == 2) {
                    this.completionCode = 0;
                    break;
                }
                if (this.completionCode != 3) continue;
                this.completionCode = 0;
            }
        }
        catch (EcmaScriptException e) {
            throw new PackagedException(e, node);
        }
        return result;
    }

    public Object visit(ASTForVarInStatement node, Object data) {
        Object result = null;
        node.assertFourChildren();
        try {
            Object lvo = node.jjtGetChild(0).jjtAccept(this, FOR_REFERENCE);
            if (!(lvo instanceof ESReference)) {
                throw new ProgrammingError("Value '" + lvo.toString() + "' is not a variable");
            }
            ESReference lv = (ESReference)lvo;
            ESValue init = EcmaScriptEvaluateVisitor.acceptNull(node.jjtGetChild(1).jjtAccept(this, FOR_VALUE));
            this.evaluator.putValue(lv, init);
            ESValue ob = EcmaScriptEvaluateVisitor.acceptNull(node.jjtGetChild(2).jjtAccept(this, FOR_VALUE));
            ESObject obj = (ESObject)ob.toESObject(this.evaluator);
            boolean directEnumeration = obj.isDirectEnumerator();
            Enumeration e = obj.getProperties();
            while (e.hasMoreElements()) {
                Object en = e.nextElement();
                ESValue s = directEnumeration ? ESLoader.normalizeValue(en, this.evaluator) : new ESString(en.toString());
                lv = (ESReference)node.jjtGetChild(0).jjtAccept(this, FOR_REFERENCE);
                this.evaluator.putValue(lv, s);
                result = node.jjtGetChild(3).jjtAccept(this, FOR_VALUE);
                if (this.completionCode == 1) break;
                if (this.completionCode == 2) {
                    this.completionCode = 0;
                    break;
                }
                if (this.completionCode != 3) continue;
                this.completionCode = 0;
            }
        }
        catch (EcmaScriptException e) {
            throw new PackagedException(e, node);
        }
        return result;
    }

    public Object visit(ASTContinueStatement node, Object data) {
        node.assertNoChildren();
        this.completionCode = 3;
        return null;
    }

    public Object visit(ASTBreakStatement node, Object data) {
        node.assertNoChildren();
        this.completionCode = 2;
        return null;
    }

    public Object visit(ASTReturnStatement node, Object data) {
        node.assertOneChild();
        Object result = node.jjtGetChild(0).jjtAccept(this, FOR_VALUE);
        this.completionCode = 1;
        return result;
    }

    public Object visit(ASTWithStatement node, Object data) {
        node.assertTwoChildren();
        ESValue result = null;
        try {
            EvaluationSource es = (EvaluationSource)node.getEvaluationSource();
            ESValue scopeValue = EcmaScriptEvaluateVisitor.acceptNull(node.jjtGetChild(0).jjtAccept(this, FOR_VALUE));
            ASTStatement statementNode = (ASTStatement)node.jjtGetChild(1);
            ESObject scopeObject = (ESObject)scopeValue.toESObject(this.evaluator);
            result = this.evaluator.evaluateWith(statementNode, scopeObject, es);
        }
        catch (EcmaScriptException e) {
            throw new PackagedException(e, node);
        }
        return result;
    }

    public Object visit(ASTThisReference node, Object data) {
        node.assertNoChildren();
        return this.evaluator.getThisObject();
    }

    public Object visit(ASTCompositeReference node, Object forWhat) {
        int nChildren = node.jjtGetNumChildren();
        if (nChildren < 2) {
            throw new ProgrammingError("Bad ast");
        }
        try {
            Object result;
            String propertyName;
            ESObject currentBase;
            ESValue currentProperty;
            ESValue lastResult;
            Node baseNode = node.jjtGetChild(0);
            if (baseNode instanceof ASTIdentifier) {
                lastResult = null;
                String id = ((ASTIdentifier)baseNode).getName();
                currentProperty = new ESString(id);
            } else {
                lastResult = EcmaScriptEvaluateVisitor.acceptNull(baseNode.jjtAccept(this, FOR_VALUE));
                currentProperty = null;
            }
            for (int i = 1; i < nChildren; ++i) {
                Node compositor = node.jjtGetChild(i);
                if (compositor instanceof ASTPropertyValueReference || compositor instanceof ASTPropertyIdentifierReference) {
                    if (currentProperty != null) {
                        ESValue newBase;
                        String propertyName2 = currentProperty.toString();
                        if (lastResult == null) {
                            newBase = this.evaluator.getValue(propertyName2, propertyName2.hashCode());
                            if (newBase instanceof ESUndefined) {
                                throw new EcmaScriptException("The property '" + propertyName2 + "' is not defined in global object");
                            }
                        } else {
                            ESObject currentBase2 = (ESObject)lastResult.toESObject(this.evaluator);
                            newBase = currentBase2.getProperty(propertyName2, propertyName2.hashCode());
                            if (newBase instanceof ESUndefined) {
                                throw new EcmaScriptException("The property '" + propertyName2 + "' is not defined in object '" + currentBase2.toString() + "'");
                            }
                        }
                        lastResult = newBase;
                        currentProperty = null;
                    }
                    currentProperty = (ESValue)compositor.jjtAccept(this, FOR_VALUE);
                    continue;
                }
                if (compositor instanceof ASTFunctionCallParameters) {
                    ESObject thisObject;
                    ESValue[] arguments = (ESValue[])compositor.jjtAccept(this, FOR_VALUE);
                    if (currentProperty != null) {
                        thisObject = lastResult == null ? this.evaluator.getGlobalObject() : (ESObject)lastResult.toESObject(this.evaluator);
                        if (thisObject instanceof ESArguments) {
                            thisObject = this.evaluator.getGlobalObject();
                        }
                    } else {
                        thisObject = this.evaluator.getGlobalObject();
                    }
                    if (currentProperty != null) {
                        String functionName = currentProperty.toString();
                        if (lastResult == null) {
                            lastResult = this.evaluator.doIndirectCall(thisObject, functionName, functionName.hashCode(), arguments);
                        } else {
                            try {
                                lastResult = thisObject.doIndirectCall(this.evaluator, thisObject, functionName, arguments);
                            }
                            catch (NoSuchMethodException e) {
                                throw new EcmaScriptException(e.getMessage());
                            }
                        }
                        currentProperty = null;
                    } else {
                        System.out.println("--->Last result: " + lastResult + " " + lastResult.getClass() + "<---");
                        ESObject theFunction = (ESObject)lastResult.toESObject(this.evaluator);
                        lastResult = ((ESValue)theFunction).callFunction(thisObject, arguments);
                    }
                    this.completionCode = 0;
                    continue;
                }
                throw new ProgrammingError("Bad AST");
            }
            if (forWhat == FOR_VALUE) {
                if (currentProperty != null) {
                    if (lastResult == null) {
                        throw new EcmaScriptException("'undefined' is not an object with properties");
                    }
                    currentBase = (ESObject)lastResult.toESObject(this.evaluator);
                    propertyName = currentProperty.toString();
                    result = currentBase.getProperty(propertyName, propertyName.hashCode());
                } else {
                    result = lastResult;
                }
            } else {
                if (lastResult == null) {
                    throw new EcmaScriptException("'undefined' is not an assignable value");
                }
                if (currentProperty == null) {
                    throw new EcmaScriptException("'" + lastResult.toString() + "' is not an assignable value");
                }
                currentBase = (ESObject)lastResult.toESObject(this.evaluator);
                propertyName = currentProperty.toString();
                result = new ESReference(currentBase, propertyName, propertyName.hashCode());
            }
            return result;
        }
        catch (EcmaScriptException e) {
            throw new PackagedException(e, node);
        }
    }

    public Object visit(ASTFunctionCallParameters node, Object data) {
        int nChildren = node.jjtGetNumChildren();
        ESValue[] arguments = new ESValue[nChildren];
        for (int i = 0; i < nChildren; ++i) {
            arguments[i] = (ESValue)node.jjtGetChild(i).jjtAccept(this, FOR_VALUE);
        }
        return arguments;
    }

    public Object visit(ASTPropertyValueReference node, Object data) {
        node.assertOneChild();
        return EcmaScriptEvaluateVisitor.acceptNull(node.jjtGetChild(0).jjtAccept(this, FOR_VALUE));
    }

    public Object visit(ASTPropertyIdentifierReference node, Object data) {
        node.assertOneChild();
        ESString result = null;
        Node idNode = node.jjtGetChild(0);
        if (!(idNode instanceof ASTIdentifier)) {
            throw new ProgrammingError("Bad AST");
        }
        String id = ((ASTIdentifier)idNode).getName();
        result = new ESString(id);
        return result;
    }

    public Object visit(ASTAllocationExpression node, Object data) {
        node.assertTwoChildren();
        ESObject result = null;
        try {
            int nChildren = node.jjtGetNumChildren();
            Node baseNode = node.jjtGetChild(0);
            ESValue constr = EcmaScriptEvaluateVisitor.acceptNull(baseNode.jjtAccept(this, FOR_VALUE));
            Node compositor = node.jjtGetChild(1);
            if (compositor instanceof ASTFunctionCallParameters) {
                ASTFunctionCallParameters fc = (ASTFunctionCallParameters)compositor;
                ESValue[] arguments = (ESValue[])fc.jjtAccept(this, FOR_VALUE);
                result = constr.doConstruct(this.evaluator.getThisObject(), arguments);
                if (!(result instanceof ESObject)) {
                    throw new EcmaScriptException("new " + compositor + " did not return an object");
                }
            } else {
                throw new ProgrammingError("Bad AST");
            }
            this.completionCode = 0;
        }
        catch (EcmaScriptException e) {
            throw new PackagedException(e, node);
        }
        return result;
    }

    public Object visit(ASTOperator node, Object data) {
        throw new ProgrammingError("Bad AST walk");
    }

    public Object visit(ASTPostfixExpression node, Object data) {
        ESValue result;
        try {
            node.assertTwoChildren();
            Object lvo = node.jjtGetChild(0).jjtAccept(this, FOR_REFERENCE);
            if (!(lvo instanceof ESReference)) {
                throw new EcmaScriptException("Value '" + lvo.toString() + "' is not an assignable object or property");
            }
            ESReference lv = (ESReference)lvo;
            int operator = ((ASTOperator)node.jjtGetChild(1)).getOperator();
            result = lv.getValue();
            double dv = result.doubleValue();
            if (operator == 79) {
                dv += 1.0;
            } else if (operator == 80) {
                dv -= 1.0;
            } else {
                throw new ProgrammingError("Bad operator");
            }
            ESNumber vr = new ESNumber(dv);
            this.evaluator.putValue(lv, vr);
        }
        catch (EcmaScriptException e) {
            throw new PackagedException(e, node);
        }
        return result;
    }

    public Object visit(ASTUnaryExpression node, Object data) {
        ESValue r = null;
        try {
            node.assertTwoChildren();
            int operator = ((ASTOperator)node.jjtGetChild(0)).getOperator();
            switch (operator) {
                case 13: {
                    Object lvo = node.jjtGetChild(1).jjtAccept(this, FOR_REFERENCE);
                    if (!(lvo instanceof ESReference)) {
                        throw new EcmaScriptException("Value '" + lvo.toString() + "' is not a property reference");
                    }
                    ESReference lv = (ESReference)lvo;
                    ESValue base = lv.getBase();
                    String propertyName = lv.getPropertyName();
                    if (base instanceof ESObject) {
                        r = ESBoolean.makeBoolean(((ESObject)base).deleteProperty(propertyName, propertyName.hashCode()));
                        break;
                    }
                    r = ESBoolean.makeBoolean(true);
                    break;
                }
                case 24: {
                    r = null;
                    break;
                }
                case 22: {
                    Node n = node.jjtGetChild(1);
                    if (n instanceof ASTIdentifier) {
                        ESReference ref = (ESReference)n.jjtAccept(this, FOR_REFERENCE);
                        if (ref == null || ref.getBase() == null) {
                            r = new ESString("undefined");
                            break;
                        }
                        ESValue v = ref.getValue();
                        r = new ESString(v.getTypeofString());
                        break;
                    }
                    ESValue v = EcmaScriptEvaluateVisitor.acceptNull(n.jjtAccept(this, FOR_VALUE));
                    r = new ESString(v.getTypeofString());
                    break;
                }
                case 79: {
                    Object lvo = node.jjtGetChild(1).jjtAccept(this, FOR_REFERENCE);
                    if (!(lvo instanceof ESReference)) {
                        throw new EcmaScriptException("Value '" + lvo.toString() + "' is not an assignable object or property");
                    }
                    ESReference lv = (ESReference)lvo;
                    ESValue v = lv.getValue();
                    double dv = v.doubleValue();
                    r = new ESNumber(dv += 1.0);
                    this.evaluator.putValue(lv, r);
                    break;
                }
                case 80: {
                    Object lvo = node.jjtGetChild(1).jjtAccept(this, FOR_REFERENCE);
                    if (!(lvo instanceof ESReference)) {
                        throw new EcmaScriptException("Value '" + lvo.toString() + "' is not an assignable object or property");
                    }
                    ESReference lv = (ESReference)lvo;
                    ESValue v = lv.getValue();
                    double dv = v.doubleValue();
                    r = new ESNumber(dv -= 1.0);
                    this.evaluator.putValue(lv, r);
                    break;
                }
                case 81: {
                    ESValue v = (ESValue)node.jjtGetChild(1).jjtAccept(this, FOR_VALUE);
                    r = v.toESNumber();
                    break;
                }
                case 82: {
                    ESValue v = (ESValue)node.jjtGetChild(1).jjtAccept(this, FOR_VALUE);
                    double dv = v.doubleValue();
                    r = new ESNumber(-dv);
                    break;
                }
                case 70: {
                    ESValue v = (ESValue)node.jjtGetChild(1).jjtAccept(this, FOR_VALUE);
                    int iv = v.toInt32();
                    r = new ESNumber(~iv);
                    break;
                }
                case 69: {
                    ESValue v = (ESValue)node.jjtGetChild(1).jjtAccept(this, FOR_VALUE);
                    boolean bv = v.booleanValue();
                    r = ESBoolean.makeBoolean(!bv);
                    break;
                }
                default: {
                    throw new ProgrammingError("Unimplemented unary");
                }
            }
        }
        catch (EcmaScriptException e) {
            throw new PackagedException(e, node);
        }
        return r;
    }

    public Object visit(ASTBinaryExpressionSequence node, Object data) {
        ESPrimitive result = null;
        try {
            ESValue v1 = EcmaScriptEvaluateVisitor.acceptNull(node.jjtGetChild(0).jjtAccept(this, FOR_VALUE));
            for (int i = 0; i < node.jjtGetNumChildren() - 1; i += 2) {
                ESValue v2 = EcmaScriptEvaluateVisitor.acceptNull(node.jjtGetChild(i + 2).jjtAccept(this, FOR_VALUE));
                int operator = ((ASTOperator)node.jjtGetChild(i + 1)).getOperator();
                switch (operator) {
                    case 81: {
                        ESValue v1p = v1.toESPrimitive();
                        ESValue v2p = v2.toESPrimitive();
                        if (v1p instanceof ESString || v2p instanceof ESString) {
                            result = new ESString(v1.toString() + v2.toString());
                            break;
                        }
                        result = new ESNumber(v1.doubleValue() + v2.doubleValue());
                        break;
                    }
                    case 82: {
                        result = new ESNumber(v1.doubleValue() - v2.doubleValue());
                        break;
                    }
                    case 83: {
                        result = new ESNumber(v1.doubleValue() * v2.doubleValue());
                        break;
                    }
                    case 84: {
                        result = new ESNumber(v1.doubleValue() / v2.doubleValue());
                        break;
                    }
                    case 88: {
                        result = new ESNumber(v1.doubleValue() % v2.doubleValue());
                        break;
                    }
                    case 89: {
                        result = new ESNumber(v1.toInt32() << v2.toUInt32());
                        break;
                    }
                    case 90: {
                        result = new ESNumber(v1.toInt32() >> v2.toUInt32());
                        break;
                    }
                    case 91: {
                        result = new ESNumber(v1.toUInt32() >>> v2.toUInt32());
                        break;
                    }
                    case 68: {
                        int compareCode = this.compare(v1, v2);
                        if (compareCode == -1) {
                            result = ESBoolean.makeBoolean(true);
                            break;
                        }
                        result = ESBoolean.makeBoolean(false);
                        break;
                    }
                    case 67: {
                        int compareCode = this.compare(v2, v1);
                        if (compareCode == -1) {
                            result = ESBoolean.makeBoolean(true);
                            break;
                        }
                        result = ESBoolean.makeBoolean(false);
                        break;
                    }
                    case 74: {
                        int compareCode = this.compare(v2, v1);
                        if (compareCode == 1) {
                            result = ESBoolean.makeBoolean(true);
                            break;
                        }
                        result = ESBoolean.makeBoolean(false);
                        break;
                    }
                    case 75: {
                        int compareCode = this.compare(v1, v2);
                        if (compareCode == 1) {
                            result = ESBoolean.makeBoolean(true);
                            break;
                        }
                        result = ESBoolean.makeBoolean(false);
                        break;
                    }
                    case 73: {
                        result = ESBoolean.makeBoolean(this.equal(v1, v2));
                        break;
                    }
                    case 76: {
                        result = ESBoolean.makeBoolean(!this.equal(v1, v2));
                        break;
                    }
                    case 85: {
                        int iv1 = v1.toInt32();
                        int iv2 = v2.toInt32();
                        result = new ESNumber(iv1 & iv2);
                        break;
                    }
                    case 86: {
                        int iv1 = v1.toInt32();
                        int iv2 = v2.toInt32();
                        result = new ESNumber(iv1 | iv2);
                        break;
                    }
                    case 87: {
                        int iv1 = v1.toInt32();
                        int iv2 = v2.toInt32();
                        result = new ESNumber(iv1 ^ iv2);
                        break;
                    }
                    default: {
                        throw new ProgrammingError("Unimplemented binary");
                    }
                }
                v1 = result;
            }
        }
        catch (EcmaScriptException e) {
            throw new PackagedException(e, node);
        }
        return result;
    }

    public Object visit(ASTAndExpressionSequence node, Object data) {
        ESValue result = null;
        int nChildren = node.jjtGetNumChildren();
        try {
            result = EcmaScriptEvaluateVisitor.acceptNull(node.jjtGetChild(0).jjtAccept(this, FOR_VALUE));
            for (int i = 1; result.booleanValue() && i < nChildren; ++i) {
                result = EcmaScriptEvaluateVisitor.acceptNull(node.jjtGetChild(i).jjtAccept(this, FOR_VALUE));
            }
            result = ESBoolean.makeBoolean(result.booleanValue());
        }
        catch (EcmaScriptException e) {
            throw new PackagedException(e, node);
        }
        return result;
    }

    public Object visit(ASTOrExpressionSequence node, Object data) {
        int nChildren = node.jjtGetNumChildren();
        ESValue result = null;
        try {
            result = EcmaScriptEvaluateVisitor.acceptNull(node.jjtGetChild(0).jjtAccept(this, FOR_VALUE));
            for (int i = 1; !result.booleanValue() && i < nChildren; ++i) {
                result = EcmaScriptEvaluateVisitor.acceptNull(node.jjtGetChild(i).jjtAccept(this, FOR_VALUE));
            }
            result = ESBoolean.makeBoolean(result.booleanValue());
        }
        catch (EcmaScriptException e) {
            throw new PackagedException(e, node);
        }
        return result;
    }

    public Object visit(ASTEmptyExpression node, Object data) {
        node.assertNoChildren();
        return ESUndefined.theUndefined;
    }

    public Object visit(ASTConditionalExpression node, Object data) {
        node.assertThreeChildren();
        Object result = null;
        try {
            ESValue t = EcmaScriptEvaluateVisitor.acceptNull(node.jjtGetChild(0).jjtAccept(this, FOR_VALUE));
            boolean test = t.booleanValue();
            result = test ? node.jjtGetChild(1).jjtAccept(this, FOR_VALUE) : node.jjtGetChild(2).jjtAccept(this, FOR_VALUE);
        }
        catch (EcmaScriptException e) {
            throw new PackagedException(e, node);
        }
        return result;
    }

    public Object visit(ASTAssignmentExpression node, Object data) {
        node.assertThreeChildren();
        ESValue result = null;
        try {
            Object lvo = node.jjtGetChild(0).jjtAccept(this, FOR_REFERENCE);
            if (!(lvo instanceof ESReference)) {
                throw new EcmaScriptException("Value '" + lvo.toString() + "' is not an assignable object or property");
            }
            ESReference lv = (ESReference)lvo;
            ESValue v2 = EcmaScriptEvaluateVisitor.acceptNull(node.jjtGetChild(2).jjtAccept(this, FOR_VALUE));
            int operator = ((ASTOperator)node.jjtGetChild(1)).getOperator();
            if (operator == 66) {
                this.evaluator.putValue(lv, v2);
                result = v2;
            } else {
                ESValue v1 = lv.getValue();
                switch (operator) {
                    case 92: {
                        ESValue v1p = v1.toESPrimitive();
                        ESValue v2p = v2.toESPrimitive();
                        if (v1p instanceof ESString || v2p instanceof ESString) {
                            result = new ESString(v1.toString() + v2.toString());
                            break;
                        }
                        result = new ESNumber(v1.doubleValue() + v2.doubleValue());
                        break;
                    }
                    case 93: {
                        result = new ESNumber(v1.doubleValue() - v2.doubleValue());
                        break;
                    }
                    case 94: {
                        result = new ESNumber(v1.doubleValue() * v2.doubleValue());
                        break;
                    }
                    case 95: {
                        result = new ESNumber(v1.doubleValue() / v2.doubleValue());
                        break;
                    }
                    case 96: {
                        int iv1 = v1.toInt32();
                        int iv2 = v2.toInt32();
                        result = new ESNumber(iv1 & iv2);
                        break;
                    }
                    case 97: {
                        int iv1 = v1.toInt32();
                        int iv2 = v2.toInt32();
                        result = new ESNumber(iv1 | iv2);
                        break;
                    }
                    case 98: {
                        int iv1 = v1.toInt32();
                        int iv2 = v2.toInt32();
                        result = new ESNumber(iv1 ^ iv2);
                        break;
                    }
                    case 99: {
                        result = new ESNumber(v1.doubleValue() % v2.doubleValue());
                        break;
                    }
                    case 100: {
                        result = new ESNumber(v1.toInt32() << v2.toUInt32());
                        break;
                    }
                    case 101: {
                        result = new ESNumber(v1.toInt32() >> v2.toUInt32());
                        break;
                    }
                    case 102: {
                        result = new ESNumber(v1.toUInt32() >>> v2.toUInt32());
                        break;
                    }
                    default: {
                        throw new ProgrammingError("Unimplemented assign operator");
                    }
                }
                this.evaluator.putValue(lv, result);
                v2 = result;
            }
        }
        catch (EcmaScriptException e) {
            throw new PackagedException(e, node);
        }
        return result;
    }

    public Object visit(ASTExpressionList node, Object data) {
        int n = node.jjtGetNumChildren();
        Object result = null;
        if (n <= 0) {
            throw new ProgrammingError("Empty expression list");
        }
        result = node.jjtGetChild(0).jjtAccept(this, FOR_VALUE);
        for (int i = 1; i < node.jjtGetNumChildren(); ++i) {
            Node statement = node.jjtGetChild(i);
            result = statement.jjtAccept(this, FOR_VALUE);
        }
        return result;
    }

    public Object visit(ASTLiteral node, Object data) {
        node.assertNoChildren();
        return node.getValue();
    }

    public Object visit(ASTIdentifier node, Object forWhat) {
        Object result;
        try {
            result = forWhat == FOR_VALUE ? this.evaluator.getValue(node.getName(), node.hashCode()) : this.evaluator.getReference(node.getName(), node.hashCode());
        }
        catch (EcmaScriptException e) {
            throw new PackagedException(e, node);
        }
        return result;
    }

    protected static ESValue acceptNull(Object v) {
        if (v == null) {
            return ESUndefined.theUndefined;
        }
        return (ESValue)v;
    }
}

