/*
 * Decompiled with CFR 0.152.
 */
package FESI.Interpreter;

import FESI.Interpreter.Interpret;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Vector;

abstract class Command {
    private static Vector allCommands = new Vector();
    protected String name;
    protected String lowerCaseName;
    protected String help;

    static void printHelp(PrintStream printStream) {
        Enumeration e = allCommands.elements();
        while (e.hasMoreElements()) {
            Command cmd = (Command)e.nextElement();
            printStream.println("  @" + cmd.name + " - " + cmd.help);
        }
    }

    static boolean executeCommand(Interpret interpreter, PrintStream printStream, String command, String parameter) {
        Command cmd;
        Vector<Command> foundCmds = new Vector<Command>();
        String lcCommand = command.toLowerCase();
        Enumeration e = allCommands.elements();
        while (e.hasMoreElements()) {
            cmd = (Command)e.nextElement();
            if (cmd.lowerCaseName.equals(command)) {
                return cmd.doCommand(interpreter, parameter);
            }
            if (!cmd.lowerCaseName.startsWith(command)) continue;
            foundCmds.addElement(cmd);
        }
        if (foundCmds.size() == 0) {
            printStream.println("@@ Command '" + command + "' not recognized");
            interpreter.printHelp();
        } else {
            if (foundCmds.size() == 1) {
                Command cmd2 = (Command)foundCmds.elementAt(0);
                return cmd2.doCommand(interpreter, parameter);
            }
            printStream.println("@@ Command More than one command starting with '" + command + "'");
            e = foundCmds.elements();
            while (e.hasMoreElements()) {
                cmd = (Command)e.nextElement();
                printStream.println("  @" + cmd.name + " - " + cmd.help);
            }
        }
        return false;
    }

    Command(String name, String help) {
        this.name = name;
        this.lowerCaseName = "@" + name.toLowerCase();
        this.help = help;
        allCommands.addElement(this);
    }

    abstract boolean doCommand(Interpret var1, String var2);
}

