/*
 * Decompiled with CFR 0.152.
 */
package FESI.Extensions;

import FESI.Data.BuiltinFunctionObject;
import FESI.Data.ESNumber;
import FESI.Data.ESObject;
import FESI.Data.ESValue;
import FESI.Data.FunctionPrototype;
import FESI.Data.GlobalObject;
import FESI.Exceptions.EcmaScriptException;
import FESI.Extensions.Extension;
import FESI.Interpreter.Evaluator;

public class OptionalRegExp
extends Extension {
    private Evaluator evaluator = null;
    private static Extension loadedRegExpExtension = null;

    public void initializeExtension(Evaluator evaluator) throws EcmaScriptException {
        Object regExp = null;
        this.evaluator = evaluator;
        if (loadedRegExpExtension != null) {
            return;
        }
        regExp = evaluator.addExtension("FESI.Extensions.JavaRegExp");
        if (regExp == null) {
            regExp = evaluator.addExtension("FESI.Extensions.ORORegExp");
        }
        if (regExp == null) {
            regExp = evaluator.addExtension("FESI.Extensions.GNURegExp");
        }
        if (regExp == null) {
            GlobalObject go = evaluator.getGlobalObject();
            FunctionPrototype fp = (FunctionPrototype)evaluator.getFunctionPrototype();
            GlobalObjectRegExp globalObjectRegExp = new GlobalObjectRegExp("RegExp", evaluator, fp);
            globalObjectRegExp.putHiddenProperty("length", new ESNumber(1.0));
            go.putHiddenProperty("RegExp", globalObjectRegExp);
        }
    }

    public static void setLoadedRegExp(Extension regExp) {
        if (loadedRegExpExtension != null) {
            throw new IllegalStateException("Attempt to load extension " + regExp + " when conflicting extension " + loadedRegExpExtension + " is already loaded");
        }
        if (regExp == null) {
            throw new NullPointerException("regExp");
        }
        loadedRegExpExtension = regExp;
    }

    public static boolean hasLoadedRegExp() {
        return loadedRegExpExtension != null;
    }

    class GlobalObjectRegExp
    extends BuiltinFunctionObject {
        GlobalObjectRegExp(String name, Evaluator evaluator, FunctionPrototype fp) {
            super(fp, evaluator, name, 1);
        }

        public ESValue callFunction(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
            return this.doConstruct(thisObject, arguments);
        }

        public ESObject doConstruct(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
            throw new EcmaScriptException("RegExp package not loaded, probably not on CLASSPATH");
        }
    }
}

