/*
 * Decompiled with CFR 0.152.
 */
package FESI.Extensions;

import FESI.Data.ArrayPrototype;
import FESI.Data.BuiltinFunctionObject;
import FESI.Data.ESBoolean;
import FESI.Data.ESNull;
import FESI.Data.ESNumber;
import FESI.Data.ESObject;
import FESI.Data.ESString;
import FESI.Data.ESValue;
import FESI.Data.FunctionPrototype;
import FESI.Data.GlobalObject;
import FESI.Data.ObjectPrototype;
import FESI.Exceptions.EcmaScriptException;
import FESI.Extensions.ESORORegExp;
import FESI.Extensions.Extension;
import FESI.Extensions.OptionalRegExp;
import FESI.Interpreter.Evaluator;
import java.util.ArrayList;
import org.apache.oro.text.regex.MatchResult;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternCompiler;
import org.apache.oro.text.regex.PatternMatcher;
import org.apache.oro.text.regex.PatternMatcherInput;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;
import org.apache.oro.text.regex.Perl5Substitution;
import org.apache.oro.text.regex.Substitution;
import org.apache.oro.text.regex.Util;

public class ORORegExp
extends Extension {
    private static final String INDEXstring = "index".intern();
    private static final int INDEXhash = INDEXstring.hashCode();
    private static final String INPUTstring = "input".intern();
    private static final int INPUThash = INPUTstring.hashCode();
    private Evaluator evaluator = null;
    private ESObject esRegExpPrototype;
    private PatternCompiler compiler;
    private PatternMatcher matcher;

    public void initializeExtension(Evaluator evaluator) throws EcmaScriptException {
        this.compiler = new Perl5Compiler();
        this.matcher = new Perl5Matcher();
        this.evaluator = evaluator;
        GlobalObject go = evaluator.getGlobalObject();
        ObjectPrototype op = (ObjectPrototype)evaluator.getObjectPrototype();
        FunctionPrototype fp = (FunctionPrototype)evaluator.getFunctionPrototype();
        this.esRegExpPrototype = new ESORORegExp(op, evaluator, this.compiler, this.matcher);
        GlobalObjectRegExp globalObjectRegExp = new GlobalObjectRegExp("RegExp", evaluator, fp);
        globalObjectRegExp.putHiddenProperty("prototype", this.esRegExpPrototype);
        globalObjectRegExp.putHiddenProperty("length", new ESNumber(1.0));
        this.esRegExpPrototype.putHiddenProperty("constructor", globalObjectRegExp);
        this.esRegExpPrototype.putHiddenProperty("test", new ESRegExpPrototypeTest("test", evaluator, fp));
        this.esRegExpPrototype.putHiddenProperty("exec", new ESRegExpPrototypeExec("exec", evaluator, fp));
        go.putHiddenProperty("RegExp", globalObjectRegExp);
        ESObject stringPrototype = evaluator.getStringPrototype();
        class StringPrototypeSearch
        extends BuiltinFunctionObject {
            StringPrototypeSearch(String name, Evaluator evaluator, FunctionPrototype fp) {
                super(fp, evaluator, name, 1);
            }

            public ESValue callFunction(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
                if (arguments.length < 1) {
                    throw new EcmaScriptException("search requires 1 pattern argument");
                }
                String str = thisObject.toString();
                PatternMatcherInput input = new PatternMatcherInput(str);
                if (!(arguments[0] instanceof ESORORegExp)) {
                    throw new EcmaScriptException("The search argument must be a RegExp");
                }
                ESORORegExp pattern = (ESORORegExp)arguments[0];
                if (ORORegExp.this.matcher.contains(input, pattern.getPattern())) {
                    MatchResult result = ORORegExp.this.matcher.getMatch();
                    return new ESNumber(result.beginOffset(0));
                }
                return new ESNumber(-1.0);
            }
        }
        stringPrototype.putHiddenProperty("search", new StringPrototypeSearch("search", evaluator, fp));
        class StringPrototypeReplace
        extends BuiltinFunctionObject {
            StringPrototypeReplace(String name, Evaluator evaluator, FunctionPrototype fp) {
                super(fp, evaluator, name, 1);
            }

            public ESValue callFunction(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
                if (arguments.length < 2) {
                    throw new EcmaScriptException("replace requires 2 arguments: pattern and replacement string");
                }
                String str = thisObject.toString();
                if (!(arguments[0] instanceof ESORORegExp)) {
                    throw new EcmaScriptException("The replace argument must be a RegExp");
                }
                ESORORegExp pattern = (ESORORegExp)arguments[0];
                String replacement = arguments[1].toString();
                Perl5Substitution substitution = new Perl5Substitution(replacement);
                String result = Util.substitute((PatternMatcher)ORORegExp.this.matcher, (Pattern)pattern.getPattern(), (Substitution)substitution, (String)str, (int)(pattern.isGlobal() ? -1 : 1));
                return new ESString(result);
            }
        }
        stringPrototype.putHiddenProperty("replace", new StringPrototypeReplace("replace", evaluator, fp));
        class StringPrototypeMatch
        extends BuiltinFunctionObject {
            StringPrototypeMatch(String name, Evaluator evaluator, FunctionPrototype fp) {
                super(fp, evaluator, name, 1);
            }

            public ESValue callFunction(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
                if (arguments.length < 1) {
                    throw new EcmaScriptException("match requires 1 pattern argument");
                }
                String str = thisObject.toString();
                if (!(arguments[0] instanceof ESORORegExp)) {
                    throw new EcmaScriptException("The match argument must be a RegExp");
                }
                ESORORegExp pattern = (ESORORegExp)arguments[0];
                PatternMatcherInput input = new PatternMatcherInput(str);
                if (ORORegExp.this.matcher.contains(input, pattern.getPattern())) {
                    MatchResult result = ORORegExp.this.matcher.getMatch();
                    int groups = result.groups();
                    ESObject ap = this.evaluator.getArrayPrototype();
                    ArrayPrototype resultArray = new ArrayPrototype(ap, this.evaluator);
                    resultArray.setSize(groups);
                    resultArray.putProperty(INDEXstring, new ESNumber(result.beginOffset(0)), INDEXhash);
                    resultArray.putProperty(INPUTstring, new ESString(str), INPUThash);
                    for (int i = 0; i < groups; ++i) {
                        int beg = result.beginOffset(i);
                        int end = result.endOffset(i);
                        resultArray.setElementAt(new ESString(str.substring(beg, end)), i);
                    }
                    return resultArray;
                }
                return ESNull.theNull;
            }
        }
        stringPrototype.putHiddenProperty("match", new StringPrototypeMatch("match", evaluator, fp));
        class StringPrototypeSplit
        extends BuiltinFunctionObject {
            StringPrototypeSplit(String name, Evaluator evaluator, FunctionPrototype fp) {
                super(fp, evaluator, name, 1);
            }

            public ESValue callFunction(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
                String str = thisObject.toString();
                ESObject ap = this.evaluator.getArrayPrototype();
                ArrayPrototype theArray = new ArrayPrototype(ap, this.evaluator);
                if (arguments.length <= 0) {
                    theArray.setSize(1);
                    theArray.setElementAt(thisObject, 0);
                } else if (arguments[0] instanceof ESORORegExp) {
                    ESORORegExp pattern = (ESORORegExp)arguments[0];
                    int n = 0;
                    if (arguments.length > 1) {
                        n = arguments[1].toUInt32();
                    }
                    ArrayList result = new ArrayList();
                    Util.split(result, (PatternMatcher)ORORegExp.this.matcher, (Pattern)pattern.getPattern(), (String)str, (int)n);
                    int l = result.size();
                    theArray.setSize(l);
                    for (int i = 0; i < l; ++i) {
                        theArray.setElementAt(new ESString((String)result.get(i)), i);
                    }
                } else {
                    String sep = arguments[0].toString();
                    if (sep.length() == 0) {
                        int l = str.length();
                        theArray.setSize(l);
                        for (int i = 0; i < l; ++i) {
                            theArray.setElementAt(new ESString(str.substring(i, i + 1)), i);
                        }
                    } else {
                        int i = 0;
                        int start = 0;
                        while (start < str.length()) {
                            int pos = str.indexOf(sep, start);
                            if (pos < 0) {
                                pos = str.length();
                            }
                            theArray.setSize(i + 1);
                            theArray.setElementAt(new ESString(str.substring(start, pos)), i);
                            start = pos + sep.length();
                            ++i;
                        }
                    }
                }
                return theArray;
            }
        }
        stringPrototype.putHiddenProperty("split", new StringPrototypeSplit("split", evaluator, fp));
        OptionalRegExp.setLoadedRegExp(this);
    }

    class GlobalObjectRegExp
    extends BuiltinFunctionObject {
        GlobalObjectRegExp(String name, Evaluator evaluator, FunctionPrototype fp) {
            super(fp, evaluator, name, 1);
        }

        public ESValue callFunction(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
            return this.doConstruct(thisObject, arguments);
        }

        public ESObject doConstruct(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
            ESORORegExp regExp = null;
            if (arguments.length == 0) {
                throw new EcmaScriptException("RegExp requires 1 or 2 arguments");
            }
            if (arguments.length == 1) {
                regExp = new ESORORegExp(ORORegExp.this.esRegExpPrototype, this.evaluator, ORORegExp.this.compiler, ORORegExp.this.matcher, arguments[0].toString());
            }
            return regExp;
        }
    }

    class ESRegExpPrototypeExec
    extends BuiltinFunctionObject {
        ESRegExpPrototypeExec(String name, Evaluator evaluator, FunctionPrototype fp) {
            super(fp, evaluator, name, 1);
        }

        public ESValue callFunction(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
            if (arguments.length < 1) {
                throw new EcmaScriptException("exec requires 1 string argument");
            }
            ESORORegExp pattern = (ESORORegExp)thisObject;
            String str = arguments[0].toString();
            PatternMatcherInput input = new PatternMatcherInput(str);
            if (ORORegExp.this.matcher.contains(input, pattern.getPattern())) {
                MatchResult result = ORORegExp.this.matcher.getMatch();
                int groups = result.groups();
                ESObject ap = this.evaluator.getArrayPrototype();
                ArrayPrototype resultArray = new ArrayPrototype(ap, this.evaluator);
                resultArray.setSize(groups);
                resultArray.putProperty(INDEXstring, new ESNumber(result.beginOffset(0)), INDEXhash);
                resultArray.putProperty(INPUTstring, new ESString(str), INPUThash);
                for (int i = 0; i < groups; ++i) {
                    int beg = result.beginOffset(i);
                    int end = result.endOffset(i);
                    if (beg < 0 || end < 0) {
                        resultArray.setElementAt(new ESString(""), i);
                        continue;
                    }
                    resultArray.setElementAt(new ESString(str.substring(beg, end)), i);
                }
                return resultArray;
            }
            return ESNull.theNull;
        }
    }

    class ESRegExpPrototypeTest
    extends BuiltinFunctionObject {
        ESRegExpPrototypeTest(String name, Evaluator evaluator, FunctionPrototype fp) {
            super(fp, evaluator, name, 1);
        }

        public ESValue callFunction(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
            if (arguments.length < 1) {
                throw new EcmaScriptException("test requires 1 string argument");
            }
            ESORORegExp pattern = (ESORORegExp)thisObject;
            String str = arguments[0].toString();
            PatternMatcherInput input = new PatternMatcherInput(str);
            return ESBoolean.makeBoolean(ORORegExp.this.matcher.contains(input, pattern.getPattern()));
        }
    }
}

