/*
 * Decompiled with CFR 0.152.
 */
package FESI.Extensions;

import FESI.Data.ArrayPrototype;
import FESI.Data.BuiltinFunctionObject;
import FESI.Data.ESBoolean;
import FESI.Data.ESNull;
import FESI.Data.ESNumber;
import FESI.Data.ESObject;
import FESI.Data.ESString;
import FESI.Data.ESValue;
import FESI.Data.FunctionPrototype;
import FESI.Data.GlobalObject;
import FESI.Data.ObjectPrototype;
import FESI.Exceptions.EcmaScriptException;
import FESI.Extensions.ESJavaRegExp;
import FESI.Extensions.Extension;
import FESI.Extensions.OptionalRegExp;
import FESI.Interpreter.Evaluator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaRegExp
extends Extension {
    private static final String INDEXstring = "index".intern();
    private static final int INDEXhash = INDEXstring.hashCode();
    private static final String INPUTstring = "input".intern();
    private static final int INPUThash = INPUTstring.hashCode();
    private Evaluator evaluator = null;
    private ESObject esRegExpPrototype;

    public void initializeExtension(Evaluator evaluator) throws EcmaScriptException {
        this.evaluator = evaluator;
        GlobalObject go = evaluator.getGlobalObject();
        ObjectPrototype op = (ObjectPrototype)evaluator.getObjectPrototype();
        FunctionPrototype fp = (FunctionPrototype)evaluator.getFunctionPrototype();
        this.esRegExpPrototype = new ESJavaRegExp(op, evaluator);
        GlobalObjectRegExp globalObjectRegExp = new GlobalObjectRegExp("RegExp", evaluator, fp);
        globalObjectRegExp.putHiddenProperty("prototype", this.esRegExpPrototype);
        globalObjectRegExp.putHiddenProperty("length", new ESNumber(1.0));
        this.esRegExpPrototype.putHiddenProperty("constructor", globalObjectRegExp);
        this.esRegExpPrototype.putHiddenProperty("test", new ESRegExpPrototypeTest("test", evaluator, fp));
        this.esRegExpPrototype.putHiddenProperty("exec", new ESRegExpPrototypeExec("exec", evaluator, fp));
        go.putHiddenProperty("RegExp", globalObjectRegExp);
        ESObject stringPrototype = evaluator.getStringPrototype();
        class StringPrototypeSearch
        extends BuiltinFunctionObject {
            StringPrototypeSearch(String name, Evaluator evaluator, FunctionPrototype fp) {
                super(fp, evaluator, name, 1);
            }

            public ESValue callFunction(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
                if (arguments.length < 1) {
                    throw new EcmaScriptException("search requires 1 pattern argument");
                }
                String str = thisObject.toString();
                if (!(arguments[0] instanceof ESJavaRegExp)) {
                    throw new EcmaScriptException("The search argument must be a RegExp");
                }
                ESJavaRegExp pattern = (ESJavaRegExp)arguments[0];
                Matcher matcher = pattern.getPattern().matcher(str);
                if (matcher.find()) {
                    return new ESNumber(matcher.start());
                }
                return new ESNumber(-1.0);
            }
        }
        stringPrototype.putHiddenProperty("search", new StringPrototypeSearch("search", evaluator, fp));
        class StringPrototypeReplace
        extends BuiltinFunctionObject {
            StringPrototypeReplace(String name, Evaluator evaluator, FunctionPrototype fp) {
                super(fp, evaluator, name, 1);
            }

            public ESValue callFunction(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
                if (arguments.length < 2) {
                    throw new EcmaScriptException("replace requires 2 arguments: pattern and replacement string");
                }
                String str = thisObject.toString();
                if (!(arguments[0] instanceof ESJavaRegExp)) {
                    throw new EcmaScriptException("The replace argument must be a RegExp");
                }
                ESJavaRegExp pattern = (ESJavaRegExp)arguments[0];
                Matcher matcher = pattern.getPattern().matcher(str);
                String replacement = arguments[1].toString();
                if (pattern.isGlobal()) {
                    return new ESString(matcher.replaceAll(replacement));
                }
                return new ESString(matcher.replaceFirst(replacement));
            }
        }
        stringPrototype.putHiddenProperty("replace", new StringPrototypeReplace("replace", evaluator, fp));
        class StringPrototypeMatch
        extends BuiltinFunctionObject {
            StringPrototypeMatch(String name, Evaluator evaluator, FunctionPrototype fp) {
                super(fp, evaluator, name, 1);
            }

            public ESValue callFunction(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
                if (arguments.length < 1) {
                    throw new EcmaScriptException("match requires 1 pattern argument");
                }
                String str = thisObject.toString();
                if (!(arguments[0] instanceof ESJavaRegExp)) {
                    throw new EcmaScriptException("The match argument must be a RegExp");
                }
                ESJavaRegExp pattern = (ESJavaRegExp)arguments[0];
                Matcher matcher = pattern.getPattern().matcher(str);
                boolean result = matcher.find();
                if (result) {
                    ESObject ap = this.evaluator.getArrayPrototype();
                    ArrayPrototype resultArray = new ArrayPrototype(ap, this.evaluator);
                    resultArray.putProperty(INDEXstring, new ESNumber(matcher.start()), INDEXhash);
                    resultArray.putProperty(INPUTstring, new ESString(str), INPUThash);
                    resultArray.setSize(matcher.groupCount() + 1);
                    for (int i = 0; i <= matcher.groupCount(); ++i) {
                        int beg = matcher.start(i);
                        int end = matcher.end(i);
                        resultArray.setElementAt(new ESString(matcher.group(i)), i);
                    }
                    return resultArray;
                }
                return ESNull.theNull;
            }
        }
        stringPrototype.putHiddenProperty("match", new StringPrototypeMatch("match", evaluator, fp));
        class StringPrototypeSplit
        extends BuiltinFunctionObject {
            StringPrototypeSplit(String name, Evaluator evaluator, FunctionPrototype fp) {
                super(fp, evaluator, name, 1);
            }

            public ESValue callFunction(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
                String str = thisObject.toString();
                ESObject ap = this.evaluator.getArrayPrototype();
                ArrayPrototype theArray = new ArrayPrototype(ap, this.evaluator);
                if (arguments.length <= 0) {
                    theArray.setSize(1);
                    theArray.setElementAt(thisObject, 0);
                } else if (arguments[0] instanceof ESJavaRegExp) {
                    ESJavaRegExp pattern = (ESJavaRegExp)arguments[0];
                    Pattern spliter = pattern.getPattern();
                    String[] result = null;
                    if (arguments.length > 1) {
                        int n = arguments[1].toUInt32();
                        result = spliter.split(str, n);
                    } else {
                        result = spliter.split(str);
                    }
                    int l = result.length;
                    theArray.setSize(l);
                    for (int i = 0; i < l; ++i) {
                        theArray.setElementAt(new ESString(result[i]), i);
                    }
                } else {
                    String sep = arguments[0].toString();
                    if (sep.length() == 0) {
                        int l = str.length();
                        theArray.setSize(l);
                        for (int i = 0; i < l; ++i) {
                            theArray.setElementAt(new ESString(str.substring(i, i + 1)), i);
                        }
                    } else {
                        int i = 0;
                        int start = 0;
                        while (start < str.length()) {
                            int pos = str.indexOf(sep, start);
                            if (pos < 0) {
                                pos = str.length();
                            }
                            theArray.setSize(i + 1);
                            theArray.setElementAt(new ESString(str.substring(start, pos)), i);
                            start = pos + sep.length();
                            ++i;
                        }
                    }
                }
                return theArray;
            }
        }
        stringPrototype.putHiddenProperty("split", new StringPrototypeSplit("split", evaluator, fp));
        OptionalRegExp.setLoadedRegExp(this);
    }

    class GlobalObjectRegExp
    extends BuiltinFunctionObject {
        GlobalObjectRegExp(String name, Evaluator evaluator, FunctionPrototype fp) {
            super(fp, evaluator, name, 1);
        }

        public ESValue callFunction(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
            return this.doConstruct(thisObject, arguments);
        }

        public ESObject doConstruct(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
            ESJavaRegExp regExp = null;
            if (arguments.length == 0) {
                throw new EcmaScriptException("RegExp requires 1 or 2 arguments");
            }
            if (arguments.length == 1) {
                regExp = new ESJavaRegExp(JavaRegExp.this.esRegExpPrototype, this.evaluator, arguments[0].toString());
            }
            return regExp;
        }
    }

    class ESRegExpPrototypeExec
    extends BuiltinFunctionObject {
        ESRegExpPrototypeExec(String name, Evaluator evaluator, FunctionPrototype fp) {
            super(fp, evaluator, name, 1);
        }

        public ESValue callFunction(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
            if (arguments.length < 1) {
                throw new EcmaScriptException("exec requires 1 string argument");
            }
            ESJavaRegExp pattern = (ESJavaRegExp)thisObject;
            String str = arguments[0].toString();
            Matcher matcher = pattern.getPattern().matcher(str);
            boolean result = matcher.find();
            if (result) {
                ESObject ap = this.evaluator.getArrayPrototype();
                ArrayPrototype resultArray = new ArrayPrototype(ap, this.evaluator);
                resultArray.putProperty(INDEXstring, new ESNumber(matcher.start()), INDEXhash);
                resultArray.putProperty(INPUTstring, new ESString(str), INPUThash);
                resultArray.setSize(matcher.groupCount() + 1);
                for (int i = 0; i <= matcher.groupCount(); ++i) {
                    int beg = matcher.start(i);
                    int end = matcher.end(i);
                    resultArray.setElementAt(new ESString(matcher.group(i)), i);
                }
                return resultArray;
            }
            return ESNull.theNull;
        }
    }

    class ESRegExpPrototypeTest
    extends BuiltinFunctionObject {
        ESRegExpPrototypeTest(String name, Evaluator evaluator, FunctionPrototype fp) {
            super(fp, evaluator, name, 1);
        }

        public ESValue callFunction(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
            if (arguments.length < 1) {
                throw new EcmaScriptException("test requires 1 string argument");
            }
            ESJavaRegExp pattern = (ESJavaRegExp)thisObject;
            String str = arguments[0].toString();
            Matcher matcher = pattern.getPattern().matcher(str);
            return ESBoolean.makeBoolean(matcher.find());
        }
    }
}

