/*
 * Decompiled with CFR 0.152.
 */
package FESI.Extensions;

import FESI.Data.BuiltinFunctionObject;
import FESI.Data.ESBeans;
import FESI.Data.ESBoolean;
import FESI.Data.ESLoader;
import FESI.Data.ESObject;
import FESI.Data.ESPackages;
import FESI.Data.ESString;
import FESI.Data.ESUndefined;
import FESI.Data.ESValue;
import FESI.Data.FunctionPrototype;
import FESI.Data.GlobalObject;
import FESI.Exceptions.EcmaScriptException;
import FESI.Extensions.Extension;
import FESI.Interpreter.Evaluator;

public class JavaAccess
extends Extension {
    private Evaluator evaluator = null;

    public void initializeExtension(Evaluator evaluator) throws EcmaScriptException {
        this.evaluator = evaluator;
        GlobalObject go = evaluator.getGlobalObject();
        FunctionPrototype fp = (FunctionPrototype)evaluator.getFunctionPrototype();
        go.putHiddenProperty("javaTypeOf", new GlobalObjectJavaTypeOf("javaTypeOf", evaluator, fp));
        go.putHiddenProperty("loadExtension", new GlobalObjectLoadExtension("loadExtension", evaluator, fp));
        ESPackages packagesObject = (ESPackages)evaluator.getPackageObject();
        String java = "java".intern();
        ESPackages javaPackages = (ESPackages)packagesObject.getProperty(java, java.hashCode());
        go.putHiddenProperty("Packages", packagesObject);
        go.putHiddenProperty(java, javaPackages);
        ESBeans javaBeans = new ESBeans(evaluator);
        go.putHiddenProperty("Beans", javaBeans);
    }

    class GlobalObjectLoadExtension
    extends BuiltinFunctionObject {
        GlobalObjectLoadExtension(String name, Evaluator evaluator, FunctionPrototype fp) {
            super(fp, evaluator, name, 1);
        }

        public ESValue callFunction(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
            Object ext = null;
            if (arguments.length > 0) {
                String pathName = arguments[0].toString();
                ext = this.evaluator.addExtension(pathName);
            }
            return ESBoolean.makeBoolean(ext != null);
        }
    }

    class GlobalObjectJavaTypeOf
    extends BuiltinFunctionObject {
        GlobalObjectJavaTypeOf(String name, Evaluator evaluator, FunctionPrototype fp) {
            super(fp, evaluator, name, 1);
        }

        public ESValue callFunction(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
            if (arguments.length > 0) {
                Object obj = arguments[0].toJavaObject();
                String cn = obj == null ? "null" : ESLoader.typeName(obj.getClass());
                return new ESString(cn);
            }
            return ESUndefined.theUndefined;
        }
    }
}

