/*
 * Decompiled with CFR 0.152.
 */
package FESI.Extensions;

import FESI.Data.ArrayPrototype;
import FESI.Data.BuiltinFunctionObject;
import FESI.Data.ESBoolean;
import FESI.Data.ESNull;
import FESI.Data.ESNumber;
import FESI.Data.ESObject;
import FESI.Data.ESString;
import FESI.Data.ESValue;
import FESI.Data.FunctionPrototype;
import FESI.Data.GlobalObject;
import FESI.Data.ObjectPrototype;
import FESI.Exceptions.EcmaScriptException;
import FESI.Extensions.ESGNURegExp;
import FESI.Extensions.Extension;
import FESI.Extensions.OptionalRegExp;
import FESI.Interpreter.Evaluator;
import gnu.regexp.RE;
import gnu.regexp.REMatch;
import java.util.Vector;

public class GNURegExp
extends Extension {
    private static final String INDEXstring = "index";
    private static final int INDEXhash = "index".hashCode();
    private static final String INPUTstring = "input";
    private static final int INPUThash = "input".hashCode();
    private Evaluator evaluator = null;
    private ESObject esRegExpPrototype;

    public void initializeExtension(Evaluator evaluator) throws EcmaScriptException {
        this.evaluator = evaluator;
        GlobalObject go = evaluator.getGlobalObject();
        ObjectPrototype op = (ObjectPrototype)evaluator.getObjectPrototype();
        FunctionPrototype fp = (FunctionPrototype)evaluator.getFunctionPrototype();
        this.esRegExpPrototype = new ESGNURegExp(op, evaluator);
        GlobalObjectRegExp globalObjectRegExp = new GlobalObjectRegExp("RegExp", evaluator, fp);
        globalObjectRegExp.putHiddenProperty("prototype", this.esRegExpPrototype);
        globalObjectRegExp.putHiddenProperty("length", new ESNumber(1.0));
        this.esRegExpPrototype.putHiddenProperty("constructor", globalObjectRegExp);
        this.esRegExpPrototype.putHiddenProperty("test", new ESRegExpPrototypeTest("test", evaluator, fp));
        this.esRegExpPrototype.putHiddenProperty("exec", new ESRegExpPrototypeExec("exec", evaluator, fp));
        go.putHiddenProperty("RegExp", globalObjectRegExp);
        ESObject stringPrototype = evaluator.getStringPrototype();
        class StringPrototypeSearch
        extends BuiltinFunctionObject {
            StringPrototypeSearch(String name, Evaluator evaluator, FunctionPrototype fp) {
                super(fp, evaluator, name, 1);
            }

            public ESValue callFunction(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
                if (arguments.length < 1) {
                    throw new EcmaScriptException("search requires 1 pattern argument");
                }
                String str = thisObject.toString();
                if (!(arguments[0] instanceof ESGNURegExp)) {
                    throw new EcmaScriptException("The search argument must be a GNURegExp");
                }
                ESGNURegExp pattern = (ESGNURegExp)arguments[0];
                RE re = pattern.getPattern();
                REMatch match = re.getMatch((Object)str);
                int matchStart = match == null ? -1 : match.getStartIndex();
                return new ESNumber(matchStart);
            }
        }
        stringPrototype.putHiddenProperty("search", new StringPrototypeSearch("search", evaluator, fp));
        class StringPrototypeReplace
        extends BuiltinFunctionObject {
            StringPrototypeReplace(String name, Evaluator evaluator, FunctionPrototype fp) {
                super(fp, evaluator, name, 1);
            }

            public ESValue callFunction(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
                if (arguments.length < 2) {
                    throw new EcmaScriptException("replace requires 2 arguments: pattern and replacement string");
                }
                String str = thisObject.toString();
                if (!(arguments[0] instanceof ESGNURegExp)) {
                    throw new EcmaScriptException("The replace argument must be a GNURegExp");
                }
                ESGNURegExp pattern = (ESGNURegExp)arguments[0];
                String replacement = arguments[1].toString();
                RE re = pattern.getPattern();
                String result = null;
                result = pattern.isGlobal() ? re.substituteAll((Object)str, replacement) : re.substitute((Object)str, replacement);
                return new ESString(result);
            }
        }
        stringPrototype.putHiddenProperty("replace", new StringPrototypeReplace("replace", evaluator, fp));
        class StringPrototypeMatch
        extends BuiltinFunctionObject {
            StringPrototypeMatch(String name, Evaluator evaluator, FunctionPrototype fp) {
                super(fp, evaluator, name, 1);
            }

            public ESValue callFunction(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
                if (arguments.length < 1) {
                    throw new EcmaScriptException("match requires 1 pattern argument");
                }
                String str = thisObject.toString();
                if (!(arguments[0] instanceof ESGNURegExp)) {
                    throw new EcmaScriptException("The match argument must be a GNURegExp");
                }
                ESGNURegExp pattern = (ESGNURegExp)arguments[0];
                RE re = pattern.getPattern();
                REMatch match = re.getMatch((Object)str);
                if (match != null) {
                    int groups = re.getNumSubs() + 1;
                    ESObject ap = this.evaluator.getArrayPrototype();
                    ArrayPrototype resultArray = new ArrayPrototype(ap, this.evaluator);
                    resultArray.setSize(groups);
                    resultArray.putProperty(GNURegExp.INDEXstring, new ESNumber(match.getStartIndex()), INDEXhash);
                    resultArray.putProperty(GNURegExp.INPUTstring, new ESString(str), INPUThash);
                    for (int i = 0; i < groups; ++i) {
                        String sub = match.toString(i);
                        if (sub != null) {
                            resultArray.setElementAt(new ESString(sub), i);
                            continue;
                        }
                        resultArray.setElementAt(new ESString(""), i);
                    }
                    return resultArray;
                }
                return ESNull.theNull;
            }
        }
        stringPrototype.putHiddenProperty("match", new StringPrototypeMatch("match", evaluator, fp));
        class StringPrototypeSplit
        extends BuiltinFunctionObject {
            StringPrototypeSplit(String name, Evaluator evaluator, FunctionPrototype fp) {
                super(fp, evaluator, name, 1);
            }

            public ESValue callFunction(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
                String str = thisObject.toString();
                ESObject ap = this.evaluator.getArrayPrototype();
                ArrayPrototype theArray = new ArrayPrototype(ap, this.evaluator);
                if (arguments.length <= 0) {
                    theArray.setSize(1);
                    theArray.setElementAt(thisObject, 0);
                } else if (arguments[0] instanceof ESGNURegExp) {
                    ESGNURegExp pattern = (ESGNURegExp)arguments[0];
                    int n = -1;
                    if (arguments.length > 1 && (n = arguments[1].toUInt32()) <= 0) {
                        n = -1;
                    }
                    RE re = pattern.getPattern();
                    Vector<String> result = new Vector<String>();
                    int pos = 0;
                    int len = str.length();
                    while (pos < len) {
                        REMatch match = re.getMatch((Object)str, pos);
                        if (match != null && (n == -1 || n - 1 > result.size())) {
                            int start = match.getStartIndex();
                            int end = match.getEndIndex();
                            int matchLen = end - start;
                            int chunkLen = start - pos;
                            if (matchLen == 0) {
                                ++chunkLen;
                            }
                            result.addElement(str.substring(pos, pos + chunkLen));
                            pos = Math.max(end, pos + 1);
                            continue;
                        }
                        result.addElement(str.substring(pos));
                        break;
                    }
                    int l = result.size();
                    theArray.setSize(l);
                    for (int i = 0; i < l; ++i) {
                        theArray.setElementAt(new ESString((String)result.elementAt(i)), i);
                    }
                } else {
                    String sep = arguments[0].toString();
                    int strLen = str.length();
                    int sepLen = sep.length();
                    if (sepLen == 0) {
                        theArray.setSize(strLen);
                        for (int i = 0; i < strLen; ++i) {
                            theArray.setElementAt(new ESString(str.substring(i, i + 1)), i);
                        }
                    } else {
                        int i = 0;
                        int start = 0;
                        while (start < strLen) {
                            int pos = str.indexOf(sep, start);
                            if (pos < 0) {
                                pos = strLen;
                            }
                            theArray.setSize(i + 1);
                            theArray.setElementAt(new ESString(str.substring(start, pos)), i);
                            start = pos + sepLen;
                            ++i;
                        }
                    }
                }
                return theArray;
            }
        }
        stringPrototype.putHiddenProperty("split", new StringPrototypeSplit("split", evaluator, fp));
        OptionalRegExp.setLoadedRegExp(this);
    }

    class GlobalObjectRegExp
    extends BuiltinFunctionObject {
        GlobalObjectRegExp(String name, Evaluator evaluator, FunctionPrototype fp) {
            super(fp, evaluator, name, 1);
        }

        public ESValue callFunction(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
            return this.doConstruct(thisObject, arguments);
        }

        public ESObject doConstruct(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
            ESGNURegExp regExp = null;
            if (arguments.length == 0) {
                throw new EcmaScriptException("GNURegExp requires 1 argument");
            }
            if (arguments.length == 1) {
                regExp = new ESGNURegExp(GNURegExp.this.esRegExpPrototype, this.evaluator, arguments[0].toString());
            }
            return regExp;
        }
    }

    class ESRegExpPrototypeExec
    extends BuiltinFunctionObject {
        ESRegExpPrototypeExec(String name, Evaluator evaluator, FunctionPrototype fp) {
            super(fp, evaluator, name, 1);
        }

        public ESValue callFunction(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
            String str;
            if (arguments.length < 1) {
                throw new EcmaScriptException("exec requires 1 string argument");
            }
            RE pattern = ((ESGNURegExp)thisObject).getPattern();
            REMatch match = pattern.getMatch((Object)(str = arguments[0].toString()));
            if (match != null) {
                int groups = pattern.getNumSubs() + 1;
                ESObject ap = this.evaluator.getArrayPrototype();
                ArrayPrototype resultArray = new ArrayPrototype(ap, this.evaluator);
                resultArray.setSize(groups);
                resultArray.putProperty(GNURegExp.INDEXstring, new ESNumber(match.getStartIndex()), INDEXhash);
                resultArray.putProperty(GNURegExp.INPUTstring, new ESString(str), INPUThash);
                for (int i = 0; i < groups; ++i) {
                    String sub = match.toString(i);
                    resultArray.setElementAt(new ESString(sub == null ? "" : sub), i);
                }
                return resultArray;
            }
            return ESNull.theNull;
        }
    }

    class ESRegExpPrototypeTest
    extends BuiltinFunctionObject {
        ESRegExpPrototypeTest(String name, Evaluator evaluator, FunctionPrototype fp) {
            super(fp, evaluator, name, 1);
        }

        public ESValue callFunction(ESObject thisObject, ESValue[] arguments) throws EcmaScriptException {
            if (arguments.length < 1) {
                throw new EcmaScriptException("test requires 1 string argument");
            }
            RE pattern = ((ESGNURegExp)thisObject).getPattern();
            boolean contains = pattern.getMatch((Object)arguments[0].toString()) != null;
            return ESBoolean.makeBoolean(contains);
        }
    }
}

