/*
 * Decompiled with CFR 0.152.
 */
package FESI.Extensions;

import FESI.Data.ESBoolean;
import FESI.Data.ESLoader;
import FESI.Data.ESNumber;
import FESI.Data.ESObject;
import FESI.Data.ESUndefined;
import FESI.Data.ESValue;
import FESI.Exceptions.EcmaScriptException;
import FESI.Extensions.ESDatabase;
import FESI.Interpreter.Evaluator;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Vector;

class ESRowSet
extends ESObject {
    private transient ESDatabase database = null;
    private transient String sql = null;
    private transient Statement statement = null;
    private transient ResultSet resultSet = null;
    private transient ResultSetMetaData resultSetMetaData = null;
    private transient Vector colNames = null;
    private transient boolean lastRowSeen = false;
    private transient boolean firstRowSeen = false;
    private transient Exception lastError = null;

    ESRowSet(ESObject prototype, Evaluator evaluator, String sql, ESDatabase database, Statement statement, ResultSet resultSet) throws EcmaScriptException {
        super(prototype, evaluator);
        this.sql = sql;
        this.database = database;
        this.statement = statement;
        this.resultSet = resultSet;
        if (sql == null) {
            throw new NullPointerException("sql");
        }
        if (resultSet == null) {
            throw new NullPointerException("resultSet");
        }
        if (statement == null) {
            throw new NullPointerException("statement");
        }
        if (database == null) {
            throw new NullPointerException("database");
        }
        try {
            this.resultSetMetaData = resultSet.getMetaData();
            int numcols = this.resultSetMetaData.getColumnCount();
            this.colNames = new Vector(numcols);
            for (int i = 0; i < numcols; ++i) {
                String colName = this.resultSetMetaData.getColumnLabel(i + 1);
                this.colNames.addElement(colName);
            }
        }
        catch (SQLException e) {
            this.colNames = new Vector();
            throw new EcmaScriptException("Could not get column names", e);
        }
    }

    public String getESClassName() {
        return "RowSet";
    }

    public String toDetailString() {
        return "ES:[Object: builtin " + this.getClass().getName() + ":" + this.toString() + "]";
    }

    public int getColumnCount() {
        return this.colNames.size();
    }

    public Object getMetaData() {
        return this.resultSetMetaData;
    }

    ESValue getLastError() throws EcmaScriptException {
        if (this.lastError == null) {
            return ESUndefined.theUndefined;
        }
        return ESLoader.normalizeValue(this.lastError, this.evaluator);
    }

    ESValue release() {
        try {
            if (this.statement != null) {
                this.statement.close();
            }
            if (this.resultSet != null) {
                this.resultSet.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.statement = null;
        this.resultSet = null;
        this.resultSetMetaData = null;
        return ESUndefined.theUndefined;
    }

    public boolean hasMoreRows() {
        return !this.lastRowSeen;
    }

    public String getColumnName(int idx) throws EcmaScriptException {
        if (this.resultSet == null) {
            throw new EcmaScriptException("Attempt to access a released result set");
        }
        if (idx > 0 && idx <= this.colNames.size()) {
            return (String)this.colNames.elementAt(idx - 1);
        }
        throw new EcmaScriptException("Column index (base 1) " + idx + " out of range, max: " + this.colNames.size());
    }

    public int getColumnDatatypeNumber(int idx) throws EcmaScriptException {
        if (this.resultSet == null) {
            throw new EcmaScriptException("Attempt to access a released result set");
        }
        if (idx > 0 && idx <= this.colNames.size()) {
            try {
                return this.resultSetMetaData.getColumnType(idx);
            }
            catch (SQLException e) {
                this.lastError = e;
                return -1;
            }
        }
        throw new EcmaScriptException("Column index (base 1) " + idx + " out of range, max: " + this.colNames.size());
    }

    public String getColumnDatatypeName(int idx) throws EcmaScriptException {
        if (this.resultSet == null) {
            throw new EcmaScriptException("Attempt to access a released result set");
        }
        if (idx > 0 && idx <= this.colNames.size()) {
            try {
                return this.resultSetMetaData.getColumnTypeName(idx);
            }
            catch (SQLException e) {
                this.lastError = e;
                return null;
            }
        }
        throw new EcmaScriptException("Column index (base 1) " + idx + " out of range, max: " + this.colNames.size());
    }

    public ESValue getColumnItem(String propertyName) throws EcmaScriptException {
        if (this.resultSet == null) {
            throw new EcmaScriptException("Attempt to access a released result set");
        }
        if (!this.firstRowSeen) {
            throw new EcmaScriptException("Attempt to access data before the first row is read");
        }
        int hash = propertyName.hashCode();
        try {
            int index = -1;
            try {
                char c = propertyName.charAt(0);
                if ('0' <= c && c <= '9') {
                    index = Integer.parseInt(propertyName);
                }
            }
            catch (NumberFormatException e) {
            }
            catch (StringIndexOutOfBoundsException e) {
                // empty catch block
            }
            if (index >= 0) {
                return this.getProperty(index);
            }
            Object o = this.resultSet.getObject(propertyName);
            ESValue value = ESLoader.normalizeValue(o, this.evaluator);
            this.lastError = null;
            return value;
        }
        catch (SQLException e) {
            this.lastError = e;
            return ESUndefined.theUndefined;
        }
    }

    public ESValue getProperty(String propertyName, int hash) throws EcmaScriptException {
        if (propertyName.equals("length")) {
            return new ESNumber(this.colNames.size());
        }
        if (super.hasProperty(propertyName, hash)) {
            return super.getProperty(propertyName, hash);
        }
        if (this.resultSet == null) {
            throw new EcmaScriptException("Attempt to access a released result set");
        }
        if (!this.firstRowSeen) {
            throw new EcmaScriptException("Attempt to access data before the first row is read");
        }
        try {
            int index = -1;
            try {
                char c = propertyName.charAt(0);
                if ('0' <= c && c <= '9') {
                    index = Integer.parseInt(propertyName);
                }
            }
            catch (NumberFormatException e) {
            }
            catch (StringIndexOutOfBoundsException e) {
                // empty catch block
            }
            if (index >= 0) {
                return this.getProperty(index);
            }
            Object o = this.resultSet.getObject(propertyName);
            ESValue value = ESLoader.normalizeValue(o, this.evaluator);
            this.lastError = null;
            return value;
        }
        catch (SQLException e) {
            this.lastError = e;
            return ESUndefined.theUndefined;
        }
    }

    public ESValue getProperty(int index) throws EcmaScriptException {
        if (!this.firstRowSeen) {
            throw new EcmaScriptException("Attempt to access data before the first row is read");
        }
        if (this.resultSet == null) {
            throw new EcmaScriptException("Attempt to access a released result set");
        }
        try {
            Object o = this.resultSet.getObject(index);
            ESValue value = ESLoader.normalizeValue(o, this.evaluator);
            this.lastError = null;
            return value;
        }
        catch (SQLException e) {
            this.lastError = e;
            return ESUndefined.theUndefined;
        }
    }

    public Enumeration getProperties() {
        if (this.resultSet == null) {
            return new Vector().elements();
        }
        return this.colNames.elements();
    }

    public Enumeration getAllProperties() {
        return new Enumeration(){
            String[] specialProperties;
            int specialEnumerator;
            Enumeration props;
            String currentKey;
            int currentHash;
            boolean inside;
            {
                this.specialProperties = ESRowSet.this.getSpecialPropertyNames();
                this.specialEnumerator = 0;
                this.props = ESRowSet.this.getProperties();
                this.currentKey = null;
                this.currentHash = 0;
                this.inside = false;
            }

            public boolean hasMoreElements() {
                if (this.currentKey != null) {
                    return true;
                }
                if (this.specialEnumerator < this.specialProperties.length) {
                    this.currentKey = this.specialProperties[this.specialEnumerator];
                    this.currentHash = this.currentKey.hashCode();
                    ++this.specialEnumerator;
                    return true;
                }
                while (this.props.hasMoreElements()) {
                    this.currentKey = (String)this.props.nextElement();
                    this.currentHash = this.currentKey.hashCode();
                    if (this.inside) {
                        try {
                            if (ESRowSet.this.hasProperty(this.currentKey, this.currentHash)) {
                                continue;
                            }
                        }
                        catch (EcmaScriptException ignore) {
                            // empty catch block
                        }
                    }
                    return true;
                }
                if (!this.inside && ESRowSet.this.getPrototype() != null) {
                    this.inside = true;
                    this.props = ESRowSet.this.getPrototype().getProperties();
                    while (this.props.hasMoreElements()) {
                        this.currentKey = (String)this.props.nextElement();
                        this.currentHash = this.currentKey.hashCode();
                        try {
                            if (ESRowSet.this.hasProperty(this.currentKey, this.currentHash)) {
                                continue;
                            }
                        }
                        catch (EcmaScriptException ecmaScriptException) {
                            // empty catch block
                        }
                        return true;
                    }
                }
                return false;
            }

            public Object nextElement() {
                if (this.hasMoreElements()) {
                    String key = this.currentKey;
                    this.currentKey = null;
                    return key;
                }
                throw new NoSuchElementException();
            }
        };
    }

    public String[] getSpecialPropertyNames() {
        String[] ns = new String[]{"length"};
        return ns;
    }

    ESValue next() throws EcmaScriptException {
        boolean status = false;
        if (this.lastRowSeen) {
            throw new EcmaScriptException("Attempt to access a next row after last row has been returned");
        }
        if (this.resultSet == null) {
            throw new EcmaScriptException("Attempt to access a released result set");
        }
        try {
            status = this.resultSet.next();
            this.lastError = null;
        }
        catch (SQLException e) {
            this.lastError = e;
        }
        if (status) {
            this.firstRowSeen = true;
        } else {
            this.lastRowSeen = true;
        }
        return ESBoolean.makeBoolean(status);
    }

    public String toString() {
        return "[RowSet: '" + this.sql + "'" + (this.resultSet == null ? " - released]" : (this.lastRowSeen ? " - at end]" : (this.firstRowSeen ? "]" : " - at start]")));
    }
}

