/*
 * Decompiled with CFR 0.152.
 */
package FESI.Extensions;

import FESI.Data.ESBoolean;
import FESI.Data.ESObject;
import FESI.Data.ESPrimitive;
import FESI.Data.ESValue;
import FESI.Exceptions.EcmaScriptException;
import FESI.Interpreter.Evaluator;
import FESI.Interpreter.ScopeChain;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternCompiler;
import org.apache.oro.text.regex.PatternMatcher;

class ESORORegExp
extends ESObject {
    private String regExpString;
    private boolean ignoreCase = false;
    private boolean global = false;
    private Pattern pattern = null;
    private int groups;
    private PatternCompiler compiler;
    private PatternMatcher matcher;
    private static final String IGNORECASEstring = "ignoreCase".intern();
    private static final int IGNORECASEhash = IGNORECASEstring.hashCode();
    private static final String GLOBALstring = "global".intern();
    private static final int GLOBALhash = GLOBALstring.hashCode();

    ESORORegExp(ESObject prototype, Evaluator evaluator, PatternCompiler compiler, PatternMatcher matcher, String regExpString) {
        super(prototype, evaluator);
        this.compiler = compiler;
        this.matcher = matcher;
        this.regExpString = regExpString;
    }

    ESORORegExp(ESObject prototype, Evaluator evaluator, PatternCompiler compiler, PatternMatcher matcher) {
        super(prototype, evaluator);
        this.compiler = compiler;
        this.matcher = matcher;
        this.regExpString = "";
    }

    public Pattern getPattern() throws EcmaScriptException {
        if (this.pattern == null) {
            this.compile();
        }
        return this.pattern;
    }

    public boolean isGlobal() {
        return this.global;
    }

    public void compile() throws EcmaScriptException {
        try {
            this.pattern = this.compiler.compile(this.regExpString, this.ignoreCase ? 1 : 0);
        }
        catch (MalformedPatternException e) {
            throw new EcmaScriptException("MalformedPatternException: /" + this.regExpString + "/", e);
        }
    }

    public String getESClassName() {
        return "RegExp";
    }

    public String toString() {
        if (this.regExpString == null) {
            return "/<null>/";
        }
        return "/" + this.regExpString + "/";
    }

    public String toDetailString() {
        return "ES:[Object: builtin " + this.getClass().getName() + ":" + this.toString() + "]";
    }

    public ESValue getPropertyInScope(String propertyName, ScopeChain previousScope, int hash) throws EcmaScriptException {
        if (propertyName.equals(IGNORECASEstring)) {
            return ESBoolean.makeBoolean(this.ignoreCase);
        }
        if (propertyName.equals(GLOBALstring)) {
            return ESBoolean.makeBoolean(this.global);
        }
        return super.getPropertyInScope(propertyName, previousScope, hash);
    }

    public ESValue getProperty(String propertyName, int hash) throws EcmaScriptException {
        if (propertyName.equals(IGNORECASEstring)) {
            return ESBoolean.makeBoolean(this.ignoreCase);
        }
        if (propertyName.equals(GLOBALstring)) {
            return ESBoolean.makeBoolean(this.global);
        }
        return super.getProperty(propertyName, hash);
    }

    public void putProperty(String propertyName, ESValue propertyValue, int hash) throws EcmaScriptException {
        if (hash == IGNORECASEhash && propertyName.equals(IGNORECASEstring)) {
            boolean oldIgnoreCase = this.ignoreCase;
            this.ignoreCase = ((ESPrimitive)propertyValue).booleanValue();
            if (oldIgnoreCase != this.ignoreCase) {
                this.pattern = null;
            }
        } else if (hash == GLOBALhash && propertyName.equals(GLOBALstring)) {
            this.global = ((ESPrimitive)propertyValue).booleanValue();
        } else {
            super.putProperty(propertyName, propertyValue, hash);
        }
    }

    public String[] getSpecialPropertyNames() {
        String[] ns = new String[]{GLOBALstring, IGNORECASEstring};
        return ns;
    }
}

