/*
 * Decompiled with CFR 0.152.
 */
package FESI.Extensions;

import FESI.Data.ESBoolean;
import FESI.Data.ESObject;
import FESI.Data.ESPrimitive;
import FESI.Data.ESValue;
import FESI.Exceptions.EcmaScriptException;
import FESI.Interpreter.Evaluator;
import FESI.Interpreter.ScopeChain;
import gnu.regexp.RE;
import gnu.regexp.REException;
import gnu.regexp.RESyntax;

class ESGNURegExp
extends ESObject {
    private String regExpString;
    private boolean ignoreCase = false;
    private boolean global = false;
    private RE pattern = null;
    private int groups;
    private static final String IGNORECASEstring = "ignoreCase";
    private static final int IGNORECASEhash = "ignoreCase".hashCode();
    private static final String GLOBALstring = "global";
    private static final int GLOBALhash = "global".hashCode();

    ESGNURegExp(ESObject prototype, Evaluator evaluator, String regExpString) {
        super(prototype, evaluator);
        this.regExpString = regExpString;
    }

    ESGNURegExp(ESObject prototype, Evaluator evaluator) {
        super(prototype, evaluator);
        this.regExpString = "";
    }

    public RE getPattern() throws EcmaScriptException {
        if (this.pattern == null) {
            this.compile();
        }
        return this.pattern;
    }

    public boolean isGlobal() {
        return this.global;
    }

    public void compile() throws EcmaScriptException {
        try {
            this.pattern = new RE((Object)this.regExpString, (this.ignoreCase ? 2 : 0) | 8, RESyntax.RE_SYNTAX_PERL5);
        }
        catch (REException e) {
            throw new EcmaScriptException(this.toString(), e);
        }
    }

    public String getESClassName() {
        return "RegExp";
    }

    public String toString() {
        return "/" + (this.regExpString == null ? "<null>" : this.regExpString) + "/";
    }

    public String toDetailString() {
        return "ES:[Object: builtin " + this.getClass().getName() + ":" + this.toString() + "]";
    }

    public ESValue getPropertyInScope(String propertyName, ScopeChain previousScope, int hash) throws EcmaScriptException {
        if (IGNORECASEstring.equals(propertyName)) {
            return ESBoolean.makeBoolean(this.ignoreCase);
        }
        if (GLOBALstring.equals(propertyName)) {
            return ESBoolean.makeBoolean(this.global);
        }
        return super.getPropertyInScope(propertyName, previousScope, hash);
    }

    public ESValue getProperty(String propertyName, int hash) throws EcmaScriptException {
        if (IGNORECASEstring.equals(propertyName)) {
            return ESBoolean.makeBoolean(this.ignoreCase);
        }
        if (GLOBALstring.equals(propertyName)) {
            return ESBoolean.makeBoolean(this.global);
        }
        return super.getProperty(propertyName, hash);
    }

    public void putProperty(String propertyName, ESValue propertyValue, int hash) throws EcmaScriptException {
        if (hash == IGNORECASEhash && IGNORECASEstring.equals(propertyName)) {
            boolean oldIgnoreCase = this.ignoreCase;
            this.ignoreCase = ((ESPrimitive)propertyValue).booleanValue();
            if (oldIgnoreCase != this.ignoreCase) {
                this.pattern = null;
            }
        } else if (hash == GLOBALhash && GLOBALstring.equals(propertyName)) {
            this.global = ((ESPrimitive)propertyValue).booleanValue();
        } else {
            super.putProperty(propertyName, propertyValue, hash);
        }
    }

    public String[] getSpecialPropertyNames() {
        String[] ns = new String[]{GLOBALstring, IGNORECASEstring};
        return ns;
    }
}

